<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class NurseryGrid extends Nursery
{
    use MessagesTrait;

    // Page ID
    public $PageID = "grid";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "NurseryGrid";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fnurserygrid";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "NurseryGrid";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->NurseryCode->setVisibility();
        $this->NurseryName->setVisibility();
        $this->NurseryType->setVisibility();
        $this->PhysicalAddress->setVisibility();
        $this->PostalAddress->setVisibility();
        $this->Phone->setVisibility();
        $this->_Email->setVisibility();
        $this->NurseryOwnership->setVisibility();
        $this->SeedVariety->setVisibility();
        $this->NumberOfMembers->setVisibility();
        $this->FemaleMembers->setVisibility();
        $this->MaleMembers->setVisibility();
        $this->YoungFemales->setVisibility();
        $this->YoungMales->setVisibility();
        $this->FemalesInManagement->setVisibility();
        $this->MalesInManagement->setVisibility();
        $this->Latitude->setVisibility();
        $this->Longitude->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'nursery';
        $this->TableName = 'nursery';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $this->FormActionName .= "_" . $this->FormName;
        $this->OldKeyName .= "_" . $this->FormName;
        $this->FormBlankRowName .= "_" . $this->FormName;
        $this->FormKeyCountName .= "_" . $this->FormName;
        $GLOBALS["Grid"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (nursery)
        if (!isset($GLOBALS["nursery"]) || $GLOBALS["nursery"]::class == PROJECT_NAMESPACE . "nursery") {
            $GLOBALS["nursery"] = &$this;
        }
        $this->AddUrl = "NurseryAdd";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'nursery');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;
        unset($GLOBALS["Grid"]);
        if ($url === "") {
            return;
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['NurseryCode'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->NurseryCode->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $ShowOtherOptions = false;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        if (Param("export") !== null) {
            $this->Export = Param("export");
        }

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up master detail parameters
        $this->setupMasterParms();

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->ProvinceCode);
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->NurseryType);
        $this->setupLookupOptions($this->NurseryOwnership);
        $this->setupLookupOptions($this->SeedVariety);

        // Load default values for add
        $this->loadDefaultValues();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fnurserygrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Show grid delete link for grid add / grid edit
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $item = $this->ListOptions["griddelete"];
                if ($item) {
                    $item->Visible = $Security->allowDelete(CurrentProjectID() . $this->TableName);
                }
            }
        }

        // Set up sorting order
        $this->setupSortOrder();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }

        // Restore master/detail filter from session
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Restore master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Restore detail filter from session
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "district") {
            $masterTbl = Container("district");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("DistrictList"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->TotalRecords = $this->listRecordCount();
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->TotalRecords;
                $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
            } else {
                $this->CurrentFilter = "0=1";
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->GridAddRowCount;
            }
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->TotalRecords; // Display all records
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->Latitude->FormValue = ""; // Clear form value
        $this->Longitude->FormValue = ""; // Clear form value
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to grid add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Switch to grid edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old result set
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAllAssociative();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();
        if ($this->AuditTrailOnEdit) {
            $this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
        }
        $wrkfilter = "";
        $key = "";

        // Update row index and get row key
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $this->setKey($CurrentForm->getValue($this->OldKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete" && $rowaction != "hide") { // Skip insert then deleted rows / hidden rows for grid edit
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->OldKey != ""; // Key must not be empty
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($this->OldKey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                        if ($gridUpdate) { // Get inserted or updated filter
                            AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                        }
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $this->OldKey;
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($gridUpdate) {
            $this->FilterForModalActions = $wrkfilter;

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
            }
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
            }
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Perform grid add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        if ($this->AuditTrailOnAdd) {
            $this->writeAuditTrailDummy($Language->phrase("BatchInsertBegin")); // Batch insert begin
        }
        $key = "";

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $rsold = null;
            if ($rowaction == "insert") {
                $this->OldKey = strval($CurrentForm->getValue($this->OldKeyName));
                $rsold = $this->loadOldRecord(); // Load old record
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success
                $gridInsert = $this->addRow($rsold); // Insert row (already validated by validateGridForm())
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->NurseryCode->CurrentValue;

                    // Add filter for this record
                    AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->clearInlineMode(); // Clear grid add mode and return
            return true;
        }
        if ($gridInsert) {
            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $this->FilterForModalActions = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailDummy($Language->phrase("BatchInsertSuccess")); // Batch insert success
            }
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailDummy($Language->phrase("BatchInsertRollback")); // Batch insert rollback
            }
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if (
            $CurrentForm->hasValue("x_ProvinceCode") &&
            $CurrentForm->hasValue("o_ProvinceCode") &&
            $this->ProvinceCode->CurrentValue != $this->ProvinceCode->DefaultValue &&
            !($this->ProvinceCode->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->ProvinceCode->CurrentValue == $this->ProvinceCode->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_DistrictCode") &&
            $CurrentForm->hasValue("o_DistrictCode") &&
            $this->DistrictCode->CurrentValue != $this->DistrictCode->DefaultValue &&
            !($this->DistrictCode->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->DistrictCode->CurrentValue == $this->DistrictCode->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_NurseryName") &&
            $CurrentForm->hasValue("o_NurseryName") &&
            $this->NurseryName->CurrentValue != $this->NurseryName->DefaultValue &&
            !($this->NurseryName->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->NurseryName->CurrentValue == $this->NurseryName->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_NurseryType") &&
            $CurrentForm->hasValue("o_NurseryType") &&
            $this->NurseryType->CurrentValue != $this->NurseryType->DefaultValue &&
            !($this->NurseryType->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->NurseryType->CurrentValue == $this->NurseryType->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_PhysicalAddress") &&
            $CurrentForm->hasValue("o_PhysicalAddress") &&
            $this->PhysicalAddress->CurrentValue != $this->PhysicalAddress->DefaultValue &&
            !($this->PhysicalAddress->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->PhysicalAddress->CurrentValue == $this->PhysicalAddress->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_PostalAddress") &&
            $CurrentForm->hasValue("o_PostalAddress") &&
            $this->PostalAddress->CurrentValue != $this->PostalAddress->DefaultValue &&
            !($this->PostalAddress->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->PostalAddress->CurrentValue == $this->PostalAddress->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_Phone") &&
            $CurrentForm->hasValue("o_Phone") &&
            $this->Phone->CurrentValue != $this->Phone->DefaultValue &&
            !($this->Phone->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->Phone->CurrentValue == $this->Phone->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x__Email") &&
            $CurrentForm->hasValue("o__Email") &&
            $this->_Email->CurrentValue != $this->_Email->DefaultValue &&
            !($this->_Email->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->_Email->CurrentValue == $this->_Email->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_NurseryOwnership") &&
            $CurrentForm->hasValue("o_NurseryOwnership") &&
            $this->NurseryOwnership->CurrentValue != $this->NurseryOwnership->DefaultValue &&
            !($this->NurseryOwnership->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->NurseryOwnership->CurrentValue == $this->NurseryOwnership->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_SeedVariety") &&
            $CurrentForm->hasValue("o_SeedVariety") &&
            $this->SeedVariety->CurrentValue != $this->SeedVariety->DefaultValue &&
            !($this->SeedVariety->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->SeedVariety->CurrentValue == $this->SeedVariety->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_NumberOfMembers") &&
            $CurrentForm->hasValue("o_NumberOfMembers") &&
            $this->NumberOfMembers->CurrentValue != $this->NumberOfMembers->DefaultValue &&
            !($this->NumberOfMembers->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->NumberOfMembers->CurrentValue == $this->NumberOfMembers->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_FemaleMembers") &&
            $CurrentForm->hasValue("o_FemaleMembers") &&
            $this->FemaleMembers->CurrentValue != $this->FemaleMembers->DefaultValue &&
            !($this->FemaleMembers->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->FemaleMembers->CurrentValue == $this->FemaleMembers->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_MaleMembers") &&
            $CurrentForm->hasValue("o_MaleMembers") &&
            $this->MaleMembers->CurrentValue != $this->MaleMembers->DefaultValue &&
            !($this->MaleMembers->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->MaleMembers->CurrentValue == $this->MaleMembers->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_YoungFemales") &&
            $CurrentForm->hasValue("o_YoungFemales") &&
            $this->YoungFemales->CurrentValue != $this->YoungFemales->DefaultValue &&
            !($this->YoungFemales->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->YoungFemales->CurrentValue == $this->YoungFemales->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_YoungMales") &&
            $CurrentForm->hasValue("o_YoungMales") &&
            $this->YoungMales->CurrentValue != $this->YoungMales->DefaultValue &&
            !($this->YoungMales->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->YoungMales->CurrentValue == $this->YoungMales->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_FemalesInManagement") &&
            $CurrentForm->hasValue("o_FemalesInManagement") &&
            $this->FemalesInManagement->CurrentValue != $this->FemalesInManagement->DefaultValue &&
            !($this->FemalesInManagement->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->FemalesInManagement->CurrentValue == $this->FemalesInManagement->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_MalesInManagement") &&
            $CurrentForm->hasValue("o_MalesInManagement") &&
            $this->MalesInManagement->CurrentValue != $this->MalesInManagement->DefaultValue &&
            !($this->MalesInManagement->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->MalesInManagement->CurrentValue == $this->MalesInManagement->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_Latitude") &&
            $CurrentForm->hasValue("o_Latitude") &&
            $this->Latitude->CurrentValue != $this->Latitude->DefaultValue &&
            !($this->Latitude->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->Latitude->CurrentValue == $this->Latitude->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_Longitude") &&
            $CurrentForm->hasValue("o_Longitude") &&
            $this->Longitude->CurrentValue != $this->Longitude->DefaultValue &&
            !($this->Longitude->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->Longitude->CurrentValue == $this->Longitude->getSessionValue())
        ) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Load default values for emptyRow checking
        $this->loadDefaultValues();

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete" && $rowaction != "hide") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    $this->ValidationErrors[$rowindex] = $this->getValidationErrors();
                    $this->EventCancelled = true;
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        foreach ($this->Fields as $field) {
            $field->clearErrorMessage();
        }
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset master/detail keys
            if ($this->Command == "resetall") {
                $this->setCurrentMasterTable(""); // Clear master table
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
                        $this->ProvinceCode->setSessionValue("");
                        $this->DistrictCode->setSessionValue("");
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = true;
            $item->Visible = false; // Default hidden
        }

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = true;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->OldKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            $oldKey = $this->getKey(false); // Get from OldValue
            if ($oldKeyName != "" && $oldKey != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($oldKey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (!$Security->allowDelete(CurrentProjectID() . $this->TableName) && is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-ew-action=\"delete-grid-row\" data-rowindex=\"" . $this->RowIndex . "\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"nursery\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"nursery\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"nursery\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $option = $this->OtherOptions["addedit"];
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Add
        if ($this->CurrentMode == "view") { // Check view mode
            $item = &$option->add("add");
            $addcaption = HtmlTitle($Language->phrase("AddLink"));
            $this->AddUrl = $this->getAddUrl();
            if ($this->ModalAdd && !IsMobile()) {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"nursery\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
            } else {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
            }
            $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        }
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
            if (in_array($this->CurrentMode, ["add", "copy", "edit"]) && !$this->isConfirm()) { // Check add/copy/edit mode
                if ($this->AllowAddDeleteRow) {
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-ew-action=\"add-grid-row\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = $Security->canAdd();
                    $this->ShowOtherOptions = $item->Visible;
                }
            }
            if ($this->CurrentMode == "view") { // Check view mode
                $option = $options["addedit"];
                $item = $option["add"];
                $this->ShowOtherOptions = $item?->Visible ?? false;
            }
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        $this->StartRecord = 1;
        $this->StopRecord = $this->TotalRecords; // Show all records

        // Restore number of post back records
        if ($CurrentForm && ($this->isConfirm() || $this->EventCancelled)) {
            $CurrentForm->resetIndex();
            if ($CurrentForm->hasValue($this->FormKeyCountName) && ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm())) {
                $this->KeyCount = $CurrentForm->getValue($this->FormKeyCountName);
                $this->StopRecord = $this->StartRecord + $this->KeyCount - 1;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_nursery", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }
        if ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm() || $this->isMultiEdit()) {
            $this->RowIndex++;
            $CurrentForm->Index = $this->RowIndex;
            if ($CurrentForm->hasValue($this->FormActionName) && ($this->isConfirm() || $this->EventCancelled)) {
                $this->RowAction = strval($CurrentForm->getValue($this->FormActionName));
            } elseif ($this->isGridAdd()) {
                $this->RowAction = "insert";
            } else {
                $this->RowAction = "";
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->loadRowValues($this->CurrentRow); // Load row values
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
            } else {
                $this->loadRowValues(); // Load default values
                $this->OldKey = "";
            }
        } else {
            $this->loadRowValues($this->CurrentRow); // Load row values
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
        }
        $this->setKey($this->OldKey);
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }
        if ($this->isGridAdd() && $this->EventCancelled && !$CurrentForm->hasValue($this->FormBlankRowName)) { // Insert failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isGridEdit()) { // Grid edit
            if ($this->EventCancelled) {
                $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
            }
            if ($this->RowAction == "insert") {
                $this->RowType = RowType::ADD; // Render add
            } else {
                $this->RowType = RowType::EDIT; // Render edit
            }
        }
        if ($this->isGridEdit() && ($this->RowType == RowType::EDIT || $this->RowType == RowType::ADD) && $this->EventCancelled) { // Update failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isConfirm()) { // Confirm row
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_nursery",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->ProvinceCode->DefaultValue = $this->ProvinceCode->getDefault(); // PHP
        $this->ProvinceCode->OldValue = $this->ProvinceCode->DefaultValue;
        $this->DistrictCode->DefaultValue = $this->DistrictCode->getDefault(); // PHP
        $this->DistrictCode->OldValue = $this->DistrictCode->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $CurrentForm->FormName = $this->FormName;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ProvinceCode' first before field var 'x_ProvinceCode'
        $val = $CurrentForm->hasValue("ProvinceCode") ? $CurrentForm->getValue("ProvinceCode") : $CurrentForm->getValue("x_ProvinceCode");
        if (!$this->ProvinceCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProvinceCode->Visible = false; // Disable update for API request
            } else {
                $this->ProvinceCode->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_ProvinceCode")) {
            $this->ProvinceCode->setOldValue($CurrentForm->getValue("o_ProvinceCode"));
        }

        // Check field name 'DistrictCode' first before field var 'x_DistrictCode'
        $val = $CurrentForm->hasValue("DistrictCode") ? $CurrentForm->getValue("DistrictCode") : $CurrentForm->getValue("x_DistrictCode");
        if (!$this->DistrictCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DistrictCode->Visible = false; // Disable update for API request
            } else {
                $this->DistrictCode->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_DistrictCode")) {
            $this->DistrictCode->setOldValue($CurrentForm->getValue("o_DistrictCode"));
        }

        // Check field name 'NurseryCode' first before field var 'x_NurseryCode'
        $val = $CurrentForm->hasValue("NurseryCode") ? $CurrentForm->getValue("NurseryCode") : $CurrentForm->getValue("x_NurseryCode");
        if (!$this->NurseryCode->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->NurseryCode->setFormValue($val);
        }

        // Check field name 'NurseryName' first before field var 'x_NurseryName'
        $val = $CurrentForm->hasValue("NurseryName") ? $CurrentForm->getValue("NurseryName") : $CurrentForm->getValue("x_NurseryName");
        if (!$this->NurseryName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NurseryName->Visible = false; // Disable update for API request
            } else {
                $this->NurseryName->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_NurseryName")) {
            $this->NurseryName->setOldValue($CurrentForm->getValue("o_NurseryName"));
        }

        // Check field name 'NurseryType' first before field var 'x_NurseryType'
        $val = $CurrentForm->hasValue("NurseryType") ? $CurrentForm->getValue("NurseryType") : $CurrentForm->getValue("x_NurseryType");
        if (!$this->NurseryType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NurseryType->Visible = false; // Disable update for API request
            } else {
                $this->NurseryType->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_NurseryType")) {
            $this->NurseryType->setOldValue($CurrentForm->getValue("o_NurseryType"));
        }

        // Check field name 'PhysicalAddress' first before field var 'x_PhysicalAddress'
        $val = $CurrentForm->hasValue("PhysicalAddress") ? $CurrentForm->getValue("PhysicalAddress") : $CurrentForm->getValue("x_PhysicalAddress");
        if (!$this->PhysicalAddress->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PhysicalAddress->Visible = false; // Disable update for API request
            } else {
                $this->PhysicalAddress->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_PhysicalAddress")) {
            $this->PhysicalAddress->setOldValue($CurrentForm->getValue("o_PhysicalAddress"));
        }

        // Check field name 'PostalAddress' first before field var 'x_PostalAddress'
        $val = $CurrentForm->hasValue("PostalAddress") ? $CurrentForm->getValue("PostalAddress") : $CurrentForm->getValue("x_PostalAddress");
        if (!$this->PostalAddress->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PostalAddress->Visible = false; // Disable update for API request
            } else {
                $this->PostalAddress->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_PostalAddress")) {
            $this->PostalAddress->setOldValue($CurrentForm->getValue("o_PostalAddress"));
        }

        // Check field name 'Phone' first before field var 'x_Phone'
        $val = $CurrentForm->hasValue("Phone") ? $CurrentForm->getValue("Phone") : $CurrentForm->getValue("x_Phone");
        if (!$this->Phone->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Phone->Visible = false; // Disable update for API request
            } else {
                $this->Phone->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_Phone")) {
            $this->Phone->setOldValue($CurrentForm->getValue("o_Phone"));
        }

        // Check field name 'Email' first before field var 'x__Email'
        $val = $CurrentForm->hasValue("Email") ? $CurrentForm->getValue("Email") : $CurrentForm->getValue("x__Email");
        if (!$this->_Email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_Email->Visible = false; // Disable update for API request
            } else {
                $this->_Email->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o__Email")) {
            $this->_Email->setOldValue($CurrentForm->getValue("o__Email"));
        }

        // Check field name 'NurseryOwnership' first before field var 'x_NurseryOwnership'
        $val = $CurrentForm->hasValue("NurseryOwnership") ? $CurrentForm->getValue("NurseryOwnership") : $CurrentForm->getValue("x_NurseryOwnership");
        if (!$this->NurseryOwnership->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NurseryOwnership->Visible = false; // Disable update for API request
            } else {
                $this->NurseryOwnership->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_NurseryOwnership")) {
            $this->NurseryOwnership->setOldValue($CurrentForm->getValue("o_NurseryOwnership"));
        }

        // Check field name 'SeedVariety' first before field var 'x_SeedVariety'
        $val = $CurrentForm->hasValue("SeedVariety") ? $CurrentForm->getValue("SeedVariety") : $CurrentForm->getValue("x_SeedVariety");
        if (!$this->SeedVariety->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SeedVariety->Visible = false; // Disable update for API request
            } else {
                $this->SeedVariety->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_SeedVariety")) {
            $this->SeedVariety->setOldValue($CurrentForm->getValue("o_SeedVariety"));
        }

        // Check field name 'NumberOfMembers' first before field var 'x_NumberOfMembers'
        $val = $CurrentForm->hasValue("NumberOfMembers") ? $CurrentForm->getValue("NumberOfMembers") : $CurrentForm->getValue("x_NumberOfMembers");
        if (!$this->NumberOfMembers->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NumberOfMembers->Visible = false; // Disable update for API request
            } else {
                $this->NumberOfMembers->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_NumberOfMembers")) {
            $this->NumberOfMembers->setOldValue($CurrentForm->getValue("o_NumberOfMembers"));
        }

        // Check field name 'FemaleMembers' first before field var 'x_FemaleMembers'
        $val = $CurrentForm->hasValue("FemaleMembers") ? $CurrentForm->getValue("FemaleMembers") : $CurrentForm->getValue("x_FemaleMembers");
        if (!$this->FemaleMembers->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FemaleMembers->Visible = false; // Disable update for API request
            } else {
                $this->FemaleMembers->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_FemaleMembers")) {
            $this->FemaleMembers->setOldValue($CurrentForm->getValue("o_FemaleMembers"));
        }

        // Check field name 'MaleMembers' first before field var 'x_MaleMembers'
        $val = $CurrentForm->hasValue("MaleMembers") ? $CurrentForm->getValue("MaleMembers") : $CurrentForm->getValue("x_MaleMembers");
        if (!$this->MaleMembers->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MaleMembers->Visible = false; // Disable update for API request
            } else {
                $this->MaleMembers->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_MaleMembers")) {
            $this->MaleMembers->setOldValue($CurrentForm->getValue("o_MaleMembers"));
        }

        // Check field name 'YoungFemales' first before field var 'x_YoungFemales'
        $val = $CurrentForm->hasValue("YoungFemales") ? $CurrentForm->getValue("YoungFemales") : $CurrentForm->getValue("x_YoungFemales");
        if (!$this->YoungFemales->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->YoungFemales->Visible = false; // Disable update for API request
            } else {
                $this->YoungFemales->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_YoungFemales")) {
            $this->YoungFemales->setOldValue($CurrentForm->getValue("o_YoungFemales"));
        }

        // Check field name 'YoungMales' first before field var 'x_YoungMales'
        $val = $CurrentForm->hasValue("YoungMales") ? $CurrentForm->getValue("YoungMales") : $CurrentForm->getValue("x_YoungMales");
        if (!$this->YoungMales->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->YoungMales->Visible = false; // Disable update for API request
            } else {
                $this->YoungMales->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_YoungMales")) {
            $this->YoungMales->setOldValue($CurrentForm->getValue("o_YoungMales"));
        }

        // Check field name 'FemalesInManagement' first before field var 'x_FemalesInManagement'
        $val = $CurrentForm->hasValue("FemalesInManagement") ? $CurrentForm->getValue("FemalesInManagement") : $CurrentForm->getValue("x_FemalesInManagement");
        if (!$this->FemalesInManagement->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FemalesInManagement->Visible = false; // Disable update for API request
            } else {
                $this->FemalesInManagement->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_FemalesInManagement")) {
            $this->FemalesInManagement->setOldValue($CurrentForm->getValue("o_FemalesInManagement"));
        }

        // Check field name 'MalesInManagement' first before field var 'x_MalesInManagement'
        $val = $CurrentForm->hasValue("MalesInManagement") ? $CurrentForm->getValue("MalesInManagement") : $CurrentForm->getValue("x_MalesInManagement");
        if (!$this->MalesInManagement->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MalesInManagement->Visible = false; // Disable update for API request
            } else {
                $this->MalesInManagement->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_MalesInManagement")) {
            $this->MalesInManagement->setOldValue($CurrentForm->getValue("o_MalesInManagement"));
        }

        // Check field name 'Latitude' first before field var 'x_Latitude'
        $val = $CurrentForm->hasValue("Latitude") ? $CurrentForm->getValue("Latitude") : $CurrentForm->getValue("x_Latitude");
        if (!$this->Latitude->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Latitude->Visible = false; // Disable update for API request
            } else {
                $this->Latitude->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_Latitude")) {
            $this->Latitude->setOldValue($CurrentForm->getValue("o_Latitude"));
        }

        // Check field name 'Longitude' first before field var 'x_Longitude'
        $val = $CurrentForm->hasValue("Longitude") ? $CurrentForm->getValue("Longitude") : $CurrentForm->getValue("x_Longitude");
        if (!$this->Longitude->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Longitude->Visible = false; // Disable update for API request
            } else {
                $this->Longitude->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_Longitude")) {
            $this->Longitude->setOldValue($CurrentForm->getValue("o_Longitude"));
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ProvinceCode->CurrentValue = $this->ProvinceCode->FormValue;
        $this->DistrictCode->CurrentValue = $this->DistrictCode->FormValue;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->NurseryCode->CurrentValue = $this->NurseryCode->FormValue;
        }
        $this->NurseryName->CurrentValue = $this->NurseryName->FormValue;
        $this->NurseryType->CurrentValue = $this->NurseryType->FormValue;
        $this->PhysicalAddress->CurrentValue = $this->PhysicalAddress->FormValue;
        $this->PostalAddress->CurrentValue = $this->PostalAddress->FormValue;
        $this->Phone->CurrentValue = $this->Phone->FormValue;
        $this->_Email->CurrentValue = $this->_Email->FormValue;
        $this->NurseryOwnership->CurrentValue = $this->NurseryOwnership->FormValue;
        $this->SeedVariety->CurrentValue = $this->SeedVariety->FormValue;
        $this->NumberOfMembers->CurrentValue = $this->NumberOfMembers->FormValue;
        $this->FemaleMembers->CurrentValue = $this->FemaleMembers->FormValue;
        $this->MaleMembers->CurrentValue = $this->MaleMembers->FormValue;
        $this->YoungFemales->CurrentValue = $this->YoungFemales->FormValue;
        $this->YoungMales->CurrentValue = $this->YoungMales->FormValue;
        $this->FemalesInManagement->CurrentValue = $this->FemalesInManagement->FormValue;
        $this->MalesInManagement->CurrentValue = $this->MalesInManagement->FormValue;
        $this->Latitude->CurrentValue = $this->Latitude->FormValue;
        $this->Longitude->CurrentValue = $this->Longitude->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->NurseryCode->setDbValue($row['NurseryCode']);
        $this->NurseryName->setDbValue($row['NurseryName']);
        $this->NurseryType->setDbValue($row['NurseryType']);
        $this->PhysicalAddress->setDbValue($row['PhysicalAddress']);
        $this->PostalAddress->setDbValue($row['PostalAddress']);
        $this->Phone->setDbValue($row['Phone']);
        $this->_Email->setDbValue($row['Email']);
        $this->NurseryOwnership->setDbValue($row['NurseryOwnership']);
        $this->SeedVariety->setDbValue($row['SeedVariety']);
        $this->NumberOfMembers->setDbValue($row['NumberOfMembers']);
        $this->FemaleMembers->setDbValue($row['FemaleMembers']);
        $this->MaleMembers->setDbValue($row['MaleMembers']);
        $this->YoungFemales->setDbValue($row['YoungFemales']);
        $this->YoungMales->setDbValue($row['YoungMales']);
        $this->FemalesInManagement->setDbValue($row['FemalesInManagement']);
        $this->MalesInManagement->setDbValue($row['MalesInManagement']);
        $this->Latitude->setDbValue($row['Latitude']);
        $this->Longitude->setDbValue($row['Longitude']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProvinceCode'] = $this->ProvinceCode->DefaultValue;
        $row['DistrictCode'] = $this->DistrictCode->DefaultValue;
        $row['NurseryCode'] = $this->NurseryCode->DefaultValue;
        $row['NurseryName'] = $this->NurseryName->DefaultValue;
        $row['NurseryType'] = $this->NurseryType->DefaultValue;
        $row['PhysicalAddress'] = $this->PhysicalAddress->DefaultValue;
        $row['PostalAddress'] = $this->PostalAddress->DefaultValue;
        $row['Phone'] = $this->Phone->DefaultValue;
        $row['Email'] = $this->_Email->DefaultValue;
        $row['NurseryOwnership'] = $this->NurseryOwnership->DefaultValue;
        $row['SeedVariety'] = $this->SeedVariety->DefaultValue;
        $row['NumberOfMembers'] = $this->NumberOfMembers->DefaultValue;
        $row['FemaleMembers'] = $this->FemaleMembers->DefaultValue;
        $row['MaleMembers'] = $this->MaleMembers->DefaultValue;
        $row['YoungFemales'] = $this->YoungFemales->DefaultValue;
        $row['YoungMales'] = $this->YoungMales->DefaultValue;
        $row['FemalesInManagement'] = $this->FemalesInManagement->DefaultValue;
        $row['MalesInManagement'] = $this->MalesInManagement->DefaultValue;
        $row['Latitude'] = $this->Latitude->DefaultValue;
        $row['Longitude'] = $this->Longitude->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProvinceCode

        // DistrictCode

        // NurseryCode

        // NurseryName

        // NurseryType

        // PhysicalAddress

        // PostalAddress

        // Phone

        // Email

        // NurseryOwnership

        // SeedVariety

        // NumberOfMembers

        // FemaleMembers

        // MaleMembers

        // YoungFemales

        // YoungMales

        // FemalesInManagement

        // MalesInManagement

        // Latitude

        // Longitude

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProvinceCode
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }

            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // NurseryCode
            $this->NurseryCode->ViewValue = $this->NurseryCode->CurrentValue;

            // NurseryName
            $this->NurseryName->ViewValue = $this->NurseryName->CurrentValue;

            // NurseryType
            $curVal = strval($this->NurseryType->CurrentValue);
            if ($curVal != "") {
                $this->NurseryType->ViewValue = $this->NurseryType->lookupCacheOption($curVal);
                if ($this->NurseryType->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NurseryType->Lookup->getTable()->Fields["NurseryTpeCode"]->searchExpression(), "=", $curVal, $this->NurseryType->Lookup->getTable()->Fields["NurseryTpeCode"]->searchDataType(), "");
                    $sqlWrk = $this->NurseryType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NurseryType->Lookup->renderViewRow($rswrk[0]);
                        $this->NurseryType->ViewValue = $this->NurseryType->displayValue($arwrk);
                    } else {
                        $this->NurseryType->ViewValue = $this->NurseryType->CurrentValue;
                    }
                }
            } else {
                $this->NurseryType->ViewValue = null;
            }

            // PhysicalAddress
            $this->PhysicalAddress->ViewValue = $this->PhysicalAddress->CurrentValue;

            // PostalAddress
            $this->PostalAddress->ViewValue = $this->PostalAddress->CurrentValue;

            // Phone
            $this->Phone->ViewValue = $this->Phone->CurrentValue;

            // Email
            $this->_Email->ViewValue = $this->_Email->CurrentValue;

            // NurseryOwnership
            $curVal = strval($this->NurseryOwnership->CurrentValue);
            if ($curVal != "") {
                $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->lookupCacheOption($curVal);
                if ($this->NurseryOwnership->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NurseryOwnership->Lookup->getTable()->Fields["NurseryOwnershipCode"]->searchExpression(), "=", $curVal, $this->NurseryOwnership->Lookup->getTable()->Fields["NurseryOwnershipCode"]->searchDataType(), "");
                    $sqlWrk = $this->NurseryOwnership->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NurseryOwnership->Lookup->renderViewRow($rswrk[0]);
                        $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->displayValue($arwrk);
                    } else {
                        $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->CurrentValue;
                    }
                }
            } else {
                $this->NurseryOwnership->ViewValue = null;
            }

            // SeedVariety
            $curVal = strval($this->SeedVariety->CurrentValue);
            if ($curVal != "") {
                $this->SeedVariety->ViewValue = $this->SeedVariety->lookupCacheOption($curVal);
                if ($this->SeedVariety->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SeedVariety->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $curVal, $this->SeedVariety->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                    $sqlWrk = $this->SeedVariety->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SeedVariety->Lookup->renderViewRow($rswrk[0]);
                        $this->SeedVariety->ViewValue = $this->SeedVariety->displayValue($arwrk);
                    } else {
                        $this->SeedVariety->ViewValue = $this->SeedVariety->CurrentValue;
                    }
                }
            } else {
                $this->SeedVariety->ViewValue = null;
            }

            // NumberOfMembers
            $this->NumberOfMembers->ViewValue = $this->NumberOfMembers->CurrentValue;

            // FemaleMembers
            $this->FemaleMembers->ViewValue = $this->FemaleMembers->CurrentValue;

            // MaleMembers
            $this->MaleMembers->ViewValue = $this->MaleMembers->CurrentValue;

            // YoungFemales
            $this->YoungFemales->ViewValue = $this->YoungFemales->CurrentValue;

            // YoungMales
            $this->YoungMales->ViewValue = $this->YoungMales->CurrentValue;

            // FemalesInManagement
            $this->FemalesInManagement->ViewValue = $this->FemalesInManagement->CurrentValue;

            // MalesInManagement
            $this->MalesInManagement->ViewValue = $this->MalesInManagement->CurrentValue;

            // Latitude
            $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
            $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

            // Longitude
            $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
            $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";
            $this->ProvinceCode->TooltipValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";
            $this->DistrictCode->TooltipValue = "";

            // NurseryCode
            $this->NurseryCode->HrefValue = "";
            $this->NurseryCode->TooltipValue = "";

            // NurseryName
            $this->NurseryName->HrefValue = "";
            $this->NurseryName->TooltipValue = "";

            // NurseryType
            $this->NurseryType->HrefValue = "";
            $this->NurseryType->TooltipValue = "";

            // PhysicalAddress
            $this->PhysicalAddress->HrefValue = "";
            $this->PhysicalAddress->TooltipValue = "";

            // PostalAddress
            $this->PostalAddress->HrefValue = "";
            $this->PostalAddress->TooltipValue = "";

            // Phone
            $this->Phone->HrefValue = "";
            $this->Phone->TooltipValue = "";

            // Email
            $this->_Email->HrefValue = "";
            $this->_Email->TooltipValue = "";

            // NurseryOwnership
            $this->NurseryOwnership->HrefValue = "";
            $this->NurseryOwnership->TooltipValue = "";

            // SeedVariety
            $this->SeedVariety->HrefValue = "";
            $this->SeedVariety->TooltipValue = "";

            // NumberOfMembers
            $this->NumberOfMembers->HrefValue = "";
            $this->NumberOfMembers->TooltipValue = "";

            // FemaleMembers
            $this->FemaleMembers->HrefValue = "";
            $this->FemaleMembers->TooltipValue = "";

            // MaleMembers
            $this->MaleMembers->HrefValue = "";
            $this->MaleMembers->TooltipValue = "";

            // YoungFemales
            $this->YoungFemales->HrefValue = "";
            $this->YoungFemales->TooltipValue = "";

            // YoungMales
            $this->YoungMales->HrefValue = "";
            $this->YoungMales->TooltipValue = "";

            // FemalesInManagement
            $this->FemalesInManagement->HrefValue = "";
            $this->FemalesInManagement->TooltipValue = "";

            // MalesInManagement
            $this->MalesInManagement->HrefValue = "";
            $this->MalesInManagement->TooltipValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";
            $this->Latitude->TooltipValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
            $this->Longitude->TooltipValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            if ($this->ProvinceCode->getSessionValue() != "") {
                $this->ProvinceCode->CurrentValue = GetForeignKeyValue($this->ProvinceCode->getSessionValue());
                $this->ProvinceCode->OldValue = $this->ProvinceCode->CurrentValue;
                $curVal = strval($this->ProvinceCode->CurrentValue);
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                    if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                        $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                        $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                        } else {
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                        }
                    }
                } else {
                    $this->ProvinceCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->ProvinceCode->CurrentValue));
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->ProvinceCode->ViewValue !== null) { // Load from cache
                    $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->CurrentValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->ProvinceCode->EditValue = $arwrk;
                }
                $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
            }

            // DistrictCode
            $this->DistrictCode->setupEditAttributes();
            if ($this->DistrictCode->getSessionValue() != "") {
                $this->DistrictCode->CurrentValue = GetForeignKeyValue($this->DistrictCode->getSessionValue());
                $this->DistrictCode->OldValue = $this->DistrictCode->CurrentValue;
                $curVal = strval($this->DistrictCode->CurrentValue);
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                    if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                        $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                            $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                        } else {
                            $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                        }
                    }
                } else {
                    $this->DistrictCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->DistrictCode->CurrentValue));
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->DistrictCode->ViewValue !== null) { // Load from cache
                    $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->CurrentValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->DistrictCode->EditValue = $arwrk;
                }
                $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
            }

            // NurseryCode

            // NurseryName
            $this->NurseryName->setupEditAttributes();
            if (!$this->NurseryName->Raw) {
                $this->NurseryName->CurrentValue = HtmlDecode($this->NurseryName->CurrentValue);
            }
            $this->NurseryName->EditValue = HtmlEncode($this->NurseryName->CurrentValue);
            $this->NurseryName->PlaceHolder = RemoveHtml($this->NurseryName->caption());

            // NurseryType
            $this->NurseryType->setupEditAttributes();
            $curVal = trim(strval($this->NurseryType->CurrentValue));
            if ($curVal != "") {
                $this->NurseryType->ViewValue = $this->NurseryType->lookupCacheOption($curVal);
            } else {
                $this->NurseryType->ViewValue = $this->NurseryType->Lookup !== null && is_array($this->NurseryType->lookupOptions()) && count($this->NurseryType->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->NurseryType->ViewValue !== null) { // Load from cache
                $this->NurseryType->EditValue = array_values($this->NurseryType->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->NurseryType->Lookup->getTable()->Fields["NurseryTpeCode"]->searchExpression(), "=", $this->NurseryType->CurrentValue, $this->NurseryType->Lookup->getTable()->Fields["NurseryTpeCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->NurseryType->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->NurseryType->EditValue = $arwrk;
            }
            $this->NurseryType->PlaceHolder = RemoveHtml($this->NurseryType->caption());

            // PhysicalAddress
            $this->PhysicalAddress->setupEditAttributes();
            $this->PhysicalAddress->EditValue = HtmlEncode($this->PhysicalAddress->CurrentValue);
            $this->PhysicalAddress->PlaceHolder = RemoveHtml($this->PhysicalAddress->caption());

            // PostalAddress
            $this->PostalAddress->setupEditAttributes();
            $this->PostalAddress->EditValue = HtmlEncode($this->PostalAddress->CurrentValue);
            $this->PostalAddress->PlaceHolder = RemoveHtml($this->PostalAddress->caption());

            // Phone
            $this->Phone->setupEditAttributes();
            if (!$this->Phone->Raw) {
                $this->Phone->CurrentValue = HtmlDecode($this->Phone->CurrentValue);
            }
            $this->Phone->EditValue = HtmlEncode($this->Phone->CurrentValue);
            $this->Phone->PlaceHolder = RemoveHtml($this->Phone->caption());

            // Email
            $this->_Email->setupEditAttributes();
            if (!$this->_Email->Raw) {
                $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
            }
            $this->_Email->EditValue = HtmlEncode($this->_Email->CurrentValue);
            $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

            // NurseryOwnership
            $this->NurseryOwnership->setupEditAttributes();
            $curVal = trim(strval($this->NurseryOwnership->CurrentValue));
            if ($curVal != "") {
                $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->lookupCacheOption($curVal);
            } else {
                $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->Lookup !== null && is_array($this->NurseryOwnership->lookupOptions()) && count($this->NurseryOwnership->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->NurseryOwnership->ViewValue !== null) { // Load from cache
                $this->NurseryOwnership->EditValue = array_values($this->NurseryOwnership->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->NurseryOwnership->Lookup->getTable()->Fields["NurseryOwnershipCode"]->searchExpression(), "=", $this->NurseryOwnership->CurrentValue, $this->NurseryOwnership->Lookup->getTable()->Fields["NurseryOwnershipCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->NurseryOwnership->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->NurseryOwnership->EditValue = $arwrk;
            }
            $this->NurseryOwnership->PlaceHolder = RemoveHtml($this->NurseryOwnership->caption());

            // SeedVariety
            $this->SeedVariety->setupEditAttributes();
            $curVal = trim(strval($this->SeedVariety->CurrentValue));
            if ($curVal != "") {
                $this->SeedVariety->ViewValue = $this->SeedVariety->lookupCacheOption($curVal);
            } else {
                $this->SeedVariety->ViewValue = $this->SeedVariety->Lookup !== null && is_array($this->SeedVariety->lookupOptions()) && count($this->SeedVariety->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->SeedVariety->ViewValue !== null) { // Load from cache
                $this->SeedVariety->EditValue = array_values($this->SeedVariety->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->SeedVariety->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $this->SeedVariety->CurrentValue, $this->SeedVariety->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                }
                $sqlWrk = $this->SeedVariety->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->SeedVariety->EditValue = $arwrk;
            }
            $this->SeedVariety->PlaceHolder = RemoveHtml($this->SeedVariety->caption());

            // NumberOfMembers
            $this->NumberOfMembers->setupEditAttributes();
            $this->NumberOfMembers->EditValue = $this->NumberOfMembers->CurrentValue;
            $this->NumberOfMembers->PlaceHolder = RemoveHtml($this->NumberOfMembers->caption());
            if (strval($this->NumberOfMembers->EditValue) != "" && is_numeric($this->NumberOfMembers->EditValue)) {
                $this->NumberOfMembers->EditValue = $this->NumberOfMembers->EditValue;
            }

            // FemaleMembers
            $this->FemaleMembers->setupEditAttributes();
            $this->FemaleMembers->EditValue = $this->FemaleMembers->CurrentValue;
            $this->FemaleMembers->PlaceHolder = RemoveHtml($this->FemaleMembers->caption());
            if (strval($this->FemaleMembers->EditValue) != "" && is_numeric($this->FemaleMembers->EditValue)) {
                $this->FemaleMembers->EditValue = $this->FemaleMembers->EditValue;
            }

            // MaleMembers
            $this->MaleMembers->setupEditAttributes();
            $this->MaleMembers->EditValue = $this->MaleMembers->CurrentValue;
            $this->MaleMembers->PlaceHolder = RemoveHtml($this->MaleMembers->caption());
            if (strval($this->MaleMembers->EditValue) != "" && is_numeric($this->MaleMembers->EditValue)) {
                $this->MaleMembers->EditValue = $this->MaleMembers->EditValue;
            }

            // YoungFemales
            $this->YoungFemales->setupEditAttributes();
            $this->YoungFemales->EditValue = $this->YoungFemales->CurrentValue;
            $this->YoungFemales->PlaceHolder = RemoveHtml($this->YoungFemales->caption());
            if (strval($this->YoungFemales->EditValue) != "" && is_numeric($this->YoungFemales->EditValue)) {
                $this->YoungFemales->EditValue = $this->YoungFemales->EditValue;
            }

            // YoungMales
            $this->YoungMales->setupEditAttributes();
            $this->YoungMales->EditValue = $this->YoungMales->CurrentValue;
            $this->YoungMales->PlaceHolder = RemoveHtml($this->YoungMales->caption());
            if (strval($this->YoungMales->EditValue) != "" && is_numeric($this->YoungMales->EditValue)) {
                $this->YoungMales->EditValue = $this->YoungMales->EditValue;
            }

            // FemalesInManagement
            $this->FemalesInManagement->setupEditAttributes();
            $this->FemalesInManagement->EditValue = $this->FemalesInManagement->CurrentValue;
            $this->FemalesInManagement->PlaceHolder = RemoveHtml($this->FemalesInManagement->caption());
            if (strval($this->FemalesInManagement->EditValue) != "" && is_numeric($this->FemalesInManagement->EditValue)) {
                $this->FemalesInManagement->EditValue = $this->FemalesInManagement->EditValue;
            }

            // MalesInManagement
            $this->MalesInManagement->setupEditAttributes();
            $this->MalesInManagement->EditValue = $this->MalesInManagement->CurrentValue;
            $this->MalesInManagement->PlaceHolder = RemoveHtml($this->MalesInManagement->caption());
            if (strval($this->MalesInManagement->EditValue) != "" && is_numeric($this->MalesInManagement->EditValue)) {
                $this->MalesInManagement->EditValue = $this->MalesInManagement->EditValue;
            }

            // Latitude
            $this->Latitude->setupEditAttributes();
            $this->Latitude->EditValue = $this->Latitude->CurrentValue;
            $this->Latitude->PlaceHolder = RemoveHtml($this->Latitude->caption());
            if (strval($this->Latitude->EditValue) != "" && is_numeric($this->Latitude->EditValue)) {
                $this->Latitude->EditValue = FormatNumber($this->Latitude->EditValue, null);
            }

            // Longitude
            $this->Longitude->setupEditAttributes();
            $this->Longitude->EditValue = $this->Longitude->CurrentValue;
            $this->Longitude->PlaceHolder = RemoveHtml($this->Longitude->caption());
            if (strval($this->Longitude->EditValue) != "" && is_numeric($this->Longitude->EditValue)) {
                $this->Longitude->EditValue = FormatNumber($this->Longitude->EditValue, null);
            }

            // Add refer script

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // NurseryCode
            $this->NurseryCode->HrefValue = "";

            // NurseryName
            $this->NurseryName->HrefValue = "";

            // NurseryType
            $this->NurseryType->HrefValue = "";

            // PhysicalAddress
            $this->PhysicalAddress->HrefValue = "";

            // PostalAddress
            $this->PostalAddress->HrefValue = "";

            // Phone
            $this->Phone->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // NurseryOwnership
            $this->NurseryOwnership->HrefValue = "";

            // SeedVariety
            $this->SeedVariety->HrefValue = "";

            // NumberOfMembers
            $this->NumberOfMembers->HrefValue = "";

            // FemaleMembers
            $this->FemaleMembers->HrefValue = "";

            // MaleMembers
            $this->MaleMembers->HrefValue = "";

            // YoungFemales
            $this->YoungFemales->HrefValue = "";

            // YoungMales
            $this->YoungMales->HrefValue = "";

            // FemalesInManagement
            $this->FemalesInManagement->HrefValue = "";

            // MalesInManagement
            $this->MalesInManagement->HrefValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            if ($this->ProvinceCode->getSessionValue() != "") {
                $this->ProvinceCode->CurrentValue = GetForeignKeyValue($this->ProvinceCode->getSessionValue());
                $this->ProvinceCode->OldValue = $this->ProvinceCode->CurrentValue;
                $curVal = strval($this->ProvinceCode->CurrentValue);
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                    if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                        $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                        $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                        } else {
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                        }
                    }
                } else {
                    $this->ProvinceCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->ProvinceCode->CurrentValue));
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->ProvinceCode->ViewValue !== null) { // Load from cache
                    $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->CurrentValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->ProvinceCode->EditValue = $arwrk;
                }
                $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
            }

            // DistrictCode
            $this->DistrictCode->setupEditAttributes();
            if ($this->DistrictCode->getSessionValue() != "") {
                $this->DistrictCode->CurrentValue = GetForeignKeyValue($this->DistrictCode->getSessionValue());
                $this->DistrictCode->OldValue = $this->DistrictCode->CurrentValue;
                $curVal = strval($this->DistrictCode->CurrentValue);
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                    if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                        $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                            $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                        } else {
                            $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                        }
                    }
                } else {
                    $this->DistrictCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->DistrictCode->CurrentValue));
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->DistrictCode->ViewValue !== null) { // Load from cache
                    $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->CurrentValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->DistrictCode->EditValue = $arwrk;
                }
                $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
            }

            // NurseryCode
            $this->NurseryCode->setupEditAttributes();
            $this->NurseryCode->EditValue = $this->NurseryCode->CurrentValue;

            // NurseryName
            $this->NurseryName->setupEditAttributes();
            if (!$this->NurseryName->Raw) {
                $this->NurseryName->CurrentValue = HtmlDecode($this->NurseryName->CurrentValue);
            }
            $this->NurseryName->EditValue = HtmlEncode($this->NurseryName->CurrentValue);
            $this->NurseryName->PlaceHolder = RemoveHtml($this->NurseryName->caption());

            // NurseryType
            $this->NurseryType->setupEditAttributes();
            $curVal = trim(strval($this->NurseryType->CurrentValue));
            if ($curVal != "") {
                $this->NurseryType->ViewValue = $this->NurseryType->lookupCacheOption($curVal);
            } else {
                $this->NurseryType->ViewValue = $this->NurseryType->Lookup !== null && is_array($this->NurseryType->lookupOptions()) && count($this->NurseryType->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->NurseryType->ViewValue !== null) { // Load from cache
                $this->NurseryType->EditValue = array_values($this->NurseryType->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->NurseryType->Lookup->getTable()->Fields["NurseryTpeCode"]->searchExpression(), "=", $this->NurseryType->CurrentValue, $this->NurseryType->Lookup->getTable()->Fields["NurseryTpeCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->NurseryType->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->NurseryType->EditValue = $arwrk;
            }
            $this->NurseryType->PlaceHolder = RemoveHtml($this->NurseryType->caption());

            // PhysicalAddress
            $this->PhysicalAddress->setupEditAttributes();
            $this->PhysicalAddress->EditValue = HtmlEncode($this->PhysicalAddress->CurrentValue);
            $this->PhysicalAddress->PlaceHolder = RemoveHtml($this->PhysicalAddress->caption());

            // PostalAddress
            $this->PostalAddress->setupEditAttributes();
            $this->PostalAddress->EditValue = HtmlEncode($this->PostalAddress->CurrentValue);
            $this->PostalAddress->PlaceHolder = RemoveHtml($this->PostalAddress->caption());

            // Phone
            $this->Phone->setupEditAttributes();
            if (!$this->Phone->Raw) {
                $this->Phone->CurrentValue = HtmlDecode($this->Phone->CurrentValue);
            }
            $this->Phone->EditValue = HtmlEncode($this->Phone->CurrentValue);
            $this->Phone->PlaceHolder = RemoveHtml($this->Phone->caption());

            // Email
            $this->_Email->setupEditAttributes();
            if (!$this->_Email->Raw) {
                $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
            }
            $this->_Email->EditValue = HtmlEncode($this->_Email->CurrentValue);
            $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

            // NurseryOwnership
            $this->NurseryOwnership->setupEditAttributes();
            $curVal = trim(strval($this->NurseryOwnership->CurrentValue));
            if ($curVal != "") {
                $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->lookupCacheOption($curVal);
            } else {
                $this->NurseryOwnership->ViewValue = $this->NurseryOwnership->Lookup !== null && is_array($this->NurseryOwnership->lookupOptions()) && count($this->NurseryOwnership->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->NurseryOwnership->ViewValue !== null) { // Load from cache
                $this->NurseryOwnership->EditValue = array_values($this->NurseryOwnership->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->NurseryOwnership->Lookup->getTable()->Fields["NurseryOwnershipCode"]->searchExpression(), "=", $this->NurseryOwnership->CurrentValue, $this->NurseryOwnership->Lookup->getTable()->Fields["NurseryOwnershipCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->NurseryOwnership->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->NurseryOwnership->EditValue = $arwrk;
            }
            $this->NurseryOwnership->PlaceHolder = RemoveHtml($this->NurseryOwnership->caption());

            // SeedVariety
            $this->SeedVariety->setupEditAttributes();
            $curVal = trim(strval($this->SeedVariety->CurrentValue));
            if ($curVal != "") {
                $this->SeedVariety->ViewValue = $this->SeedVariety->lookupCacheOption($curVal);
            } else {
                $this->SeedVariety->ViewValue = $this->SeedVariety->Lookup !== null && is_array($this->SeedVariety->lookupOptions()) && count($this->SeedVariety->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->SeedVariety->ViewValue !== null) { // Load from cache
                $this->SeedVariety->EditValue = array_values($this->SeedVariety->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->SeedVariety->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $this->SeedVariety->CurrentValue, $this->SeedVariety->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                }
                $sqlWrk = $this->SeedVariety->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->SeedVariety->EditValue = $arwrk;
            }
            $this->SeedVariety->PlaceHolder = RemoveHtml($this->SeedVariety->caption());

            // NumberOfMembers
            $this->NumberOfMembers->setupEditAttributes();
            $this->NumberOfMembers->EditValue = $this->NumberOfMembers->CurrentValue;
            $this->NumberOfMembers->PlaceHolder = RemoveHtml($this->NumberOfMembers->caption());
            if (strval($this->NumberOfMembers->EditValue) != "" && is_numeric($this->NumberOfMembers->EditValue)) {
                $this->NumberOfMembers->EditValue = $this->NumberOfMembers->EditValue;
            }

            // FemaleMembers
            $this->FemaleMembers->setupEditAttributes();
            $this->FemaleMembers->EditValue = $this->FemaleMembers->CurrentValue;
            $this->FemaleMembers->PlaceHolder = RemoveHtml($this->FemaleMembers->caption());
            if (strval($this->FemaleMembers->EditValue) != "" && is_numeric($this->FemaleMembers->EditValue)) {
                $this->FemaleMembers->EditValue = $this->FemaleMembers->EditValue;
            }

            // MaleMembers
            $this->MaleMembers->setupEditAttributes();
            $this->MaleMembers->EditValue = $this->MaleMembers->CurrentValue;
            $this->MaleMembers->PlaceHolder = RemoveHtml($this->MaleMembers->caption());
            if (strval($this->MaleMembers->EditValue) != "" && is_numeric($this->MaleMembers->EditValue)) {
                $this->MaleMembers->EditValue = $this->MaleMembers->EditValue;
            }

            // YoungFemales
            $this->YoungFemales->setupEditAttributes();
            $this->YoungFemales->EditValue = $this->YoungFemales->CurrentValue;
            $this->YoungFemales->PlaceHolder = RemoveHtml($this->YoungFemales->caption());
            if (strval($this->YoungFemales->EditValue) != "" && is_numeric($this->YoungFemales->EditValue)) {
                $this->YoungFemales->EditValue = $this->YoungFemales->EditValue;
            }

            // YoungMales
            $this->YoungMales->setupEditAttributes();
            $this->YoungMales->EditValue = $this->YoungMales->CurrentValue;
            $this->YoungMales->PlaceHolder = RemoveHtml($this->YoungMales->caption());
            if (strval($this->YoungMales->EditValue) != "" && is_numeric($this->YoungMales->EditValue)) {
                $this->YoungMales->EditValue = $this->YoungMales->EditValue;
            }

            // FemalesInManagement
            $this->FemalesInManagement->setupEditAttributes();
            $this->FemalesInManagement->EditValue = $this->FemalesInManagement->CurrentValue;
            $this->FemalesInManagement->PlaceHolder = RemoveHtml($this->FemalesInManagement->caption());
            if (strval($this->FemalesInManagement->EditValue) != "" && is_numeric($this->FemalesInManagement->EditValue)) {
                $this->FemalesInManagement->EditValue = $this->FemalesInManagement->EditValue;
            }

            // MalesInManagement
            $this->MalesInManagement->setupEditAttributes();
            $this->MalesInManagement->EditValue = $this->MalesInManagement->CurrentValue;
            $this->MalesInManagement->PlaceHolder = RemoveHtml($this->MalesInManagement->caption());
            if (strval($this->MalesInManagement->EditValue) != "" && is_numeric($this->MalesInManagement->EditValue)) {
                $this->MalesInManagement->EditValue = $this->MalesInManagement->EditValue;
            }

            // Latitude
            $this->Latitude->setupEditAttributes();
            $this->Latitude->EditValue = $this->Latitude->CurrentValue;
            $this->Latitude->PlaceHolder = RemoveHtml($this->Latitude->caption());
            if (strval($this->Latitude->EditValue) != "" && is_numeric($this->Latitude->EditValue)) {
                $this->Latitude->EditValue = FormatNumber($this->Latitude->EditValue, null);
            }

            // Longitude
            $this->Longitude->setupEditAttributes();
            $this->Longitude->EditValue = $this->Longitude->CurrentValue;
            $this->Longitude->PlaceHolder = RemoveHtml($this->Longitude->caption());
            if (strval($this->Longitude->EditValue) != "" && is_numeric($this->Longitude->EditValue)) {
                $this->Longitude->EditValue = FormatNumber($this->Longitude->EditValue, null);
            }

            // Edit refer script

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // NurseryCode
            $this->NurseryCode->HrefValue = "";

            // NurseryName
            $this->NurseryName->HrefValue = "";

            // NurseryType
            $this->NurseryType->HrefValue = "";

            // PhysicalAddress
            $this->PhysicalAddress->HrefValue = "";

            // PostalAddress
            $this->PostalAddress->HrefValue = "";

            // Phone
            $this->Phone->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // NurseryOwnership
            $this->NurseryOwnership->HrefValue = "";

            // SeedVariety
            $this->SeedVariety->HrefValue = "";

            // NumberOfMembers
            $this->NumberOfMembers->HrefValue = "";

            // FemaleMembers
            $this->FemaleMembers->HrefValue = "";

            // MaleMembers
            $this->MaleMembers->HrefValue = "";

            // YoungFemales
            $this->YoungFemales->HrefValue = "";

            // YoungMales
            $this->YoungMales->HrefValue = "";

            // FemalesInManagement
            $this->FemalesInManagement->HrefValue = "";

            // MalesInManagement
            $this->MalesInManagement->HrefValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->ProvinceCode->Visible && $this->ProvinceCode->Required) {
                if (!$this->ProvinceCode->IsDetailKey && EmptyValue($this->ProvinceCode->FormValue)) {
                    $this->ProvinceCode->addErrorMessage(str_replace("%s", $this->ProvinceCode->caption(), $this->ProvinceCode->RequiredErrorMessage));
                }
            }
            if ($this->DistrictCode->Visible && $this->DistrictCode->Required) {
                if (!$this->DistrictCode->IsDetailKey && EmptyValue($this->DistrictCode->FormValue)) {
                    $this->DistrictCode->addErrorMessage(str_replace("%s", $this->DistrictCode->caption(), $this->DistrictCode->RequiredErrorMessage));
                }
            }
            if ($this->NurseryCode->Visible && $this->NurseryCode->Required) {
                if (!$this->NurseryCode->IsDetailKey && EmptyValue($this->NurseryCode->FormValue)) {
                    $this->NurseryCode->addErrorMessage(str_replace("%s", $this->NurseryCode->caption(), $this->NurseryCode->RequiredErrorMessage));
                }
            }
            if ($this->NurseryName->Visible && $this->NurseryName->Required) {
                if (!$this->NurseryName->IsDetailKey && EmptyValue($this->NurseryName->FormValue)) {
                    $this->NurseryName->addErrorMessage(str_replace("%s", $this->NurseryName->caption(), $this->NurseryName->RequiredErrorMessage));
                }
            }
            if ($this->NurseryType->Visible && $this->NurseryType->Required) {
                if (!$this->NurseryType->IsDetailKey && EmptyValue($this->NurseryType->FormValue)) {
                    $this->NurseryType->addErrorMessage(str_replace("%s", $this->NurseryType->caption(), $this->NurseryType->RequiredErrorMessage));
                }
            }
            if ($this->PhysicalAddress->Visible && $this->PhysicalAddress->Required) {
                if (!$this->PhysicalAddress->IsDetailKey && EmptyValue($this->PhysicalAddress->FormValue)) {
                    $this->PhysicalAddress->addErrorMessage(str_replace("%s", $this->PhysicalAddress->caption(), $this->PhysicalAddress->RequiredErrorMessage));
                }
            }
            if ($this->PostalAddress->Visible && $this->PostalAddress->Required) {
                if (!$this->PostalAddress->IsDetailKey && EmptyValue($this->PostalAddress->FormValue)) {
                    $this->PostalAddress->addErrorMessage(str_replace("%s", $this->PostalAddress->caption(), $this->PostalAddress->RequiredErrorMessage));
                }
            }
            if ($this->Phone->Visible && $this->Phone->Required) {
                if (!$this->Phone->IsDetailKey && EmptyValue($this->Phone->FormValue)) {
                    $this->Phone->addErrorMessage(str_replace("%s", $this->Phone->caption(), $this->Phone->RequiredErrorMessage));
                }
            }
            if ($this->_Email->Visible && $this->_Email->Required) {
                if (!$this->_Email->IsDetailKey && EmptyValue($this->_Email->FormValue)) {
                    $this->_Email->addErrorMessage(str_replace("%s", $this->_Email->caption(), $this->_Email->RequiredErrorMessage));
                }
            }
            if (!CheckEmail($this->_Email->FormValue)) {
                $this->_Email->addErrorMessage($this->_Email->getErrorMessage(false));
            }
            if ($this->NurseryOwnership->Visible && $this->NurseryOwnership->Required) {
                if (!$this->NurseryOwnership->IsDetailKey && EmptyValue($this->NurseryOwnership->FormValue)) {
                    $this->NurseryOwnership->addErrorMessage(str_replace("%s", $this->NurseryOwnership->caption(), $this->NurseryOwnership->RequiredErrorMessage));
                }
            }
            if ($this->SeedVariety->Visible && $this->SeedVariety->Required) {
                if (!$this->SeedVariety->IsDetailKey && EmptyValue($this->SeedVariety->FormValue)) {
                    $this->SeedVariety->addErrorMessage(str_replace("%s", $this->SeedVariety->caption(), $this->SeedVariety->RequiredErrorMessage));
                }
            }
            if ($this->NumberOfMembers->Visible && $this->NumberOfMembers->Required) {
                if (!$this->NumberOfMembers->IsDetailKey && EmptyValue($this->NumberOfMembers->FormValue)) {
                    $this->NumberOfMembers->addErrorMessage(str_replace("%s", $this->NumberOfMembers->caption(), $this->NumberOfMembers->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->NumberOfMembers->FormValue)) {
                $this->NumberOfMembers->addErrorMessage($this->NumberOfMembers->getErrorMessage(false));
            }
            if ($this->FemaleMembers->Visible && $this->FemaleMembers->Required) {
                if (!$this->FemaleMembers->IsDetailKey && EmptyValue($this->FemaleMembers->FormValue)) {
                    $this->FemaleMembers->addErrorMessage(str_replace("%s", $this->FemaleMembers->caption(), $this->FemaleMembers->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->FemaleMembers->FormValue)) {
                $this->FemaleMembers->addErrorMessage($this->FemaleMembers->getErrorMessage(false));
            }
            if ($this->MaleMembers->Visible && $this->MaleMembers->Required) {
                if (!$this->MaleMembers->IsDetailKey && EmptyValue($this->MaleMembers->FormValue)) {
                    $this->MaleMembers->addErrorMessage(str_replace("%s", $this->MaleMembers->caption(), $this->MaleMembers->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->MaleMembers->FormValue)) {
                $this->MaleMembers->addErrorMessage($this->MaleMembers->getErrorMessage(false));
            }
            if ($this->YoungFemales->Visible && $this->YoungFemales->Required) {
                if (!$this->YoungFemales->IsDetailKey && EmptyValue($this->YoungFemales->FormValue)) {
                    $this->YoungFemales->addErrorMessage(str_replace("%s", $this->YoungFemales->caption(), $this->YoungFemales->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->YoungFemales->FormValue)) {
                $this->YoungFemales->addErrorMessage($this->YoungFemales->getErrorMessage(false));
            }
            if ($this->YoungMales->Visible && $this->YoungMales->Required) {
                if (!$this->YoungMales->IsDetailKey && EmptyValue($this->YoungMales->FormValue)) {
                    $this->YoungMales->addErrorMessage(str_replace("%s", $this->YoungMales->caption(), $this->YoungMales->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->YoungMales->FormValue)) {
                $this->YoungMales->addErrorMessage($this->YoungMales->getErrorMessage(false));
            }
            if ($this->FemalesInManagement->Visible && $this->FemalesInManagement->Required) {
                if (!$this->FemalesInManagement->IsDetailKey && EmptyValue($this->FemalesInManagement->FormValue)) {
                    $this->FemalesInManagement->addErrorMessage(str_replace("%s", $this->FemalesInManagement->caption(), $this->FemalesInManagement->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->FemalesInManagement->FormValue)) {
                $this->FemalesInManagement->addErrorMessage($this->FemalesInManagement->getErrorMessage(false));
            }
            if ($this->MalesInManagement->Visible && $this->MalesInManagement->Required) {
                if (!$this->MalesInManagement->IsDetailKey && EmptyValue($this->MalesInManagement->FormValue)) {
                    $this->MalesInManagement->addErrorMessage(str_replace("%s", $this->MalesInManagement->caption(), $this->MalesInManagement->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->MalesInManagement->FormValue)) {
                $this->MalesInManagement->addErrorMessage($this->MalesInManagement->getErrorMessage(false));
            }
            if ($this->Latitude->Visible && $this->Latitude->Required) {
                if (!$this->Latitude->IsDetailKey && EmptyValue($this->Latitude->FormValue)) {
                    $this->Latitude->addErrorMessage(str_replace("%s", $this->Latitude->caption(), $this->Latitude->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Latitude->FormValue)) {
                $this->Latitude->addErrorMessage($this->Latitude->getErrorMessage(false));
            }
            if ($this->Longitude->Visible && $this->Longitude->Required) {
                if (!$this->Longitude->IsDetailKey && EmptyValue($this->Longitude->FormValue)) {
                    $this->Longitude->addErrorMessage(str_replace("%s", $this->Longitude->caption(), $this->Longitude->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Longitude->FormValue)) {
                $this->Longitude->addErrorMessage($this->Longitude->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['NurseryCode'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // ProvinceCode
        if ($this->ProvinceCode->getSessionValue() != "") {
            $this->ProvinceCode->ReadOnly = true;
        }
        $this->ProvinceCode->setDbValueDef($rsnew, $this->ProvinceCode->CurrentValue, $this->ProvinceCode->ReadOnly);

        // DistrictCode
        if ($this->DistrictCode->getSessionValue() != "") {
            $this->DistrictCode->ReadOnly = true;
        }
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, $this->DistrictCode->ReadOnly);

        // NurseryName
        $this->NurseryName->setDbValueDef($rsnew, $this->NurseryName->CurrentValue, $this->NurseryName->ReadOnly);

        // NurseryType
        $this->NurseryType->setDbValueDef($rsnew, $this->NurseryType->CurrentValue, $this->NurseryType->ReadOnly);

        // PhysicalAddress
        $this->PhysicalAddress->setDbValueDef($rsnew, $this->PhysicalAddress->CurrentValue, $this->PhysicalAddress->ReadOnly);

        // PostalAddress
        $this->PostalAddress->setDbValueDef($rsnew, $this->PostalAddress->CurrentValue, $this->PostalAddress->ReadOnly);

        // Phone
        $this->Phone->setDbValueDef($rsnew, $this->Phone->CurrentValue, $this->Phone->ReadOnly);

        // Email
        $this->_Email->setDbValueDef($rsnew, $this->_Email->CurrentValue, $this->_Email->ReadOnly);

        // NurseryOwnership
        $this->NurseryOwnership->setDbValueDef($rsnew, $this->NurseryOwnership->CurrentValue, $this->NurseryOwnership->ReadOnly);

        // SeedVariety
        $this->SeedVariety->setDbValueDef($rsnew, $this->SeedVariety->CurrentValue, $this->SeedVariety->ReadOnly);

        // NumberOfMembers
        $this->NumberOfMembers->setDbValueDef($rsnew, $this->NumberOfMembers->CurrentValue, $this->NumberOfMembers->ReadOnly);

        // FemaleMembers
        $this->FemaleMembers->setDbValueDef($rsnew, $this->FemaleMembers->CurrentValue, $this->FemaleMembers->ReadOnly);

        // MaleMembers
        $this->MaleMembers->setDbValueDef($rsnew, $this->MaleMembers->CurrentValue, $this->MaleMembers->ReadOnly);

        // YoungFemales
        $this->YoungFemales->setDbValueDef($rsnew, $this->YoungFemales->CurrentValue, $this->YoungFemales->ReadOnly);

        // YoungMales
        $this->YoungMales->setDbValueDef($rsnew, $this->YoungMales->CurrentValue, $this->YoungMales->ReadOnly);

        // FemalesInManagement
        $this->FemalesInManagement->setDbValueDef($rsnew, $this->FemalesInManagement->CurrentValue, $this->FemalesInManagement->ReadOnly);

        // MalesInManagement
        $this->MalesInManagement->setDbValueDef($rsnew, $this->MalesInManagement->CurrentValue, $this->MalesInManagement->ReadOnly);

        // Latitude
        $this->Latitude->setDbValueDef($rsnew, $this->Latitude->CurrentValue, $this->Latitude->ReadOnly);

        // Longitude
        $this->Longitude->setDbValueDef($rsnew, $this->Longitude->CurrentValue, $this->Longitude->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['ProvinceCode'])) { // ProvinceCode
            $this->ProvinceCode->CurrentValue = $row['ProvinceCode'];
        }
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->CurrentValue = $row['DistrictCode'];
        }
        if (isset($row['NurseryName'])) { // NurseryName
            $this->NurseryName->CurrentValue = $row['NurseryName'];
        }
        if (isset($row['NurseryType'])) { // NurseryType
            $this->NurseryType->CurrentValue = $row['NurseryType'];
        }
        if (isset($row['PhysicalAddress'])) { // PhysicalAddress
            $this->PhysicalAddress->CurrentValue = $row['PhysicalAddress'];
        }
        if (isset($row['PostalAddress'])) { // PostalAddress
            $this->PostalAddress->CurrentValue = $row['PostalAddress'];
        }
        if (isset($row['Phone'])) { // Phone
            $this->Phone->CurrentValue = $row['Phone'];
        }
        if (isset($row['Email'])) { // Email
            $this->_Email->CurrentValue = $row['Email'];
        }
        if (isset($row['NurseryOwnership'])) { // NurseryOwnership
            $this->NurseryOwnership->CurrentValue = $row['NurseryOwnership'];
        }
        if (isset($row['SeedVariety'])) { // SeedVariety
            $this->SeedVariety->CurrentValue = $row['SeedVariety'];
        }
        if (isset($row['NumberOfMembers'])) { // NumberOfMembers
            $this->NumberOfMembers->CurrentValue = $row['NumberOfMembers'];
        }
        if (isset($row['FemaleMembers'])) { // FemaleMembers
            $this->FemaleMembers->CurrentValue = $row['FemaleMembers'];
        }
        if (isset($row['MaleMembers'])) { // MaleMembers
            $this->MaleMembers->CurrentValue = $row['MaleMembers'];
        }
        if (isset($row['YoungFemales'])) { // YoungFemales
            $this->YoungFemales->CurrentValue = $row['YoungFemales'];
        }
        if (isset($row['YoungMales'])) { // YoungMales
            $this->YoungMales->CurrentValue = $row['YoungMales'];
        }
        if (isset($row['FemalesInManagement'])) { // FemalesInManagement
            $this->FemalesInManagement->CurrentValue = $row['FemalesInManagement'];
        }
        if (isset($row['MalesInManagement'])) { // MalesInManagement
            $this->MalesInManagement->CurrentValue = $row['MalesInManagement'];
        }
        if (isset($row['Latitude'])) { // Latitude
            $this->Latitude->CurrentValue = $row['Latitude'];
        }
        if (isset($row['Longitude'])) { // Longitude
            $this->Longitude->CurrentValue = $row['Longitude'];
        }
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set up foreign key field value from Session
        if ($this->getCurrentMasterTable() == "district") {
            $this->ProvinceCode->Visible = true; // Need to insert foreign key
            $this->ProvinceCode->CurrentValue = $this->ProvinceCode->getSessionValue();
            $this->DistrictCode->Visible = true; // Need to insert foreign key
            $this->DistrictCode->CurrentValue = $this->DistrictCode->getSessionValue();
        }

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // ProvinceCode
        $this->ProvinceCode->setDbValueDef($rsnew, $this->ProvinceCode->CurrentValue, strval($this->ProvinceCode->CurrentValue) == "");

        // DistrictCode
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, strval($this->DistrictCode->CurrentValue) == "");

        // NurseryName
        $this->NurseryName->setDbValueDef($rsnew, $this->NurseryName->CurrentValue, false);

        // NurseryType
        $this->NurseryType->setDbValueDef($rsnew, $this->NurseryType->CurrentValue, false);

        // PhysicalAddress
        $this->PhysicalAddress->setDbValueDef($rsnew, $this->PhysicalAddress->CurrentValue, false);

        // PostalAddress
        $this->PostalAddress->setDbValueDef($rsnew, $this->PostalAddress->CurrentValue, false);

        // Phone
        $this->Phone->setDbValueDef($rsnew, $this->Phone->CurrentValue, false);

        // Email
        $this->_Email->setDbValueDef($rsnew, $this->_Email->CurrentValue, false);

        // NurseryOwnership
        $this->NurseryOwnership->setDbValueDef($rsnew, $this->NurseryOwnership->CurrentValue, false);

        // SeedVariety
        $this->SeedVariety->setDbValueDef($rsnew, $this->SeedVariety->CurrentValue, false);

        // NumberOfMembers
        $this->NumberOfMembers->setDbValueDef($rsnew, $this->NumberOfMembers->CurrentValue, false);

        // FemaleMembers
        $this->FemaleMembers->setDbValueDef($rsnew, $this->FemaleMembers->CurrentValue, false);

        // MaleMembers
        $this->MaleMembers->setDbValueDef($rsnew, $this->MaleMembers->CurrentValue, false);

        // YoungFemales
        $this->YoungFemales->setDbValueDef($rsnew, $this->YoungFemales->CurrentValue, false);

        // YoungMales
        $this->YoungMales->setDbValueDef($rsnew, $this->YoungMales->CurrentValue, false);

        // FemalesInManagement
        $this->FemalesInManagement->setDbValueDef($rsnew, $this->FemalesInManagement->CurrentValue, false);

        // MalesInManagement
        $this->MalesInManagement->setDbValueDef($rsnew, $this->MalesInManagement->CurrentValue, false);

        // Latitude
        $this->Latitude->setDbValueDef($rsnew, $this->Latitude->CurrentValue, false);

        // Longitude
        $this->Longitude->setDbValueDef($rsnew, $this->Longitude->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['ProvinceCode'])) { // ProvinceCode
            $this->ProvinceCode->setFormValue($row['ProvinceCode']);
        }
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->setFormValue($row['DistrictCode']);
        }
        if (isset($row['NurseryName'])) { // NurseryName
            $this->NurseryName->setFormValue($row['NurseryName']);
        }
        if (isset($row['NurseryType'])) { // NurseryType
            $this->NurseryType->setFormValue($row['NurseryType']);
        }
        if (isset($row['PhysicalAddress'])) { // PhysicalAddress
            $this->PhysicalAddress->setFormValue($row['PhysicalAddress']);
        }
        if (isset($row['PostalAddress'])) { // PostalAddress
            $this->PostalAddress->setFormValue($row['PostalAddress']);
        }
        if (isset($row['Phone'])) { // Phone
            $this->Phone->setFormValue($row['Phone']);
        }
        if (isset($row['Email'])) { // Email
            $this->_Email->setFormValue($row['Email']);
        }
        if (isset($row['NurseryOwnership'])) { // NurseryOwnership
            $this->NurseryOwnership->setFormValue($row['NurseryOwnership']);
        }
        if (isset($row['SeedVariety'])) { // SeedVariety
            $this->SeedVariety->setFormValue($row['SeedVariety']);
        }
        if (isset($row['NumberOfMembers'])) { // NumberOfMembers
            $this->NumberOfMembers->setFormValue($row['NumberOfMembers']);
        }
        if (isset($row['FemaleMembers'])) { // FemaleMembers
            $this->FemaleMembers->setFormValue($row['FemaleMembers']);
        }
        if (isset($row['MaleMembers'])) { // MaleMembers
            $this->MaleMembers->setFormValue($row['MaleMembers']);
        }
        if (isset($row['YoungFemales'])) { // YoungFemales
            $this->YoungFemales->setFormValue($row['YoungFemales']);
        }
        if (isset($row['YoungMales'])) { // YoungMales
            $this->YoungMales->setFormValue($row['YoungMales']);
        }
        if (isset($row['FemalesInManagement'])) { // FemalesInManagement
            $this->FemalesInManagement->setFormValue($row['FemalesInManagement']);
        }
        if (isset($row['MalesInManagement'])) { // MalesInManagement
            $this->MalesInManagement->setFormValue($row['MalesInManagement']);
        }
        if (isset($row['Latitude'])) { // Latitude
            $this->Latitude->setFormValue($row['Latitude']);
        }
        if (isset($row['Longitude'])) { // Longitude
            $this->Longitude->setFormValue($row['Longitude']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        // Hide foreign keys
        $masterTblVar = $this->getCurrentMasterTable();
        if ($masterTblVar == "district") {
            $masterTbl = Container("district");
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
            $this->DistrictCode->Visible = false;
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ProvinceCode":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_DistrictCode":
                    break;
                case "x_NurseryType":
                    break;
                case "x_NurseryOwnership":
                    break;
                case "x_SeedVariety":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }
}
