<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class InspectionViewList extends InspectionView
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "InspectionViewList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "finspection_viewlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "InspectionViewList";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->Latitude->setVisibility();
        $this->Longitude->setVisibility();
        $this->FieldType->setVisibility();
        $this->Ownership->setVisibility();
        $this->FarmSize->setVisibility();
        $this->FarmSizeEstimated->setVisibility();
        $this->TreesPlantedEstimated->setVisibility();
        $this->FarmSizeVerified->setVisibility();
        $this->TreesPlantedVerified->setVisibility();
        $this->FarmNo->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmerName->setVisibility();
        $this->DOB->setVisibility();
        $this->Age->setVisibility();
        $this->Gender->setVisibility();
        $this->MaritalStatus->setVisibility();
        $this->PhoneNo->setVisibility();
        $this->_Email->setVisibility();
        $this->Dependants->setVisibility();
        $this->MaleChildren->setVisibility();
        $this->FemaleChildren->setVisibility();
        $this->HouseholdHead->setVisibility();
        $this->FarmerOrg->setVisibility();
        $this->FarmerOrgPosition->setVisibility();
        $this->JoiningDate->setVisibility();
        $this->CampName->setVisibility();
        $this->DistrictName->setVisibility();
        $this->InspectionTransNo->setVisibility();
        $this->PlantsDead->setVisibility();
        $this->PlantsVerifiedNo->setVisibility();
        $this->PlantsReplaced->setVisibility();
        $this->FungicidesReceived->setVisibility();
        $this->PescticidesReceived->setVisibility();
        $this->DiseasePresence->setVisibility();
        $this->AvailableLand->setVisibility();
        $this->LandForCashewCleared->setVisibility();
        $this->HolesDug->setVisibility();
        $this->VerifiedSeedlingArea->setVisibility();
        $this->OldTreesNo->setVisibility();
        $this->InspectionReport->Visible = false;
        $this->InspectionDate->setVisibility();
        $this->InspectedBy->setVisibility();
        $this->AuthorisedBy->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'inspection_view';
        $this->TableName = 'inspection_view';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (inspection_view)
        if (!isset($GLOBALS["inspection_view"]) || $GLOBALS["inspection_view"]::class == PROJECT_NAMESPACE . "inspection_view") {
            $GLOBALS["inspection_view"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "InspectionViewAdd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "InspectionViewDelete";
        $this->MultiUpdateUrl = "InspectionViewUpdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'inspection_view');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "InspectionViewView"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['FarmNo'] . Config("COMPOSITE_KEY_SEPARATOR");
            $key .= @$ar['InspectionTransNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->FarmNo->Visible = false;
        }
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->InspectionTransNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "finspection_viewgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("finspection_viewsrch");
        }
        $filterList = Concat($filterList, $this->Latitude->AdvancedSearch->toJson(), ","); // Field Latitude
        $filterList = Concat($filterList, $this->Longitude->AdvancedSearch->toJson(), ","); // Field Longitude
        $filterList = Concat($filterList, $this->FieldType->AdvancedSearch->toJson(), ","); // Field FieldType
        $filterList = Concat($filterList, $this->Ownership->AdvancedSearch->toJson(), ","); // Field Ownership
        $filterList = Concat($filterList, $this->FarmSize->AdvancedSearch->toJson(), ","); // Field FarmSize
        $filterList = Concat($filterList, $this->FarmSizeEstimated->AdvancedSearch->toJson(), ","); // Field FarmSizeEstimated
        $filterList = Concat($filterList, $this->TreesPlantedEstimated->AdvancedSearch->toJson(), ","); // Field TreesPlantedEstimated
        $filterList = Concat($filterList, $this->FarmSizeVerified->AdvancedSearch->toJson(), ","); // Field FarmSizeVerified
        $filterList = Concat($filterList, $this->TreesPlantedVerified->AdvancedSearch->toJson(), ","); // Field TreesPlantedVerified
        $filterList = Concat($filterList, $this->FarmNo->AdvancedSearch->toJson(), ","); // Field FarmNo
        $filterList = Concat($filterList, $this->NRC->AdvancedSearch->toJson(), ","); // Field NRC
        $filterList = Concat($filterList, $this->FarmerName->AdvancedSearch->toJson(), ","); // Field FarmerName
        $filterList = Concat($filterList, $this->DOB->AdvancedSearch->toJson(), ","); // Field DOB
        $filterList = Concat($filterList, $this->Age->AdvancedSearch->toJson(), ","); // Field Age
        $filterList = Concat($filterList, $this->Gender->AdvancedSearch->toJson(), ","); // Field Gender
        $filterList = Concat($filterList, $this->MaritalStatus->AdvancedSearch->toJson(), ","); // Field MaritalStatus
        $filterList = Concat($filterList, $this->PhoneNo->AdvancedSearch->toJson(), ","); // Field PhoneNo
        $filterList = Concat($filterList, $this->_Email->AdvancedSearch->toJson(), ","); // Field Email
        $filterList = Concat($filterList, $this->Dependants->AdvancedSearch->toJson(), ","); // Field Dependants
        $filterList = Concat($filterList, $this->MaleChildren->AdvancedSearch->toJson(), ","); // Field MaleChildren
        $filterList = Concat($filterList, $this->FemaleChildren->AdvancedSearch->toJson(), ","); // Field FemaleChildren
        $filterList = Concat($filterList, $this->HouseholdHead->AdvancedSearch->toJson(), ","); // Field HouseholdHead
        $filterList = Concat($filterList, $this->FarmerOrg->AdvancedSearch->toJson(), ","); // Field FarmerOrg
        $filterList = Concat($filterList, $this->FarmerOrgPosition->AdvancedSearch->toJson(), ","); // Field FarmerOrgPosition
        $filterList = Concat($filterList, $this->JoiningDate->AdvancedSearch->toJson(), ","); // Field JoiningDate
        $filterList = Concat($filterList, $this->CampName->AdvancedSearch->toJson(), ","); // Field CampName
        $filterList = Concat($filterList, $this->DistrictName->AdvancedSearch->toJson(), ","); // Field DistrictName
        $filterList = Concat($filterList, $this->InspectionTransNo->AdvancedSearch->toJson(), ","); // Field InspectionTransNo
        $filterList = Concat($filterList, $this->PlantsDead->AdvancedSearch->toJson(), ","); // Field PlantsDead
        $filterList = Concat($filterList, $this->PlantsVerifiedNo->AdvancedSearch->toJson(), ","); // Field PlantsVerifiedNo
        $filterList = Concat($filterList, $this->PlantsReplaced->AdvancedSearch->toJson(), ","); // Field PlantsReplaced
        $filterList = Concat($filterList, $this->FungicidesReceived->AdvancedSearch->toJson(), ","); // Field FungicidesReceived
        $filterList = Concat($filterList, $this->PescticidesReceived->AdvancedSearch->toJson(), ","); // Field PescticidesReceived
        $filterList = Concat($filterList, $this->DiseasePresence->AdvancedSearch->toJson(), ","); // Field DiseasePresence
        $filterList = Concat($filterList, $this->AvailableLand->AdvancedSearch->toJson(), ","); // Field AvailableLand
        $filterList = Concat($filterList, $this->LandForCashewCleared->AdvancedSearch->toJson(), ","); // Field LandForCashewCleared
        $filterList = Concat($filterList, $this->HolesDug->AdvancedSearch->toJson(), ","); // Field HolesDug
        $filterList = Concat($filterList, $this->VerifiedSeedlingArea->AdvancedSearch->toJson(), ","); // Field VerifiedSeedlingArea
        $filterList = Concat($filterList, $this->OldTreesNo->AdvancedSearch->toJson(), ","); // Field OldTreesNo
        $filterList = Concat($filterList, $this->InspectionReport->AdvancedSearch->toJson(), ","); // Field InspectionReport
        $filterList = Concat($filterList, $this->InspectionDate->AdvancedSearch->toJson(), ","); // Field InspectionDate
        $filterList = Concat($filterList, $this->InspectedBy->AdvancedSearch->toJson(), ","); // Field InspectedBy
        $filterList = Concat($filterList, $this->AuthorisedBy->AdvancedSearch->toJson(), ","); // Field AuthorisedBy
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("finspection_viewsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field Latitude
        $this->Latitude->AdvancedSearch->SearchValue = @$filter["x_Latitude"];
        $this->Latitude->AdvancedSearch->SearchOperator = @$filter["z_Latitude"];
        $this->Latitude->AdvancedSearch->SearchCondition = @$filter["v_Latitude"];
        $this->Latitude->AdvancedSearch->SearchValue2 = @$filter["y_Latitude"];
        $this->Latitude->AdvancedSearch->SearchOperator2 = @$filter["w_Latitude"];
        $this->Latitude->AdvancedSearch->save();

        // Field Longitude
        $this->Longitude->AdvancedSearch->SearchValue = @$filter["x_Longitude"];
        $this->Longitude->AdvancedSearch->SearchOperator = @$filter["z_Longitude"];
        $this->Longitude->AdvancedSearch->SearchCondition = @$filter["v_Longitude"];
        $this->Longitude->AdvancedSearch->SearchValue2 = @$filter["y_Longitude"];
        $this->Longitude->AdvancedSearch->SearchOperator2 = @$filter["w_Longitude"];
        $this->Longitude->AdvancedSearch->save();

        // Field FieldType
        $this->FieldType->AdvancedSearch->SearchValue = @$filter["x_FieldType"];
        $this->FieldType->AdvancedSearch->SearchOperator = @$filter["z_FieldType"];
        $this->FieldType->AdvancedSearch->SearchCondition = @$filter["v_FieldType"];
        $this->FieldType->AdvancedSearch->SearchValue2 = @$filter["y_FieldType"];
        $this->FieldType->AdvancedSearch->SearchOperator2 = @$filter["w_FieldType"];
        $this->FieldType->AdvancedSearch->save();

        // Field Ownership
        $this->Ownership->AdvancedSearch->SearchValue = @$filter["x_Ownership"];
        $this->Ownership->AdvancedSearch->SearchOperator = @$filter["z_Ownership"];
        $this->Ownership->AdvancedSearch->SearchCondition = @$filter["v_Ownership"];
        $this->Ownership->AdvancedSearch->SearchValue2 = @$filter["y_Ownership"];
        $this->Ownership->AdvancedSearch->SearchOperator2 = @$filter["w_Ownership"];
        $this->Ownership->AdvancedSearch->save();

        // Field FarmSize
        $this->FarmSize->AdvancedSearch->SearchValue = @$filter["x_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchOperator = @$filter["z_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchCondition = @$filter["v_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchValue2 = @$filter["y_FarmSize"];
        $this->FarmSize->AdvancedSearch->SearchOperator2 = @$filter["w_FarmSize"];
        $this->FarmSize->AdvancedSearch->save();

        // Field FarmSizeEstimated
        $this->FarmSizeEstimated->AdvancedSearch->SearchValue = @$filter["x_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchOperator = @$filter["z_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchCondition = @$filter["v_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchValue2 = @$filter["y_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->SearchOperator2 = @$filter["w_FarmSizeEstimated"];
        $this->FarmSizeEstimated->AdvancedSearch->save();

        // Field TreesPlantedEstimated
        $this->TreesPlantedEstimated->AdvancedSearch->SearchValue = @$filter["x_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchOperator = @$filter["z_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchCondition = @$filter["v_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchValue2 = @$filter["y_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->SearchOperator2 = @$filter["w_TreesPlantedEstimated"];
        $this->TreesPlantedEstimated->AdvancedSearch->save();

        // Field FarmSizeVerified
        $this->FarmSizeVerified->AdvancedSearch->SearchValue = @$filter["x_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchOperator = @$filter["z_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchCondition = @$filter["v_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchValue2 = @$filter["y_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->SearchOperator2 = @$filter["w_FarmSizeVerified"];
        $this->FarmSizeVerified->AdvancedSearch->save();

        // Field TreesPlantedVerified
        $this->TreesPlantedVerified->AdvancedSearch->SearchValue = @$filter["x_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchOperator = @$filter["z_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchCondition = @$filter["v_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchValue2 = @$filter["y_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->SearchOperator2 = @$filter["w_TreesPlantedVerified"];
        $this->TreesPlantedVerified->AdvancedSearch->save();

        // Field FarmNo
        $this->FarmNo->AdvancedSearch->SearchValue = @$filter["x_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchOperator = @$filter["z_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchCondition = @$filter["v_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchValue2 = @$filter["y_FarmNo"];
        $this->FarmNo->AdvancedSearch->SearchOperator2 = @$filter["w_FarmNo"];
        $this->FarmNo->AdvancedSearch->save();

        // Field NRC
        $this->NRC->AdvancedSearch->SearchValue = @$filter["x_NRC"];
        $this->NRC->AdvancedSearch->SearchOperator = @$filter["z_NRC"];
        $this->NRC->AdvancedSearch->SearchCondition = @$filter["v_NRC"];
        $this->NRC->AdvancedSearch->SearchValue2 = @$filter["y_NRC"];
        $this->NRC->AdvancedSearch->SearchOperator2 = @$filter["w_NRC"];
        $this->NRC->AdvancedSearch->save();

        // Field FarmerName
        $this->FarmerName->AdvancedSearch->SearchValue = @$filter["x_FarmerName"];
        $this->FarmerName->AdvancedSearch->SearchOperator = @$filter["z_FarmerName"];
        $this->FarmerName->AdvancedSearch->SearchCondition = @$filter["v_FarmerName"];
        $this->FarmerName->AdvancedSearch->SearchValue2 = @$filter["y_FarmerName"];
        $this->FarmerName->AdvancedSearch->SearchOperator2 = @$filter["w_FarmerName"];
        $this->FarmerName->AdvancedSearch->save();

        // Field DOB
        $this->DOB->AdvancedSearch->SearchValue = @$filter["x_DOB"];
        $this->DOB->AdvancedSearch->SearchOperator = @$filter["z_DOB"];
        $this->DOB->AdvancedSearch->SearchCondition = @$filter["v_DOB"];
        $this->DOB->AdvancedSearch->SearchValue2 = @$filter["y_DOB"];
        $this->DOB->AdvancedSearch->SearchOperator2 = @$filter["w_DOB"];
        $this->DOB->AdvancedSearch->save();

        // Field Age
        $this->Age->AdvancedSearch->SearchValue = @$filter["x_Age"];
        $this->Age->AdvancedSearch->SearchOperator = @$filter["z_Age"];
        $this->Age->AdvancedSearch->SearchCondition = @$filter["v_Age"];
        $this->Age->AdvancedSearch->SearchValue2 = @$filter["y_Age"];
        $this->Age->AdvancedSearch->SearchOperator2 = @$filter["w_Age"];
        $this->Age->AdvancedSearch->save();

        // Field Gender
        $this->Gender->AdvancedSearch->SearchValue = @$filter["x_Gender"];
        $this->Gender->AdvancedSearch->SearchOperator = @$filter["z_Gender"];
        $this->Gender->AdvancedSearch->SearchCondition = @$filter["v_Gender"];
        $this->Gender->AdvancedSearch->SearchValue2 = @$filter["y_Gender"];
        $this->Gender->AdvancedSearch->SearchOperator2 = @$filter["w_Gender"];
        $this->Gender->AdvancedSearch->save();

        // Field MaritalStatus
        $this->MaritalStatus->AdvancedSearch->SearchValue = @$filter["x_MaritalStatus"];
        $this->MaritalStatus->AdvancedSearch->SearchOperator = @$filter["z_MaritalStatus"];
        $this->MaritalStatus->AdvancedSearch->SearchCondition = @$filter["v_MaritalStatus"];
        $this->MaritalStatus->AdvancedSearch->SearchValue2 = @$filter["y_MaritalStatus"];
        $this->MaritalStatus->AdvancedSearch->SearchOperator2 = @$filter["w_MaritalStatus"];
        $this->MaritalStatus->AdvancedSearch->save();

        // Field PhoneNo
        $this->PhoneNo->AdvancedSearch->SearchValue = @$filter["x_PhoneNo"];
        $this->PhoneNo->AdvancedSearch->SearchOperator = @$filter["z_PhoneNo"];
        $this->PhoneNo->AdvancedSearch->SearchCondition = @$filter["v_PhoneNo"];
        $this->PhoneNo->AdvancedSearch->SearchValue2 = @$filter["y_PhoneNo"];
        $this->PhoneNo->AdvancedSearch->SearchOperator2 = @$filter["w_PhoneNo"];
        $this->PhoneNo->AdvancedSearch->save();

        // Field Email
        $this->_Email->AdvancedSearch->SearchValue = @$filter["x__Email"];
        $this->_Email->AdvancedSearch->SearchOperator = @$filter["z__Email"];
        $this->_Email->AdvancedSearch->SearchCondition = @$filter["v__Email"];
        $this->_Email->AdvancedSearch->SearchValue2 = @$filter["y__Email"];
        $this->_Email->AdvancedSearch->SearchOperator2 = @$filter["w__Email"];
        $this->_Email->AdvancedSearch->save();

        // Field Dependants
        $this->Dependants->AdvancedSearch->SearchValue = @$filter["x_Dependants"];
        $this->Dependants->AdvancedSearch->SearchOperator = @$filter["z_Dependants"];
        $this->Dependants->AdvancedSearch->SearchCondition = @$filter["v_Dependants"];
        $this->Dependants->AdvancedSearch->SearchValue2 = @$filter["y_Dependants"];
        $this->Dependants->AdvancedSearch->SearchOperator2 = @$filter["w_Dependants"];
        $this->Dependants->AdvancedSearch->save();

        // Field MaleChildren
        $this->MaleChildren->AdvancedSearch->SearchValue = @$filter["x_MaleChildren"];
        $this->MaleChildren->AdvancedSearch->SearchOperator = @$filter["z_MaleChildren"];
        $this->MaleChildren->AdvancedSearch->SearchCondition = @$filter["v_MaleChildren"];
        $this->MaleChildren->AdvancedSearch->SearchValue2 = @$filter["y_MaleChildren"];
        $this->MaleChildren->AdvancedSearch->SearchOperator2 = @$filter["w_MaleChildren"];
        $this->MaleChildren->AdvancedSearch->save();

        // Field FemaleChildren
        $this->FemaleChildren->AdvancedSearch->SearchValue = @$filter["x_FemaleChildren"];
        $this->FemaleChildren->AdvancedSearch->SearchOperator = @$filter["z_FemaleChildren"];
        $this->FemaleChildren->AdvancedSearch->SearchCondition = @$filter["v_FemaleChildren"];
        $this->FemaleChildren->AdvancedSearch->SearchValue2 = @$filter["y_FemaleChildren"];
        $this->FemaleChildren->AdvancedSearch->SearchOperator2 = @$filter["w_FemaleChildren"];
        $this->FemaleChildren->AdvancedSearch->save();

        // Field HouseholdHead
        $this->HouseholdHead->AdvancedSearch->SearchValue = @$filter["x_HouseholdHead"];
        $this->HouseholdHead->AdvancedSearch->SearchOperator = @$filter["z_HouseholdHead"];
        $this->HouseholdHead->AdvancedSearch->SearchCondition = @$filter["v_HouseholdHead"];
        $this->HouseholdHead->AdvancedSearch->SearchValue2 = @$filter["y_HouseholdHead"];
        $this->HouseholdHead->AdvancedSearch->SearchOperator2 = @$filter["w_HouseholdHead"];
        $this->HouseholdHead->AdvancedSearch->save();

        // Field FarmerOrg
        $this->FarmerOrg->AdvancedSearch->SearchValue = @$filter["x_FarmerOrg"];
        $this->FarmerOrg->AdvancedSearch->SearchOperator = @$filter["z_FarmerOrg"];
        $this->FarmerOrg->AdvancedSearch->SearchCondition = @$filter["v_FarmerOrg"];
        $this->FarmerOrg->AdvancedSearch->SearchValue2 = @$filter["y_FarmerOrg"];
        $this->FarmerOrg->AdvancedSearch->SearchOperator2 = @$filter["w_FarmerOrg"];
        $this->FarmerOrg->AdvancedSearch->save();

        // Field FarmerOrgPosition
        $this->FarmerOrgPosition->AdvancedSearch->SearchValue = @$filter["x_FarmerOrgPosition"];
        $this->FarmerOrgPosition->AdvancedSearch->SearchOperator = @$filter["z_FarmerOrgPosition"];
        $this->FarmerOrgPosition->AdvancedSearch->SearchCondition = @$filter["v_FarmerOrgPosition"];
        $this->FarmerOrgPosition->AdvancedSearch->SearchValue2 = @$filter["y_FarmerOrgPosition"];
        $this->FarmerOrgPosition->AdvancedSearch->SearchOperator2 = @$filter["w_FarmerOrgPosition"];
        $this->FarmerOrgPosition->AdvancedSearch->save();

        // Field JoiningDate
        $this->JoiningDate->AdvancedSearch->SearchValue = @$filter["x_JoiningDate"];
        $this->JoiningDate->AdvancedSearch->SearchOperator = @$filter["z_JoiningDate"];
        $this->JoiningDate->AdvancedSearch->SearchCondition = @$filter["v_JoiningDate"];
        $this->JoiningDate->AdvancedSearch->SearchValue2 = @$filter["y_JoiningDate"];
        $this->JoiningDate->AdvancedSearch->SearchOperator2 = @$filter["w_JoiningDate"];
        $this->JoiningDate->AdvancedSearch->save();

        // Field CampName
        $this->CampName->AdvancedSearch->SearchValue = @$filter["x_CampName"];
        $this->CampName->AdvancedSearch->SearchOperator = @$filter["z_CampName"];
        $this->CampName->AdvancedSearch->SearchCondition = @$filter["v_CampName"];
        $this->CampName->AdvancedSearch->SearchValue2 = @$filter["y_CampName"];
        $this->CampName->AdvancedSearch->SearchOperator2 = @$filter["w_CampName"];
        $this->CampName->AdvancedSearch->save();

        // Field DistrictName
        $this->DistrictName->AdvancedSearch->SearchValue = @$filter["x_DistrictName"];
        $this->DistrictName->AdvancedSearch->SearchOperator = @$filter["z_DistrictName"];
        $this->DistrictName->AdvancedSearch->SearchCondition = @$filter["v_DistrictName"];
        $this->DistrictName->AdvancedSearch->SearchValue2 = @$filter["y_DistrictName"];
        $this->DistrictName->AdvancedSearch->SearchOperator2 = @$filter["w_DistrictName"];
        $this->DistrictName->AdvancedSearch->save();

        // Field InspectionTransNo
        $this->InspectionTransNo->AdvancedSearch->SearchValue = @$filter["x_InspectionTransNo"];
        $this->InspectionTransNo->AdvancedSearch->SearchOperator = @$filter["z_InspectionTransNo"];
        $this->InspectionTransNo->AdvancedSearch->SearchCondition = @$filter["v_InspectionTransNo"];
        $this->InspectionTransNo->AdvancedSearch->SearchValue2 = @$filter["y_InspectionTransNo"];
        $this->InspectionTransNo->AdvancedSearch->SearchOperator2 = @$filter["w_InspectionTransNo"];
        $this->InspectionTransNo->AdvancedSearch->save();

        // Field PlantsDead
        $this->PlantsDead->AdvancedSearch->SearchValue = @$filter["x_PlantsDead"];
        $this->PlantsDead->AdvancedSearch->SearchOperator = @$filter["z_PlantsDead"];
        $this->PlantsDead->AdvancedSearch->SearchCondition = @$filter["v_PlantsDead"];
        $this->PlantsDead->AdvancedSearch->SearchValue2 = @$filter["y_PlantsDead"];
        $this->PlantsDead->AdvancedSearch->SearchOperator2 = @$filter["w_PlantsDead"];
        $this->PlantsDead->AdvancedSearch->save();

        // Field PlantsVerifiedNo
        $this->PlantsVerifiedNo->AdvancedSearch->SearchValue = @$filter["x_PlantsVerifiedNo"];
        $this->PlantsVerifiedNo->AdvancedSearch->SearchOperator = @$filter["z_PlantsVerifiedNo"];
        $this->PlantsVerifiedNo->AdvancedSearch->SearchCondition = @$filter["v_PlantsVerifiedNo"];
        $this->PlantsVerifiedNo->AdvancedSearch->SearchValue2 = @$filter["y_PlantsVerifiedNo"];
        $this->PlantsVerifiedNo->AdvancedSearch->SearchOperator2 = @$filter["w_PlantsVerifiedNo"];
        $this->PlantsVerifiedNo->AdvancedSearch->save();

        // Field PlantsReplaced
        $this->PlantsReplaced->AdvancedSearch->SearchValue = @$filter["x_PlantsReplaced"];
        $this->PlantsReplaced->AdvancedSearch->SearchOperator = @$filter["z_PlantsReplaced"];
        $this->PlantsReplaced->AdvancedSearch->SearchCondition = @$filter["v_PlantsReplaced"];
        $this->PlantsReplaced->AdvancedSearch->SearchValue2 = @$filter["y_PlantsReplaced"];
        $this->PlantsReplaced->AdvancedSearch->SearchOperator2 = @$filter["w_PlantsReplaced"];
        $this->PlantsReplaced->AdvancedSearch->save();

        // Field FungicidesReceived
        $this->FungicidesReceived->AdvancedSearch->SearchValue = @$filter["x_FungicidesReceived"];
        $this->FungicidesReceived->AdvancedSearch->SearchOperator = @$filter["z_FungicidesReceived"];
        $this->FungicidesReceived->AdvancedSearch->SearchCondition = @$filter["v_FungicidesReceived"];
        $this->FungicidesReceived->AdvancedSearch->SearchValue2 = @$filter["y_FungicidesReceived"];
        $this->FungicidesReceived->AdvancedSearch->SearchOperator2 = @$filter["w_FungicidesReceived"];
        $this->FungicidesReceived->AdvancedSearch->save();

        // Field PescticidesReceived
        $this->PescticidesReceived->AdvancedSearch->SearchValue = @$filter["x_PescticidesReceived"];
        $this->PescticidesReceived->AdvancedSearch->SearchOperator = @$filter["z_PescticidesReceived"];
        $this->PescticidesReceived->AdvancedSearch->SearchCondition = @$filter["v_PescticidesReceived"];
        $this->PescticidesReceived->AdvancedSearch->SearchValue2 = @$filter["y_PescticidesReceived"];
        $this->PescticidesReceived->AdvancedSearch->SearchOperator2 = @$filter["w_PescticidesReceived"];
        $this->PescticidesReceived->AdvancedSearch->save();

        // Field DiseasePresence
        $this->DiseasePresence->AdvancedSearch->SearchValue = @$filter["x_DiseasePresence"];
        $this->DiseasePresence->AdvancedSearch->SearchOperator = @$filter["z_DiseasePresence"];
        $this->DiseasePresence->AdvancedSearch->SearchCondition = @$filter["v_DiseasePresence"];
        $this->DiseasePresence->AdvancedSearch->SearchValue2 = @$filter["y_DiseasePresence"];
        $this->DiseasePresence->AdvancedSearch->SearchOperator2 = @$filter["w_DiseasePresence"];
        $this->DiseasePresence->AdvancedSearch->save();

        // Field AvailableLand
        $this->AvailableLand->AdvancedSearch->SearchValue = @$filter["x_AvailableLand"];
        $this->AvailableLand->AdvancedSearch->SearchOperator = @$filter["z_AvailableLand"];
        $this->AvailableLand->AdvancedSearch->SearchCondition = @$filter["v_AvailableLand"];
        $this->AvailableLand->AdvancedSearch->SearchValue2 = @$filter["y_AvailableLand"];
        $this->AvailableLand->AdvancedSearch->SearchOperator2 = @$filter["w_AvailableLand"];
        $this->AvailableLand->AdvancedSearch->save();

        // Field LandForCashewCleared
        $this->LandForCashewCleared->AdvancedSearch->SearchValue = @$filter["x_LandForCashewCleared"];
        $this->LandForCashewCleared->AdvancedSearch->SearchOperator = @$filter["z_LandForCashewCleared"];
        $this->LandForCashewCleared->AdvancedSearch->SearchCondition = @$filter["v_LandForCashewCleared"];
        $this->LandForCashewCleared->AdvancedSearch->SearchValue2 = @$filter["y_LandForCashewCleared"];
        $this->LandForCashewCleared->AdvancedSearch->SearchOperator2 = @$filter["w_LandForCashewCleared"];
        $this->LandForCashewCleared->AdvancedSearch->save();

        // Field HolesDug
        $this->HolesDug->AdvancedSearch->SearchValue = @$filter["x_HolesDug"];
        $this->HolesDug->AdvancedSearch->SearchOperator = @$filter["z_HolesDug"];
        $this->HolesDug->AdvancedSearch->SearchCondition = @$filter["v_HolesDug"];
        $this->HolesDug->AdvancedSearch->SearchValue2 = @$filter["y_HolesDug"];
        $this->HolesDug->AdvancedSearch->SearchOperator2 = @$filter["w_HolesDug"];
        $this->HolesDug->AdvancedSearch->save();

        // Field VerifiedSeedlingArea
        $this->VerifiedSeedlingArea->AdvancedSearch->SearchValue = @$filter["x_VerifiedSeedlingArea"];
        $this->VerifiedSeedlingArea->AdvancedSearch->SearchOperator = @$filter["z_VerifiedSeedlingArea"];
        $this->VerifiedSeedlingArea->AdvancedSearch->SearchCondition = @$filter["v_VerifiedSeedlingArea"];
        $this->VerifiedSeedlingArea->AdvancedSearch->SearchValue2 = @$filter["y_VerifiedSeedlingArea"];
        $this->VerifiedSeedlingArea->AdvancedSearch->SearchOperator2 = @$filter["w_VerifiedSeedlingArea"];
        $this->VerifiedSeedlingArea->AdvancedSearch->save();

        // Field OldTreesNo
        $this->OldTreesNo->AdvancedSearch->SearchValue = @$filter["x_OldTreesNo"];
        $this->OldTreesNo->AdvancedSearch->SearchOperator = @$filter["z_OldTreesNo"];
        $this->OldTreesNo->AdvancedSearch->SearchCondition = @$filter["v_OldTreesNo"];
        $this->OldTreesNo->AdvancedSearch->SearchValue2 = @$filter["y_OldTreesNo"];
        $this->OldTreesNo->AdvancedSearch->SearchOperator2 = @$filter["w_OldTreesNo"];
        $this->OldTreesNo->AdvancedSearch->save();

        // Field InspectionReport
        $this->InspectionReport->AdvancedSearch->SearchValue = @$filter["x_InspectionReport"];
        $this->InspectionReport->AdvancedSearch->SearchOperator = @$filter["z_InspectionReport"];
        $this->InspectionReport->AdvancedSearch->SearchCondition = @$filter["v_InspectionReport"];
        $this->InspectionReport->AdvancedSearch->SearchValue2 = @$filter["y_InspectionReport"];
        $this->InspectionReport->AdvancedSearch->SearchOperator2 = @$filter["w_InspectionReport"];
        $this->InspectionReport->AdvancedSearch->save();

        // Field InspectionDate
        $this->InspectionDate->AdvancedSearch->SearchValue = @$filter["x_InspectionDate"];
        $this->InspectionDate->AdvancedSearch->SearchOperator = @$filter["z_InspectionDate"];
        $this->InspectionDate->AdvancedSearch->SearchCondition = @$filter["v_InspectionDate"];
        $this->InspectionDate->AdvancedSearch->SearchValue2 = @$filter["y_InspectionDate"];
        $this->InspectionDate->AdvancedSearch->SearchOperator2 = @$filter["w_InspectionDate"];
        $this->InspectionDate->AdvancedSearch->save();

        // Field InspectedBy
        $this->InspectedBy->AdvancedSearch->SearchValue = @$filter["x_InspectedBy"];
        $this->InspectedBy->AdvancedSearch->SearchOperator = @$filter["z_InspectedBy"];
        $this->InspectedBy->AdvancedSearch->SearchCondition = @$filter["v_InspectedBy"];
        $this->InspectedBy->AdvancedSearch->SearchValue2 = @$filter["y_InspectedBy"];
        $this->InspectedBy->AdvancedSearch->SearchOperator2 = @$filter["w_InspectedBy"];
        $this->InspectedBy->AdvancedSearch->save();

        // Field AuthorisedBy
        $this->AuthorisedBy->AdvancedSearch->SearchValue = @$filter["x_AuthorisedBy"];
        $this->AuthorisedBy->AdvancedSearch->SearchOperator = @$filter["z_AuthorisedBy"];
        $this->AuthorisedBy->AdvancedSearch->SearchCondition = @$filter["v_AuthorisedBy"];
        $this->AuthorisedBy->AdvancedSearch->SearchValue2 = @$filter["y_AuthorisedBy"];
        $this->AuthorisedBy->AdvancedSearch->SearchOperator2 = @$filter["w_AuthorisedBy"];
        $this->AuthorisedBy->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->FarmSize;
        $searchFlds[] = &$this->NRC;
        $searchFlds[] = &$this->FarmerName;
        $searchFlds[] = &$this->Gender;
        $searchFlds[] = &$this->PhoneNo;
        $searchFlds[] = &$this->_Email;
        $searchFlds[] = &$this->FarmerOrg;
        $searchFlds[] = &$this->FarmerOrgPosition;
        $searchFlds[] = &$this->CampName;
        $searchFlds[] = &$this->DistrictName;
        $searchFlds[] = &$this->DiseasePresence;
        $searchFlds[] = &$this->InspectionReport;
        $searchFlds[] = &$this->InspectedBy;
        $searchFlds[] = &$this->AuthorisedBy;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->Latitude); // Latitude
            $this->updateSort($this->Longitude); // Longitude
            $this->updateSort($this->FieldType); // FieldType
            $this->updateSort($this->Ownership); // Ownership
            $this->updateSort($this->FarmSize); // FarmSize
            $this->updateSort($this->FarmSizeEstimated); // FarmSizeEstimated
            $this->updateSort($this->TreesPlantedEstimated); // TreesPlantedEstimated
            $this->updateSort($this->FarmSizeVerified); // FarmSizeVerified
            $this->updateSort($this->TreesPlantedVerified); // TreesPlantedVerified
            $this->updateSort($this->FarmNo); // FarmNo
            $this->updateSort($this->NRC); // NRC
            $this->updateSort($this->FarmerName); // FarmerName
            $this->updateSort($this->DOB); // DOB
            $this->updateSort($this->Age); // Age
            $this->updateSort($this->Gender); // Gender
            $this->updateSort($this->MaritalStatus); // MaritalStatus
            $this->updateSort($this->PhoneNo); // PhoneNo
            $this->updateSort($this->_Email); // Email
            $this->updateSort($this->Dependants); // Dependants
            $this->updateSort($this->MaleChildren); // MaleChildren
            $this->updateSort($this->FemaleChildren); // FemaleChildren
            $this->updateSort($this->HouseholdHead); // HouseholdHead
            $this->updateSort($this->FarmerOrg); // FarmerOrg
            $this->updateSort($this->FarmerOrgPosition); // FarmerOrgPosition
            $this->updateSort($this->JoiningDate); // JoiningDate
            $this->updateSort($this->CampName); // CampName
            $this->updateSort($this->DistrictName); // DistrictName
            $this->updateSort($this->InspectionTransNo); // InspectionTransNo
            $this->updateSort($this->PlantsDead); // PlantsDead
            $this->updateSort($this->PlantsVerifiedNo); // PlantsVerifiedNo
            $this->updateSort($this->PlantsReplaced); // PlantsReplaced
            $this->updateSort($this->FungicidesReceived); // FungicidesReceived
            $this->updateSort($this->PescticidesReceived); // PescticidesReceived
            $this->updateSort($this->DiseasePresence); // DiseasePresence
            $this->updateSort($this->AvailableLand); // AvailableLand
            $this->updateSort($this->LandForCashewCleared); // LandForCashewCleared
            $this->updateSort($this->HolesDug); // HolesDug
            $this->updateSort($this->VerifiedSeedlingArea); // VerifiedSeedlingArea
            $this->updateSort($this->OldTreesNo); // OldTreesNo
            $this->updateSort($this->InspectionDate); // InspectionDate
            $this->updateSort($this->InspectedBy); // InspectedBy
            $this->updateSort($this->AuthorisedBy); // AuthorisedBy
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->Latitude->setSort("");
                $this->Longitude->setSort("");
                $this->FieldType->setSort("");
                $this->Ownership->setSort("");
                $this->FarmSize->setSort("");
                $this->FarmSizeEstimated->setSort("");
                $this->TreesPlantedEstimated->setSort("");
                $this->FarmSizeVerified->setSort("");
                $this->TreesPlantedVerified->setSort("");
                $this->FarmNo->setSort("");
                $this->NRC->setSort("");
                $this->FarmerName->setSort("");
                $this->DOB->setSort("");
                $this->Age->setSort("");
                $this->Gender->setSort("");
                $this->MaritalStatus->setSort("");
                $this->PhoneNo->setSort("");
                $this->_Email->setSort("");
                $this->Dependants->setSort("");
                $this->MaleChildren->setSort("");
                $this->FemaleChildren->setSort("");
                $this->HouseholdHead->setSort("");
                $this->FarmerOrg->setSort("");
                $this->FarmerOrgPosition->setSort("");
                $this->JoiningDate->setSort("");
                $this->CampName->setSort("");
                $this->DistrictName->setSort("");
                $this->InspectionTransNo->setSort("");
                $this->PlantsDead->setSort("");
                $this->PlantsVerifiedNo->setSort("");
                $this->PlantsReplaced->setSort("");
                $this->FungicidesReceived->setSort("");
                $this->PescticidesReceived->setSort("");
                $this->DiseasePresence->setSort("");
                $this->AvailableLand->setSort("");
                $this->LandForCashewCleared->setSort("");
                $this->HolesDug->setSort("");
                $this->VerifiedSeedlingArea->setSort("");
                $this->OldTreesNo->setSort("");
                $this->InspectionReport->setSort("");
                $this->InspectionDate->setSort("");
                $this->InspectedBy->setSort("");
                $this->AuthorisedBy->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = true;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") { // Check view mode
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"finspection_viewlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"finspection_viewlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->FarmNo->CurrentValue . Config("COMPOSITE_KEY_SEPARATOR") . $this->InspectionTransNo->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "Latitude");
            $this->createColumnOption($option, "Longitude");
            $this->createColumnOption($option, "FieldType");
            $this->createColumnOption($option, "Ownership");
            $this->createColumnOption($option, "FarmSize");
            $this->createColumnOption($option, "FarmSizeEstimated");
            $this->createColumnOption($option, "TreesPlantedEstimated");
            $this->createColumnOption($option, "FarmSizeVerified");
            $this->createColumnOption($option, "TreesPlantedVerified");
            $this->createColumnOption($option, "FarmNo");
            $this->createColumnOption($option, "NRC");
            $this->createColumnOption($option, "FarmerName");
            $this->createColumnOption($option, "DOB");
            $this->createColumnOption($option, "Age");
            $this->createColumnOption($option, "Gender");
            $this->createColumnOption($option, "MaritalStatus");
            $this->createColumnOption($option, "PhoneNo");
            $this->createColumnOption($option, "Email");
            $this->createColumnOption($option, "Dependants");
            $this->createColumnOption($option, "MaleChildren");
            $this->createColumnOption($option, "FemaleChildren");
            $this->createColumnOption($option, "HouseholdHead");
            $this->createColumnOption($option, "FarmerOrg");
            $this->createColumnOption($option, "FarmerOrgPosition");
            $this->createColumnOption($option, "JoiningDate");
            $this->createColumnOption($option, "CampName");
            $this->createColumnOption($option, "DistrictName");
            $this->createColumnOption($option, "InspectionTransNo");
            $this->createColumnOption($option, "PlantsDead");
            $this->createColumnOption($option, "PlantsVerifiedNo");
            $this->createColumnOption($option, "PlantsReplaced");
            $this->createColumnOption($option, "FungicidesReceived");
            $this->createColumnOption($option, "PescticidesReceived");
            $this->createColumnOption($option, "DiseasePresence");
            $this->createColumnOption($option, "AvailableLand");
            $this->createColumnOption($option, "LandForCashewCleared");
            $this->createColumnOption($option, "HolesDug");
            $this->createColumnOption($option, "VerifiedSeedlingArea");
            $this->createColumnOption($option, "OldTreesNo");
            $this->createColumnOption($option, "InspectionDate");
            $this->createColumnOption($option, "InspectedBy");
            $this->createColumnOption($option, "AuthorisedBy");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"finspection_viewsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"finspection_viewsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="finspection_viewlist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_inspection_view", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_inspection_view",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->Latitude->setDbValue($row['Latitude']);
        $this->Longitude->setDbValue($row['Longitude']);
        $this->FieldType->setDbValue($row['FieldType']);
        $this->Ownership->setDbValue($row['Ownership']);
        $this->FarmSize->setDbValue($row['FarmSize']);
        $this->FarmSizeEstimated->setDbValue($row['FarmSizeEstimated']);
        $this->TreesPlantedEstimated->setDbValue($row['TreesPlantedEstimated']);
        $this->FarmSizeVerified->setDbValue($row['FarmSizeVerified']);
        $this->TreesPlantedVerified->setDbValue($row['TreesPlantedVerified']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerName->setDbValue($row['FarmerName']);
        $this->DOB->setDbValue($row['DOB']);
        $this->Age->setDbValue($row['Age']);
        $this->Gender->setDbValue($row['Gender']);
        $this->MaritalStatus->setDbValue($row['MaritalStatus']);
        $this->PhoneNo->setDbValue($row['PhoneNo']);
        $this->_Email->setDbValue($row['Email']);
        $this->Dependants->setDbValue($row['Dependants']);
        $this->MaleChildren->setDbValue($row['MaleChildren']);
        $this->FemaleChildren->setDbValue($row['FemaleChildren']);
        $this->HouseholdHead->setDbValue($row['HouseholdHead']);
        $this->FarmerOrg->setDbValue($row['FarmerOrg']);
        $this->FarmerOrgPosition->setDbValue($row['FarmerOrgPosition']);
        $this->JoiningDate->setDbValue($row['JoiningDate']);
        $this->CampName->setDbValue($row['CampName']);
        $this->DistrictName->setDbValue($row['DistrictName']);
        $this->InspectionTransNo->setDbValue($row['InspectionTransNo']);
        $this->PlantsDead->setDbValue($row['PlantsDead']);
        $this->PlantsVerifiedNo->setDbValue($row['PlantsVerifiedNo']);
        $this->PlantsReplaced->setDbValue($row['PlantsReplaced']);
        $this->FungicidesReceived->setDbValue($row['FungicidesReceived']);
        $this->PescticidesReceived->setDbValue($row['PescticidesReceived']);
        $this->DiseasePresence->setDbValue($row['DiseasePresence']);
        $this->AvailableLand->setDbValue($row['AvailableLand']);
        $this->LandForCashewCleared->setDbValue($row['LandForCashewCleared']);
        $this->HolesDug->setDbValue($row['HolesDug']);
        $this->VerifiedSeedlingArea->setDbValue($row['VerifiedSeedlingArea']);
        $this->OldTreesNo->setDbValue($row['OldTreesNo']);
        $this->InspectionReport->setDbValue($row['InspectionReport']);
        $this->InspectionDate->setDbValue($row['InspectionDate']);
        $this->InspectedBy->setDbValue($row['InspectedBy']);
        $this->AuthorisedBy->setDbValue($row['AuthorisedBy']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['Latitude'] = $this->Latitude->DefaultValue;
        $row['Longitude'] = $this->Longitude->DefaultValue;
        $row['FieldType'] = $this->FieldType->DefaultValue;
        $row['Ownership'] = $this->Ownership->DefaultValue;
        $row['FarmSize'] = $this->FarmSize->DefaultValue;
        $row['FarmSizeEstimated'] = $this->FarmSizeEstimated->DefaultValue;
        $row['TreesPlantedEstimated'] = $this->TreesPlantedEstimated->DefaultValue;
        $row['FarmSizeVerified'] = $this->FarmSizeVerified->DefaultValue;
        $row['TreesPlantedVerified'] = $this->TreesPlantedVerified->DefaultValue;
        $row['FarmNo'] = $this->FarmNo->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['FarmerName'] = $this->FarmerName->DefaultValue;
        $row['DOB'] = $this->DOB->DefaultValue;
        $row['Age'] = $this->Age->DefaultValue;
        $row['Gender'] = $this->Gender->DefaultValue;
        $row['MaritalStatus'] = $this->MaritalStatus->DefaultValue;
        $row['PhoneNo'] = $this->PhoneNo->DefaultValue;
        $row['Email'] = $this->_Email->DefaultValue;
        $row['Dependants'] = $this->Dependants->DefaultValue;
        $row['MaleChildren'] = $this->MaleChildren->DefaultValue;
        $row['FemaleChildren'] = $this->FemaleChildren->DefaultValue;
        $row['HouseholdHead'] = $this->HouseholdHead->DefaultValue;
        $row['FarmerOrg'] = $this->FarmerOrg->DefaultValue;
        $row['FarmerOrgPosition'] = $this->FarmerOrgPosition->DefaultValue;
        $row['JoiningDate'] = $this->JoiningDate->DefaultValue;
        $row['CampName'] = $this->CampName->DefaultValue;
        $row['DistrictName'] = $this->DistrictName->DefaultValue;
        $row['InspectionTransNo'] = $this->InspectionTransNo->DefaultValue;
        $row['PlantsDead'] = $this->PlantsDead->DefaultValue;
        $row['PlantsVerifiedNo'] = $this->PlantsVerifiedNo->DefaultValue;
        $row['PlantsReplaced'] = $this->PlantsReplaced->DefaultValue;
        $row['FungicidesReceived'] = $this->FungicidesReceived->DefaultValue;
        $row['PescticidesReceived'] = $this->PescticidesReceived->DefaultValue;
        $row['DiseasePresence'] = $this->DiseasePresence->DefaultValue;
        $row['AvailableLand'] = $this->AvailableLand->DefaultValue;
        $row['LandForCashewCleared'] = $this->LandForCashewCleared->DefaultValue;
        $row['HolesDug'] = $this->HolesDug->DefaultValue;
        $row['VerifiedSeedlingArea'] = $this->VerifiedSeedlingArea->DefaultValue;
        $row['OldTreesNo'] = $this->OldTreesNo->DefaultValue;
        $row['InspectionReport'] = $this->InspectionReport->DefaultValue;
        $row['InspectionDate'] = $this->InspectionDate->DefaultValue;
        $row['InspectedBy'] = $this->InspectedBy->DefaultValue;
        $row['AuthorisedBy'] = $this->AuthorisedBy->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // Latitude

        // Longitude

        // FieldType

        // Ownership

        // FarmSize

        // FarmSizeEstimated

        // TreesPlantedEstimated

        // FarmSizeVerified

        // TreesPlantedVerified

        // FarmNo

        // NRC

        // FarmerName

        // DOB

        // Age

        // Gender

        // MaritalStatus

        // PhoneNo

        // Email

        // Dependants

        // MaleChildren

        // FemaleChildren

        // HouseholdHead

        // FarmerOrg

        // FarmerOrgPosition

        // JoiningDate

        // CampName

        // DistrictName

        // InspectionTransNo

        // PlantsDead

        // PlantsVerifiedNo

        // PlantsReplaced

        // FungicidesReceived

        // PescticidesReceived

        // DiseasePresence

        // AvailableLand

        // LandForCashewCleared

        // HolesDug

        // VerifiedSeedlingArea

        // OldTreesNo

        // InspectionReport

        // InspectionDate

        // InspectedBy

        // AuthorisedBy

        // View row
        if ($this->RowType == RowType::VIEW) {
            // Latitude
            $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
            $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

            // Longitude
            $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
            $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

            // FieldType
            $this->FieldType->ViewValue = $this->FieldType->CurrentValue;

            // Ownership
            $this->Ownership->ViewValue = $this->Ownership->CurrentValue;

            // FarmSize
            $this->FarmSize->ViewValue = $this->FarmSize->CurrentValue;

            // FarmSizeEstimated
            $this->FarmSizeEstimated->ViewValue = $this->FarmSizeEstimated->CurrentValue;
            $this->FarmSizeEstimated->ViewValue = FormatNumber($this->FarmSizeEstimated->ViewValue, $this->FarmSizeEstimated->formatPattern());

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->ViewValue = $this->TreesPlantedEstimated->CurrentValue;
            $this->TreesPlantedEstimated->ViewValue = FormatNumber($this->TreesPlantedEstimated->ViewValue, $this->TreesPlantedEstimated->formatPattern());

            // FarmSizeVerified
            $this->FarmSizeVerified->ViewValue = $this->FarmSizeVerified->CurrentValue;
            $this->FarmSizeVerified->ViewValue = FormatNumber($this->FarmSizeVerified->ViewValue, $this->FarmSizeVerified->formatPattern());

            // TreesPlantedVerified
            $this->TreesPlantedVerified->ViewValue = $this->TreesPlantedVerified->CurrentValue;
            $this->TreesPlantedVerified->ViewValue = FormatNumber($this->TreesPlantedVerified->ViewValue, $this->TreesPlantedVerified->formatPattern());

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;

            // FarmerName
            $this->FarmerName->ViewValue = $this->FarmerName->CurrentValue;

            // DOB
            $this->DOB->ViewValue = $this->DOB->CurrentValue;
            $this->DOB->ViewValue = FormatDateTime($this->DOB->ViewValue, $this->DOB->formatPattern());

            // Age
            $this->Age->ViewValue = $this->Age->CurrentValue;
            $this->Age->ViewValue = FormatNumber($this->Age->ViewValue, $this->Age->formatPattern());

            // Gender
            $this->Gender->ViewValue = $this->Gender->CurrentValue;

            // MaritalStatus
            $this->MaritalStatus->ViewValue = $this->MaritalStatus->CurrentValue;

            // PhoneNo
            $this->PhoneNo->ViewValue = $this->PhoneNo->CurrentValue;

            // Email
            $this->_Email->ViewValue = $this->_Email->CurrentValue;

            // Dependants
            $this->Dependants->ViewValue = $this->Dependants->CurrentValue;

            // MaleChildren
            $this->MaleChildren->ViewValue = $this->MaleChildren->CurrentValue;

            // FemaleChildren
            $this->FemaleChildren->ViewValue = $this->FemaleChildren->CurrentValue;

            // HouseholdHead
            $this->HouseholdHead->ViewValue = $this->HouseholdHead->CurrentValue;

            // FarmerOrg
            $this->FarmerOrg->ViewValue = $this->FarmerOrg->CurrentValue;

            // FarmerOrgPosition
            $this->FarmerOrgPosition->ViewValue = $this->FarmerOrgPosition->CurrentValue;

            // JoiningDate
            $this->JoiningDate->ViewValue = $this->JoiningDate->CurrentValue;
            $this->JoiningDate->ViewValue = FormatDateTime($this->JoiningDate->ViewValue, $this->JoiningDate->formatPattern());

            // CampName
            $this->CampName->ViewValue = $this->CampName->CurrentValue;

            // DistrictName
            $this->DistrictName->ViewValue = $this->DistrictName->CurrentValue;

            // InspectionTransNo
            $this->InspectionTransNo->ViewValue = $this->InspectionTransNo->CurrentValue;

            // PlantsDead
            $this->PlantsDead->ViewValue = $this->PlantsDead->CurrentValue;

            // PlantsVerifiedNo
            $this->PlantsVerifiedNo->ViewValue = $this->PlantsVerifiedNo->CurrentValue;

            // PlantsReplaced
            $this->PlantsReplaced->ViewValue = $this->PlantsReplaced->CurrentValue;

            // FungicidesReceived
            $this->FungicidesReceived->ViewValue = $this->FungicidesReceived->CurrentValue;
            $this->FungicidesReceived->ViewValue = FormatNumber($this->FungicidesReceived->ViewValue, $this->FungicidesReceived->formatPattern());

            // PescticidesReceived
            $this->PescticidesReceived->ViewValue = $this->PescticidesReceived->CurrentValue;
            $this->PescticidesReceived->ViewValue = FormatNumber($this->PescticidesReceived->ViewValue, $this->PescticidesReceived->formatPattern());

            // DiseasePresence
            $this->DiseasePresence->ViewValue = $this->DiseasePresence->CurrentValue;

            // AvailableLand
            $this->AvailableLand->ViewValue = $this->AvailableLand->CurrentValue;
            $this->AvailableLand->ViewValue = FormatNumber($this->AvailableLand->ViewValue, $this->AvailableLand->formatPattern());

            // LandForCashewCleared
            $this->LandForCashewCleared->ViewValue = $this->LandForCashewCleared->CurrentValue;
            $this->LandForCashewCleared->ViewValue = FormatNumber($this->LandForCashewCleared->ViewValue, $this->LandForCashewCleared->formatPattern());

            // HolesDug
            $this->HolesDug->ViewValue = $this->HolesDug->CurrentValue;

            // VerifiedSeedlingArea
            $this->VerifiedSeedlingArea->ViewValue = $this->VerifiedSeedlingArea->CurrentValue;
            $this->VerifiedSeedlingArea->ViewValue = FormatNumber($this->VerifiedSeedlingArea->ViewValue, $this->VerifiedSeedlingArea->formatPattern());

            // OldTreesNo
            $this->OldTreesNo->ViewValue = $this->OldTreesNo->CurrentValue;

            // InspectionDate
            $this->InspectionDate->ViewValue = $this->InspectionDate->CurrentValue;
            $this->InspectionDate->ViewValue = FormatDateTime($this->InspectionDate->ViewValue, $this->InspectionDate->formatPattern());

            // InspectedBy
            $this->InspectedBy->ViewValue = $this->InspectedBy->CurrentValue;

            // AuthorisedBy
            $this->AuthorisedBy->ViewValue = $this->AuthorisedBy->CurrentValue;

            // Latitude
            $this->Latitude->HrefValue = "";
            $this->Latitude->TooltipValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
            $this->Longitude->TooltipValue = "";

            // FieldType
            $this->FieldType->HrefValue = "";
            $this->FieldType->TooltipValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";
            $this->Ownership->TooltipValue = "";

            // FarmSize
            $this->FarmSize->HrefValue = "";
            $this->FarmSize->TooltipValue = "";

            // FarmSizeEstimated
            $this->FarmSizeEstimated->HrefValue = "";
            $this->FarmSizeEstimated->TooltipValue = "";

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->HrefValue = "";
            $this->TreesPlantedEstimated->TooltipValue = "";

            // FarmSizeVerified
            $this->FarmSizeVerified->HrefValue = "";
            $this->FarmSizeVerified->TooltipValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";
            $this->TreesPlantedVerified->TooltipValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";
            $this->FarmNo->TooltipValue = "";

            // NRC
            $this->NRC->HrefValue = "";
            $this->NRC->TooltipValue = "";

            // FarmerName
            $this->FarmerName->HrefValue = "";
            $this->FarmerName->TooltipValue = "";

            // DOB
            $this->DOB->HrefValue = "";
            $this->DOB->TooltipValue = "";

            // Age
            $this->Age->HrefValue = "";
            $this->Age->TooltipValue = "";

            // Gender
            $this->Gender->HrefValue = "";
            $this->Gender->TooltipValue = "";

            // MaritalStatus
            $this->MaritalStatus->HrefValue = "";
            $this->MaritalStatus->TooltipValue = "";

            // PhoneNo
            $this->PhoneNo->HrefValue = "";
            $this->PhoneNo->TooltipValue = "";

            // Email
            $this->_Email->HrefValue = "";
            $this->_Email->TooltipValue = "";

            // Dependants
            $this->Dependants->HrefValue = "";
            $this->Dependants->TooltipValue = "";

            // MaleChildren
            $this->MaleChildren->HrefValue = "";
            $this->MaleChildren->TooltipValue = "";

            // FemaleChildren
            $this->FemaleChildren->HrefValue = "";
            $this->FemaleChildren->TooltipValue = "";

            // HouseholdHead
            $this->HouseholdHead->HrefValue = "";
            $this->HouseholdHead->TooltipValue = "";

            // FarmerOrg
            $this->FarmerOrg->HrefValue = "";
            $this->FarmerOrg->TooltipValue = "";

            // FarmerOrgPosition
            $this->FarmerOrgPosition->HrefValue = "";
            $this->FarmerOrgPosition->TooltipValue = "";

            // JoiningDate
            $this->JoiningDate->HrefValue = "";
            $this->JoiningDate->TooltipValue = "";

            // CampName
            $this->CampName->HrefValue = "";
            $this->CampName->TooltipValue = "";

            // DistrictName
            $this->DistrictName->HrefValue = "";
            $this->DistrictName->TooltipValue = "";

            // InspectionTransNo
            $this->InspectionTransNo->HrefValue = "";
            $this->InspectionTransNo->TooltipValue = "";

            // PlantsDead
            $this->PlantsDead->HrefValue = "";
            $this->PlantsDead->TooltipValue = "";

            // PlantsVerifiedNo
            $this->PlantsVerifiedNo->HrefValue = "";
            $this->PlantsVerifiedNo->TooltipValue = "";

            // PlantsReplaced
            $this->PlantsReplaced->HrefValue = "";
            $this->PlantsReplaced->TooltipValue = "";

            // FungicidesReceived
            $this->FungicidesReceived->HrefValue = "";
            $this->FungicidesReceived->TooltipValue = "";

            // PescticidesReceived
            $this->PescticidesReceived->HrefValue = "";
            $this->PescticidesReceived->TooltipValue = "";

            // DiseasePresence
            $this->DiseasePresence->HrefValue = "";
            $this->DiseasePresence->TooltipValue = "";

            // AvailableLand
            $this->AvailableLand->HrefValue = "";
            $this->AvailableLand->TooltipValue = "";

            // LandForCashewCleared
            $this->LandForCashewCleared->HrefValue = "";
            $this->LandForCashewCleared->TooltipValue = "";

            // HolesDug
            $this->HolesDug->HrefValue = "";
            $this->HolesDug->TooltipValue = "";

            // VerifiedSeedlingArea
            $this->VerifiedSeedlingArea->HrefValue = "";
            $this->VerifiedSeedlingArea->TooltipValue = "";

            // OldTreesNo
            $this->OldTreesNo->HrefValue = "";
            $this->OldTreesNo->TooltipValue = "";

            // InspectionDate
            $this->InspectionDate->HrefValue = "";
            $this->InspectionDate->TooltipValue = "";

            // InspectedBy
            $this->InspectedBy->HrefValue = "";
            $this->InspectedBy->TooltipValue = "";

            // AuthorisedBy
            $this->AuthorisedBy->HrefValue = "";
            $this->AuthorisedBy->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"finspection_viewlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"finspection_viewlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"finspection_viewlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="finspection_viewlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = true;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"finspection_viewsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
