<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class GrantAdd extends Grant
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "GrantAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "GrantAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->GrantNo->setVisibility();
        $this->GrantRef->setVisibility();
        $this->SourceOfFunding->setVisibility();
        $this->GrantAmount->setVisibility();
        $this->DisbursementDate->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'grant';
        $this->TableName = 'grant';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (grant)
        if (!isset($GLOBALS["grant"]) || $GLOBALS["grant"]::class == PROJECT_NAMESPACE . "grant") {
            $GLOBALS["grant"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'grant');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "GrantView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else { // Not post back
            $this->CopyRecord = false;
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("GrantList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "GrantList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "GrantView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "GrantList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "GrantList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'GrantNo' first before field var 'x_GrantNo'
        $val = $CurrentForm->hasValue("GrantNo") ? $CurrentForm->getValue("GrantNo") : $CurrentForm->getValue("x_GrantNo");
        if (!$this->GrantNo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GrantNo->Visible = false; // Disable update for API request
            } else {
                $this->GrantNo->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'GrantRef' first before field var 'x_GrantRef'
        $val = $CurrentForm->hasValue("GrantRef") ? $CurrentForm->getValue("GrantRef") : $CurrentForm->getValue("x_GrantRef");
        if (!$this->GrantRef->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GrantRef->Visible = false; // Disable update for API request
            } else {
                $this->GrantRef->setFormValue($val);
            }
        }

        // Check field name 'SourceOfFunding' first before field var 'x_SourceOfFunding'
        $val = $CurrentForm->hasValue("SourceOfFunding") ? $CurrentForm->getValue("SourceOfFunding") : $CurrentForm->getValue("x_SourceOfFunding");
        if (!$this->SourceOfFunding->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SourceOfFunding->Visible = false; // Disable update for API request
            } else {
                $this->SourceOfFunding->setFormValue($val);
            }
        }

        // Check field name 'GrantAmount' first before field var 'x_GrantAmount'
        $val = $CurrentForm->hasValue("GrantAmount") ? $CurrentForm->getValue("GrantAmount") : $CurrentForm->getValue("x_GrantAmount");
        if (!$this->GrantAmount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GrantAmount->Visible = false; // Disable update for API request
            } else {
                $this->GrantAmount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'DisbursementDate' first before field var 'x_DisbursementDate'
        $val = $CurrentForm->hasValue("DisbursementDate") ? $CurrentForm->getValue("DisbursementDate") : $CurrentForm->getValue("x_DisbursementDate");
        if (!$this->DisbursementDate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DisbursementDate->Visible = false; // Disable update for API request
            } else {
                $this->DisbursementDate->setFormValue($val, true, $validate);
            }
            $this->DisbursementDate->CurrentValue = UnFormatDateTime($this->DisbursementDate->CurrentValue, $this->DisbursementDate->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->GrantNo->CurrentValue = $this->GrantNo->FormValue;
        $this->GrantRef->CurrentValue = $this->GrantRef->FormValue;
        $this->SourceOfFunding->CurrentValue = $this->SourceOfFunding->FormValue;
        $this->GrantAmount->CurrentValue = $this->GrantAmount->FormValue;
        $this->DisbursementDate->CurrentValue = $this->DisbursementDate->FormValue;
        $this->DisbursementDate->CurrentValue = UnFormatDateTime($this->DisbursementDate->CurrentValue, $this->DisbursementDate->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->GrantNo->setDbValue($row['GrantNo']);
        $this->GrantRef->setDbValue($row['GrantRef']);
        $this->SourceOfFunding->setDbValue($row['SourceOfFunding']);
        $this->GrantAmount->setDbValue($row['GrantAmount']);
        $this->DisbursementDate->setDbValue($row['DisbursementDate']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['GrantNo'] = $this->GrantNo->DefaultValue;
        $row['GrantRef'] = $this->GrantRef->DefaultValue;
        $row['SourceOfFunding'] = $this->SourceOfFunding->DefaultValue;
        $row['GrantAmount'] = $this->GrantAmount->DefaultValue;
        $row['DisbursementDate'] = $this->DisbursementDate->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // GrantNo
        $this->GrantNo->RowCssClass = "row";

        // GrantRef
        $this->GrantRef->RowCssClass = "row";

        // SourceOfFunding
        $this->SourceOfFunding->RowCssClass = "row";

        // GrantAmount
        $this->GrantAmount->RowCssClass = "row";

        // DisbursementDate
        $this->DisbursementDate->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // GrantNo
            $this->GrantNo->ViewValue = $this->GrantNo->CurrentValue;

            // GrantRef
            $this->GrantRef->ViewValue = $this->GrantRef->CurrentValue;

            // SourceOfFunding
            $this->SourceOfFunding->ViewValue = $this->SourceOfFunding->CurrentValue;

            // GrantAmount
            $this->GrantAmount->ViewValue = $this->GrantAmount->CurrentValue;
            $this->GrantAmount->ViewValue = FormatNumber($this->GrantAmount->ViewValue, $this->GrantAmount->formatPattern());

            // DisbursementDate
            $this->DisbursementDate->ViewValue = $this->DisbursementDate->CurrentValue;
            $this->DisbursementDate->ViewValue = FormatDateTime($this->DisbursementDate->ViewValue, $this->DisbursementDate->formatPattern());

            // GrantNo
            $this->GrantNo->HrefValue = "";

            // GrantRef
            $this->GrantRef->HrefValue = "";

            // SourceOfFunding
            $this->SourceOfFunding->HrefValue = "";

            // GrantAmount
            $this->GrantAmount->HrefValue = "";

            // DisbursementDate
            $this->DisbursementDate->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // GrantNo
            $this->GrantNo->setupEditAttributes();
            $this->GrantNo->EditValue = $this->GrantNo->CurrentValue;
            $this->GrantNo->PlaceHolder = RemoveHtml($this->GrantNo->caption());
            if (strval($this->GrantNo->EditValue) != "" && is_numeric($this->GrantNo->EditValue)) {
                $this->GrantNo->EditValue = $this->GrantNo->EditValue;
            }

            // GrantRef
            $this->GrantRef->setupEditAttributes();
            if (!$this->GrantRef->Raw) {
                $this->GrantRef->CurrentValue = HtmlDecode($this->GrantRef->CurrentValue);
            }
            $this->GrantRef->EditValue = HtmlEncode($this->GrantRef->CurrentValue);
            $this->GrantRef->PlaceHolder = RemoveHtml($this->GrantRef->caption());

            // SourceOfFunding
            $this->SourceOfFunding->setupEditAttributes();
            if (!$this->SourceOfFunding->Raw) {
                $this->SourceOfFunding->CurrentValue = HtmlDecode($this->SourceOfFunding->CurrentValue);
            }
            $this->SourceOfFunding->EditValue = HtmlEncode($this->SourceOfFunding->CurrentValue);
            $this->SourceOfFunding->PlaceHolder = RemoveHtml($this->SourceOfFunding->caption());

            // GrantAmount
            $this->GrantAmount->setupEditAttributes();
            $this->GrantAmount->EditValue = $this->GrantAmount->CurrentValue;
            $this->GrantAmount->PlaceHolder = RemoveHtml($this->GrantAmount->caption());
            if (strval($this->GrantAmount->EditValue) != "" && is_numeric($this->GrantAmount->EditValue)) {
                $this->GrantAmount->EditValue = FormatNumber($this->GrantAmount->EditValue, null);
            }

            // DisbursementDate
            $this->DisbursementDate->setupEditAttributes();
            $this->DisbursementDate->EditValue = HtmlEncode(FormatDateTime($this->DisbursementDate->CurrentValue, $this->DisbursementDate->formatPattern()));
            $this->DisbursementDate->PlaceHolder = RemoveHtml($this->DisbursementDate->caption());

            // Add refer script

            // GrantNo
            $this->GrantNo->HrefValue = "";

            // GrantRef
            $this->GrantRef->HrefValue = "";

            // SourceOfFunding
            $this->SourceOfFunding->HrefValue = "";

            // GrantAmount
            $this->GrantAmount->HrefValue = "";

            // DisbursementDate
            $this->DisbursementDate->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->GrantNo->Visible && $this->GrantNo->Required) {
                if (!$this->GrantNo->IsDetailKey && EmptyValue($this->GrantNo->FormValue)) {
                    $this->GrantNo->addErrorMessage(str_replace("%s", $this->GrantNo->caption(), $this->GrantNo->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->GrantNo->FormValue)) {
                $this->GrantNo->addErrorMessage($this->GrantNo->getErrorMessage(false));
            }
            if ($this->GrantRef->Visible && $this->GrantRef->Required) {
                if (!$this->GrantRef->IsDetailKey && EmptyValue($this->GrantRef->FormValue)) {
                    $this->GrantRef->addErrorMessage(str_replace("%s", $this->GrantRef->caption(), $this->GrantRef->RequiredErrorMessage));
                }
            }
            if ($this->SourceOfFunding->Visible && $this->SourceOfFunding->Required) {
                if (!$this->SourceOfFunding->IsDetailKey && EmptyValue($this->SourceOfFunding->FormValue)) {
                    $this->SourceOfFunding->addErrorMessage(str_replace("%s", $this->SourceOfFunding->caption(), $this->SourceOfFunding->RequiredErrorMessage));
                }
            }
            if ($this->GrantAmount->Visible && $this->GrantAmount->Required) {
                if (!$this->GrantAmount->IsDetailKey && EmptyValue($this->GrantAmount->FormValue)) {
                    $this->GrantAmount->addErrorMessage(str_replace("%s", $this->GrantAmount->caption(), $this->GrantAmount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->GrantAmount->FormValue)) {
                $this->GrantAmount->addErrorMessage($this->GrantAmount->getErrorMessage(false));
            }
            if ($this->DisbursementDate->Visible && $this->DisbursementDate->Required) {
                if (!$this->DisbursementDate->IsDetailKey && EmptyValue($this->DisbursementDate->FormValue)) {
                    $this->DisbursementDate->addErrorMessage(str_replace("%s", $this->DisbursementDate->caption(), $this->DisbursementDate->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->DisbursementDate->FormValue, $this->DisbursementDate->formatPattern())) {
                $this->DisbursementDate->addErrorMessage($this->DisbursementDate->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // GrantNo
        $this->GrantNo->setDbValueDef($rsnew, $this->GrantNo->CurrentValue, false);

        // GrantRef
        $this->GrantRef->setDbValueDef($rsnew, $this->GrantRef->CurrentValue, false);

        // SourceOfFunding
        $this->SourceOfFunding->setDbValueDef($rsnew, $this->SourceOfFunding->CurrentValue, false);

        // GrantAmount
        $this->GrantAmount->setDbValueDef($rsnew, $this->GrantAmount->CurrentValue, false);

        // DisbursementDate
        $this->DisbursementDate->setDbValueDef($rsnew, UnFormatDateTime($this->DisbursementDate->CurrentValue, $this->DisbursementDate->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['GrantNo'])) { // GrantNo
            $this->GrantNo->setFormValue($row['GrantNo']);
        }
        if (isset($row['GrantRef'])) { // GrantRef
            $this->GrantRef->setFormValue($row['GrantRef']);
        }
        if (isset($row['SourceOfFunding'])) { // SourceOfFunding
            $this->SourceOfFunding->setFormValue($row['SourceOfFunding']);
        }
        if (isset($row['GrantAmount'])) { // GrantAmount
            $this->GrantAmount->setFormValue($row['GrantAmount']);
        }
        if (isset($row['DisbursementDate'])) { // DisbursementDate
            $this->DisbursementDate->setFormValue($row['DisbursementDate']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("GrantList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
