<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class GoodsReceivedNoteAdd extends GoodsReceivedNote
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "GoodsReceivedNoteAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "GoodsReceivedNoteAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->SupplierCode->setVisibility();
        $this->GRN->setVisibility();
        $this->District->setVisibility();
        $this->FarmingSeason->setVisibility();
        $this->SeedlingsReceived->setVisibility();
        $this->SeedsReceived->setVisibility();
        $this->SeedType->setVisibility();
        $this->GoodsDescription->setVisibility();
        $this->DateReceived->setVisibility();
        $this->ReceivedBy->setVisibility();
        $this->AuthorizedBy->setVisibility();
        $this->GoodsReceived->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'goods_received_note';
        $this->TableName = 'goods_received_note';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (goods_received_note)
        if (!isset($GLOBALS["goods_received_note"]) || $GLOBALS["goods_received_note"]::class == PROJECT_NAMESPACE . "goods_received_note") {
            $GLOBALS["goods_received_note"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'goods_received_note');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "GoodsReceivedNoteView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['SupplierCode'] . Config("COMPOSITE_KEY_SEPARATOR");
            $key .= @$ar['GRN'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->SupplierCode);
        $this->setupLookupOptions($this->District);
        $this->setupLookupOptions($this->FarmingSeason);
        $this->setupLookupOptions($this->SeedType);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("SupplierCode") ?? Route("SupplierCode")) !== null) {
                $this->SupplierCode->setQueryStringValue($keyValue);
            }
            if (($keyValue = Get("GRN") ?? Route("GRN")) !== null) {
                $this->GRN->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("GoodsReceivedNoteList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "GoodsReceivedNoteList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "GoodsReceivedNoteView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "GoodsReceivedNoteList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "GoodsReceivedNoteList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'SupplierCode' first before field var 'x_SupplierCode'
        $val = $CurrentForm->hasValue("SupplierCode") ? $CurrentForm->getValue("SupplierCode") : $CurrentForm->getValue("x_SupplierCode");
        if (!$this->SupplierCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SupplierCode->Visible = false; // Disable update for API request
            } else {
                $this->SupplierCode->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'GRN' first before field var 'x_GRN'
        $val = $CurrentForm->hasValue("GRN") ? $CurrentForm->getValue("GRN") : $CurrentForm->getValue("x_GRN");
        if (!$this->GRN->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GRN->Visible = false; // Disable update for API request
            } else {
                $this->GRN->setFormValue($val);
            }
        }

        // Check field name 'District' first before field var 'x_District'
        $val = $CurrentForm->hasValue("District") ? $CurrentForm->getValue("District") : $CurrentForm->getValue("x_District");
        if (!$this->District->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->District->Visible = false; // Disable update for API request
            } else {
                $this->District->setFormValue($val);
            }
        }

        // Check field name 'FarmingSeason' first before field var 'x_FarmingSeason'
        $val = $CurrentForm->hasValue("FarmingSeason") ? $CurrentForm->getValue("FarmingSeason") : $CurrentForm->getValue("x_FarmingSeason");
        if (!$this->FarmingSeason->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmingSeason->Visible = false; // Disable update for API request
            } else {
                $this->FarmingSeason->setFormValue($val);
            }
        }

        // Check field name 'SeedlingsReceived' first before field var 'x_SeedlingsReceived'
        $val = $CurrentForm->hasValue("SeedlingsReceived") ? $CurrentForm->getValue("SeedlingsReceived") : $CurrentForm->getValue("x_SeedlingsReceived");
        if (!$this->SeedlingsReceived->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SeedlingsReceived->Visible = false; // Disable update for API request
            } else {
                $this->SeedlingsReceived->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'SeedsReceived' first before field var 'x_SeedsReceived'
        $val = $CurrentForm->hasValue("SeedsReceived") ? $CurrentForm->getValue("SeedsReceived") : $CurrentForm->getValue("x_SeedsReceived");
        if (!$this->SeedsReceived->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SeedsReceived->Visible = false; // Disable update for API request
            } else {
                $this->SeedsReceived->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'SeedType' first before field var 'x_SeedType'
        $val = $CurrentForm->hasValue("SeedType") ? $CurrentForm->getValue("SeedType") : $CurrentForm->getValue("x_SeedType");
        if (!$this->SeedType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SeedType->Visible = false; // Disable update for API request
            } else {
                $this->SeedType->setFormValue($val);
            }
        }

        // Check field name 'GoodsDescription' first before field var 'x_GoodsDescription'
        $val = $CurrentForm->hasValue("GoodsDescription") ? $CurrentForm->getValue("GoodsDescription") : $CurrentForm->getValue("x_GoodsDescription");
        if (!$this->GoodsDescription->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GoodsDescription->Visible = false; // Disable update for API request
            } else {
                $this->GoodsDescription->setFormValue($val);
            }
        }

        // Check field name 'DateReceived' first before field var 'x_DateReceived'
        $val = $CurrentForm->hasValue("DateReceived") ? $CurrentForm->getValue("DateReceived") : $CurrentForm->getValue("x_DateReceived");
        if (!$this->DateReceived->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DateReceived->Visible = false; // Disable update for API request
            } else {
                $this->DateReceived->setFormValue($val, true, $validate);
            }
            $this->DateReceived->CurrentValue = UnFormatDateTime($this->DateReceived->CurrentValue, $this->DateReceived->formatPattern());
        }

        // Check field name 'ReceivedBy' first before field var 'x_ReceivedBy'
        $val = $CurrentForm->hasValue("ReceivedBy") ? $CurrentForm->getValue("ReceivedBy") : $CurrentForm->getValue("x_ReceivedBy");
        if (!$this->ReceivedBy->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ReceivedBy->Visible = false; // Disable update for API request
            } else {
                $this->ReceivedBy->setFormValue($val);
            }
        }

        // Check field name 'AuthorizedBy' first before field var 'x_AuthorizedBy'
        $val = $CurrentForm->hasValue("AuthorizedBy") ? $CurrentForm->getValue("AuthorizedBy") : $CurrentForm->getValue("x_AuthorizedBy");
        if (!$this->AuthorizedBy->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->AuthorizedBy->Visible = false; // Disable update for API request
            } else {
                $this->AuthorizedBy->setFormValue($val);
            }
        }

        // Check field name 'GoodsReceived' first before field var 'x_GoodsReceived'
        $val = $CurrentForm->hasValue("GoodsReceived") ? $CurrentForm->getValue("GoodsReceived") : $CurrentForm->getValue("x_GoodsReceived");
        if (!$this->GoodsReceived->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GoodsReceived->Visible = false; // Disable update for API request
            } else {
                $this->GoodsReceived->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->SupplierCode->CurrentValue = $this->SupplierCode->FormValue;
        $this->GRN->CurrentValue = $this->GRN->FormValue;
        $this->District->CurrentValue = $this->District->FormValue;
        $this->FarmingSeason->CurrentValue = $this->FarmingSeason->FormValue;
        $this->SeedlingsReceived->CurrentValue = $this->SeedlingsReceived->FormValue;
        $this->SeedsReceived->CurrentValue = $this->SeedsReceived->FormValue;
        $this->SeedType->CurrentValue = $this->SeedType->FormValue;
        $this->GoodsDescription->CurrentValue = $this->GoodsDescription->FormValue;
        $this->DateReceived->CurrentValue = $this->DateReceived->FormValue;
        $this->DateReceived->CurrentValue = UnFormatDateTime($this->DateReceived->CurrentValue, $this->DateReceived->formatPattern());
        $this->ReceivedBy->CurrentValue = $this->ReceivedBy->FormValue;
        $this->AuthorizedBy->CurrentValue = $this->AuthorizedBy->FormValue;
        $this->GoodsReceived->CurrentValue = $this->GoodsReceived->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->SupplierCode->setDbValue($row['SupplierCode']);
        $this->GRN->setDbValue($row['GRN']);
        $this->District->setDbValue($row['District']);
        $this->FarmingSeason->setDbValue($row['FarmingSeason']);
        $this->SeedlingsReceived->setDbValue($row['SeedlingsReceived']);
        $this->SeedsReceived->setDbValue($row['SeedsReceived']);
        $this->SeedType->setDbValue($row['SeedType']);
        $this->GoodsDescription->setDbValue($row['GoodsDescription']);
        $this->DateReceived->setDbValue($row['DateReceived']);
        $this->ReceivedBy->setDbValue($row['ReceivedBy']);
        $this->AuthorizedBy->setDbValue($row['AuthorizedBy']);
        $this->GoodsReceived->setDbValue($row['GoodsReceived']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['SupplierCode'] = $this->SupplierCode->DefaultValue;
        $row['GRN'] = $this->GRN->DefaultValue;
        $row['District'] = $this->District->DefaultValue;
        $row['FarmingSeason'] = $this->FarmingSeason->DefaultValue;
        $row['SeedlingsReceived'] = $this->SeedlingsReceived->DefaultValue;
        $row['SeedsReceived'] = $this->SeedsReceived->DefaultValue;
        $row['SeedType'] = $this->SeedType->DefaultValue;
        $row['GoodsDescription'] = $this->GoodsDescription->DefaultValue;
        $row['DateReceived'] = $this->DateReceived->DefaultValue;
        $row['ReceivedBy'] = $this->ReceivedBy->DefaultValue;
        $row['AuthorizedBy'] = $this->AuthorizedBy->DefaultValue;
        $row['GoodsReceived'] = $this->GoodsReceived->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // SupplierCode
        $this->SupplierCode->RowCssClass = "row";

        // GRN
        $this->GRN->RowCssClass = "row";

        // District
        $this->District->RowCssClass = "row";

        // FarmingSeason
        $this->FarmingSeason->RowCssClass = "row";

        // SeedlingsReceived
        $this->SeedlingsReceived->RowCssClass = "row";

        // SeedsReceived
        $this->SeedsReceived->RowCssClass = "row";

        // SeedType
        $this->SeedType->RowCssClass = "row";

        // GoodsDescription
        $this->GoodsDescription->RowCssClass = "row";

        // DateReceived
        $this->DateReceived->RowCssClass = "row";

        // ReceivedBy
        $this->ReceivedBy->RowCssClass = "row";

        // AuthorizedBy
        $this->AuthorizedBy->RowCssClass = "row";

        // GoodsReceived
        $this->GoodsReceived->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // SupplierCode
            $this->SupplierCode->ViewValue = $this->SupplierCode->CurrentValue;
            $curVal = strval($this->SupplierCode->CurrentValue);
            if ($curVal != "") {
                $this->SupplierCode->ViewValue = $this->SupplierCode->lookupCacheOption($curVal);
                if ($this->SupplierCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SupplierCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SupplierCode->Lookup->renderViewRow($rswrk[0]);
                        $this->SupplierCode->ViewValue = $this->SupplierCode->displayValue($arwrk);
                    } else {
                        $this->SupplierCode->ViewValue = $this->SupplierCode->CurrentValue;
                    }
                }
            } else {
                $this->SupplierCode->ViewValue = null;
            }

            // GRN
            $this->GRN->ViewValue = $this->GRN->CurrentValue;

            // District
            $curVal = strval($this->District->CurrentValue);
            if ($curVal != "") {
                $this->District->ViewValue = $this->District->lookupCacheOption($curVal);
                if ($this->District->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->District->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->District->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->District->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->District->Lookup->renderViewRow($rswrk[0]);
                        $this->District->ViewValue = $this->District->displayValue($arwrk);
                    } else {
                        $this->District->ViewValue = $this->District->CurrentValue;
                    }
                }
            } else {
                $this->District->ViewValue = null;
            }

            // FarmingSeason
            $curVal = strval($this->FarmingSeason->CurrentValue);
            if ($curVal != "") {
                $this->FarmingSeason->ViewValue = $this->FarmingSeason->lookupCacheOption($curVal);
                if ($this->FarmingSeason->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->FarmingSeason->Lookup->getTable()->Fields["year"]->searchExpression(), "=", $curVal, $this->FarmingSeason->Lookup->getTable()->Fields["year"]->searchDataType(), "");
                    $sqlWrk = $this->FarmingSeason->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->FarmingSeason->Lookup->renderViewRow($rswrk[0]);
                        $this->FarmingSeason->ViewValue = $this->FarmingSeason->displayValue($arwrk);
                    } else {
                        $this->FarmingSeason->ViewValue = $this->FarmingSeason->CurrentValue;
                    }
                }
            } else {
                $this->FarmingSeason->ViewValue = null;
            }

            // SeedlingsReceived
            $this->SeedlingsReceived->ViewValue = $this->SeedlingsReceived->CurrentValue;
            $this->SeedlingsReceived->ViewValue = FormatNumber($this->SeedlingsReceived->ViewValue, $this->SeedlingsReceived->formatPattern());
            $this->SeedlingsReceived->CellCssStyle .= "text-align: right;";

            // SeedsReceived
            $this->SeedsReceived->ViewValue = $this->SeedsReceived->CurrentValue;
            $this->SeedsReceived->ViewValue = FormatNumber($this->SeedsReceived->ViewValue, $this->SeedsReceived->formatPattern());
            $this->SeedsReceived->CellCssStyle .= "text-align: right;";

            // SeedType
            $curVal = strval($this->SeedType->CurrentValue);
            if ($curVal != "") {
                $this->SeedType->ViewValue = $this->SeedType->lookupCacheOption($curVal);
                if ($this->SeedType->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $curVal, $this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                    $sqlWrk = $this->SeedType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SeedType->Lookup->renderViewRow($rswrk[0]);
                        $this->SeedType->ViewValue = $this->SeedType->displayValue($arwrk);
                    } else {
                        $this->SeedType->ViewValue = $this->SeedType->CurrentValue;
                    }
                }
            } else {
                $this->SeedType->ViewValue = null;
            }

            // GoodsDescription
            $this->GoodsDescription->ViewValue = $this->GoodsDescription->CurrentValue;

            // DateReceived
            $this->DateReceived->ViewValue = $this->DateReceived->CurrentValue;
            $this->DateReceived->ViewValue = FormatDateTime($this->DateReceived->ViewValue, $this->DateReceived->formatPattern());

            // ReceivedBy
            $this->ReceivedBy->ViewValue = $this->ReceivedBy->CurrentValue;

            // AuthorizedBy
            $this->AuthorizedBy->ViewValue = $this->AuthorizedBy->CurrentValue;

            // GoodsReceived
            $this->GoodsReceived->ViewValue = $this->GoodsReceived->CurrentValue;

            // SupplierCode
            $this->SupplierCode->HrefValue = "";

            // GRN
            $this->GRN->HrefValue = "";

            // District
            $this->District->HrefValue = "";

            // FarmingSeason
            $this->FarmingSeason->HrefValue = "";

            // SeedlingsReceived
            $this->SeedlingsReceived->HrefValue = "";

            // SeedsReceived
            $this->SeedsReceived->HrefValue = "";

            // SeedType
            $this->SeedType->HrefValue = "";

            // GoodsDescription
            $this->GoodsDescription->HrefValue = "";

            // DateReceived
            $this->DateReceived->HrefValue = "";

            // ReceivedBy
            $this->ReceivedBy->HrefValue = "";

            // AuthorizedBy
            $this->AuthorizedBy->HrefValue = "";

            // GoodsReceived
            $this->GoodsReceived->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // SupplierCode
            $this->SupplierCode->setupEditAttributes();
            $this->SupplierCode->EditValue = $this->SupplierCode->CurrentValue;
            $curVal = strval($this->SupplierCode->CurrentValue);
            if ($curVal != "") {
                $this->SupplierCode->EditValue = $this->SupplierCode->lookupCacheOption($curVal);
                if ($this->SupplierCode->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SupplierCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SupplierCode->Lookup->renderViewRow($rswrk[0]);
                        $this->SupplierCode->EditValue = $this->SupplierCode->displayValue($arwrk);
                    } else {
                        $this->SupplierCode->EditValue = HtmlEncode($this->SupplierCode->CurrentValue);
                    }
                }
            } else {
                $this->SupplierCode->EditValue = null;
            }
            $this->SupplierCode->PlaceHolder = RemoveHtml($this->SupplierCode->caption());

            // GRN
            $this->GRN->setupEditAttributes();
            if (!$this->GRN->Raw) {
                $this->GRN->CurrentValue = HtmlDecode($this->GRN->CurrentValue);
            }
            $this->GRN->EditValue = HtmlEncode($this->GRN->CurrentValue);
            $this->GRN->PlaceHolder = RemoveHtml($this->GRN->caption());

            // District
            $curVal = trim(strval($this->District->CurrentValue));
            if ($curVal != "") {
                $this->District->ViewValue = $this->District->lookupCacheOption($curVal);
            } else {
                $this->District->ViewValue = $this->District->Lookup !== null && is_array($this->District->lookupOptions()) && count($this->District->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->District->ViewValue !== null) { // Load from cache
                $this->District->EditValue = array_values($this->District->lookupOptions());
                if ($this->District->ViewValue == "") {
                    $this->District->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->District->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->District->CurrentValue, $this->District->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->District->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->District->Lookup->renderViewRow($rswrk[0]);
                    $this->District->ViewValue = $this->District->displayValue($arwrk);
                } else {
                    $this->District->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->District->EditValue = $arwrk;
            }
            $this->District->PlaceHolder = RemoveHtml($this->District->caption());

            // FarmingSeason
            $curVal = trim(strval($this->FarmingSeason->CurrentValue));
            if ($curVal != "") {
                $this->FarmingSeason->ViewValue = $this->FarmingSeason->lookupCacheOption($curVal);
            } else {
                $this->FarmingSeason->ViewValue = $this->FarmingSeason->Lookup !== null && is_array($this->FarmingSeason->lookupOptions()) && count($this->FarmingSeason->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->FarmingSeason->ViewValue !== null) { // Load from cache
                $this->FarmingSeason->EditValue = array_values($this->FarmingSeason->lookupOptions());
                if ($this->FarmingSeason->ViewValue == "") {
                    $this->FarmingSeason->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->FarmingSeason->Lookup->getTable()->Fields["year"]->searchExpression(), "=", $this->FarmingSeason->CurrentValue, $this->FarmingSeason->Lookup->getTable()->Fields["year"]->searchDataType(), "");
                }
                $sqlWrk = $this->FarmingSeason->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->FarmingSeason->Lookup->renderViewRow($rswrk[0]);
                    $this->FarmingSeason->ViewValue = $this->FarmingSeason->displayValue($arwrk);
                } else {
                    $this->FarmingSeason->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->FarmingSeason->EditValue = $arwrk;
            }
            $this->FarmingSeason->PlaceHolder = RemoveHtml($this->FarmingSeason->caption());

            // SeedlingsReceived
            $this->SeedlingsReceived->setupEditAttributes();
            $this->SeedlingsReceived->EditValue = $this->SeedlingsReceived->CurrentValue;
            $this->SeedlingsReceived->PlaceHolder = RemoveHtml($this->SeedlingsReceived->caption());
            if (strval($this->SeedlingsReceived->EditValue) != "" && is_numeric($this->SeedlingsReceived->EditValue)) {
                $this->SeedlingsReceived->EditValue = FormatNumber($this->SeedlingsReceived->EditValue, null);
            }

            // SeedsReceived
            $this->SeedsReceived->setupEditAttributes();
            $this->SeedsReceived->EditValue = $this->SeedsReceived->CurrentValue;
            $this->SeedsReceived->PlaceHolder = RemoveHtml($this->SeedsReceived->caption());
            if (strval($this->SeedsReceived->EditValue) != "" && is_numeric($this->SeedsReceived->EditValue)) {
                $this->SeedsReceived->EditValue = FormatNumber($this->SeedsReceived->EditValue, null);
            }

            // SeedType
            $this->SeedType->setupEditAttributes();
            $curVal = trim(strval($this->SeedType->CurrentValue));
            if ($curVal != "") {
                $this->SeedType->ViewValue = $this->SeedType->lookupCacheOption($curVal);
            } else {
                $this->SeedType->ViewValue = $this->SeedType->Lookup !== null && is_array($this->SeedType->lookupOptions()) && count($this->SeedType->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->SeedType->ViewValue !== null) { // Load from cache
                $this->SeedType->EditValue = array_values($this->SeedType->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $this->SeedType->CurrentValue, $this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                }
                $sqlWrk = $this->SeedType->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->SeedType->EditValue = $arwrk;
            }
            $this->SeedType->PlaceHolder = RemoveHtml($this->SeedType->caption());

            // GoodsDescription
            $this->GoodsDescription->setupEditAttributes();
            if (!$this->GoodsDescription->Raw) {
                $this->GoodsDescription->CurrentValue = HtmlDecode($this->GoodsDescription->CurrentValue);
            }
            $this->GoodsDescription->EditValue = HtmlEncode($this->GoodsDescription->CurrentValue);
            $this->GoodsDescription->PlaceHolder = RemoveHtml($this->GoodsDescription->caption());

            // DateReceived
            $this->DateReceived->setupEditAttributes();
            $this->DateReceived->EditValue = HtmlEncode(FormatDateTime($this->DateReceived->CurrentValue, $this->DateReceived->formatPattern()));
            $this->DateReceived->PlaceHolder = RemoveHtml($this->DateReceived->caption());

            // ReceivedBy
            $this->ReceivedBy->setupEditAttributes();
            if (!$this->ReceivedBy->Raw) {
                $this->ReceivedBy->CurrentValue = HtmlDecode($this->ReceivedBy->CurrentValue);
            }
            $this->ReceivedBy->EditValue = HtmlEncode($this->ReceivedBy->CurrentValue);
            $this->ReceivedBy->PlaceHolder = RemoveHtml($this->ReceivedBy->caption());

            // AuthorizedBy
            $this->AuthorizedBy->setupEditAttributes();
            if (!$this->AuthorizedBy->Raw) {
                $this->AuthorizedBy->CurrentValue = HtmlDecode($this->AuthorizedBy->CurrentValue);
            }
            $this->AuthorizedBy->EditValue = HtmlEncode($this->AuthorizedBy->CurrentValue);
            $this->AuthorizedBy->PlaceHolder = RemoveHtml($this->AuthorizedBy->caption());

            // GoodsReceived
            $this->GoodsReceived->setupEditAttributes();
            $this->GoodsReceived->EditValue = HtmlEncode($this->GoodsReceived->CurrentValue);
            $this->GoodsReceived->PlaceHolder = RemoveHtml($this->GoodsReceived->caption());

            // Add refer script

            // SupplierCode
            $this->SupplierCode->HrefValue = "";

            // GRN
            $this->GRN->HrefValue = "";

            // District
            $this->District->HrefValue = "";

            // FarmingSeason
            $this->FarmingSeason->HrefValue = "";

            // SeedlingsReceived
            $this->SeedlingsReceived->HrefValue = "";

            // SeedsReceived
            $this->SeedsReceived->HrefValue = "";

            // SeedType
            $this->SeedType->HrefValue = "";

            // GoodsDescription
            $this->GoodsDescription->HrefValue = "";

            // DateReceived
            $this->DateReceived->HrefValue = "";

            // ReceivedBy
            $this->ReceivedBy->HrefValue = "";

            // AuthorizedBy
            $this->AuthorizedBy->HrefValue = "";

            // GoodsReceived
            $this->GoodsReceived->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->SupplierCode->Visible && $this->SupplierCode->Required) {
                if (!$this->SupplierCode->IsDetailKey && EmptyValue($this->SupplierCode->FormValue)) {
                    $this->SupplierCode->addErrorMessage(str_replace("%s", $this->SupplierCode->caption(), $this->SupplierCode->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->SupplierCode->FormValue)) {
                $this->SupplierCode->addErrorMessage($this->SupplierCode->getErrorMessage(false));
            }
            if ($this->GRN->Visible && $this->GRN->Required) {
                if (!$this->GRN->IsDetailKey && EmptyValue($this->GRN->FormValue)) {
                    $this->GRN->addErrorMessage(str_replace("%s", $this->GRN->caption(), $this->GRN->RequiredErrorMessage));
                }
            }
            if ($this->District->Visible && $this->District->Required) {
                if (!$this->District->IsDetailKey && EmptyValue($this->District->FormValue)) {
                    $this->District->addErrorMessage(str_replace("%s", $this->District->caption(), $this->District->RequiredErrorMessage));
                }
            }
            if ($this->FarmingSeason->Visible && $this->FarmingSeason->Required) {
                if (!$this->FarmingSeason->IsDetailKey && EmptyValue($this->FarmingSeason->FormValue)) {
                    $this->FarmingSeason->addErrorMessage(str_replace("%s", $this->FarmingSeason->caption(), $this->FarmingSeason->RequiredErrorMessage));
                }
            }
            if ($this->SeedlingsReceived->Visible && $this->SeedlingsReceived->Required) {
                if (!$this->SeedlingsReceived->IsDetailKey && EmptyValue($this->SeedlingsReceived->FormValue)) {
                    $this->SeedlingsReceived->addErrorMessage(str_replace("%s", $this->SeedlingsReceived->caption(), $this->SeedlingsReceived->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->SeedlingsReceived->FormValue)) {
                $this->SeedlingsReceived->addErrorMessage($this->SeedlingsReceived->getErrorMessage(false));
            }
            if ($this->SeedsReceived->Visible && $this->SeedsReceived->Required) {
                if (!$this->SeedsReceived->IsDetailKey && EmptyValue($this->SeedsReceived->FormValue)) {
                    $this->SeedsReceived->addErrorMessage(str_replace("%s", $this->SeedsReceived->caption(), $this->SeedsReceived->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->SeedsReceived->FormValue)) {
                $this->SeedsReceived->addErrorMessage($this->SeedsReceived->getErrorMessage(false));
            }
            if ($this->SeedType->Visible && $this->SeedType->Required) {
                if (!$this->SeedType->IsDetailKey && EmptyValue($this->SeedType->FormValue)) {
                    $this->SeedType->addErrorMessage(str_replace("%s", $this->SeedType->caption(), $this->SeedType->RequiredErrorMessage));
                }
            }
            if ($this->GoodsDescription->Visible && $this->GoodsDescription->Required) {
                if (!$this->GoodsDescription->IsDetailKey && EmptyValue($this->GoodsDescription->FormValue)) {
                    $this->GoodsDescription->addErrorMessage(str_replace("%s", $this->GoodsDescription->caption(), $this->GoodsDescription->RequiredErrorMessage));
                }
            }
            if ($this->DateReceived->Visible && $this->DateReceived->Required) {
                if (!$this->DateReceived->IsDetailKey && EmptyValue($this->DateReceived->FormValue)) {
                    $this->DateReceived->addErrorMessage(str_replace("%s", $this->DateReceived->caption(), $this->DateReceived->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->DateReceived->FormValue, $this->DateReceived->formatPattern())) {
                $this->DateReceived->addErrorMessage($this->DateReceived->getErrorMessage(false));
            }
            if ($this->ReceivedBy->Visible && $this->ReceivedBy->Required) {
                if (!$this->ReceivedBy->IsDetailKey && EmptyValue($this->ReceivedBy->FormValue)) {
                    $this->ReceivedBy->addErrorMessage(str_replace("%s", $this->ReceivedBy->caption(), $this->ReceivedBy->RequiredErrorMessage));
                }
            }
            if ($this->AuthorizedBy->Visible && $this->AuthorizedBy->Required) {
                if (!$this->AuthorizedBy->IsDetailKey && EmptyValue($this->AuthorizedBy->FormValue)) {
                    $this->AuthorizedBy->addErrorMessage(str_replace("%s", $this->AuthorizedBy->caption(), $this->AuthorizedBy->RequiredErrorMessage));
                }
            }
            if ($this->GoodsReceived->Visible && $this->GoodsReceived->Required) {
                if (!$this->GoodsReceived->IsDetailKey && EmptyValue($this->GoodsReceived->FormValue)) {
                    $this->GoodsReceived->addErrorMessage(str_replace("%s", $this->GoodsReceived->caption(), $this->GoodsReceived->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);

        // Check if key value entered
        if ($insertRow && $this->ValidateKey && strval($rsnew['SupplierCode']) == "") {
            $this->setFailureMessage($Language->phrase("InvalidKeyValue"));
            $insertRow = false;
        }

        // Check if key value entered
        if ($insertRow && $this->ValidateKey && strval($rsnew['GRN']) == "") {
            $this->setFailureMessage($Language->phrase("InvalidKeyValue"));
            $insertRow = false;
        }

        // Check for duplicate key
        if ($insertRow && $this->ValidateKey) {
            $filter = $this->getRecordFilter($rsnew);
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
                $this->setFailureMessage($keyErrMsg);
                $insertRow = false;
            }
        }
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // SupplierCode
        $this->SupplierCode->setDbValueDef($rsnew, $this->SupplierCode->CurrentValue, false);

        // GRN
        $this->GRN->setDbValueDef($rsnew, $this->GRN->CurrentValue, false);

        // District
        $this->District->setDbValueDef($rsnew, $this->District->CurrentValue, false);

        // FarmingSeason
        $this->FarmingSeason->setDbValueDef($rsnew, $this->FarmingSeason->CurrentValue, false);

        // SeedlingsReceived
        $this->SeedlingsReceived->setDbValueDef($rsnew, $this->SeedlingsReceived->CurrentValue, strval($this->SeedlingsReceived->CurrentValue) == "");

        // SeedsReceived
        $this->SeedsReceived->setDbValueDef($rsnew, $this->SeedsReceived->CurrentValue, false);

        // SeedType
        $this->SeedType->setDbValueDef($rsnew, $this->SeedType->CurrentValue, false);

        // GoodsDescription
        $this->GoodsDescription->setDbValueDef($rsnew, $this->GoodsDescription->CurrentValue, false);

        // DateReceived
        $this->DateReceived->setDbValueDef($rsnew, UnFormatDateTime($this->DateReceived->CurrentValue, $this->DateReceived->formatPattern()), false);

        // ReceivedBy
        $this->ReceivedBy->setDbValueDef($rsnew, $this->ReceivedBy->CurrentValue, false);

        // AuthorizedBy
        $this->AuthorizedBy->setDbValueDef($rsnew, $this->AuthorizedBy->CurrentValue, false);

        // GoodsReceived
        $this->GoodsReceived->setDbValueDef($rsnew, $this->GoodsReceived->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['SupplierCode'])) { // SupplierCode
            $this->SupplierCode->setFormValue($row['SupplierCode']);
        }
        if (isset($row['GRN'])) { // GRN
            $this->GRN->setFormValue($row['GRN']);
        }
        if (isset($row['District'])) { // District
            $this->District->setFormValue($row['District']);
        }
        if (isset($row['FarmingSeason'])) { // FarmingSeason
            $this->FarmingSeason->setFormValue($row['FarmingSeason']);
        }
        if (isset($row['SeedlingsReceived'])) { // SeedlingsReceived
            $this->SeedlingsReceived->setFormValue($row['SeedlingsReceived']);
        }
        if (isset($row['SeedsReceived'])) { // SeedsReceived
            $this->SeedsReceived->setFormValue($row['SeedsReceived']);
        }
        if (isset($row['SeedType'])) { // SeedType
            $this->SeedType->setFormValue($row['SeedType']);
        }
        if (isset($row['GoodsDescription'])) { // GoodsDescription
            $this->GoodsDescription->setFormValue($row['GoodsDescription']);
        }
        if (isset($row['DateReceived'])) { // DateReceived
            $this->DateReceived->setFormValue($row['DateReceived']);
        }
        if (isset($row['ReceivedBy'])) { // ReceivedBy
            $this->ReceivedBy->setFormValue($row['ReceivedBy']);
        }
        if (isset($row['AuthorizedBy'])) { // AuthorizedBy
            $this->AuthorizedBy->setFormValue($row['AuthorizedBy']);
        }
        if (isset($row['GoodsReceived'])) { // GoodsReceived
            $this->GoodsReceived->setFormValue($row['GoodsReceived']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("GoodsReceivedNoteList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_SupplierCode":
                    break;
                case "x_District":
                    break;
                case "x_FarmingSeason":
                    break;
                case "x_SeedType":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
