<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Table class for goods_received_note
 */
class GoodsReceivedNote extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $SupplierCode;
    public $GRN;
    public $District;
    public $FarmingSeason;
    public $SeedlingsReceived;
    public $SeedsReceived;
    public $SeedType;
    public $GoodsDescription;
    public $DateReceived;
    public $ReceivedBy;
    public $AuthorizedBy;
    public $GoodsReceived;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "goods_received_note";
        $this->TableName = 'goods_received_note';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "goods_received_note";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // SupplierCode
        $this->SupplierCode = new DbField(
            $this, // Table
            'x_SupplierCode', // Variable name
            'SupplierCode', // Name
            '`SupplierCode`', // Expression
            '`SupplierCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SupplierCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SupplierCode->InputTextType = "text";
        $this->SupplierCode->Raw = true;
        $this->SupplierCode->IsPrimaryKey = true; // Primary key field
        $this->SupplierCode->Nullable = false; // NOT NULL field
        $this->SupplierCode->Required = true; // Required field
        $this->SupplierCode->Lookup = new Lookup($this->SupplierCode, 'nursery', false, 'NurseryCode', ["NurseryName","","",""], '', '', [], [], [], [], [], [], false, '', '', "`NurseryName`");
        $this->SupplierCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->SupplierCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['SupplierCode'] = &$this->SupplierCode;

        // GRN
        $this->GRN = new DbField(
            $this, // Table
            'x_GRN', // Variable name
            'GRN', // Name
            '`GRN`', // Expression
            '`GRN`', // Basic search expression
            200, // Type
            30, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`GRN`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->GRN->InputTextType = "text";
        $this->GRN->Raw = true;
        $this->GRN->IsPrimaryKey = true; // Primary key field
        $this->GRN->Nullable = false; // NOT NULL field
        $this->GRN->Required = true; // Required field
        $this->GRN->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['GRN'] = &$this->GRN;

        // District
        $this->District = new DbField(
            $this, // Table
            'x_District', // Variable name
            'District', // Name
            '`District`', // Expression
            '`District`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`District`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->District->InputTextType = "text";
        $this->District->Raw = true;
        $this->District->setSelectMultiple(false); // Select one
        $this->District->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->District->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->District->Lookup = new Lookup($this->District, 'district', false, 'DistrictCode', ["DistrictName","","",""], '', '', [], [], [], [], [], [], false, '', '', "`DistrictName`");
        $this->District->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->District->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['District'] = &$this->District;

        // FarmingSeason
        $this->FarmingSeason = new DbField(
            $this, // Table
            'x_FarmingSeason', // Variable name
            'FarmingSeason', // Name
            '`FarmingSeason`', // Expression
            '`FarmingSeason`', // Basic search expression
            18, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmingSeason`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->FarmingSeason->InputTextType = "text";
        $this->FarmingSeason->Raw = true;
        $this->FarmingSeason->Nullable = false; // NOT NULL field
        $this->FarmingSeason->Required = true; // Required field
        $this->FarmingSeason->setSelectMultiple(false); // Select one
        $this->FarmingSeason->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->FarmingSeason->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->FarmingSeason->Lookup = new Lookup($this->FarmingSeason, 'years', false, 'year', ["year","","",""], '', '', [], [], [], [], [], [], false, '', '', "`year`");
        $this->FarmingSeason->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmingSeason->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['FarmingSeason'] = &$this->FarmingSeason;

        // SeedlingsReceived
        $this->SeedlingsReceived = new DbField(
            $this, // Table
            'x_SeedlingsReceived', // Variable name
            'SeedlingsReceived', // Name
            '`SeedlingsReceived`', // Expression
            '`SeedlingsReceived`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SeedlingsReceived`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SeedlingsReceived->InputTextType = "text";
        $this->SeedlingsReceived->Raw = true;
        $this->SeedlingsReceived->Nullable = false; // NOT NULL field
        $this->SeedlingsReceived->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->SeedlingsReceived->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['SeedlingsReceived'] = &$this->SeedlingsReceived;

        // SeedsReceived
        $this->SeedsReceived = new DbField(
            $this, // Table
            'x_SeedsReceived', // Variable name
            'SeedsReceived', // Name
            '`SeedsReceived`', // Expression
            '`SeedsReceived`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SeedsReceived`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SeedsReceived->InputTextType = "text";
        $this->SeedsReceived->Raw = true;
        $this->SeedsReceived->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->SeedsReceived->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['SeedsReceived'] = &$this->SeedsReceived;

        // SeedType
        $this->SeedType = new DbField(
            $this, // Table
            'x_SeedType', // Variable name
            'SeedType', // Name
            '`SeedType`', // Expression
            '`SeedType`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SeedType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->SeedType->InputTextType = "text";
        $this->SeedType->Nullable = false; // NOT NULL field
        $this->SeedType->Required = true; // Required field
        $this->SeedType->setSelectMultiple(false); // Select one
        $this->SeedType->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->SeedType->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->SeedType->Lookup = new Lookup($this->SeedType, 'seed_variety', false, 'SeedVariety', ["SeedVariety","","",""], '', '', [], [], [], [], [], [], false, '', '', "`SeedVariety`");
        $this->SeedType->SearchOperators = ["=", "<>"];
        $this->Fields['SeedType'] = &$this->SeedType;

        // GoodsDescription
        $this->GoodsDescription = new DbField(
            $this, // Table
            'x_GoodsDescription', // Variable name
            'GoodsDescription', // Name
            '`GoodsDescription`', // Expression
            '`GoodsDescription`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`GoodsDescription`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->GoodsDescription->InputTextType = "text";
        $this->GoodsDescription->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['GoodsDescription'] = &$this->GoodsDescription;

        // DateReceived
        $this->DateReceived = new DbField(
            $this, // Table
            'x_DateReceived', // Variable name
            'DateReceived', // Name
            '`DateReceived`', // Expression
            CastDateFieldForLike("`DateReceived`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`DateReceived`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DateReceived->InputTextType = "text";
        $this->DateReceived->Raw = true;
        $this->DateReceived->Nullable = false; // NOT NULL field
        $this->DateReceived->Required = true; // Required field
        $this->DateReceived->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->DateReceived->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['DateReceived'] = &$this->DateReceived;

        // ReceivedBy
        $this->ReceivedBy = new DbField(
            $this, // Table
            'x_ReceivedBy', // Variable name
            'ReceivedBy', // Name
            '`ReceivedBy`', // Expression
            '`ReceivedBy`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ReceivedBy`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ReceivedBy->InputTextType = "text";
        $this->ReceivedBy->Nullable = false; // NOT NULL field
        $this->ReceivedBy->Required = true; // Required field
        $this->ReceivedBy->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['ReceivedBy'] = &$this->ReceivedBy;

        // AuthorizedBy
        $this->AuthorizedBy = new DbField(
            $this, // Table
            'x_AuthorizedBy', // Variable name
            'AuthorizedBy', // Name
            '`AuthorizedBy`', // Expression
            '`AuthorizedBy`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`AuthorizedBy`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->AuthorizedBy->InputTextType = "text";
        $this->AuthorizedBy->Nullable = false; // NOT NULL field
        $this->AuthorizedBy->Required = true; // Required field
        $this->AuthorizedBy->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['AuthorizedBy'] = &$this->AuthorizedBy;

        // GoodsReceived
        $this->GoodsReceived = new DbField(
            $this, // Table
            'x_GoodsReceived', // Variable name
            'GoodsReceived', // Name
            '`GoodsReceived`', // Expression
            '`GoodsReceived`', // Basic search expression
            200, // Type
            65535, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`GoodsReceived`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->GoodsReceived->InputTextType = "text";
        $this->GoodsReceived->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['GoodsReceived'] = &$this->GoodsReceived;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "goods_received_note";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('SupplierCode', $rs)) {
                AddFilter($where, QuotedName('SupplierCode', $this->Dbid) . '=' . QuotedValue($rs['SupplierCode'], $this->SupplierCode->DataType, $this->Dbid));
            }
            if (array_key_exists('GRN', $rs)) {
                AddFilter($where, QuotedName('GRN', $this->Dbid) . '=' . QuotedValue($rs['GRN'], $this->GRN->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->SupplierCode->DbValue = $row['SupplierCode'];
        $this->GRN->DbValue = $row['GRN'];
        $this->District->DbValue = $row['District'];
        $this->FarmingSeason->DbValue = $row['FarmingSeason'];
        $this->SeedlingsReceived->DbValue = $row['SeedlingsReceived'];
        $this->SeedsReceived->DbValue = $row['SeedsReceived'];
        $this->SeedType->DbValue = $row['SeedType'];
        $this->GoodsDescription->DbValue = $row['GoodsDescription'];
        $this->DateReceived->DbValue = $row['DateReceived'];
        $this->ReceivedBy->DbValue = $row['ReceivedBy'];
        $this->AuthorizedBy->DbValue = $row['AuthorizedBy'];
        $this->GoodsReceived->DbValue = $row['GoodsReceived'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`SupplierCode` = @SupplierCode@ AND `GRN` = '@GRN@'";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->SupplierCode->CurrentValue : $this->SupplierCode->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $val = $current ? $this->GRN->CurrentValue : $this->GRN->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 2) {
            if ($current) {
                $this->SupplierCode->CurrentValue = $keys[0];
            } else {
                $this->SupplierCode->OldValue = $keys[0];
            }
            if ($current) {
                $this->GRN->CurrentValue = $keys[1];
            } else {
                $this->GRN->OldValue = $keys[1];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('SupplierCode', $row) ? $row['SupplierCode'] : null;
        } else {
            $val = !EmptyValue($this->SupplierCode->OldValue) && !$current ? $this->SupplierCode->OldValue : $this->SupplierCode->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@SupplierCode@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        if (is_array($row)) {
            $val = array_key_exists('GRN', $row) ? $row['GRN'] : null;
        } else {
            $val = !EmptyValue($this->GRN->OldValue) && !$current ? $this->GRN->OldValue : $this->GRN->CurrentValue;
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@GRN@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("GoodsReceivedNoteList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "GoodsReceivedNoteView" => $Language->phrase("View"),
            "GoodsReceivedNoteEdit" => $Language->phrase("Edit"),
            "GoodsReceivedNoteAdd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "GoodsReceivedNoteList";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "GoodsReceivedNoteView",
            Config("API_ADD_ACTION") => "GoodsReceivedNoteAdd",
            Config("API_EDIT_ACTION") => "GoodsReceivedNoteEdit",
            Config("API_DELETE_ACTION") => "GoodsReceivedNoteDelete",
            Config("API_LIST_ACTION") => "GoodsReceivedNoteList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "GoodsReceivedNoteList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("GoodsReceivedNoteView", $parm);
        } else {
            $url = $this->keyUrl("GoodsReceivedNoteView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "GoodsReceivedNoteAdd?" . $parm;
        } else {
            $url = "GoodsReceivedNoteAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("GoodsReceivedNoteEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("GoodsReceivedNoteList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("GoodsReceivedNoteAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("GoodsReceivedNoteList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("GoodsReceivedNoteDelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"SupplierCode\":" . VarToJson($this->SupplierCode->CurrentValue, "number");
        $json .= ",\"GRN\":" . VarToJson($this->GRN->CurrentValue, "string");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->SupplierCode->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->SupplierCode->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($this->GRN->CurrentValue !== null) {
            $url .= $this->RouteCompositeKeySeparator . $this->encodeKeyValue($this->GRN->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
            for ($i = 0; $i < $cnt; $i++) {
                $arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
            }
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 1))) // Other API
                : []; // Non-API
            if (($keyValue = Param("SupplierCode") ?? Route("SupplierCode")) !== null) {
                $arKey[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            if (($keyValue = Param("GRN") ?? Route("GRN")) !== null) {
                $arKey[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(1) ?? $keyValues[1] ?? null) !== null)) {
                $arKey[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
            $arKeys[] = $arKey;
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_array($key) || count($key) != 2) {
                    continue; // Just skip so other keys will still work
                }
                if (!is_numeric($key[0])) { // SupplierCode
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->SupplierCode->CurrentValue = $key[0];
            } else {
                $this->SupplierCode->OldValue = $key[0];
            }
            if ($setCurrent) {
                $this->GRN->CurrentValue = $key[1];
            } else {
                $this->GRN->OldValue = $key[1];
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->SupplierCode->setDbValue($row['SupplierCode']);
        $this->GRN->setDbValue($row['GRN']);
        $this->District->setDbValue($row['District']);
        $this->FarmingSeason->setDbValue($row['FarmingSeason']);
        $this->SeedlingsReceived->setDbValue($row['SeedlingsReceived']);
        $this->SeedsReceived->setDbValue($row['SeedsReceived']);
        $this->SeedType->setDbValue($row['SeedType']);
        $this->GoodsDescription->setDbValue($row['GoodsDescription']);
        $this->DateReceived->setDbValue($row['DateReceived']);
        $this->ReceivedBy->setDbValue($row['ReceivedBy']);
        $this->AuthorizedBy->setDbValue($row['AuthorizedBy']);
        $this->GoodsReceived->setDbValue($row['GoodsReceived']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "GoodsReceivedNoteList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // SupplierCode

        // GRN

        // District

        // FarmingSeason

        // SeedlingsReceived

        // SeedsReceived

        // SeedType

        // GoodsDescription

        // DateReceived

        // ReceivedBy

        // AuthorizedBy

        // GoodsReceived

        // SupplierCode
        $this->SupplierCode->ViewValue = $this->SupplierCode->CurrentValue;
        $curVal = strval($this->SupplierCode->CurrentValue);
        if ($curVal != "") {
            $this->SupplierCode->ViewValue = $this->SupplierCode->lookupCacheOption($curVal);
            if ($this->SupplierCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                $sqlWrk = $this->SupplierCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->SupplierCode->Lookup->renderViewRow($rswrk[0]);
                    $this->SupplierCode->ViewValue = $this->SupplierCode->displayValue($arwrk);
                } else {
                    $this->SupplierCode->ViewValue = $this->SupplierCode->CurrentValue;
                }
            }
        } else {
            $this->SupplierCode->ViewValue = null;
        }

        // GRN
        $this->GRN->ViewValue = $this->GRN->CurrentValue;

        // District
        $curVal = strval($this->District->CurrentValue);
        if ($curVal != "") {
            $this->District->ViewValue = $this->District->lookupCacheOption($curVal);
            if ($this->District->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->District->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->District->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                $sqlWrk = $this->District->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->District->Lookup->renderViewRow($rswrk[0]);
                    $this->District->ViewValue = $this->District->displayValue($arwrk);
                } else {
                    $this->District->ViewValue = $this->District->CurrentValue;
                }
            }
        } else {
            $this->District->ViewValue = null;
        }

        // FarmingSeason
        $curVal = strval($this->FarmingSeason->CurrentValue);
        if ($curVal != "") {
            $this->FarmingSeason->ViewValue = $this->FarmingSeason->lookupCacheOption($curVal);
            if ($this->FarmingSeason->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->FarmingSeason->Lookup->getTable()->Fields["year"]->searchExpression(), "=", $curVal, $this->FarmingSeason->Lookup->getTable()->Fields["year"]->searchDataType(), "");
                $sqlWrk = $this->FarmingSeason->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->FarmingSeason->Lookup->renderViewRow($rswrk[0]);
                    $this->FarmingSeason->ViewValue = $this->FarmingSeason->displayValue($arwrk);
                } else {
                    $this->FarmingSeason->ViewValue = $this->FarmingSeason->CurrentValue;
                }
            }
        } else {
            $this->FarmingSeason->ViewValue = null;
        }

        // SeedlingsReceived
        $this->SeedlingsReceived->ViewValue = $this->SeedlingsReceived->CurrentValue;
        $this->SeedlingsReceived->ViewValue = FormatNumber($this->SeedlingsReceived->ViewValue, $this->SeedlingsReceived->formatPattern());
        $this->SeedlingsReceived->CellCssStyle .= "text-align: right;";

        // SeedsReceived
        $this->SeedsReceived->ViewValue = $this->SeedsReceived->CurrentValue;
        $this->SeedsReceived->ViewValue = FormatNumber($this->SeedsReceived->ViewValue, $this->SeedsReceived->formatPattern());
        $this->SeedsReceived->CellCssStyle .= "text-align: right;";

        // SeedType
        $curVal = strval($this->SeedType->CurrentValue);
        if ($curVal != "") {
            $this->SeedType->ViewValue = $this->SeedType->lookupCacheOption($curVal);
            if ($this->SeedType->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $curVal, $this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                $sqlWrk = $this->SeedType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->SeedType->Lookup->renderViewRow($rswrk[0]);
                    $this->SeedType->ViewValue = $this->SeedType->displayValue($arwrk);
                } else {
                    $this->SeedType->ViewValue = $this->SeedType->CurrentValue;
                }
            }
        } else {
            $this->SeedType->ViewValue = null;
        }

        // GoodsDescription
        $this->GoodsDescription->ViewValue = $this->GoodsDescription->CurrentValue;

        // DateReceived
        $this->DateReceived->ViewValue = $this->DateReceived->CurrentValue;
        $this->DateReceived->ViewValue = FormatDateTime($this->DateReceived->ViewValue, $this->DateReceived->formatPattern());

        // ReceivedBy
        $this->ReceivedBy->ViewValue = $this->ReceivedBy->CurrentValue;

        // AuthorizedBy
        $this->AuthorizedBy->ViewValue = $this->AuthorizedBy->CurrentValue;

        // GoodsReceived
        $this->GoodsReceived->ViewValue = $this->GoodsReceived->CurrentValue;

        // SupplierCode
        $this->SupplierCode->HrefValue = "";
        $this->SupplierCode->TooltipValue = "";

        // GRN
        $this->GRN->HrefValue = "";
        $this->GRN->TooltipValue = "";

        // District
        $this->District->HrefValue = "";
        $this->District->TooltipValue = "";

        // FarmingSeason
        $this->FarmingSeason->HrefValue = "";
        $this->FarmingSeason->TooltipValue = "";

        // SeedlingsReceived
        $this->SeedlingsReceived->HrefValue = "";
        $this->SeedlingsReceived->TooltipValue = "";

        // SeedsReceived
        $this->SeedsReceived->HrefValue = "";
        $this->SeedsReceived->TooltipValue = "";

        // SeedType
        $this->SeedType->HrefValue = "";
        $this->SeedType->TooltipValue = "";

        // GoodsDescription
        $this->GoodsDescription->HrefValue = "";
        $this->GoodsDescription->TooltipValue = "";

        // DateReceived
        $this->DateReceived->HrefValue = "";
        $this->DateReceived->TooltipValue = "";

        // ReceivedBy
        $this->ReceivedBy->HrefValue = "";
        $this->ReceivedBy->TooltipValue = "";

        // AuthorizedBy
        $this->AuthorizedBy->HrefValue = "";
        $this->AuthorizedBy->TooltipValue = "";

        // GoodsReceived
        $this->GoodsReceived->HrefValue = "";
        $this->GoodsReceived->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // SupplierCode
        $this->SupplierCode->setupEditAttributes();
        $this->SupplierCode->EditValue = $this->SupplierCode->CurrentValue;
        $this->SupplierCode->PlaceHolder = RemoveHtml($this->SupplierCode->caption());

        // GRN
        $this->GRN->setupEditAttributes();
        if (!$this->GRN->Raw) {
            $this->GRN->CurrentValue = HtmlDecode($this->GRN->CurrentValue);
        }
        $this->GRN->EditValue = $this->GRN->CurrentValue;
        $this->GRN->PlaceHolder = RemoveHtml($this->GRN->caption());

        // District
        $this->District->setupEditAttributes();
        $this->District->PlaceHolder = RemoveHtml($this->District->caption());

        // FarmingSeason
        $this->FarmingSeason->setupEditAttributes();
        $this->FarmingSeason->PlaceHolder = RemoveHtml($this->FarmingSeason->caption());

        // SeedlingsReceived
        $this->SeedlingsReceived->setupEditAttributes();
        $this->SeedlingsReceived->EditValue = $this->SeedlingsReceived->CurrentValue;
        $this->SeedlingsReceived->PlaceHolder = RemoveHtml($this->SeedlingsReceived->caption());
        if (strval($this->SeedlingsReceived->EditValue) != "" && is_numeric($this->SeedlingsReceived->EditValue)) {
            $this->SeedlingsReceived->EditValue = FormatNumber($this->SeedlingsReceived->EditValue, null);
        }

        // SeedsReceived
        $this->SeedsReceived->setupEditAttributes();
        $this->SeedsReceived->EditValue = $this->SeedsReceived->CurrentValue;
        $this->SeedsReceived->PlaceHolder = RemoveHtml($this->SeedsReceived->caption());
        if (strval($this->SeedsReceived->EditValue) != "" && is_numeric($this->SeedsReceived->EditValue)) {
            $this->SeedsReceived->EditValue = FormatNumber($this->SeedsReceived->EditValue, null);
        }

        // SeedType
        $this->SeedType->setupEditAttributes();
        $this->SeedType->PlaceHolder = RemoveHtml($this->SeedType->caption());

        // GoodsDescription
        $this->GoodsDescription->setupEditAttributes();
        if (!$this->GoodsDescription->Raw) {
            $this->GoodsDescription->CurrentValue = HtmlDecode($this->GoodsDescription->CurrentValue);
        }
        $this->GoodsDescription->EditValue = $this->GoodsDescription->CurrentValue;
        $this->GoodsDescription->PlaceHolder = RemoveHtml($this->GoodsDescription->caption());

        // DateReceived
        $this->DateReceived->setupEditAttributes();
        $this->DateReceived->EditValue = FormatDateTime($this->DateReceived->CurrentValue, $this->DateReceived->formatPattern());
        $this->DateReceived->PlaceHolder = RemoveHtml($this->DateReceived->caption());

        // ReceivedBy
        $this->ReceivedBy->setupEditAttributes();
        if (!$this->ReceivedBy->Raw) {
            $this->ReceivedBy->CurrentValue = HtmlDecode($this->ReceivedBy->CurrentValue);
        }
        $this->ReceivedBy->EditValue = $this->ReceivedBy->CurrentValue;
        $this->ReceivedBy->PlaceHolder = RemoveHtml($this->ReceivedBy->caption());

        // AuthorizedBy
        $this->AuthorizedBy->setupEditAttributes();
        if (!$this->AuthorizedBy->Raw) {
            $this->AuthorizedBy->CurrentValue = HtmlDecode($this->AuthorizedBy->CurrentValue);
        }
        $this->AuthorizedBy->EditValue = $this->AuthorizedBy->CurrentValue;
        $this->AuthorizedBy->PlaceHolder = RemoveHtml($this->AuthorizedBy->caption());

        // GoodsReceived
        $this->GoodsReceived->setupEditAttributes();
        $this->GoodsReceived->EditValue = $this->GoodsReceived->CurrentValue;
        $this->GoodsReceived->PlaceHolder = RemoveHtml($this->GoodsReceived->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->SupplierCode);
                    $doc->exportCaption($this->GRN);
                    $doc->exportCaption($this->District);
                    $doc->exportCaption($this->FarmingSeason);
                    $doc->exportCaption($this->SeedlingsReceived);
                    $doc->exportCaption($this->SeedsReceived);
                    $doc->exportCaption($this->SeedType);
                    $doc->exportCaption($this->GoodsDescription);
                    $doc->exportCaption($this->DateReceived);
                    $doc->exportCaption($this->ReceivedBy);
                    $doc->exportCaption($this->AuthorizedBy);
                    $doc->exportCaption($this->GoodsReceived);
                } else {
                    $doc->exportCaption($this->SupplierCode);
                    $doc->exportCaption($this->GRN);
                    $doc->exportCaption($this->District);
                    $doc->exportCaption($this->FarmingSeason);
                    $doc->exportCaption($this->SeedlingsReceived);
                    $doc->exportCaption($this->SeedsReceived);
                    $doc->exportCaption($this->SeedType);
                    $doc->exportCaption($this->GoodsDescription);
                    $doc->exportCaption($this->DateReceived);
                    $doc->exportCaption($this->ReceivedBy);
                    $doc->exportCaption($this->AuthorizedBy);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->SupplierCode);
                        $doc->exportField($this->GRN);
                        $doc->exportField($this->District);
                        $doc->exportField($this->FarmingSeason);
                        $doc->exportField($this->SeedlingsReceived);
                        $doc->exportField($this->SeedsReceived);
                        $doc->exportField($this->SeedType);
                        $doc->exportField($this->GoodsDescription);
                        $doc->exportField($this->DateReceived);
                        $doc->exportField($this->ReceivedBy);
                        $doc->exportField($this->AuthorizedBy);
                        $doc->exportField($this->GoodsReceived);
                    } else {
                        $doc->exportField($this->SupplierCode);
                        $doc->exportField($this->GRN);
                        $doc->exportField($this->District);
                        $doc->exportField($this->FarmingSeason);
                        $doc->exportField($this->SeedlingsReceived);
                        $doc->exportField($this->SeedsReceived);
                        $doc->exportField($this->SeedType);
                        $doc->exportField($this->GoodsDescription);
                        $doc->exportField($this->DateReceived);
                        $doc->exportField($this->ReceivedBy);
                        $doc->exportField($this->AuthorizedBy);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
