<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Table class for farmers_extra
 */
class FarmersExtra extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $ProvinceCode;
    public $DistrictCode;
    public $CampCode;
    public $VillageCode;
    public $FarmerNo;
    public $NRC;
    public $FarmerName;
    public $FarmerType;
    public $DOB;
    public $Age;
    public $Gender;
    public $MaritalStatus;
    public $PhoneNo;
    public $_Email;
    public $Dependants;
    public $MaleChildren;
    public $FemaleChildren;
    public $HouseholdHead;
    public $FarmerOrg;
    public $FarmerOrgPosition;
    public $JoiningDate;
    public $Comments;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "farmers_extra";
        $this->TableName = 'farmers_extra';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "farmers_extra";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ProvinceCode
        $this->ProvinceCode = new DbField(
            $this, // Table
            'x_ProvinceCode', // Variable name
            'ProvinceCode', // Name
            '`ProvinceCode`', // Expression
            '`ProvinceCode`', // Basic search expression
            3, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProvinceCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ProvinceCode->addMethod("getDefault", fn() => 0);
        $this->ProvinceCode->InputTextType = "text";
        $this->ProvinceCode->Raw = true;
        $this->ProvinceCode->Nullable = false; // NOT NULL field
        $this->ProvinceCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ProvinceCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ProvinceCode'] = &$this->ProvinceCode;

        // DistrictCode
        $this->DistrictCode = new DbField(
            $this, // Table
            'x_DistrictCode', // Variable name
            'DistrictCode', // Name
            '`DistrictCode`', // Expression
            '`DistrictCode`', // Basic search expression
            3, // Type
            2, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DistrictCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DistrictCode->addMethod("getDefault", fn() => 0);
        $this->DistrictCode->InputTextType = "text";
        $this->DistrictCode->Raw = true;
        $this->DistrictCode->Nullable = false; // NOT NULL field
        $this->DistrictCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->DistrictCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['DistrictCode'] = &$this->DistrictCode;

        // CampCode
        $this->CampCode = new DbField(
            $this, // Table
            'x_CampCode', // Variable name
            'CampCode', // Name
            '`CampCode`', // Expression
            '`CampCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`CampCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->CampCode->InputTextType = "text";
        $this->CampCode->Raw = true;
        $this->CampCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->CampCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['CampCode'] = &$this->CampCode;

        // VillageCode
        $this->VillageCode = new DbField(
            $this, // Table
            'x_VillageCode', // Variable name
            'VillageCode', // Name
            '`VillageCode`', // Expression
            '`VillageCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`VillageCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->VillageCode->InputTextType = "text";
        $this->VillageCode->Raw = true;
        $this->VillageCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->VillageCode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['VillageCode'] = &$this->VillageCode;

        // FarmerNo
        $this->FarmerNo = new DbField(
            $this, // Table
            'x_FarmerNo', // Variable name
            'FarmerNo', // Name
            '`FarmerNo`', // Expression
            '`FarmerNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerNo->addMethod("getDefault", fn() => 0);
        $this->FarmerNo->InputTextType = "text";
        $this->FarmerNo->Raw = true;
        $this->FarmerNo->Nullable = false; // NOT NULL field
        $this->FarmerNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmerNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['FarmerNo'] = &$this->FarmerNo;

        // NRC
        $this->NRC = new DbField(
            $this, // Table
            'x_NRC', // Variable name
            'NRC', // Name
            '`NRC`', // Expression
            '`NRC`', // Basic search expression
            200, // Type
            13, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NRC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NRC->InputTextType = "text";
        $this->NRC->Nullable = false; // NOT NULL field
        $this->NRC->Required = true; // Required field
        $this->NRC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['NRC'] = &$this->NRC;

        // FarmerName
        $this->FarmerName = new DbField(
            $this, // Table
            'x_FarmerName', // Variable name
            'FarmerName', // Name
            '`FarmerName`', // Expression
            '`FarmerName`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerName`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerName->InputTextType = "text";
        $this->FarmerName->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmerName'] = &$this->FarmerName;

        // FarmerType
        $this->FarmerType = new DbField(
            $this, // Table
            'x_FarmerType', // Variable name
            'FarmerType', // Name
            '`FarmerType`', // Expression
            '`FarmerType`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerType->addMethod("getDefault", fn() => 1);
        $this->FarmerType->InputTextType = "text";
        $this->FarmerType->Raw = true;
        $this->FarmerType->Nullable = false; // NOT NULL field
        $this->FarmerType->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmerType->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['FarmerType'] = &$this->FarmerType;

        // DOB
        $this->DOB = new DbField(
            $this, // Table
            'x_DOB', // Variable name
            'DOB', // Name
            '`DOB`', // Expression
            CastDateFieldForLike("`DOB`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`DOB`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->DOB->InputTextType = "text";
        $this->DOB->Raw = true;
        $this->DOB->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->DOB->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['DOB'] = &$this->DOB;

        // Age
        $this->Age = new DbField(
            $this, // Table
            'x_Age', // Variable name
            'Age', // Name
            '`Age`', // Expression
            '`Age`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Age`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Age->InputTextType = "text";
        $this->Age->Raw = true;
        $this->Age->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Age->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Age'] = &$this->Age;

        // Gender
        $this->Gender = new DbField(
            $this, // Table
            'x_Gender', // Variable name
            'Gender', // Name
            '`Gender`', // Expression
            '`Gender`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Gender`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Gender->InputTextType = "text";
        $this->Gender->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Gender'] = &$this->Gender;

        // MaritalStatus
        $this->MaritalStatus = new DbField(
            $this, // Table
            'x_MaritalStatus', // Variable name
            'MaritalStatus', // Name
            '`MaritalStatus`', // Expression
            '`MaritalStatus`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MaritalStatus`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MaritalStatus->InputTextType = "text";
        $this->MaritalStatus->Raw = true;
        $this->MaritalStatus->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MaritalStatus->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['MaritalStatus'] = &$this->MaritalStatus;

        // PhoneNo
        $this->PhoneNo = new DbField(
            $this, // Table
            'x_PhoneNo', // Variable name
            'PhoneNo', // Name
            '`PhoneNo`', // Expression
            '`PhoneNo`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`PhoneNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->PhoneNo->InputTextType = "text";
        $this->PhoneNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['PhoneNo'] = &$this->PhoneNo;

        // Email
        $this->_Email = new DbField(
            $this, // Table
            'x__Email', // Variable name
            'Email', // Name
            '`Email`', // Expression
            '`Email`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Email`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_Email->InputTextType = "text";
        $this->_Email->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Email'] = &$this->_Email;

        // Dependants
        $this->Dependants = new DbField(
            $this, // Table
            'x_Dependants', // Variable name
            'Dependants', // Name
            '`Dependants`', // Expression
            '`Dependants`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Dependants`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Dependants->InputTextType = "text";
        $this->Dependants->Raw = true;
        $this->Dependants->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Dependants->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Dependants'] = &$this->Dependants;

        // MaleChildren
        $this->MaleChildren = new DbField(
            $this, // Table
            'x_MaleChildren', // Variable name
            'MaleChildren', // Name
            '`MaleChildren`', // Expression
            '`MaleChildren`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`MaleChildren`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->MaleChildren->InputTextType = "text";
        $this->MaleChildren->Raw = true;
        $this->MaleChildren->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MaleChildren->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['MaleChildren'] = &$this->MaleChildren;

        // FemaleChildren
        $this->FemaleChildren = new DbField(
            $this, // Table
            'x_FemaleChildren', // Variable name
            'FemaleChildren', // Name
            '`FemaleChildren`', // Expression
            '`FemaleChildren`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FemaleChildren`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FemaleChildren->InputTextType = "text";
        $this->FemaleChildren->Raw = true;
        $this->FemaleChildren->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FemaleChildren->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FemaleChildren'] = &$this->FemaleChildren;

        // HouseholdHead
        $this->HouseholdHead = new DbField(
            $this, // Table
            'x_HouseholdHead', // Variable name
            'HouseholdHead', // Name
            '`HouseholdHead`', // Expression
            '`HouseholdHead`', // Basic search expression
            16, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`HouseholdHead`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->HouseholdHead->InputTextType = "text";
        $this->HouseholdHead->Raw = true;
        $this->HouseholdHead->setDataType(DataType::BOOLEAN);
        $this->HouseholdHead->Lookup = new Lookup($this->HouseholdHead, 'farmers_extra', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->HouseholdHead->OptionCount = 2;
        $this->HouseholdHead->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->HouseholdHead->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['HouseholdHead'] = &$this->HouseholdHead;

        // FarmerOrg
        $this->FarmerOrg = new DbField(
            $this, // Table
            'x_FarmerOrg', // Variable name
            'FarmerOrg', // Name
            '`FarmerOrg`', // Expression
            '`FarmerOrg`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerOrg`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerOrg->InputTextType = "text";
        $this->FarmerOrg->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmerOrg'] = &$this->FarmerOrg;

        // FarmerOrgPosition
        $this->FarmerOrgPosition = new DbField(
            $this, // Table
            'x_FarmerOrgPosition', // Variable name
            'FarmerOrgPosition', // Name
            '`FarmerOrgPosition`', // Expression
            '`FarmerOrgPosition`', // Basic search expression
            200, // Type
            40, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerOrgPosition`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerOrgPosition->InputTextType = "text";
        $this->FarmerOrgPosition->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmerOrgPosition'] = &$this->FarmerOrgPosition;

        // JoiningDate
        $this->JoiningDate = new DbField(
            $this, // Table
            'x_JoiningDate', // Variable name
            'JoiningDate', // Name
            '`JoiningDate`', // Expression
            CastDateFieldForLike("`JoiningDate`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`JoiningDate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->JoiningDate->InputTextType = "text";
        $this->JoiningDate->Raw = true;
        $this->JoiningDate->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->JoiningDate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['JoiningDate'] = &$this->JoiningDate;

        // Comments
        $this->Comments = new DbField(
            $this, // Table
            'x_Comments', // Variable name
            'Comments', // Name
            '`Comments`', // Expression
            '`Comments`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Comments`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Comments->InputTextType = "text";
        $this->Comments->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Comments'] = &$this->Comments;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "farmers_extra";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->ProvinceCode->DbValue = $row['ProvinceCode'];
        $this->DistrictCode->DbValue = $row['DistrictCode'];
        $this->CampCode->DbValue = $row['CampCode'];
        $this->VillageCode->DbValue = $row['VillageCode'];
        $this->FarmerNo->DbValue = $row['FarmerNo'];
        $this->NRC->DbValue = $row['NRC'];
        $this->FarmerName->DbValue = $row['FarmerName'];
        $this->FarmerType->DbValue = $row['FarmerType'];
        $this->DOB->DbValue = $row['DOB'];
        $this->Age->DbValue = $row['Age'];
        $this->Gender->DbValue = $row['Gender'];
        $this->MaritalStatus->DbValue = $row['MaritalStatus'];
        $this->PhoneNo->DbValue = $row['PhoneNo'];
        $this->_Email->DbValue = $row['Email'];
        $this->Dependants->DbValue = $row['Dependants'];
        $this->MaleChildren->DbValue = $row['MaleChildren'];
        $this->FemaleChildren->DbValue = $row['FemaleChildren'];
        $this->HouseholdHead->DbValue = $row['HouseholdHead'];
        $this->FarmerOrg->DbValue = $row['FarmerOrg'];
        $this->FarmerOrgPosition->DbValue = $row['FarmerOrgPosition'];
        $this->JoiningDate->DbValue = $row['JoiningDate'];
        $this->Comments->DbValue = $row['Comments'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("FarmersExtraList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "FarmersExtraView" => $Language->phrase("View"),
            "FarmersExtraEdit" => $Language->phrase("Edit"),
            "FarmersExtraAdd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "FarmersExtraList";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "FarmersExtraView",
            Config("API_ADD_ACTION") => "FarmersExtraAdd",
            Config("API_EDIT_ACTION") => "FarmersExtraEdit",
            Config("API_DELETE_ACTION") => "FarmersExtraDelete",
            Config("API_LIST_ACTION") => "FarmersExtraList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "FarmersExtraList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("FarmersExtraView", $parm);
        } else {
            $url = $this->keyUrl("FarmersExtraView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "FarmersExtraAdd?" . $parm;
        } else {
            $url = "FarmersExtraAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("FarmersExtraEdit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("FarmersExtraList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("FarmersExtraAdd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("FarmersExtraList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("FarmersExtraDelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerName->setDbValue($row['FarmerName']);
        $this->FarmerType->setDbValue($row['FarmerType']);
        $this->DOB->setDbValue($row['DOB']);
        $this->Age->setDbValue($row['Age']);
        $this->Gender->setDbValue($row['Gender']);
        $this->MaritalStatus->setDbValue($row['MaritalStatus']);
        $this->PhoneNo->setDbValue($row['PhoneNo']);
        $this->_Email->setDbValue($row['Email']);
        $this->Dependants->setDbValue($row['Dependants']);
        $this->MaleChildren->setDbValue($row['MaleChildren']);
        $this->FemaleChildren->setDbValue($row['FemaleChildren']);
        $this->HouseholdHead->setDbValue($row['HouseholdHead']);
        $this->FarmerOrg->setDbValue($row['FarmerOrg']);
        $this->FarmerOrgPosition->setDbValue($row['FarmerOrgPosition']);
        $this->JoiningDate->setDbValue($row['JoiningDate']);
        $this->Comments->setDbValue($row['Comments']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "FarmersExtraList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ProvinceCode

        // DistrictCode

        // CampCode

        // VillageCode

        // FarmerNo

        // NRC

        // FarmerName

        // FarmerType

        // DOB

        // Age

        // Gender

        // MaritalStatus

        // PhoneNo

        // Email

        // Dependants

        // MaleChildren

        // FemaleChildren

        // HouseholdHead

        // FarmerOrg

        // FarmerOrgPosition

        // JoiningDate

        // Comments

        // ProvinceCode
        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
        $this->ProvinceCode->ViewValue = FormatNumber($this->ProvinceCode->ViewValue, $this->ProvinceCode->formatPattern());

        // DistrictCode
        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
        $this->DistrictCode->ViewValue = FormatNumber($this->DistrictCode->ViewValue, $this->DistrictCode->formatPattern());

        // CampCode
        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
        $this->CampCode->ViewValue = FormatNumber($this->CampCode->ViewValue, $this->CampCode->formatPattern());

        // VillageCode
        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
        $this->VillageCode->ViewValue = FormatNumber($this->VillageCode->ViewValue, $this->VillageCode->formatPattern());

        // FarmerNo
        $this->FarmerNo->ViewValue = $this->FarmerNo->CurrentValue;
        $this->FarmerNo->ViewValue = FormatNumber($this->FarmerNo->ViewValue, $this->FarmerNo->formatPattern());

        // NRC
        $this->NRC->ViewValue = $this->NRC->CurrentValue;

        // FarmerName
        $this->FarmerName->ViewValue = $this->FarmerName->CurrentValue;

        // FarmerType
        $this->FarmerType->ViewValue = $this->FarmerType->CurrentValue;
        $this->FarmerType->ViewValue = FormatNumber($this->FarmerType->ViewValue, $this->FarmerType->formatPattern());

        // DOB
        $this->DOB->ViewValue = $this->DOB->CurrentValue;
        $this->DOB->ViewValue = FormatDateTime($this->DOB->ViewValue, $this->DOB->formatPattern());

        // Age
        $this->Age->ViewValue = $this->Age->CurrentValue;
        $this->Age->ViewValue = FormatNumber($this->Age->ViewValue, $this->Age->formatPattern());

        // Gender
        $this->Gender->ViewValue = $this->Gender->CurrentValue;

        // MaritalStatus
        $this->MaritalStatus->ViewValue = $this->MaritalStatus->CurrentValue;
        $this->MaritalStatus->ViewValue = FormatNumber($this->MaritalStatus->ViewValue, $this->MaritalStatus->formatPattern());

        // PhoneNo
        $this->PhoneNo->ViewValue = $this->PhoneNo->CurrentValue;

        // Email
        $this->_Email->ViewValue = $this->_Email->CurrentValue;

        // Dependants
        $this->Dependants->ViewValue = $this->Dependants->CurrentValue;
        $this->Dependants->ViewValue = FormatNumber($this->Dependants->ViewValue, $this->Dependants->formatPattern());

        // MaleChildren
        $this->MaleChildren->ViewValue = $this->MaleChildren->CurrentValue;
        $this->MaleChildren->ViewValue = FormatNumber($this->MaleChildren->ViewValue, $this->MaleChildren->formatPattern());

        // FemaleChildren
        $this->FemaleChildren->ViewValue = $this->FemaleChildren->CurrentValue;
        $this->FemaleChildren->ViewValue = FormatNumber($this->FemaleChildren->ViewValue, $this->FemaleChildren->formatPattern());

        // HouseholdHead
        if (ConvertToBool($this->HouseholdHead->CurrentValue)) {
            $this->HouseholdHead->ViewValue = $this->HouseholdHead->tagCaption(1) != "" ? $this->HouseholdHead->tagCaption(1) : "Yes";
        } else {
            $this->HouseholdHead->ViewValue = $this->HouseholdHead->tagCaption(2) != "" ? $this->HouseholdHead->tagCaption(2) : "No";
        }

        // FarmerOrg
        $this->FarmerOrg->ViewValue = $this->FarmerOrg->CurrentValue;

        // FarmerOrgPosition
        $this->FarmerOrgPosition->ViewValue = $this->FarmerOrgPosition->CurrentValue;

        // JoiningDate
        $this->JoiningDate->ViewValue = $this->JoiningDate->CurrentValue;
        $this->JoiningDate->ViewValue = FormatDateTime($this->JoiningDate->ViewValue, $this->JoiningDate->formatPattern());

        // Comments
        $this->Comments->ViewValue = $this->Comments->CurrentValue;

        // ProvinceCode
        $this->ProvinceCode->HrefValue = "";
        $this->ProvinceCode->TooltipValue = "";

        // DistrictCode
        $this->DistrictCode->HrefValue = "";
        $this->DistrictCode->TooltipValue = "";

        // CampCode
        $this->CampCode->HrefValue = "";
        $this->CampCode->TooltipValue = "";

        // VillageCode
        $this->VillageCode->HrefValue = "";
        $this->VillageCode->TooltipValue = "";

        // FarmerNo
        $this->FarmerNo->HrefValue = "";
        $this->FarmerNo->TooltipValue = "";

        // NRC
        $this->NRC->HrefValue = "";
        $this->NRC->TooltipValue = "";

        // FarmerName
        $this->FarmerName->HrefValue = "";
        $this->FarmerName->TooltipValue = "";

        // FarmerType
        $this->FarmerType->HrefValue = "";
        $this->FarmerType->TooltipValue = "";

        // DOB
        $this->DOB->HrefValue = "";
        $this->DOB->TooltipValue = "";

        // Age
        $this->Age->HrefValue = "";
        $this->Age->TooltipValue = "";

        // Gender
        $this->Gender->HrefValue = "";
        $this->Gender->TooltipValue = "";

        // MaritalStatus
        $this->MaritalStatus->HrefValue = "";
        $this->MaritalStatus->TooltipValue = "";

        // PhoneNo
        $this->PhoneNo->HrefValue = "";
        $this->PhoneNo->TooltipValue = "";

        // Email
        $this->_Email->HrefValue = "";
        $this->_Email->TooltipValue = "";

        // Dependants
        $this->Dependants->HrefValue = "";
        $this->Dependants->TooltipValue = "";

        // MaleChildren
        $this->MaleChildren->HrefValue = "";
        $this->MaleChildren->TooltipValue = "";

        // FemaleChildren
        $this->FemaleChildren->HrefValue = "";
        $this->FemaleChildren->TooltipValue = "";

        // HouseholdHead
        $this->HouseholdHead->HrefValue = "";
        $this->HouseholdHead->TooltipValue = "";

        // FarmerOrg
        $this->FarmerOrg->HrefValue = "";
        $this->FarmerOrg->TooltipValue = "";

        // FarmerOrgPosition
        $this->FarmerOrgPosition->HrefValue = "";
        $this->FarmerOrgPosition->TooltipValue = "";

        // JoiningDate
        $this->JoiningDate->HrefValue = "";
        $this->JoiningDate->TooltipValue = "";

        // Comments
        $this->Comments->HrefValue = "";
        $this->Comments->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ProvinceCode
        $this->ProvinceCode->setupEditAttributes();
        $this->ProvinceCode->EditValue = $this->ProvinceCode->CurrentValue;
        $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
        if (strval($this->ProvinceCode->EditValue) != "" && is_numeric($this->ProvinceCode->EditValue)) {
            $this->ProvinceCode->EditValue = FormatNumber($this->ProvinceCode->EditValue, null);
        }

        // DistrictCode
        $this->DistrictCode->setupEditAttributes();
        $this->DistrictCode->EditValue = $this->DistrictCode->CurrentValue;
        $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
        if (strval($this->DistrictCode->EditValue) != "" && is_numeric($this->DistrictCode->EditValue)) {
            $this->DistrictCode->EditValue = FormatNumber($this->DistrictCode->EditValue, null);
        }

        // CampCode
        $this->CampCode->setupEditAttributes();
        $this->CampCode->EditValue = $this->CampCode->CurrentValue;
        $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());
        if (strval($this->CampCode->EditValue) != "" && is_numeric($this->CampCode->EditValue)) {
            $this->CampCode->EditValue = FormatNumber($this->CampCode->EditValue, null);
        }

        // VillageCode
        $this->VillageCode->setupEditAttributes();
        $this->VillageCode->EditValue = $this->VillageCode->CurrentValue;
        $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
        if (strval($this->VillageCode->EditValue) != "" && is_numeric($this->VillageCode->EditValue)) {
            $this->VillageCode->EditValue = FormatNumber($this->VillageCode->EditValue, null);
        }

        // FarmerNo
        $this->FarmerNo->setupEditAttributes();
        $this->FarmerNo->EditValue = $this->FarmerNo->CurrentValue;
        $this->FarmerNo->PlaceHolder = RemoveHtml($this->FarmerNo->caption());
        if (strval($this->FarmerNo->EditValue) != "" && is_numeric($this->FarmerNo->EditValue)) {
            $this->FarmerNo->EditValue = FormatNumber($this->FarmerNo->EditValue, null);
        }

        // NRC
        $this->NRC->setupEditAttributes();
        if (!$this->NRC->Raw) {
            $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
        }
        $this->NRC->EditValue = $this->NRC->CurrentValue;
        $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

        // FarmerName
        $this->FarmerName->setupEditAttributes();
        if (!$this->FarmerName->Raw) {
            $this->FarmerName->CurrentValue = HtmlDecode($this->FarmerName->CurrentValue);
        }
        $this->FarmerName->EditValue = $this->FarmerName->CurrentValue;
        $this->FarmerName->PlaceHolder = RemoveHtml($this->FarmerName->caption());

        // FarmerType
        $this->FarmerType->setupEditAttributes();
        $this->FarmerType->EditValue = $this->FarmerType->CurrentValue;
        $this->FarmerType->PlaceHolder = RemoveHtml($this->FarmerType->caption());
        if (strval($this->FarmerType->EditValue) != "" && is_numeric($this->FarmerType->EditValue)) {
            $this->FarmerType->EditValue = FormatNumber($this->FarmerType->EditValue, null);
        }

        // DOB
        $this->DOB->setupEditAttributes();
        $this->DOB->EditValue = FormatDateTime($this->DOB->CurrentValue, $this->DOB->formatPattern());
        $this->DOB->PlaceHolder = RemoveHtml($this->DOB->caption());

        // Age
        $this->Age->setupEditAttributes();
        $this->Age->EditValue = $this->Age->CurrentValue;
        $this->Age->PlaceHolder = RemoveHtml($this->Age->caption());
        if (strval($this->Age->EditValue) != "" && is_numeric($this->Age->EditValue)) {
            $this->Age->EditValue = FormatNumber($this->Age->EditValue, null);
        }

        // Gender
        $this->Gender->setupEditAttributes();
        if (!$this->Gender->Raw) {
            $this->Gender->CurrentValue = HtmlDecode($this->Gender->CurrentValue);
        }
        $this->Gender->EditValue = $this->Gender->CurrentValue;
        $this->Gender->PlaceHolder = RemoveHtml($this->Gender->caption());

        // MaritalStatus
        $this->MaritalStatus->setupEditAttributes();
        $this->MaritalStatus->EditValue = $this->MaritalStatus->CurrentValue;
        $this->MaritalStatus->PlaceHolder = RemoveHtml($this->MaritalStatus->caption());
        if (strval($this->MaritalStatus->EditValue) != "" && is_numeric($this->MaritalStatus->EditValue)) {
            $this->MaritalStatus->EditValue = FormatNumber($this->MaritalStatus->EditValue, null);
        }

        // PhoneNo
        $this->PhoneNo->setupEditAttributes();
        if (!$this->PhoneNo->Raw) {
            $this->PhoneNo->CurrentValue = HtmlDecode($this->PhoneNo->CurrentValue);
        }
        $this->PhoneNo->EditValue = $this->PhoneNo->CurrentValue;
        $this->PhoneNo->PlaceHolder = RemoveHtml($this->PhoneNo->caption());

        // Email
        $this->_Email->setupEditAttributes();
        if (!$this->_Email->Raw) {
            $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
        }
        $this->_Email->EditValue = $this->_Email->CurrentValue;
        $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

        // Dependants
        $this->Dependants->setupEditAttributes();
        $this->Dependants->EditValue = $this->Dependants->CurrentValue;
        $this->Dependants->PlaceHolder = RemoveHtml($this->Dependants->caption());
        if (strval($this->Dependants->EditValue) != "" && is_numeric($this->Dependants->EditValue)) {
            $this->Dependants->EditValue = FormatNumber($this->Dependants->EditValue, null);
        }

        // MaleChildren
        $this->MaleChildren->setupEditAttributes();
        $this->MaleChildren->EditValue = $this->MaleChildren->CurrentValue;
        $this->MaleChildren->PlaceHolder = RemoveHtml($this->MaleChildren->caption());
        if (strval($this->MaleChildren->EditValue) != "" && is_numeric($this->MaleChildren->EditValue)) {
            $this->MaleChildren->EditValue = FormatNumber($this->MaleChildren->EditValue, null);
        }

        // FemaleChildren
        $this->FemaleChildren->setupEditAttributes();
        $this->FemaleChildren->EditValue = $this->FemaleChildren->CurrentValue;
        $this->FemaleChildren->PlaceHolder = RemoveHtml($this->FemaleChildren->caption());
        if (strval($this->FemaleChildren->EditValue) != "" && is_numeric($this->FemaleChildren->EditValue)) {
            $this->FemaleChildren->EditValue = FormatNumber($this->FemaleChildren->EditValue, null);
        }

        // HouseholdHead
        $this->HouseholdHead->EditValue = $this->HouseholdHead->options(false);
        $this->HouseholdHead->PlaceHolder = RemoveHtml($this->HouseholdHead->caption());

        // FarmerOrg
        $this->FarmerOrg->setupEditAttributes();
        if (!$this->FarmerOrg->Raw) {
            $this->FarmerOrg->CurrentValue = HtmlDecode($this->FarmerOrg->CurrentValue);
        }
        $this->FarmerOrg->EditValue = $this->FarmerOrg->CurrentValue;
        $this->FarmerOrg->PlaceHolder = RemoveHtml($this->FarmerOrg->caption());

        // FarmerOrgPosition
        $this->FarmerOrgPosition->setupEditAttributes();
        if (!$this->FarmerOrgPosition->Raw) {
            $this->FarmerOrgPosition->CurrentValue = HtmlDecode($this->FarmerOrgPosition->CurrentValue);
        }
        $this->FarmerOrgPosition->EditValue = $this->FarmerOrgPosition->CurrentValue;
        $this->FarmerOrgPosition->PlaceHolder = RemoveHtml($this->FarmerOrgPosition->caption());

        // JoiningDate
        $this->JoiningDate->setupEditAttributes();
        $this->JoiningDate->EditValue = FormatDateTime($this->JoiningDate->CurrentValue, $this->JoiningDate->formatPattern());
        $this->JoiningDate->PlaceHolder = RemoveHtml($this->JoiningDate->caption());

        // Comments
        $this->Comments->setupEditAttributes();
        if (!$this->Comments->Raw) {
            $this->Comments->CurrentValue = HtmlDecode($this->Comments->CurrentValue);
        }
        $this->Comments->EditValue = $this->Comments->CurrentValue;
        $this->Comments->PlaceHolder = RemoveHtml($this->Comments->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                    $doc->exportCaption($this->FarmerNo);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmerName);
                    $doc->exportCaption($this->FarmerType);
                    $doc->exportCaption($this->DOB);
                    $doc->exportCaption($this->Age);
                    $doc->exportCaption($this->Gender);
                    $doc->exportCaption($this->MaritalStatus);
                    $doc->exportCaption($this->PhoneNo);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->Dependants);
                    $doc->exportCaption($this->MaleChildren);
                    $doc->exportCaption($this->FemaleChildren);
                    $doc->exportCaption($this->HouseholdHead);
                    $doc->exportCaption($this->FarmerOrg);
                    $doc->exportCaption($this->FarmerOrgPosition);
                    $doc->exportCaption($this->JoiningDate);
                    $doc->exportCaption($this->Comments);
                } else {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                    $doc->exportCaption($this->FarmerNo);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmerName);
                    $doc->exportCaption($this->FarmerType);
                    $doc->exportCaption($this->DOB);
                    $doc->exportCaption($this->Age);
                    $doc->exportCaption($this->Gender);
                    $doc->exportCaption($this->MaritalStatus);
                    $doc->exportCaption($this->PhoneNo);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->Dependants);
                    $doc->exportCaption($this->MaleChildren);
                    $doc->exportCaption($this->FemaleChildren);
                    $doc->exportCaption($this->HouseholdHead);
                    $doc->exportCaption($this->FarmerOrg);
                    $doc->exportCaption($this->FarmerOrgPosition);
                    $doc->exportCaption($this->JoiningDate);
                    $doc->exportCaption($this->Comments);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                        $doc->exportField($this->FarmerNo);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmerName);
                        $doc->exportField($this->FarmerType);
                        $doc->exportField($this->DOB);
                        $doc->exportField($this->Age);
                        $doc->exportField($this->Gender);
                        $doc->exportField($this->MaritalStatus);
                        $doc->exportField($this->PhoneNo);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->Dependants);
                        $doc->exportField($this->MaleChildren);
                        $doc->exportField($this->FemaleChildren);
                        $doc->exportField($this->HouseholdHead);
                        $doc->exportField($this->FarmerOrg);
                        $doc->exportField($this->FarmerOrgPosition);
                        $doc->exportField($this->JoiningDate);
                        $doc->exportField($this->Comments);
                    } else {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                        $doc->exportField($this->FarmerNo);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmerName);
                        $doc->exportField($this->FarmerType);
                        $doc->exportField($this->DOB);
                        $doc->exportField($this->Age);
                        $doc->exportField($this->Gender);
                        $doc->exportField($this->MaritalStatus);
                        $doc->exportField($this->PhoneNo);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->Dependants);
                        $doc->exportField($this->MaleChildren);
                        $doc->exportField($this->FemaleChildren);
                        $doc->exportField($this->HouseholdHead);
                        $doc->exportField($this->FarmerOrg);
                        $doc->exportField($this->FarmerOrgPosition);
                        $doc->exportField($this->JoiningDate);
                        $doc->exportField($this->Comments);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
