<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class FarmerAdd extends Farmer
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FarmerAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "FarmerAdd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->CampCode->setVisibility();
        $this->VillageCode->setVisibility();
        $this->FarmerNo->Visible = false;
        $this->NRC->setVisibility();
        $this->FarmerName->setVisibility();
        $this->FarmerType->setVisibility();
        $this->DOB->setVisibility();
        $this->Age->setVisibility();
        $this->Gender->setVisibility();
        $this->MaritalStatus->setVisibility();
        $this->PhoneNo->setVisibility();
        $this->_Email->setVisibility();
        $this->Dependants->setVisibility();
        $this->MaleChildren->setVisibility();
        $this->FemaleChildren->setVisibility();
        $this->HouseholdHead->setVisibility();
        $this->FarmerOrg->setVisibility();
        $this->FarmerOrgPosition->setVisibility();
        $this->JoiningDate->setVisibility();
        $this->Comments->setVisibility();
        $this->AgeGroup->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'farmer';
        $this->TableName = 'farmer';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (farmer)
        if (!isset($GLOBALS["farmer"]) || $GLOBALS["farmer"]::class == PROJECT_NAMESPACE . "farmer") {
            $GLOBALS["farmer"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'farmer');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "FarmerView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['FarmerNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->FarmerNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->ProvinceCode);
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->CampCode);
        $this->setupLookupOptions($this->VillageCode);
        $this->setupLookupOptions($this->FarmerType);
        $this->setupLookupOptions($this->Gender);
        $this->setupLookupOptions($this->MaritalStatus);
        $this->setupLookupOptions($this->HouseholdHead);
        $this->setupLookupOptions($this->FarmerOrg);
        $this->setupLookupOptions($this->FarmerOrgPosition);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("FarmerNo") ?? Route("FarmerNo")) !== null) {
                $this->FarmerNo->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Set up master/detail parameters
        // NOTE: Must be after loadOldRecord to prevent master key values being overwritten
        $this->setupMasterParms();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Set up detail parameters
        $this->setupDetailParms();

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("FarmerList"); // No matching record, return to list
                    return;
                }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    if ($this->getCurrentDetailTable() != "") { // Master/detail add
                        $returnUrl = $this->getDetailUrl();
                    } else {
                        $returnUrl = $this->getReturnUrl();
                    }
                    if (GetPageName($returnUrl) == "FarmerList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "FarmerView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions && !$this->getCurrentMasterTable()) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "FarmerList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "FarmerList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->ProvinceCode->DefaultValue = $this->ProvinceCode->getDefault(); // PHP
        $this->ProvinceCode->OldValue = $this->ProvinceCode->DefaultValue;
        $this->DistrictCode->DefaultValue = $this->DistrictCode->getDefault(); // PHP
        $this->DistrictCode->OldValue = $this->DistrictCode->DefaultValue;
        $this->FarmerType->DefaultValue = $this->FarmerType->getDefault(); // PHP
        $this->FarmerType->OldValue = $this->FarmerType->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ProvinceCode' first before field var 'x_ProvinceCode'
        $val = $CurrentForm->hasValue("ProvinceCode") ? $CurrentForm->getValue("ProvinceCode") : $CurrentForm->getValue("x_ProvinceCode");
        if (!$this->ProvinceCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProvinceCode->Visible = false; // Disable update for API request
            } else {
                $this->ProvinceCode->setFormValue($val);
            }
        }

        // Check field name 'DistrictCode' first before field var 'x_DistrictCode'
        $val = $CurrentForm->hasValue("DistrictCode") ? $CurrentForm->getValue("DistrictCode") : $CurrentForm->getValue("x_DistrictCode");
        if (!$this->DistrictCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DistrictCode->Visible = false; // Disable update for API request
            } else {
                $this->DistrictCode->setFormValue($val);
            }
        }

        // Check field name 'CampCode' first before field var 'x_CampCode'
        $val = $CurrentForm->hasValue("CampCode") ? $CurrentForm->getValue("CampCode") : $CurrentForm->getValue("x_CampCode");
        if (!$this->CampCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->CampCode->Visible = false; // Disable update for API request
            } else {
                $this->CampCode->setFormValue($val);
            }
        }

        // Check field name 'VillageCode' first before field var 'x_VillageCode'
        $val = $CurrentForm->hasValue("VillageCode") ? $CurrentForm->getValue("VillageCode") : $CurrentForm->getValue("x_VillageCode");
        if (!$this->VillageCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->VillageCode->Visible = false; // Disable update for API request
            } else {
                $this->VillageCode->setFormValue($val);
            }
        }

        // Check field name 'NRC' first before field var 'x_NRC'
        $val = $CurrentForm->hasValue("NRC") ? $CurrentForm->getValue("NRC") : $CurrentForm->getValue("x_NRC");
        if (!$this->NRC->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NRC->Visible = false; // Disable update for API request
            } else {
                $this->NRC->setFormValue($val);
            }
        }

        // Check field name 'FarmerName' first before field var 'x_FarmerName'
        $val = $CurrentForm->hasValue("FarmerName") ? $CurrentForm->getValue("FarmerName") : $CurrentForm->getValue("x_FarmerName");
        if (!$this->FarmerName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmerName->Visible = false; // Disable update for API request
            } else {
                $this->FarmerName->setFormValue($val);
            }
        }

        // Check field name 'FarmerType' first before field var 'x_FarmerType'
        $val = $CurrentForm->hasValue("FarmerType") ? $CurrentForm->getValue("FarmerType") : $CurrentForm->getValue("x_FarmerType");
        if (!$this->FarmerType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmerType->Visible = false; // Disable update for API request
            } else {
                $this->FarmerType->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'DOB' first before field var 'x_DOB'
        $val = $CurrentForm->hasValue("DOB") ? $CurrentForm->getValue("DOB") : $CurrentForm->getValue("x_DOB");
        if (!$this->DOB->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DOB->Visible = false; // Disable update for API request
            } else {
                $this->DOB->setFormValue($val);
            }
            $this->DOB->CurrentValue = UnFormatDateTime($this->DOB->CurrentValue, $this->DOB->formatPattern());
        }

        // Check field name 'Age' first before field var 'x_Age'
        $val = $CurrentForm->hasValue("Age") ? $CurrentForm->getValue("Age") : $CurrentForm->getValue("x_Age");
        if (!$this->Age->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Age->Visible = false; // Disable update for API request
            } else {
                $this->Age->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Gender' first before field var 'x_Gender'
        $val = $CurrentForm->hasValue("Gender") ? $CurrentForm->getValue("Gender") : $CurrentForm->getValue("x_Gender");
        if (!$this->Gender->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Gender->Visible = false; // Disable update for API request
            } else {
                $this->Gender->setFormValue($val);
            }
        }

        // Check field name 'MaritalStatus' first before field var 'x_MaritalStatus'
        $val = $CurrentForm->hasValue("MaritalStatus") ? $CurrentForm->getValue("MaritalStatus") : $CurrentForm->getValue("x_MaritalStatus");
        if (!$this->MaritalStatus->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MaritalStatus->Visible = false; // Disable update for API request
            } else {
                $this->MaritalStatus->setFormValue($val);
            }
        }

        // Check field name 'PhoneNo' first before field var 'x_PhoneNo'
        $val = $CurrentForm->hasValue("PhoneNo") ? $CurrentForm->getValue("PhoneNo") : $CurrentForm->getValue("x_PhoneNo");
        if (!$this->PhoneNo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PhoneNo->Visible = false; // Disable update for API request
            } else {
                $this->PhoneNo->setFormValue($val);
            }
        }

        // Check field name 'Email' first before field var 'x__Email'
        $val = $CurrentForm->hasValue("Email") ? $CurrentForm->getValue("Email") : $CurrentForm->getValue("x__Email");
        if (!$this->_Email->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_Email->Visible = false; // Disable update for API request
            } else {
                $this->_Email->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Dependants' first before field var 'x_Dependants'
        $val = $CurrentForm->hasValue("Dependants") ? $CurrentForm->getValue("Dependants") : $CurrentForm->getValue("x_Dependants");
        if (!$this->Dependants->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Dependants->Visible = false; // Disable update for API request
            } else {
                $this->Dependants->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'MaleChildren' first before field var 'x_MaleChildren'
        $val = $CurrentForm->hasValue("MaleChildren") ? $CurrentForm->getValue("MaleChildren") : $CurrentForm->getValue("x_MaleChildren");
        if (!$this->MaleChildren->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->MaleChildren->Visible = false; // Disable update for API request
            } else {
                $this->MaleChildren->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'FemaleChildren' first before field var 'x_FemaleChildren'
        $val = $CurrentForm->hasValue("FemaleChildren") ? $CurrentForm->getValue("FemaleChildren") : $CurrentForm->getValue("x_FemaleChildren");
        if (!$this->FemaleChildren->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FemaleChildren->Visible = false; // Disable update for API request
            } else {
                $this->FemaleChildren->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'HouseholdHead' first before field var 'x_HouseholdHead'
        $val = $CurrentForm->hasValue("HouseholdHead") ? $CurrentForm->getValue("HouseholdHead") : $CurrentForm->getValue("x_HouseholdHead");
        if (!$this->HouseholdHead->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->HouseholdHead->Visible = false; // Disable update for API request
            } else {
                $this->HouseholdHead->setFormValue($val);
            }
        }

        // Check field name 'FarmerOrg' first before field var 'x_FarmerOrg'
        $val = $CurrentForm->hasValue("FarmerOrg") ? $CurrentForm->getValue("FarmerOrg") : $CurrentForm->getValue("x_FarmerOrg");
        if (!$this->FarmerOrg->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmerOrg->Visible = false; // Disable update for API request
            } else {
                $this->FarmerOrg->setFormValue($val);
            }
        }

        // Check field name 'FarmerOrgPosition' first before field var 'x_FarmerOrgPosition'
        $val = $CurrentForm->hasValue("FarmerOrgPosition") ? $CurrentForm->getValue("FarmerOrgPosition") : $CurrentForm->getValue("x_FarmerOrgPosition");
        if (!$this->FarmerOrgPosition->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmerOrgPosition->Visible = false; // Disable update for API request
            } else {
                $this->FarmerOrgPosition->setFormValue($val);
            }
        }

        // Check field name 'JoiningDate' first before field var 'x_JoiningDate'
        $val = $CurrentForm->hasValue("JoiningDate") ? $CurrentForm->getValue("JoiningDate") : $CurrentForm->getValue("x_JoiningDate");
        if (!$this->JoiningDate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->JoiningDate->Visible = false; // Disable update for API request
            } else {
                $this->JoiningDate->setFormValue($val, true, $validate);
            }
            $this->JoiningDate->CurrentValue = UnFormatDateTime($this->JoiningDate->CurrentValue, $this->JoiningDate->formatPattern());
        }

        // Check field name 'Comments' first before field var 'x_Comments'
        $val = $CurrentForm->hasValue("Comments") ? $CurrentForm->getValue("Comments") : $CurrentForm->getValue("x_Comments");
        if (!$this->Comments->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Comments->Visible = false; // Disable update for API request
            } else {
                $this->Comments->setFormValue($val);
            }
        }

        // Check field name 'AgeGroup' first before field var 'x_AgeGroup'
        $val = $CurrentForm->hasValue("AgeGroup") ? $CurrentForm->getValue("AgeGroup") : $CurrentForm->getValue("x_AgeGroup");
        if (!$this->AgeGroup->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->AgeGroup->Visible = false; // Disable update for API request
            } else {
                $this->AgeGroup->setFormValue($val);
            }
        }

        // Check field name 'FarmerNo' first before field var 'x_FarmerNo'
        $val = $CurrentForm->hasValue("FarmerNo") ? $CurrentForm->getValue("FarmerNo") : $CurrentForm->getValue("x_FarmerNo");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ProvinceCode->CurrentValue = $this->ProvinceCode->FormValue;
        $this->DistrictCode->CurrentValue = $this->DistrictCode->FormValue;
        $this->CampCode->CurrentValue = $this->CampCode->FormValue;
        $this->VillageCode->CurrentValue = $this->VillageCode->FormValue;
        $this->NRC->CurrentValue = $this->NRC->FormValue;
        $this->FarmerName->CurrentValue = $this->FarmerName->FormValue;
        $this->FarmerType->CurrentValue = $this->FarmerType->FormValue;
        $this->DOB->CurrentValue = $this->DOB->FormValue;
        $this->DOB->CurrentValue = UnFormatDateTime($this->DOB->CurrentValue, $this->DOB->formatPattern());
        $this->Age->CurrentValue = $this->Age->FormValue;
        $this->Gender->CurrentValue = $this->Gender->FormValue;
        $this->MaritalStatus->CurrentValue = $this->MaritalStatus->FormValue;
        $this->PhoneNo->CurrentValue = $this->PhoneNo->FormValue;
        $this->_Email->CurrentValue = $this->_Email->FormValue;
        $this->Dependants->CurrentValue = $this->Dependants->FormValue;
        $this->MaleChildren->CurrentValue = $this->MaleChildren->FormValue;
        $this->FemaleChildren->CurrentValue = $this->FemaleChildren->FormValue;
        $this->HouseholdHead->CurrentValue = $this->HouseholdHead->FormValue;
        $this->FarmerOrg->CurrentValue = $this->FarmerOrg->FormValue;
        $this->FarmerOrgPosition->CurrentValue = $this->FarmerOrgPosition->FormValue;
        $this->JoiningDate->CurrentValue = $this->JoiningDate->FormValue;
        $this->JoiningDate->CurrentValue = UnFormatDateTime($this->JoiningDate->CurrentValue, $this->JoiningDate->formatPattern());
        $this->Comments->CurrentValue = $this->Comments->FormValue;
        $this->AgeGroup->CurrentValue = $this->AgeGroup->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerName->setDbValue($row['FarmerName']);
        $this->FarmerType->setDbValue($row['FarmerType']);
        $this->DOB->setDbValue($row['DOB']);
        $this->Age->setDbValue($row['Age']);
        $this->Gender->setDbValue($row['Gender']);
        $this->MaritalStatus->setDbValue($row['MaritalStatus']);
        $this->PhoneNo->setDbValue($row['PhoneNo']);
        $this->_Email->setDbValue($row['Email']);
        $this->Dependants->setDbValue($row['Dependants']);
        $this->MaleChildren->setDbValue($row['MaleChildren']);
        $this->FemaleChildren->setDbValue($row['FemaleChildren']);
        $this->HouseholdHead->setDbValue($row['HouseholdHead']);
        $this->FarmerOrg->setDbValue($row['FarmerOrg']);
        $this->FarmerOrgPosition->setDbValue($row['FarmerOrgPosition']);
        $this->JoiningDate->setDbValue($row['JoiningDate']);
        $this->Comments->setDbValue($row['Comments']);
        $this->AgeGroup->setDbValue($row['AgeGroup']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProvinceCode'] = $this->ProvinceCode->DefaultValue;
        $row['DistrictCode'] = $this->DistrictCode->DefaultValue;
        $row['CampCode'] = $this->CampCode->DefaultValue;
        $row['VillageCode'] = $this->VillageCode->DefaultValue;
        $row['FarmerNo'] = $this->FarmerNo->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['FarmerName'] = $this->FarmerName->DefaultValue;
        $row['FarmerType'] = $this->FarmerType->DefaultValue;
        $row['DOB'] = $this->DOB->DefaultValue;
        $row['Age'] = $this->Age->DefaultValue;
        $row['Gender'] = $this->Gender->DefaultValue;
        $row['MaritalStatus'] = $this->MaritalStatus->DefaultValue;
        $row['PhoneNo'] = $this->PhoneNo->DefaultValue;
        $row['Email'] = $this->_Email->DefaultValue;
        $row['Dependants'] = $this->Dependants->DefaultValue;
        $row['MaleChildren'] = $this->MaleChildren->DefaultValue;
        $row['FemaleChildren'] = $this->FemaleChildren->DefaultValue;
        $row['HouseholdHead'] = $this->HouseholdHead->DefaultValue;
        $row['FarmerOrg'] = $this->FarmerOrg->DefaultValue;
        $row['FarmerOrgPosition'] = $this->FarmerOrgPosition->DefaultValue;
        $row['JoiningDate'] = $this->JoiningDate->DefaultValue;
        $row['Comments'] = $this->Comments->DefaultValue;
        $row['AgeGroup'] = $this->AgeGroup->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProvinceCode
        $this->ProvinceCode->RowCssClass = "row";

        // DistrictCode
        $this->DistrictCode->RowCssClass = "row";

        // CampCode
        $this->CampCode->RowCssClass = "row";

        // VillageCode
        $this->VillageCode->RowCssClass = "row";

        // FarmerNo
        $this->FarmerNo->RowCssClass = "row";

        // NRC
        $this->NRC->RowCssClass = "row";

        // FarmerName
        $this->FarmerName->RowCssClass = "row";

        // FarmerType
        $this->FarmerType->RowCssClass = "row";

        // DOB
        $this->DOB->RowCssClass = "row";

        // Age
        $this->Age->RowCssClass = "row";

        // Gender
        $this->Gender->RowCssClass = "row";

        // MaritalStatus
        $this->MaritalStatus->RowCssClass = "row";

        // PhoneNo
        $this->PhoneNo->RowCssClass = "row";

        // Email
        $this->_Email->RowCssClass = "row";

        // Dependants
        $this->Dependants->RowCssClass = "row";

        // MaleChildren
        $this->MaleChildren->RowCssClass = "row";

        // FemaleChildren
        $this->FemaleChildren->RowCssClass = "row";

        // HouseholdHead
        $this->HouseholdHead->RowCssClass = "row";

        // FarmerOrg
        $this->FarmerOrg->RowCssClass = "row";

        // FarmerOrgPosition
        $this->FarmerOrgPosition->RowCssClass = "row";

        // JoiningDate
        $this->JoiningDate->RowCssClass = "row";

        // Comments
        $this->Comments->RowCssClass = "row";

        // AgeGroup
        $this->AgeGroup->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProvinceCode
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }

            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // CampCode
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }

            // VillageCode
            $curVal = strval($this->VillageCode->CurrentValue);
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                if ($this->VillageCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                    }
                }
            } else {
                $this->VillageCode->ViewValue = null;
            }

            // FarmerNo
            $this->FarmerNo->ViewValue = $this->FarmerNo->CurrentValue;

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;

            // FarmerName
            $this->FarmerName->ViewValue = $this->FarmerName->CurrentValue;

            // FarmerType
            $this->FarmerType->ViewValue = $this->FarmerType->CurrentValue;
            $curVal = strval($this->FarmerType->CurrentValue);
            if ($curVal != "") {
                $this->FarmerType->ViewValue = $this->FarmerType->lookupCacheOption($curVal);
                if ($this->FarmerType->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->FarmerType->Lookup->getTable()->Fields["FarmerType"]->searchExpression(), "=", $curVal, $this->FarmerType->Lookup->getTable()->Fields["FarmerType"]->searchDataType(), "");
                    $sqlWrk = $this->FarmerType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->FarmerType->Lookup->renderViewRow($rswrk[0]);
                        $this->FarmerType->ViewValue = $this->FarmerType->displayValue($arwrk);
                    } else {
                        $this->FarmerType->ViewValue = $this->FarmerType->CurrentValue;
                    }
                }
            } else {
                $this->FarmerType->ViewValue = null;
            }

            // DOB
            $this->DOB->ViewValue = $this->DOB->CurrentValue;

            // Age
            $this->Age->ViewValue = $this->Age->CurrentValue;
            $this->Age->ViewValue = FormatNumber($this->Age->ViewValue, $this->Age->formatPattern());

            // Gender
            $curVal = strval($this->Gender->CurrentValue);
            if ($curVal != "") {
                $this->Gender->ViewValue = $this->Gender->lookupCacheOption($curVal);
                if ($this->Gender->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Gender->Lookup->getTable()->Fields["Gender"]->searchExpression(), "=", $curVal, $this->Gender->Lookup->getTable()->Fields["Gender"]->searchDataType(), "");
                    $sqlWrk = $this->Gender->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Gender->Lookup->renderViewRow($rswrk[0]);
                        $this->Gender->ViewValue = $this->Gender->displayValue($arwrk);
                    } else {
                        $this->Gender->ViewValue = $this->Gender->CurrentValue;
                    }
                }
            } else {
                $this->Gender->ViewValue = null;
            }

            // MaritalStatus
            $curVal = strval($this->MaritalStatus->CurrentValue);
            if ($curVal != "") {
                $this->MaritalStatus->ViewValue = $this->MaritalStatus->lookupCacheOption($curVal);
                if ($this->MaritalStatus->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->MaritalStatus->Lookup->getTable()->Fields["MaritalStatusCode"]->searchExpression(), "=", $curVal, $this->MaritalStatus->Lookup->getTable()->Fields["MaritalStatusCode"]->searchDataType(), "");
                    $sqlWrk = $this->MaritalStatus->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->MaritalStatus->Lookup->renderViewRow($rswrk[0]);
                        $this->MaritalStatus->ViewValue = $this->MaritalStatus->displayValue($arwrk);
                    } else {
                        $this->MaritalStatus->ViewValue = $this->MaritalStatus->CurrentValue;
                    }
                }
            } else {
                $this->MaritalStatus->ViewValue = null;
            }

            // PhoneNo
            $this->PhoneNo->ViewValue = $this->PhoneNo->CurrentValue;

            // Email
            $this->_Email->ViewValue = $this->_Email->CurrentValue;

            // Dependants
            $this->Dependants->ViewValue = $this->Dependants->CurrentValue;

            // MaleChildren
            $this->MaleChildren->ViewValue = $this->MaleChildren->CurrentValue;

            // FemaleChildren
            $this->FemaleChildren->ViewValue = $this->FemaleChildren->CurrentValue;

            // HouseholdHead
            $curVal = strval($this->HouseholdHead->CurrentValue);
            if ($curVal != "") {
                $this->HouseholdHead->ViewValue = $this->HouseholdHead->lookupCacheOption($curVal);
                if ($this->HouseholdHead->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->HouseholdHead->Lookup->getTable()->Fields["ChoiceCode"]->searchExpression(), "=", $curVal, $this->HouseholdHead->Lookup->getTable()->Fields["ChoiceCode"]->searchDataType(), "");
                    $sqlWrk = $this->HouseholdHead->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->HouseholdHead->Lookup->renderViewRow($rswrk[0]);
                        $this->HouseholdHead->ViewValue = $this->HouseholdHead->displayValue($arwrk);
                    } else {
                        $this->HouseholdHead->ViewValue = $this->HouseholdHead->CurrentValue;
                    }
                }
            } else {
                $this->HouseholdHead->ViewValue = null;
            }

            // FarmerOrg
            $curVal = strval($this->FarmerOrg->CurrentValue);
            if ($curVal != "") {
                $this->FarmerOrg->ViewValue = $this->FarmerOrg->lookupCacheOption($curVal);
                if ($this->FarmerOrg->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->FarmerOrg->Lookup->getTable()->Fields["FarmerOrganisation"]->searchExpression(), "=", $curVal, $this->FarmerOrg->Lookup->getTable()->Fields["FarmerOrganisation"]->searchDataType(), "");
                    $sqlWrk = $this->FarmerOrg->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->FarmerOrg->Lookup->renderViewRow($rswrk[0]);
                        $this->FarmerOrg->ViewValue = $this->FarmerOrg->displayValue($arwrk);
                    } else {
                        $this->FarmerOrg->ViewValue = $this->FarmerOrg->CurrentValue;
                    }
                }
            } else {
                $this->FarmerOrg->ViewValue = null;
            }

            // FarmerOrgPosition
            $curVal = strval($this->FarmerOrgPosition->CurrentValue);
            if ($curVal != "") {
                $this->FarmerOrgPosition->ViewValue = $this->FarmerOrgPosition->lookupCacheOption($curVal);
                if ($this->FarmerOrgPosition->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->FarmerOrgPosition->Lookup->getTable()->Fields["FOPosition"]->searchExpression(), "=", $curVal, $this->FarmerOrgPosition->Lookup->getTable()->Fields["FOPosition"]->searchDataType(), "");
                    $sqlWrk = $this->FarmerOrgPosition->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->FarmerOrgPosition->Lookup->renderViewRow($rswrk[0]);
                        $this->FarmerOrgPosition->ViewValue = $this->FarmerOrgPosition->displayValue($arwrk);
                    } else {
                        $this->FarmerOrgPosition->ViewValue = $this->FarmerOrgPosition->CurrentValue;
                    }
                }
            } else {
                $this->FarmerOrgPosition->ViewValue = null;
            }

            // JoiningDate
            $this->JoiningDate->ViewValue = $this->JoiningDate->CurrentValue;
            $this->JoiningDate->ViewValue = FormatDateTime($this->JoiningDate->ViewValue, $this->JoiningDate->formatPattern());

            // Comments
            $this->Comments->ViewValue = $this->Comments->CurrentValue;

            // AgeGroup
            $this->AgeGroup->ViewValue = $this->AgeGroup->CurrentValue;

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmerName
            $this->FarmerName->HrefValue = "";

            // FarmerType
            $this->FarmerType->HrefValue = "";

            // DOB
            $this->DOB->HrefValue = "";

            // Age
            $this->Age->HrefValue = "";

            // Gender
            $this->Gender->HrefValue = "";

            // MaritalStatus
            $this->MaritalStatus->HrefValue = "";

            // PhoneNo
            $this->PhoneNo->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // Dependants
            $this->Dependants->HrefValue = "";

            // MaleChildren
            $this->MaleChildren->HrefValue = "";

            // FemaleChildren
            $this->FemaleChildren->HrefValue = "";

            // HouseholdHead
            $this->HouseholdHead->HrefValue = "";

            // FarmerOrg
            $this->FarmerOrg->HrefValue = "";

            // FarmerOrgPosition
            $this->FarmerOrgPosition->HrefValue = "";

            // JoiningDate
            $this->JoiningDate->HrefValue = "";

            // Comments
            $this->Comments->HrefValue = "";

            // AgeGroup
            $this->AgeGroup->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            if ($this->ProvinceCode->getSessionValue() != "") {
                $this->ProvinceCode->CurrentValue = GetForeignKeyValue($this->ProvinceCode->getSessionValue());
                $curVal = strval($this->ProvinceCode->CurrentValue);
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                    if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                        $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                        $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                        } else {
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                        }
                    }
                } else {
                    $this->ProvinceCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->ProvinceCode->CurrentValue));
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->ProvinceCode->ViewValue !== null) { // Load from cache
                    $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->CurrentValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->ProvinceCode->EditValue = $arwrk;
                }
                $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
            }

            // DistrictCode
            $this->DistrictCode->setupEditAttributes();
            if ($this->DistrictCode->getSessionValue() != "") {
                $this->DistrictCode->CurrentValue = GetForeignKeyValue($this->DistrictCode->getSessionValue());
                $curVal = strval($this->DistrictCode->CurrentValue);
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                    if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                        $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                            $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                        } else {
                            $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                        }
                    }
                } else {
                    $this->DistrictCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->DistrictCode->CurrentValue));
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->DistrictCode->ViewValue !== null) { // Load from cache
                    $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->CurrentValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->DistrictCode->EditValue = $arwrk;
                }
                $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
            }

            // CampCode
            if ($this->CampCode->getSessionValue() != "") {
                $this->CampCode->CurrentValue = GetForeignKeyValue($this->CampCode->getSessionValue());
                $curVal = strval($this->CampCode->CurrentValue);
                if ($curVal != "") {
                    $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                    if ($this->CampCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                        $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                            $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                        } else {
                            $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                        }
                    }
                } else {
                    $this->CampCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->CampCode->CurrentValue));
                if ($curVal != "") {
                    $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                } else {
                    $this->CampCode->ViewValue = $this->CampCode->Lookup !== null && is_array($this->CampCode->lookupOptions()) && count($this->CampCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->CampCode->ViewValue !== null) { // Load from cache
                    $this->CampCode->EditValue = array_values($this->CampCode->lookupOptions());
                    if ($this->CampCode->ViewValue == "") {
                        $this->CampCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $this->CampCode->CurrentValue, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->CampCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->CampCode->EditValue = $arwrk;
                }
                $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());
            }

            // VillageCode
            if ($this->VillageCode->getSessionValue() != "") {
                $this->VillageCode->CurrentValue = GetForeignKeyValue($this->VillageCode->getSessionValue());
                $curVal = strval($this->VillageCode->CurrentValue);
                if ($curVal != "") {
                    $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                    if ($this->VillageCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                        $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                            $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                        } else {
                            $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                        }
                    }
                } else {
                    $this->VillageCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->VillageCode->CurrentValue));
                if ($curVal != "") {
                    $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                } else {
                    $this->VillageCode->ViewValue = $this->VillageCode->Lookup !== null && is_array($this->VillageCode->lookupOptions()) && count($this->VillageCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->VillageCode->ViewValue !== null) { // Load from cache
                    $this->VillageCode->EditValue = array_values($this->VillageCode->lookupOptions());
                    if ($this->VillageCode->ViewValue == "") {
                        $this->VillageCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $this->VillageCode->CurrentValue, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->VillageCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->VillageCode->EditValue = $arwrk;
                }
                $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
            }

            // NRC
            $this->NRC->setupEditAttributes();
            if (!$this->NRC->Raw) {
                $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
            }
            $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

            // FarmerName
            $this->FarmerName->setupEditAttributes();
            if (!$this->FarmerName->Raw) {
                $this->FarmerName->CurrentValue = HtmlDecode($this->FarmerName->CurrentValue);
            }
            $this->FarmerName->EditValue = HtmlEncode($this->FarmerName->CurrentValue);
            $this->FarmerName->PlaceHolder = RemoveHtml($this->FarmerName->caption());

            // FarmerType
            $this->FarmerType->setupEditAttributes();
            $this->FarmerType->EditValue = $this->FarmerType->CurrentValue;
            $curVal = strval($this->FarmerType->CurrentValue);
            if ($curVal != "") {
                $this->FarmerType->EditValue = $this->FarmerType->lookupCacheOption($curVal);
                if ($this->FarmerType->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->FarmerType->Lookup->getTable()->Fields["FarmerType"]->searchExpression(), "=", $curVal, $this->FarmerType->Lookup->getTable()->Fields["FarmerType"]->searchDataType(), "");
                    $sqlWrk = $this->FarmerType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->FarmerType->Lookup->renderViewRow($rswrk[0]);
                        $this->FarmerType->EditValue = $this->FarmerType->displayValue($arwrk);
                    } else {
                        $this->FarmerType->EditValue = HtmlEncode($this->FarmerType->CurrentValue);
                    }
                }
            } else {
                $this->FarmerType->EditValue = null;
            }
            $this->FarmerType->PlaceHolder = RemoveHtml($this->FarmerType->caption());

            // DOB
            $this->DOB->setupEditAttributes();
            $this->DOB->EditValue = HtmlEncode($this->DOB->CurrentValue);
            $this->DOB->PlaceHolder = RemoveHtml($this->DOB->caption());

            // Age
            $this->Age->setupEditAttributes();
            $this->Age->EditValue = $this->Age->CurrentValue;
            $this->Age->PlaceHolder = RemoveHtml($this->Age->caption());
            if (strval($this->Age->EditValue) != "" && is_numeric($this->Age->EditValue)) {
                $this->Age->EditValue = FormatNumber($this->Age->EditValue, null);
            }

            // Gender
            $this->Gender->setupEditAttributes();
            $curVal = trim(strval($this->Gender->CurrentValue));
            if ($curVal != "") {
                $this->Gender->ViewValue = $this->Gender->lookupCacheOption($curVal);
            } else {
                $this->Gender->ViewValue = $this->Gender->Lookup !== null && is_array($this->Gender->lookupOptions()) && count($this->Gender->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Gender->ViewValue !== null) { // Load from cache
                $this->Gender->EditValue = array_values($this->Gender->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Gender->Lookup->getTable()->Fields["Gender"]->searchExpression(), "=", $this->Gender->CurrentValue, $this->Gender->Lookup->getTable()->Fields["Gender"]->searchDataType(), "");
                }
                $sqlWrk = $this->Gender->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Gender->EditValue = $arwrk;
            }
            $this->Gender->PlaceHolder = RemoveHtml($this->Gender->caption());

            // MaritalStatus
            $this->MaritalStatus->setupEditAttributes();
            $curVal = trim(strval($this->MaritalStatus->CurrentValue));
            if ($curVal != "") {
                $this->MaritalStatus->ViewValue = $this->MaritalStatus->lookupCacheOption($curVal);
            } else {
                $this->MaritalStatus->ViewValue = $this->MaritalStatus->Lookup !== null && is_array($this->MaritalStatus->lookupOptions()) && count($this->MaritalStatus->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->MaritalStatus->ViewValue !== null) { // Load from cache
                $this->MaritalStatus->EditValue = array_values($this->MaritalStatus->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->MaritalStatus->Lookup->getTable()->Fields["MaritalStatusCode"]->searchExpression(), "=", $this->MaritalStatus->CurrentValue, $this->MaritalStatus->Lookup->getTable()->Fields["MaritalStatusCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->MaritalStatus->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->MaritalStatus->EditValue = $arwrk;
            }
            $this->MaritalStatus->PlaceHolder = RemoveHtml($this->MaritalStatus->caption());

            // PhoneNo
            $this->PhoneNo->setupEditAttributes();
            if (!$this->PhoneNo->Raw) {
                $this->PhoneNo->CurrentValue = HtmlDecode($this->PhoneNo->CurrentValue);
            }
            $this->PhoneNo->EditValue = HtmlEncode($this->PhoneNo->CurrentValue);
            $this->PhoneNo->PlaceHolder = RemoveHtml($this->PhoneNo->caption());

            // Email
            $this->_Email->setupEditAttributes();
            if (!$this->_Email->Raw) {
                $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
            }
            $this->_Email->EditValue = HtmlEncode($this->_Email->CurrentValue);
            $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

            // Dependants
            $this->Dependants->setupEditAttributes();
            $this->Dependants->EditValue = $this->Dependants->CurrentValue;
            $this->Dependants->PlaceHolder = RemoveHtml($this->Dependants->caption());
            if (strval($this->Dependants->EditValue) != "" && is_numeric($this->Dependants->EditValue)) {
                $this->Dependants->EditValue = $this->Dependants->EditValue;
            }

            // MaleChildren
            $this->MaleChildren->setupEditAttributes();
            $this->MaleChildren->EditValue = $this->MaleChildren->CurrentValue;
            $this->MaleChildren->PlaceHolder = RemoveHtml($this->MaleChildren->caption());
            if (strval($this->MaleChildren->EditValue) != "" && is_numeric($this->MaleChildren->EditValue)) {
                $this->MaleChildren->EditValue = $this->MaleChildren->EditValue;
            }

            // FemaleChildren
            $this->FemaleChildren->setupEditAttributes();
            $this->FemaleChildren->EditValue = $this->FemaleChildren->CurrentValue;
            $this->FemaleChildren->PlaceHolder = RemoveHtml($this->FemaleChildren->caption());
            if (strval($this->FemaleChildren->EditValue) != "" && is_numeric($this->FemaleChildren->EditValue)) {
                $this->FemaleChildren->EditValue = $this->FemaleChildren->EditValue;
            }

            // HouseholdHead
            $this->HouseholdHead->setupEditAttributes();
            $curVal = trim(strval($this->HouseholdHead->CurrentValue));
            if ($curVal != "") {
                $this->HouseholdHead->ViewValue = $this->HouseholdHead->lookupCacheOption($curVal);
            } else {
                $this->HouseholdHead->ViewValue = $this->HouseholdHead->Lookup !== null && is_array($this->HouseholdHead->lookupOptions()) && count($this->HouseholdHead->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->HouseholdHead->ViewValue !== null) { // Load from cache
                $this->HouseholdHead->EditValue = array_values($this->HouseholdHead->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->HouseholdHead->Lookup->getTable()->Fields["ChoiceCode"]->searchExpression(), "=", $this->HouseholdHead->CurrentValue, $this->HouseholdHead->Lookup->getTable()->Fields["ChoiceCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->HouseholdHead->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->HouseholdHead->EditValue = $arwrk;
            }
            $this->HouseholdHead->PlaceHolder = RemoveHtml($this->HouseholdHead->caption());

            // FarmerOrg
            $curVal = trim(strval($this->FarmerOrg->CurrentValue));
            if ($curVal != "") {
                $this->FarmerOrg->ViewValue = $this->FarmerOrg->lookupCacheOption($curVal);
            } else {
                $this->FarmerOrg->ViewValue = $this->FarmerOrg->Lookup !== null && is_array($this->FarmerOrg->lookupOptions()) && count($this->FarmerOrg->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->FarmerOrg->ViewValue !== null) { // Load from cache
                $this->FarmerOrg->EditValue = array_values($this->FarmerOrg->lookupOptions());
                if ($this->FarmerOrg->ViewValue == "") {
                    $this->FarmerOrg->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->FarmerOrg->Lookup->getTable()->Fields["FarmerOrganisation"]->searchExpression(), "=", $this->FarmerOrg->CurrentValue, $this->FarmerOrg->Lookup->getTable()->Fields["FarmerOrganisation"]->searchDataType(), "");
                }
                $sqlWrk = $this->FarmerOrg->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->FarmerOrg->Lookup->renderViewRow($rswrk[0]);
                    $this->FarmerOrg->ViewValue = $this->FarmerOrg->displayValue($arwrk);
                } else {
                    $this->FarmerOrg->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->FarmerOrg->EditValue = $arwrk;
            }
            $this->FarmerOrg->PlaceHolder = RemoveHtml($this->FarmerOrg->caption());

            // FarmerOrgPosition
            $this->FarmerOrgPosition->setupEditAttributes();
            $curVal = trim(strval($this->FarmerOrgPosition->CurrentValue));
            if ($curVal != "") {
                $this->FarmerOrgPosition->ViewValue = $this->FarmerOrgPosition->lookupCacheOption($curVal);
            } else {
                $this->FarmerOrgPosition->ViewValue = $this->FarmerOrgPosition->Lookup !== null && is_array($this->FarmerOrgPosition->lookupOptions()) && count($this->FarmerOrgPosition->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->FarmerOrgPosition->ViewValue !== null) { // Load from cache
                $this->FarmerOrgPosition->EditValue = array_values($this->FarmerOrgPosition->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->FarmerOrgPosition->Lookup->getTable()->Fields["FOPosition"]->searchExpression(), "=", $this->FarmerOrgPosition->CurrentValue, $this->FarmerOrgPosition->Lookup->getTable()->Fields["FOPosition"]->searchDataType(), "");
                }
                $sqlWrk = $this->FarmerOrgPosition->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->FarmerOrgPosition->EditValue = $arwrk;
            }
            $this->FarmerOrgPosition->PlaceHolder = RemoveHtml($this->FarmerOrgPosition->caption());

            // JoiningDate
            $this->JoiningDate->setupEditAttributes();
            $this->JoiningDate->EditValue = HtmlEncode(FormatDateTime($this->JoiningDate->CurrentValue, $this->JoiningDate->formatPattern()));
            $this->JoiningDate->PlaceHolder = RemoveHtml($this->JoiningDate->caption());

            // Comments
            $this->Comments->setupEditAttributes();
            if (!$this->Comments->Raw) {
                $this->Comments->CurrentValue = HtmlDecode($this->Comments->CurrentValue);
            }
            $this->Comments->EditValue = HtmlEncode($this->Comments->CurrentValue);
            $this->Comments->PlaceHolder = RemoveHtml($this->Comments->caption());

            // AgeGroup
            $this->AgeGroup->setupEditAttributes();
            if (!$this->AgeGroup->Raw) {
                $this->AgeGroup->CurrentValue = HtmlDecode($this->AgeGroup->CurrentValue);
            }
            $this->AgeGroup->EditValue = HtmlEncode($this->AgeGroup->CurrentValue);
            $this->AgeGroup->PlaceHolder = RemoveHtml($this->AgeGroup->caption());

            // Add refer script

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmerName
            $this->FarmerName->HrefValue = "";

            // FarmerType
            $this->FarmerType->HrefValue = "";

            // DOB
            $this->DOB->HrefValue = "";

            // Age
            $this->Age->HrefValue = "";

            // Gender
            $this->Gender->HrefValue = "";

            // MaritalStatus
            $this->MaritalStatus->HrefValue = "";

            // PhoneNo
            $this->PhoneNo->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // Dependants
            $this->Dependants->HrefValue = "";

            // MaleChildren
            $this->MaleChildren->HrefValue = "";

            // FemaleChildren
            $this->FemaleChildren->HrefValue = "";

            // HouseholdHead
            $this->HouseholdHead->HrefValue = "";

            // FarmerOrg
            $this->FarmerOrg->HrefValue = "";

            // FarmerOrgPosition
            $this->FarmerOrgPosition->HrefValue = "";

            // JoiningDate
            $this->JoiningDate->HrefValue = "";

            // Comments
            $this->Comments->HrefValue = "";

            // AgeGroup
            $this->AgeGroup->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->ProvinceCode->Visible && $this->ProvinceCode->Required) {
                if (!$this->ProvinceCode->IsDetailKey && EmptyValue($this->ProvinceCode->FormValue)) {
                    $this->ProvinceCode->addErrorMessage(str_replace("%s", $this->ProvinceCode->caption(), $this->ProvinceCode->RequiredErrorMessage));
                }
            }
            if ($this->DistrictCode->Visible && $this->DistrictCode->Required) {
                if (!$this->DistrictCode->IsDetailKey && EmptyValue($this->DistrictCode->FormValue)) {
                    $this->DistrictCode->addErrorMessage(str_replace("%s", $this->DistrictCode->caption(), $this->DistrictCode->RequiredErrorMessage));
                }
            }
            if ($this->CampCode->Visible && $this->CampCode->Required) {
                if (!$this->CampCode->IsDetailKey && EmptyValue($this->CampCode->FormValue)) {
                    $this->CampCode->addErrorMessage(str_replace("%s", $this->CampCode->caption(), $this->CampCode->RequiredErrorMessage));
                }
            }
            if ($this->VillageCode->Visible && $this->VillageCode->Required) {
                if (!$this->VillageCode->IsDetailKey && EmptyValue($this->VillageCode->FormValue)) {
                    $this->VillageCode->addErrorMessage(str_replace("%s", $this->VillageCode->caption(), $this->VillageCode->RequiredErrorMessage));
                }
            }
            if ($this->NRC->Visible && $this->NRC->Required) {
                if (!$this->NRC->IsDetailKey && EmptyValue($this->NRC->FormValue)) {
                    $this->NRC->addErrorMessage(str_replace("%s", $this->NRC->caption(), $this->NRC->RequiredErrorMessage));
                }
            }
            if ($this->FarmerName->Visible && $this->FarmerName->Required) {
                if (!$this->FarmerName->IsDetailKey && EmptyValue($this->FarmerName->FormValue)) {
                    $this->FarmerName->addErrorMessage(str_replace("%s", $this->FarmerName->caption(), $this->FarmerName->RequiredErrorMessage));
                }
            }
            if ($this->FarmerType->Visible && $this->FarmerType->Required) {
                if (!$this->FarmerType->IsDetailKey && EmptyValue($this->FarmerType->FormValue)) {
                    $this->FarmerType->addErrorMessage(str_replace("%s", $this->FarmerType->caption(), $this->FarmerType->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->FarmerType->FormValue)) {
                $this->FarmerType->addErrorMessage($this->FarmerType->getErrorMessage(false));
            }
            if ($this->DOB->Visible && $this->DOB->Required) {
                if (!$this->DOB->IsDetailKey && EmptyValue($this->DOB->FormValue)) {
                    $this->DOB->addErrorMessage(str_replace("%s", $this->DOB->caption(), $this->DOB->RequiredErrorMessage));
                }
            }
            if ($this->Age->Visible && $this->Age->Required) {
                if (!$this->Age->IsDetailKey && EmptyValue($this->Age->FormValue)) {
                    $this->Age->addErrorMessage(str_replace("%s", $this->Age->caption(), $this->Age->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Age->FormValue)) {
                $this->Age->addErrorMessage($this->Age->getErrorMessage(false));
            }
            if ($this->Gender->Visible && $this->Gender->Required) {
                if (!$this->Gender->IsDetailKey && EmptyValue($this->Gender->FormValue)) {
                    $this->Gender->addErrorMessage(str_replace("%s", $this->Gender->caption(), $this->Gender->RequiredErrorMessage));
                }
            }
            if ($this->MaritalStatus->Visible && $this->MaritalStatus->Required) {
                if (!$this->MaritalStatus->IsDetailKey && EmptyValue($this->MaritalStatus->FormValue)) {
                    $this->MaritalStatus->addErrorMessage(str_replace("%s", $this->MaritalStatus->caption(), $this->MaritalStatus->RequiredErrorMessage));
                }
            }
            if ($this->PhoneNo->Visible && $this->PhoneNo->Required) {
                if (!$this->PhoneNo->IsDetailKey && EmptyValue($this->PhoneNo->FormValue)) {
                    $this->PhoneNo->addErrorMessage(str_replace("%s", $this->PhoneNo->caption(), $this->PhoneNo->RequiredErrorMessage));
                }
            }
            if ($this->_Email->Visible && $this->_Email->Required) {
                if (!$this->_Email->IsDetailKey && EmptyValue($this->_Email->FormValue)) {
                    $this->_Email->addErrorMessage(str_replace("%s", $this->_Email->caption(), $this->_Email->RequiredErrorMessage));
                }
            }
            if (!CheckEmail($this->_Email->FormValue)) {
                $this->_Email->addErrorMessage($this->_Email->getErrorMessage(false));
            }
            if ($this->Dependants->Visible && $this->Dependants->Required) {
                if (!$this->Dependants->IsDetailKey && EmptyValue($this->Dependants->FormValue)) {
                    $this->Dependants->addErrorMessage(str_replace("%s", $this->Dependants->caption(), $this->Dependants->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->Dependants->FormValue)) {
                $this->Dependants->addErrorMessage($this->Dependants->getErrorMessage(false));
            }
            if ($this->MaleChildren->Visible && $this->MaleChildren->Required) {
                if (!$this->MaleChildren->IsDetailKey && EmptyValue($this->MaleChildren->FormValue)) {
                    $this->MaleChildren->addErrorMessage(str_replace("%s", $this->MaleChildren->caption(), $this->MaleChildren->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->MaleChildren->FormValue)) {
                $this->MaleChildren->addErrorMessage($this->MaleChildren->getErrorMessage(false));
            }
            if ($this->FemaleChildren->Visible && $this->FemaleChildren->Required) {
                if (!$this->FemaleChildren->IsDetailKey && EmptyValue($this->FemaleChildren->FormValue)) {
                    $this->FemaleChildren->addErrorMessage(str_replace("%s", $this->FemaleChildren->caption(), $this->FemaleChildren->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->FemaleChildren->FormValue)) {
                $this->FemaleChildren->addErrorMessage($this->FemaleChildren->getErrorMessage(false));
            }
            if ($this->HouseholdHead->Visible && $this->HouseholdHead->Required) {
                if (!$this->HouseholdHead->IsDetailKey && EmptyValue($this->HouseholdHead->FormValue)) {
                    $this->HouseholdHead->addErrorMessage(str_replace("%s", $this->HouseholdHead->caption(), $this->HouseholdHead->RequiredErrorMessage));
                }
            }
            if ($this->FarmerOrg->Visible && $this->FarmerOrg->Required) {
                if (!$this->FarmerOrg->IsDetailKey && EmptyValue($this->FarmerOrg->FormValue)) {
                    $this->FarmerOrg->addErrorMessage(str_replace("%s", $this->FarmerOrg->caption(), $this->FarmerOrg->RequiredErrorMessage));
                }
            }
            if ($this->FarmerOrgPosition->Visible && $this->FarmerOrgPosition->Required) {
                if (!$this->FarmerOrgPosition->IsDetailKey && EmptyValue($this->FarmerOrgPosition->FormValue)) {
                    $this->FarmerOrgPosition->addErrorMessage(str_replace("%s", $this->FarmerOrgPosition->caption(), $this->FarmerOrgPosition->RequiredErrorMessage));
                }
            }
            if ($this->JoiningDate->Visible && $this->JoiningDate->Required) {
                if (!$this->JoiningDate->IsDetailKey && EmptyValue($this->JoiningDate->FormValue)) {
                    $this->JoiningDate->addErrorMessage(str_replace("%s", $this->JoiningDate->caption(), $this->JoiningDate->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->JoiningDate->FormValue, $this->JoiningDate->formatPattern())) {
                $this->JoiningDate->addErrorMessage($this->JoiningDate->getErrorMessage(false));
            }
            if ($this->Comments->Visible && $this->Comments->Required) {
                if (!$this->Comments->IsDetailKey && EmptyValue($this->Comments->FormValue)) {
                    $this->Comments->addErrorMessage(str_replace("%s", $this->Comments->caption(), $this->Comments->RequiredErrorMessage));
                }
            }
            if ($this->AgeGroup->Visible && $this->AgeGroup->Required) {
                if (!$this->AgeGroup->IsDetailKey && EmptyValue($this->AgeGroup->FormValue)) {
                    $this->AgeGroup->addErrorMessage(str_replace("%s", $this->AgeGroup->caption(), $this->AgeGroup->RequiredErrorMessage));
                }
            }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("FarmGrid");
        if (in_array("farm", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->NRC->CurrentValue != "") { // Check field with unique index
            $filter = "(`NRC` = '" . AdjustSql($this->NRC->CurrentValue, $this->Dbid) . "')";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->NRC->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->NRC->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }

        // Add detail records
        if ($addRow) {
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("FarmGrid");
            if (in_array("farm", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->NRC->setSessionValue($this->NRC->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "farm"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->NRC->setSessionValue(""); // Clear master key if insert failed
                }
            }
        }

        // Commit/Rollback transaction
        if ($this->getCurrentDetailTable() != "") {
            if ($addRow) {
                if ($this->UseTransaction) { // Commit transaction
                    if ($conn->isTransactionActive()) {
                        $conn->commit();
                    }
                }
            } else {
                if ($this->UseTransaction) { // Rollback transaction
                    if ($conn->isTransactionActive()) {
                        $conn->rollback();
                    }
                }
            }
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // ProvinceCode
        $this->ProvinceCode->setDbValueDef($rsnew, $this->ProvinceCode->CurrentValue, strval($this->ProvinceCode->CurrentValue) == "");

        // DistrictCode
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, strval($this->DistrictCode->CurrentValue) == "");

        // CampCode
        $this->CampCode->setDbValueDef($rsnew, $this->CampCode->CurrentValue, false);

        // VillageCode
        $this->VillageCode->setDbValueDef($rsnew, $this->VillageCode->CurrentValue, false);

        // NRC
        $this->NRC->setDbValueDef($rsnew, $this->NRC->CurrentValue, false);

        // FarmerName
        $this->FarmerName->setDbValueDef($rsnew, $this->FarmerName->CurrentValue, false);

        // FarmerType
        $this->FarmerType->setDbValueDef($rsnew, $this->FarmerType->CurrentValue, strval($this->FarmerType->CurrentValue) == "");

        // DOB
        $this->DOB->setDbValueDef($rsnew, $this->DOB->CurrentValue, false);

        // Age
        $this->Age->setDbValueDef($rsnew, $this->Age->CurrentValue, false);

        // Gender
        $this->Gender->setDbValueDef($rsnew, $this->Gender->CurrentValue, false);

        // MaritalStatus
        $this->MaritalStatus->setDbValueDef($rsnew, $this->MaritalStatus->CurrentValue, false);

        // PhoneNo
        $this->PhoneNo->setDbValueDef($rsnew, $this->PhoneNo->CurrentValue, false);

        // Email
        $this->_Email->setDbValueDef($rsnew, $this->_Email->CurrentValue, false);

        // Dependants
        $this->Dependants->setDbValueDef($rsnew, $this->Dependants->CurrentValue, false);

        // MaleChildren
        $this->MaleChildren->setDbValueDef($rsnew, $this->MaleChildren->CurrentValue, false);

        // FemaleChildren
        $this->FemaleChildren->setDbValueDef($rsnew, $this->FemaleChildren->CurrentValue, false);

        // HouseholdHead
        $this->HouseholdHead->setDbValueDef($rsnew, $this->HouseholdHead->CurrentValue, false);

        // FarmerOrg
        $this->FarmerOrg->setDbValueDef($rsnew, $this->FarmerOrg->CurrentValue, false);

        // FarmerOrgPosition
        $this->FarmerOrgPosition->setDbValueDef($rsnew, $this->FarmerOrgPosition->CurrentValue, false);

        // JoiningDate
        $this->JoiningDate->setDbValueDef($rsnew, UnFormatDateTime($this->JoiningDate->CurrentValue, $this->JoiningDate->formatPattern()), false);

        // Comments
        $this->Comments->setDbValueDef($rsnew, $this->Comments->CurrentValue, false);

        // AgeGroup
        $this->AgeGroup->setDbValueDef($rsnew, $this->AgeGroup->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['ProvinceCode'])) { // ProvinceCode
            $this->ProvinceCode->setFormValue($row['ProvinceCode']);
        }
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->setFormValue($row['DistrictCode']);
        }
        if (isset($row['CampCode'])) { // CampCode
            $this->CampCode->setFormValue($row['CampCode']);
        }
        if (isset($row['VillageCode'])) { // VillageCode
            $this->VillageCode->setFormValue($row['VillageCode']);
        }
        if (isset($row['NRC'])) { // NRC
            $this->NRC->setFormValue($row['NRC']);
        }
        if (isset($row['FarmerName'])) { // FarmerName
            $this->FarmerName->setFormValue($row['FarmerName']);
        }
        if (isset($row['FarmerType'])) { // FarmerType
            $this->FarmerType->setFormValue($row['FarmerType']);
        }
        if (isset($row['DOB'])) { // DOB
            $this->DOB->setFormValue($row['DOB']);
        }
        if (isset($row['Age'])) { // Age
            $this->Age->setFormValue($row['Age']);
        }
        if (isset($row['Gender'])) { // Gender
            $this->Gender->setFormValue($row['Gender']);
        }
        if (isset($row['MaritalStatus'])) { // MaritalStatus
            $this->MaritalStatus->setFormValue($row['MaritalStatus']);
        }
        if (isset($row['PhoneNo'])) { // PhoneNo
            $this->PhoneNo->setFormValue($row['PhoneNo']);
        }
        if (isset($row['Email'])) { // Email
            $this->_Email->setFormValue($row['Email']);
        }
        if (isset($row['Dependants'])) { // Dependants
            $this->Dependants->setFormValue($row['Dependants']);
        }
        if (isset($row['MaleChildren'])) { // MaleChildren
            $this->MaleChildren->setFormValue($row['MaleChildren']);
        }
        if (isset($row['FemaleChildren'])) { // FemaleChildren
            $this->FemaleChildren->setFormValue($row['FemaleChildren']);
        }
        if (isset($row['HouseholdHead'])) { // HouseholdHead
            $this->HouseholdHead->setFormValue($row['HouseholdHead']);
        }
        if (isset($row['FarmerOrg'])) { // FarmerOrg
            $this->FarmerOrg->setFormValue($row['FarmerOrg']);
        }
        if (isset($row['FarmerOrgPosition'])) { // FarmerOrgPosition
            $this->FarmerOrgPosition->setFormValue($row['FarmerOrgPosition']);
        }
        if (isset($row['JoiningDate'])) { // JoiningDate
            $this->JoiningDate->setFormValue($row['JoiningDate']);
        }
        if (isset($row['Comments'])) { // Comments
            $this->Comments->setFormValue($row['Comments']);
        }
        if (isset($row['AgeGroup'])) { // AgeGroup
            $this->AgeGroup->setFormValue($row['AgeGroup']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        $validMaster = false;
        $foreignKeys = [];
        // Get the keys for master table
        if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                $validMaster = true;
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "village") {
                $validMaster = true;
                $masterTbl = Container("village");
                if (($parm = Get("fk_ProvinceCode", Get("ProvinceCode"))) !== null) {
                    $masterTbl->ProvinceCode->setQueryStringValue($parm);
                    $this->ProvinceCode->QueryStringValue = $masterTbl->ProvinceCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->ProvinceCode->setSessionValue($this->ProvinceCode->QueryStringValue);
                    $foreignKeys["ProvinceCode"] = $this->ProvinceCode->QueryStringValue;
                    if (!is_numeric($masterTbl->ProvinceCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_DistrictCode", Get("DistrictCode"))) !== null) {
                    $masterTbl->DistrictCode->setQueryStringValue($parm);
                    $this->DistrictCode->QueryStringValue = $masterTbl->DistrictCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->DistrictCode->setSessionValue($this->DistrictCode->QueryStringValue);
                    $foreignKeys["DistrictCode"] = $this->DistrictCode->QueryStringValue;
                    if (!is_numeric($masterTbl->DistrictCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_CampCode", Get("CampCode"))) !== null) {
                    $masterTbl->CampCode->setQueryStringValue($parm);
                    $this->CampCode->QueryStringValue = $masterTbl->CampCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->CampCode->setSessionValue($this->CampCode->QueryStringValue);
                    $foreignKeys["CampCode"] = $this->CampCode->QueryStringValue;
                    if (!is_numeric($masterTbl->CampCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Get("fk_VillageCode", Get("VillageCode"))) !== null) {
                    $masterTbl->VillageCode->setQueryStringValue($parm);
                    $this->VillageCode->QueryStringValue = $masterTbl->VillageCode->QueryStringValue; // DO NOT change, master/detail key data type can be different
                    $this->VillageCode->setSessionValue($this->VillageCode->QueryStringValue);
                    $foreignKeys["VillageCode"] = $this->VillageCode->QueryStringValue;
                    if (!is_numeric($masterTbl->VillageCode->QueryStringValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        } elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== null) {
            $masterTblVar = $master;
            if ($masterTblVar == "") {
                    $validMaster = true;
                    $this->DbMasterFilter = "";
                    $this->DbDetailFilter = "";
            }
            if ($masterTblVar == "village") {
                $validMaster = true;
                $masterTbl = Container("village");
                if (($parm = Post("fk_ProvinceCode", Post("ProvinceCode"))) !== null) {
                    $masterTbl->ProvinceCode->setFormValue($parm);
                    $this->ProvinceCode->FormValue = $masterTbl->ProvinceCode->FormValue;
                    $this->ProvinceCode->setSessionValue($this->ProvinceCode->FormValue);
                    $foreignKeys["ProvinceCode"] = $this->ProvinceCode->FormValue;
                    if (!is_numeric($masterTbl->ProvinceCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_DistrictCode", Post("DistrictCode"))) !== null) {
                    $masterTbl->DistrictCode->setFormValue($parm);
                    $this->DistrictCode->FormValue = $masterTbl->DistrictCode->FormValue;
                    $this->DistrictCode->setSessionValue($this->DistrictCode->FormValue);
                    $foreignKeys["DistrictCode"] = $this->DistrictCode->FormValue;
                    if (!is_numeric($masterTbl->DistrictCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_CampCode", Post("CampCode"))) !== null) {
                    $masterTbl->CampCode->setFormValue($parm);
                    $this->CampCode->FormValue = $masterTbl->CampCode->FormValue;
                    $this->CampCode->setSessionValue($this->CampCode->FormValue);
                    $foreignKeys["CampCode"] = $this->CampCode->FormValue;
                    if (!is_numeric($masterTbl->CampCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
                if (($parm = Post("fk_VillageCode", Post("VillageCode"))) !== null) {
                    $masterTbl->VillageCode->setFormValue($parm);
                    $this->VillageCode->FormValue = $masterTbl->VillageCode->FormValue;
                    $this->VillageCode->setSessionValue($this->VillageCode->FormValue);
                    $foreignKeys["VillageCode"] = $this->VillageCode->FormValue;
                    if (!is_numeric($masterTbl->VillageCode->FormValue)) {
                        $validMaster = false;
                    }
                } else {
                    $validMaster = false;
                }
            }
        }
        if ($validMaster) {
            // Save current master table
            $this->setCurrentMasterTable($masterTblVar);

            // Reset start record counter (new master key)
            if (!$this->isAddOrEdit() && !$this->isGridUpdate()) {
                $this->StartRecord = 1;
                $this->setStartRecordNumber($this->StartRecord);
            }

            // Clear previous master key from Session
            if ($masterTblVar != "village") {
                if (!array_key_exists("ProvinceCode", $foreignKeys)) { // Not current foreign key
                    $this->ProvinceCode->setSessionValue("");
                }
                if (!array_key_exists("DistrictCode", $foreignKeys)) { // Not current foreign key
                    $this->DistrictCode->setSessionValue("");
                }
                if (!array_key_exists("CampCode", $foreignKeys)) { // Not current foreign key
                    $this->CampCode->setSessionValue("");
                }
                if (!array_key_exists("VillageCode", $foreignKeys)) { // Not current foreign key
                    $this->VillageCode->setSessionValue("");
                }
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("farm", $detailTblVar)) {
                $detailPageObj = Container("FarmGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->NRC->IsDetailKey = true;
                    $detailPageObj->NRC->CurrentValue = $this->NRC->CurrentValue;
                    $detailPageObj->NRC->setSessionValue($detailPageObj->NRC->CurrentValue);
                    $detailPageObj->ProvinceCode->setSessionValue(""); // Clear session key
                    $detailPageObj->DistrictCode->setSessionValue(""); // Clear session key
                    $detailPageObj->CampCode->setSessionValue(""); // Clear session key
                    $detailPageObj->VillageCode->setSessionValue(""); // Clear session key
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("FarmerList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ProvinceCode":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_DistrictCode":
                    break;
                case "x_CampCode":
                    break;
                case "x_VillageCode":
                    break;
                case "x_FarmerType":
                    break;
                case "x_Gender":
                    break;
                case "x_MaritalStatus":
                    break;
                case "x_HouseholdHead":
                    break;
                case "x_FarmerOrg":
                    break;
                case "x_FarmerOrgPosition":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
