<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class FarmOpenBalAdd extends FarmOpenBal
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FarmOpenBalAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "FarmOpenBalAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->CampCode->setVisibility();
        $this->VillageCode->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmerNo->setVisibility();
        $this->FarmNo->setVisibility();
        $this->TransNo->Visible = false;
        $this->TreesPlanted->setVisibility();
        $this->SeedType->setVisibility();
        $this->SourcesOfSeedlings->setVisibility();
        $this->InspectionReport->setVisibility();
        $this->TransDate->setVisibility();
        $this->PreparedBy->setVisibility();
        $this->AuthorisedBy->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'farm_open_bal';
        $this->TableName = 'farm_open_bal';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (farm_open_bal)
        if (!isset($GLOBALS["farm_open_bal"]) || $GLOBALS["farm_open_bal"]::class == PROJECT_NAMESPACE . "farm_open_bal") {
            $GLOBALS["farm_open_bal"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'farm_open_bal');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "FarmOpenBalView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['TransNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->TransNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->ProvinceCode);
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->CampCode);
        $this->setupLookupOptions($this->NRC);
        $this->setupLookupOptions($this->SeedType);
        $this->setupLookupOptions($this->SourcesOfSeedlings);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("TransNo") ?? Route("TransNo")) !== null) {
                $this->TransNo->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("FarmOpenBalList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "FarmOpenBalList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "FarmOpenBalView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "FarmOpenBalList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "FarmOpenBalList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->ProvinceCode->DefaultValue = $this->ProvinceCode->getDefault(); // PHP
        $this->ProvinceCode->OldValue = $this->ProvinceCode->DefaultValue;
        $this->DistrictCode->DefaultValue = $this->DistrictCode->getDefault(); // PHP
        $this->DistrictCode->OldValue = $this->DistrictCode->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ProvinceCode' first before field var 'x_ProvinceCode'
        $val = $CurrentForm->hasValue("ProvinceCode") ? $CurrentForm->getValue("ProvinceCode") : $CurrentForm->getValue("x_ProvinceCode");
        if (!$this->ProvinceCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProvinceCode->Visible = false; // Disable update for API request
            } else {
                $this->ProvinceCode->setFormValue($val);
            }
        }

        // Check field name 'DistrictCode' first before field var 'x_DistrictCode'
        $val = $CurrentForm->hasValue("DistrictCode") ? $CurrentForm->getValue("DistrictCode") : $CurrentForm->getValue("x_DistrictCode");
        if (!$this->DistrictCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DistrictCode->Visible = false; // Disable update for API request
            } else {
                $this->DistrictCode->setFormValue($val);
            }
        }

        // Check field name 'CampCode' first before field var 'x_CampCode'
        $val = $CurrentForm->hasValue("CampCode") ? $CurrentForm->getValue("CampCode") : $CurrentForm->getValue("x_CampCode");
        if (!$this->CampCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->CampCode->Visible = false; // Disable update for API request
            } else {
                $this->CampCode->setFormValue($val);
            }
        }

        // Check field name 'VillageCode' first before field var 'x_VillageCode'
        $val = $CurrentForm->hasValue("VillageCode") ? $CurrentForm->getValue("VillageCode") : $CurrentForm->getValue("x_VillageCode");
        if (!$this->VillageCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->VillageCode->Visible = false; // Disable update for API request
            } else {
                $this->VillageCode->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'NRC' first before field var 'x_NRC'
        $val = $CurrentForm->hasValue("NRC") ? $CurrentForm->getValue("NRC") : $CurrentForm->getValue("x_NRC");
        if (!$this->NRC->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NRC->Visible = false; // Disable update for API request
            } else {
                $this->NRC->setFormValue($val);
            }
        }

        // Check field name 'FarmerNo' first before field var 'x_FarmerNo'
        $val = $CurrentForm->hasValue("FarmerNo") ? $CurrentForm->getValue("FarmerNo") : $CurrentForm->getValue("x_FarmerNo");
        if (!$this->FarmerNo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmerNo->Visible = false; // Disable update for API request
            } else {
                $this->FarmerNo->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'FarmNo' first before field var 'x_FarmNo'
        $val = $CurrentForm->hasValue("FarmNo") ? $CurrentForm->getValue("FarmNo") : $CurrentForm->getValue("x_FarmNo");
        if (!$this->FarmNo->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmNo->Visible = false; // Disable update for API request
            } else {
                $this->FarmNo->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'TreesPlanted' first before field var 'x_TreesPlanted'
        $val = $CurrentForm->hasValue("TreesPlanted") ? $CurrentForm->getValue("TreesPlanted") : $CurrentForm->getValue("x_TreesPlanted");
        if (!$this->TreesPlanted->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->TreesPlanted->Visible = false; // Disable update for API request
            } else {
                $this->TreesPlanted->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'SeedType' first before field var 'x_SeedType'
        $val = $CurrentForm->hasValue("SeedType") ? $CurrentForm->getValue("SeedType") : $CurrentForm->getValue("x_SeedType");
        if (!$this->SeedType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SeedType->Visible = false; // Disable update for API request
            } else {
                $this->SeedType->setFormValue($val);
            }
        }

        // Check field name 'SourcesOfSeedlings' first before field var 'x_SourcesOfSeedlings'
        $val = $CurrentForm->hasValue("SourcesOfSeedlings") ? $CurrentForm->getValue("SourcesOfSeedlings") : $CurrentForm->getValue("x_SourcesOfSeedlings");
        if (!$this->SourcesOfSeedlings->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SourcesOfSeedlings->Visible = false; // Disable update for API request
            } else {
                $this->SourcesOfSeedlings->setFormValue($val);
            }
        }

        // Check field name 'InspectionReport' first before field var 'x_InspectionReport'
        $val = $CurrentForm->hasValue("InspectionReport") ? $CurrentForm->getValue("InspectionReport") : $CurrentForm->getValue("x_InspectionReport");
        if (!$this->InspectionReport->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->InspectionReport->Visible = false; // Disable update for API request
            } else {
                $this->InspectionReport->setFormValue($val);
            }
        }

        // Check field name 'TransDate' first before field var 'x_TransDate'
        $val = $CurrentForm->hasValue("TransDate") ? $CurrentForm->getValue("TransDate") : $CurrentForm->getValue("x_TransDate");
        if (!$this->TransDate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->TransDate->Visible = false; // Disable update for API request
            } else {
                $this->TransDate->setFormValue($val, true, $validate);
            }
            $this->TransDate->CurrentValue = UnFormatDateTime($this->TransDate->CurrentValue, $this->TransDate->formatPattern());
        }

        // Check field name 'PreparedBy' first before field var 'x_PreparedBy'
        $val = $CurrentForm->hasValue("PreparedBy") ? $CurrentForm->getValue("PreparedBy") : $CurrentForm->getValue("x_PreparedBy");
        if (!$this->PreparedBy->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->PreparedBy->Visible = false; // Disable update for API request
            } else {
                $this->PreparedBy->setFormValue($val);
            }
        }

        // Check field name 'AuthorisedBy' first before field var 'x_AuthorisedBy'
        $val = $CurrentForm->hasValue("AuthorisedBy") ? $CurrentForm->getValue("AuthorisedBy") : $CurrentForm->getValue("x_AuthorisedBy");
        if (!$this->AuthorisedBy->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->AuthorisedBy->Visible = false; // Disable update for API request
            } else {
                $this->AuthorisedBy->setFormValue($val);
            }
        }

        // Check field name 'TransNo' first before field var 'x_TransNo'
        $val = $CurrentForm->hasValue("TransNo") ? $CurrentForm->getValue("TransNo") : $CurrentForm->getValue("x_TransNo");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->ProvinceCode->CurrentValue = $this->ProvinceCode->FormValue;
        $this->DistrictCode->CurrentValue = $this->DistrictCode->FormValue;
        $this->CampCode->CurrentValue = $this->CampCode->FormValue;
        $this->VillageCode->CurrentValue = $this->VillageCode->FormValue;
        $this->NRC->CurrentValue = $this->NRC->FormValue;
        $this->FarmerNo->CurrentValue = $this->FarmerNo->FormValue;
        $this->FarmNo->CurrentValue = $this->FarmNo->FormValue;
        $this->TreesPlanted->CurrentValue = $this->TreesPlanted->FormValue;
        $this->SeedType->CurrentValue = $this->SeedType->FormValue;
        $this->SourcesOfSeedlings->CurrentValue = $this->SourcesOfSeedlings->FormValue;
        $this->InspectionReport->CurrentValue = $this->InspectionReport->FormValue;
        $this->TransDate->CurrentValue = $this->TransDate->FormValue;
        $this->TransDate->CurrentValue = UnFormatDateTime($this->TransDate->CurrentValue, $this->TransDate->formatPattern());
        $this->PreparedBy->CurrentValue = $this->PreparedBy->FormValue;
        $this->AuthorisedBy->CurrentValue = $this->AuthorisedBy->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->TransNo->setDbValue($row['TransNo']);
        $this->TreesPlanted->setDbValue($row['TreesPlanted']);
        $this->SeedType->setDbValue($row['SeedType']);
        $this->SourcesOfSeedlings->setDbValue($row['SourcesOfSeedlings']);
        $this->InspectionReport->setDbValue($row['InspectionReport']);
        $this->TransDate->setDbValue($row['TransDate']);
        $this->PreparedBy->setDbValue($row['PreparedBy']);
        $this->AuthorisedBy->setDbValue($row['AuthorisedBy']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProvinceCode'] = $this->ProvinceCode->DefaultValue;
        $row['DistrictCode'] = $this->DistrictCode->DefaultValue;
        $row['CampCode'] = $this->CampCode->DefaultValue;
        $row['VillageCode'] = $this->VillageCode->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['FarmerNo'] = $this->FarmerNo->DefaultValue;
        $row['FarmNo'] = $this->FarmNo->DefaultValue;
        $row['TransNo'] = $this->TransNo->DefaultValue;
        $row['TreesPlanted'] = $this->TreesPlanted->DefaultValue;
        $row['SeedType'] = $this->SeedType->DefaultValue;
        $row['SourcesOfSeedlings'] = $this->SourcesOfSeedlings->DefaultValue;
        $row['InspectionReport'] = $this->InspectionReport->DefaultValue;
        $row['TransDate'] = $this->TransDate->DefaultValue;
        $row['PreparedBy'] = $this->PreparedBy->DefaultValue;
        $row['AuthorisedBy'] = $this->AuthorisedBy->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProvinceCode
        $this->ProvinceCode->RowCssClass = "row";

        // DistrictCode
        $this->DistrictCode->RowCssClass = "row";

        // CampCode
        $this->CampCode->RowCssClass = "row";

        // VillageCode
        $this->VillageCode->RowCssClass = "row";

        // NRC
        $this->NRC->RowCssClass = "row";

        // FarmerNo
        $this->FarmerNo->RowCssClass = "row";

        // FarmNo
        $this->FarmNo->RowCssClass = "row";

        // TransNo
        $this->TransNo->RowCssClass = "row";

        // TreesPlanted
        $this->TreesPlanted->RowCssClass = "row";

        // SeedType
        $this->SeedType->RowCssClass = "row";

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->RowCssClass = "row";

        // InspectionReport
        $this->InspectionReport->RowCssClass = "row";

        // TransDate
        $this->TransDate->RowCssClass = "row";

        // PreparedBy
        $this->PreparedBy->RowCssClass = "row";

        // AuthorisedBy
        $this->AuthorisedBy->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProvinceCode
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }

            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // CampCode
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }

            // VillageCode
            $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->ViewValue = $this->NRC->CurrentValue;
                    }
                }
            } else {
                $this->NRC->ViewValue = null;
            }

            // FarmerNo
            $this->FarmerNo->ViewValue = $this->FarmerNo->CurrentValue;

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

            // TransNo
            $this->TransNo->ViewValue = $this->TransNo->CurrentValue;

            // TreesPlanted
            $this->TreesPlanted->ViewValue = $this->TreesPlanted->CurrentValue;
            $this->TreesPlanted->ViewValue = FormatNumber($this->TreesPlanted->ViewValue, $this->TreesPlanted->formatPattern());

            // SeedType
            $curVal = strval($this->SeedType->CurrentValue);
            if ($curVal != "") {
                $this->SeedType->ViewValue = $this->SeedType->lookupCacheOption($curVal);
                if ($this->SeedType->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $curVal, $this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                    $sqlWrk = $this->SeedType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SeedType->Lookup->renderViewRow($rswrk[0]);
                        $this->SeedType->ViewValue = $this->SeedType->displayValue($arwrk);
                    } else {
                        $this->SeedType->ViewValue = $this->SeedType->CurrentValue;
                    }
                }
            } else {
                $this->SeedType->ViewValue = null;
            }

            // SourcesOfSeedlings
            $curVal = strval($this->SourcesOfSeedlings->CurrentValue);
            if ($curVal != "") {
                $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->lookupCacheOption($curVal);
                if ($this->SourcesOfSeedlings->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SourcesOfSeedlings->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SourcesOfSeedlings->Lookup->renderViewRow($rswrk[0]);
                        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->displayValue($arwrk);
                    } else {
                        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;
                    }
                }
            } else {
                $this->SourcesOfSeedlings->ViewValue = null;
            }

            // InspectionReport
            $this->InspectionReport->ViewValue = $this->InspectionReport->CurrentValue;

            // TransDate
            $this->TransDate->ViewValue = $this->TransDate->CurrentValue;
            $this->TransDate->ViewValue = FormatDateTime($this->TransDate->ViewValue, $this->TransDate->formatPattern());

            // PreparedBy
            $this->PreparedBy->ViewValue = $this->PreparedBy->CurrentValue;

            // AuthorisedBy
            $this->AuthorisedBy->ViewValue = $this->AuthorisedBy->CurrentValue;

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmerNo
            $this->FarmerNo->HrefValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";

            // TreesPlanted
            $this->TreesPlanted->HrefValue = "";

            // SeedType
            $this->SeedType->HrefValue = "";

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->HrefValue = "";

            // InspectionReport
            $this->InspectionReport->HrefValue = "";

            // TransDate
            $this->TransDate->HrefValue = "";

            // PreparedBy
            $this->PreparedBy->HrefValue = "";

            // AuthorisedBy
            $this->AuthorisedBy->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            $curVal = trim(strval($this->ProvinceCode->CurrentValue));
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
            } else {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ProvinceCode->ViewValue !== null) { // Load from cache
                $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->CurrentValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ProvinceCode->EditValue = $arwrk;
            }
            $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());

            // DistrictCode
            $this->DistrictCode->setupEditAttributes();
            $curVal = trim(strval($this->DistrictCode->CurrentValue));
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
            } else {
                $this->DistrictCode->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->DistrictCode->ViewValue !== null) { // Load from cache
                $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->CurrentValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->DistrictCode->EditValue = $arwrk;
            }
            $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());

            // CampCode
            $this->CampCode->setupEditAttributes();
            $curVal = trim(strval($this->CampCode->CurrentValue));
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
            } else {
                $this->CampCode->ViewValue = $this->CampCode->Lookup !== null && is_array($this->CampCode->lookupOptions()) && count($this->CampCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->CampCode->ViewValue !== null) { // Load from cache
                $this->CampCode->EditValue = array_values($this->CampCode->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $this->CampCode->CurrentValue, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->CampCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->CampCode->EditValue = $arwrk;
            }
            $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());

            // VillageCode
            $this->VillageCode->setupEditAttributes();
            $this->VillageCode->EditValue = $this->VillageCode->CurrentValue;
            $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
            if (strval($this->VillageCode->EditValue) != "" && is_numeric($this->VillageCode->EditValue)) {
                $this->VillageCode->EditValue = $this->VillageCode->EditValue;
            }

            // NRC
            $this->NRC->setupEditAttributes();
            if (!$this->NRC->Raw) {
                $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
            }
            $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->EditValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->EditValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
                    }
                }
            } else {
                $this->NRC->EditValue = null;
            }
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

            // FarmerNo
            $this->FarmerNo->setupEditAttributes();
            $this->FarmerNo->EditValue = $this->FarmerNo->CurrentValue;
            $this->FarmerNo->PlaceHolder = RemoveHtml($this->FarmerNo->caption());
            if (strval($this->FarmerNo->EditValue) != "" && is_numeric($this->FarmerNo->EditValue)) {
                $this->FarmerNo->EditValue = $this->FarmerNo->EditValue;
            }

            // FarmNo
            $this->FarmNo->setupEditAttributes();
            $this->FarmNo->EditValue = $this->FarmNo->CurrentValue;
            $this->FarmNo->PlaceHolder = RemoveHtml($this->FarmNo->caption());
            if (strval($this->FarmNo->EditValue) != "" && is_numeric($this->FarmNo->EditValue)) {
                $this->FarmNo->EditValue = $this->FarmNo->EditValue;
            }

            // TreesPlanted
            $this->TreesPlanted->setupEditAttributes();
            $this->TreesPlanted->EditValue = $this->TreesPlanted->CurrentValue;
            $this->TreesPlanted->PlaceHolder = RemoveHtml($this->TreesPlanted->caption());
            if (strval($this->TreesPlanted->EditValue) != "" && is_numeric($this->TreesPlanted->EditValue)) {
                $this->TreesPlanted->EditValue = FormatNumber($this->TreesPlanted->EditValue, null);
            }

            // SeedType
            $this->SeedType->setupEditAttributes();
            $curVal = trim(strval($this->SeedType->CurrentValue));
            if ($curVal != "") {
                $this->SeedType->ViewValue = $this->SeedType->lookupCacheOption($curVal);
            } else {
                $this->SeedType->ViewValue = $this->SeedType->Lookup !== null && is_array($this->SeedType->lookupOptions()) && count($this->SeedType->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->SeedType->ViewValue !== null) { // Load from cache
                $this->SeedType->EditValue = array_values($this->SeedType->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $this->SeedType->CurrentValue, $this->SeedType->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                }
                $sqlWrk = $this->SeedType->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->SeedType->EditValue = $arwrk;
            }
            $this->SeedType->PlaceHolder = RemoveHtml($this->SeedType->caption());

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->setupEditAttributes();
            $curVal = trim(strval($this->SourcesOfSeedlings->CurrentValue));
            if ($curVal != "") {
                $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->lookupCacheOption($curVal);
            } else {
                $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->Lookup !== null && is_array($this->SourcesOfSeedlings->lookupOptions()) && count($this->SourcesOfSeedlings->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->SourcesOfSeedlings->ViewValue !== null) { // Load from cache
                $this->SourcesOfSeedlings->EditValue = array_values($this->SourcesOfSeedlings->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $this->SourcesOfSeedlings->CurrentValue, $this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->SourcesOfSeedlings->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->SourcesOfSeedlings->EditValue = $arwrk;
            }
            $this->SourcesOfSeedlings->PlaceHolder = RemoveHtml($this->SourcesOfSeedlings->caption());

            // InspectionReport
            $this->InspectionReport->setupEditAttributes();
            $this->InspectionReport->EditValue = HtmlEncode($this->InspectionReport->CurrentValue);
            $this->InspectionReport->PlaceHolder = RemoveHtml($this->InspectionReport->caption());

            // TransDate
            $this->TransDate->setupEditAttributes();
            $this->TransDate->EditValue = HtmlEncode(FormatDateTime($this->TransDate->CurrentValue, $this->TransDate->formatPattern()));
            $this->TransDate->PlaceHolder = RemoveHtml($this->TransDate->caption());

            // PreparedBy
            $this->PreparedBy->setupEditAttributes();
            if (!$this->PreparedBy->Raw) {
                $this->PreparedBy->CurrentValue = HtmlDecode($this->PreparedBy->CurrentValue);
            }
            $this->PreparedBy->EditValue = HtmlEncode($this->PreparedBy->CurrentValue);
            $this->PreparedBy->PlaceHolder = RemoveHtml($this->PreparedBy->caption());

            // AuthorisedBy
            $this->AuthorisedBy->setupEditAttributes();
            if (!$this->AuthorisedBy->Raw) {
                $this->AuthorisedBy->CurrentValue = HtmlDecode($this->AuthorisedBy->CurrentValue);
            }
            $this->AuthorisedBy->EditValue = HtmlEncode($this->AuthorisedBy->CurrentValue);
            $this->AuthorisedBy->PlaceHolder = RemoveHtml($this->AuthorisedBy->caption());

            // Add refer script

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmerNo
            $this->FarmerNo->HrefValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";

            // TreesPlanted
            $this->TreesPlanted->HrefValue = "";

            // SeedType
            $this->SeedType->HrefValue = "";

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->HrefValue = "";

            // InspectionReport
            $this->InspectionReport->HrefValue = "";

            // TransDate
            $this->TransDate->HrefValue = "";

            // PreparedBy
            $this->PreparedBy->HrefValue = "";

            // AuthorisedBy
            $this->AuthorisedBy->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->ProvinceCode->Visible && $this->ProvinceCode->Required) {
                if (!$this->ProvinceCode->IsDetailKey && EmptyValue($this->ProvinceCode->FormValue)) {
                    $this->ProvinceCode->addErrorMessage(str_replace("%s", $this->ProvinceCode->caption(), $this->ProvinceCode->RequiredErrorMessage));
                }
            }
            if ($this->DistrictCode->Visible && $this->DistrictCode->Required) {
                if (!$this->DistrictCode->IsDetailKey && EmptyValue($this->DistrictCode->FormValue)) {
                    $this->DistrictCode->addErrorMessage(str_replace("%s", $this->DistrictCode->caption(), $this->DistrictCode->RequiredErrorMessage));
                }
            }
            if ($this->CampCode->Visible && $this->CampCode->Required) {
                if (!$this->CampCode->IsDetailKey && EmptyValue($this->CampCode->FormValue)) {
                    $this->CampCode->addErrorMessage(str_replace("%s", $this->CampCode->caption(), $this->CampCode->RequiredErrorMessage));
                }
            }
            if ($this->VillageCode->Visible && $this->VillageCode->Required) {
                if (!$this->VillageCode->IsDetailKey && EmptyValue($this->VillageCode->FormValue)) {
                    $this->VillageCode->addErrorMessage(str_replace("%s", $this->VillageCode->caption(), $this->VillageCode->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->VillageCode->FormValue)) {
                $this->VillageCode->addErrorMessage($this->VillageCode->getErrorMessage(false));
            }
            if ($this->NRC->Visible && $this->NRC->Required) {
                if (!$this->NRC->IsDetailKey && EmptyValue($this->NRC->FormValue)) {
                    $this->NRC->addErrorMessage(str_replace("%s", $this->NRC->caption(), $this->NRC->RequiredErrorMessage));
                }
            }
            if ($this->FarmerNo->Visible && $this->FarmerNo->Required) {
                if (!$this->FarmerNo->IsDetailKey && EmptyValue($this->FarmerNo->FormValue)) {
                    $this->FarmerNo->addErrorMessage(str_replace("%s", $this->FarmerNo->caption(), $this->FarmerNo->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->FarmerNo->FormValue)) {
                $this->FarmerNo->addErrorMessage($this->FarmerNo->getErrorMessage(false));
            }
            if ($this->FarmNo->Visible && $this->FarmNo->Required) {
                if (!$this->FarmNo->IsDetailKey && EmptyValue($this->FarmNo->FormValue)) {
                    $this->FarmNo->addErrorMessage(str_replace("%s", $this->FarmNo->caption(), $this->FarmNo->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->FarmNo->FormValue)) {
                $this->FarmNo->addErrorMessage($this->FarmNo->getErrorMessage(false));
            }
            if ($this->TreesPlanted->Visible && $this->TreesPlanted->Required) {
                if (!$this->TreesPlanted->IsDetailKey && EmptyValue($this->TreesPlanted->FormValue)) {
                    $this->TreesPlanted->addErrorMessage(str_replace("%s", $this->TreesPlanted->caption(), $this->TreesPlanted->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->TreesPlanted->FormValue)) {
                $this->TreesPlanted->addErrorMessage($this->TreesPlanted->getErrorMessage(false));
            }
            if ($this->SeedType->Visible && $this->SeedType->Required) {
                if (!$this->SeedType->IsDetailKey && EmptyValue($this->SeedType->FormValue)) {
                    $this->SeedType->addErrorMessage(str_replace("%s", $this->SeedType->caption(), $this->SeedType->RequiredErrorMessage));
                }
            }
            if ($this->SourcesOfSeedlings->Visible && $this->SourcesOfSeedlings->Required) {
                if (!$this->SourcesOfSeedlings->IsDetailKey && EmptyValue($this->SourcesOfSeedlings->FormValue)) {
                    $this->SourcesOfSeedlings->addErrorMessage(str_replace("%s", $this->SourcesOfSeedlings->caption(), $this->SourcesOfSeedlings->RequiredErrorMessage));
                }
            }
            if ($this->InspectionReport->Visible && $this->InspectionReport->Required) {
                if (!$this->InspectionReport->IsDetailKey && EmptyValue($this->InspectionReport->FormValue)) {
                    $this->InspectionReport->addErrorMessage(str_replace("%s", $this->InspectionReport->caption(), $this->InspectionReport->RequiredErrorMessage));
                }
            }
            if ($this->TransDate->Visible && $this->TransDate->Required) {
                if (!$this->TransDate->IsDetailKey && EmptyValue($this->TransDate->FormValue)) {
                    $this->TransDate->addErrorMessage(str_replace("%s", $this->TransDate->caption(), $this->TransDate->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->TransDate->FormValue, $this->TransDate->formatPattern())) {
                $this->TransDate->addErrorMessage($this->TransDate->getErrorMessage(false));
            }
            if ($this->PreparedBy->Visible && $this->PreparedBy->Required) {
                if (!$this->PreparedBy->IsDetailKey && EmptyValue($this->PreparedBy->FormValue)) {
                    $this->PreparedBy->addErrorMessage(str_replace("%s", $this->PreparedBy->caption(), $this->PreparedBy->RequiredErrorMessage));
                }
            }
            if ($this->AuthorisedBy->Visible && $this->AuthorisedBy->Required) {
                if (!$this->AuthorisedBy->IsDetailKey && EmptyValue($this->AuthorisedBy->FormValue)) {
                    $this->AuthorisedBy->addErrorMessage(str_replace("%s", $this->AuthorisedBy->caption(), $this->AuthorisedBy->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // ProvinceCode
        $this->ProvinceCode->setDbValueDef($rsnew, $this->ProvinceCode->CurrentValue, strval($this->ProvinceCode->CurrentValue) == "");

        // DistrictCode
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, strval($this->DistrictCode->CurrentValue) == "");

        // CampCode
        $this->CampCode->setDbValueDef($rsnew, $this->CampCode->CurrentValue, false);

        // VillageCode
        $this->VillageCode->setDbValueDef($rsnew, $this->VillageCode->CurrentValue, false);

        // NRC
        $this->NRC->setDbValueDef($rsnew, $this->NRC->CurrentValue, false);

        // FarmerNo
        $this->FarmerNo->setDbValueDef($rsnew, $this->FarmerNo->CurrentValue, false);

        // FarmNo
        $this->FarmNo->setDbValueDef($rsnew, $this->FarmNo->CurrentValue, false);

        // TreesPlanted
        $this->TreesPlanted->setDbValueDef($rsnew, $this->TreesPlanted->CurrentValue, false);

        // SeedType
        $this->SeedType->setDbValueDef($rsnew, $this->SeedType->CurrentValue, false);

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->setDbValueDef($rsnew, $this->SourcesOfSeedlings->CurrentValue, false);

        // InspectionReport
        $this->InspectionReport->setDbValueDef($rsnew, $this->InspectionReport->CurrentValue, false);

        // TransDate
        $this->TransDate->setDbValueDef($rsnew, UnFormatDateTime($this->TransDate->CurrentValue, $this->TransDate->formatPattern()), false);

        // PreparedBy
        $this->PreparedBy->setDbValueDef($rsnew, $this->PreparedBy->CurrentValue, false);

        // AuthorisedBy
        $this->AuthorisedBy->setDbValueDef($rsnew, $this->AuthorisedBy->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['ProvinceCode'])) { // ProvinceCode
            $this->ProvinceCode->setFormValue($row['ProvinceCode']);
        }
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->setFormValue($row['DistrictCode']);
        }
        if (isset($row['CampCode'])) { // CampCode
            $this->CampCode->setFormValue($row['CampCode']);
        }
        if (isset($row['VillageCode'])) { // VillageCode
            $this->VillageCode->setFormValue($row['VillageCode']);
        }
        if (isset($row['NRC'])) { // NRC
            $this->NRC->setFormValue($row['NRC']);
        }
        if (isset($row['FarmerNo'])) { // FarmerNo
            $this->FarmerNo->setFormValue($row['FarmerNo']);
        }
        if (isset($row['FarmNo'])) { // FarmNo
            $this->FarmNo->setFormValue($row['FarmNo']);
        }
        if (isset($row['TreesPlanted'])) { // TreesPlanted
            $this->TreesPlanted->setFormValue($row['TreesPlanted']);
        }
        if (isset($row['SeedType'])) { // SeedType
            $this->SeedType->setFormValue($row['SeedType']);
        }
        if (isset($row['SourcesOfSeedlings'])) { // SourcesOfSeedlings
            $this->SourcesOfSeedlings->setFormValue($row['SourcesOfSeedlings']);
        }
        if (isset($row['InspectionReport'])) { // InspectionReport
            $this->InspectionReport->setFormValue($row['InspectionReport']);
        }
        if (isset($row['TransDate'])) { // TransDate
            $this->TransDate->setFormValue($row['TransDate']);
        }
        if (isset($row['PreparedBy'])) { // PreparedBy
            $this->PreparedBy->setFormValue($row['PreparedBy']);
        }
        if (isset($row['AuthorisedBy'])) { // AuthorisedBy
            $this->AuthorisedBy->setFormValue($row['AuthorisedBy']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("FarmOpenBalList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ProvinceCode":
                    break;
                case "x_DistrictCode":
                    break;
                case "x_CampCode":
                    break;
                case "x_NRC":
                    break;
                case "x_SeedType":
                    break;
                case "x_SourcesOfSeedlings":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
