<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class FarmGrid extends Farm
{
    use MessagesTrait;

    // Page ID
    public $PageID = "grid";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "FarmGrid";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "ffarmgrid";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "FarmGrid";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->CampCode->setVisibility();
        $this->VillageCode->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmNo->Visible = false;
        $this->FarmerNo->Visible = false;
        $this->FieldType->setVisibility();
        $this->Ownership->setVisibility();
        $this->SeedlingsAllocated->setVisibility();
        $this->TreesPlantedEstimated->setVisibility();
        $this->FarmSizeEstimated->Visible = false;
        $this->FarmSizeVerified->Visible = false;
        $this->TreesPlantedVerified->setVisibility();
        $this->SourcesOfSeedlings->Visible = false;
        $this->InspecationReport->Visible = false;
        $this->ClearedLand->Visible = false;
        $this->OldTrees->Visible = false;
        $this->FarmSize->Visible = false;
        $this->Latitude->Visible = false;
        $this->Longitude->Visible = false;
        $this->Coordinates->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'farm';
        $this->TableName = 'farm';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $this->FormActionName .= "_" . $this->FormName;
        $this->OldKeyName .= "_" . $this->FormName;
        $this->FormBlankRowName .= "_" . $this->FormName;
        $this->FormKeyCountName .= "_" . $this->FormName;
        $GLOBALS["Grid"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (farm)
        if (!isset($GLOBALS["farm"]) || $GLOBALS["farm"]::class == PROJECT_NAMESPACE . "farm") {
            $GLOBALS["farm"] = &$this;
        }
        $this->AddUrl = "FarmAdd";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'farm');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;
        unset($GLOBALS["Grid"]);
        if ($url === "") {
            return;
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['FarmNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->FarmNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $ShowOtherOptions = false;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        if (Param("export") !== null) {
            $this->Export = Param("export");
        }

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up master detail parameters
        $this->setupMasterParms();

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->ProvinceCode);
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->CampCode);
        $this->setupLookupOptions($this->VillageCode);
        $this->setupLookupOptions($this->NRC);
        $this->setupLookupOptions($this->FieldType);
        $this->setupLookupOptions($this->Ownership);
        $this->setupLookupOptions($this->SourcesOfSeedlings);

        // Load default values for add
        $this->loadDefaultValues();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "ffarmgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Show grid delete link for grid add / grid edit
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $item = $this->ListOptions["griddelete"];
                if ($item) {
                    $item->Visible = $Security->allowDelete(CurrentProjectID() . $this->TableName);
                }
            }
        }

        // Set up sorting order
        $this->setupSortOrder();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }

        // Restore master/detail filter from session
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Restore master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Restore detail filter from session
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);
        if ($this->Filter == "") {
            $this->Filter = "0=101";
            $this->SearchWhere = $this->Filter;
        }

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "farmer") {
            $masterTbl = Container("farmer");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("FarmerList"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "village") {
            $masterTbl = Container("village");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("VillageList"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->TotalRecords = $this->listRecordCount();
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->TotalRecords;
                $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
            } else {
                $this->CurrentFilter = "0=1";
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->GridAddRowCount;
            }
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->TotalRecords; // Display all records
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->SeedlingsAllocated->FormValue = ""; // Clear form value
        $this->TreesPlantedEstimated->FormValue = ""; // Clear form value
        $this->TreesPlantedVerified->FormValue = ""; // Clear form value
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to grid add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Switch to grid edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old result set
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAllAssociative();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();
        if ($this->AuditTrailOnEdit) {
            $this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
        }
        $wrkfilter = "";
        $key = "";

        // Update row index and get row key
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $this->setKey($CurrentForm->getValue($this->OldKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete" && $rowaction != "hide") { // Skip insert then deleted rows / hidden rows for grid edit
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->OldKey != ""; // Key must not be empty
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($this->OldKey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                        if ($gridUpdate) { // Get inserted or updated filter
                            AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                        }
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $this->OldKey;
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($gridUpdate) {
            $this->FilterForModalActions = $wrkfilter;

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
            }
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
            }
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Perform grid add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        if ($this->AuditTrailOnAdd) {
            $this->writeAuditTrailDummy($Language->phrase("BatchInsertBegin")); // Batch insert begin
        }
        $key = "";

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $rsold = null;
            if ($rowaction == "insert") {
                $this->OldKey = strval($CurrentForm->getValue($this->OldKeyName));
                $rsold = $this->loadOldRecord(); // Load old record
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success
                $gridInsert = $this->addRow($rsold); // Insert row (already validated by validateGridForm())
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->FarmNo->CurrentValue;

                    // Add filter for this record
                    AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->clearInlineMode(); // Clear grid add mode and return
            return true;
        }
        if ($gridInsert) {
            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $this->FilterForModalActions = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailDummy($Language->phrase("BatchInsertSuccess")); // Batch insert success
            }
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailDummy($Language->phrase("BatchInsertRollback")); // Batch insert rollback
            }
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if (
            $CurrentForm->hasValue("x_ProvinceCode") &&
            $CurrentForm->hasValue("o_ProvinceCode") &&
            $this->ProvinceCode->CurrentValue != $this->ProvinceCode->DefaultValue &&
            !($this->ProvinceCode->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->ProvinceCode->CurrentValue == $this->ProvinceCode->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_DistrictCode") &&
            $CurrentForm->hasValue("o_DistrictCode") &&
            $this->DistrictCode->CurrentValue != $this->DistrictCode->DefaultValue &&
            !($this->DistrictCode->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->DistrictCode->CurrentValue == $this->DistrictCode->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_CampCode") &&
            $CurrentForm->hasValue("o_CampCode") &&
            $this->CampCode->CurrentValue != $this->CampCode->DefaultValue &&
            !($this->CampCode->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->CampCode->CurrentValue == $this->CampCode->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_VillageCode") &&
            $CurrentForm->hasValue("o_VillageCode") &&
            $this->VillageCode->CurrentValue != $this->VillageCode->DefaultValue &&
            !($this->VillageCode->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->VillageCode->CurrentValue == $this->VillageCode->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_NRC") &&
            $CurrentForm->hasValue("o_NRC") &&
            $this->NRC->CurrentValue != $this->NRC->DefaultValue &&
            !($this->NRC->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->NRC->CurrentValue == $this->NRC->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_FieldType") &&
            $CurrentForm->hasValue("o_FieldType") &&
            $this->FieldType->CurrentValue != $this->FieldType->DefaultValue &&
            !($this->FieldType->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->FieldType->CurrentValue == $this->FieldType->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_Ownership") &&
            $CurrentForm->hasValue("o_Ownership") &&
            $this->Ownership->CurrentValue != $this->Ownership->DefaultValue &&
            !($this->Ownership->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->Ownership->CurrentValue == $this->Ownership->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_SeedlingsAllocated") &&
            $CurrentForm->hasValue("o_SeedlingsAllocated") &&
            $this->SeedlingsAllocated->CurrentValue != $this->SeedlingsAllocated->DefaultValue &&
            !($this->SeedlingsAllocated->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->SeedlingsAllocated->CurrentValue == $this->SeedlingsAllocated->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_TreesPlantedEstimated") &&
            $CurrentForm->hasValue("o_TreesPlantedEstimated") &&
            $this->TreesPlantedEstimated->CurrentValue != $this->TreesPlantedEstimated->DefaultValue &&
            !($this->TreesPlantedEstimated->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->TreesPlantedEstimated->CurrentValue == $this->TreesPlantedEstimated->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_TreesPlantedVerified") &&
            $CurrentForm->hasValue("o_TreesPlantedVerified") &&
            $this->TreesPlantedVerified->CurrentValue != $this->TreesPlantedVerified->DefaultValue &&
            !($this->TreesPlantedVerified->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->TreesPlantedVerified->CurrentValue == $this->TreesPlantedVerified->getSessionValue())
        ) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Load default values for emptyRow checking
        $this->loadDefaultValues();

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete" && $rowaction != "hide") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    $this->ValidationErrors[$rowindex] = $this->getValidationErrors();
                    $this->EventCancelled = true;
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        foreach ($this->Fields as $field) {
            $field->clearErrorMessage();
        }
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset master/detail keys
            if ($this->Command == "resetall") {
                $this->setCurrentMasterTable(""); // Clear master table
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
                        $this->NRC->setSessionValue("");
                        $this->ProvinceCode->setSessionValue("");
                        $this->DistrictCode->setSessionValue("");
                        $this->CampCode->setSessionValue("");
                        $this->VillageCode->setSessionValue("");
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = true;
            $item->Visible = false; // Default hidden
        }

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = true;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->OldKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            $oldKey = $this->getKey(false); // Get from OldValue
            if ($oldKeyName != "" && $oldKey != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($oldKey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (!$Security->allowDelete(CurrentProjectID() . $this->TableName) && is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-ew-action=\"delete-grid-row\" data-rowindex=\"" . $this->RowIndex . "\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"farm\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"farm\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"farm\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;

        // Preview extension
        $links = "";
        $detailFilters = [];
        $masterKeys = []; // Reset
        $masterKeys["ProvinceCode"] = strval($this->ProvinceCode->DbValue);
        $masterKeys["DistrictCode"] = strval($this->DistrictCode->DbValue);
        $masterKeys["CampCode"] = strval($this->CampCode->DbValue);
        $masterKeys["VillageCode"] = strval($this->VillageCode->DbValue);
        $masterKeys["FarmNo"] = strval($this->FarmNo->DbValue);

        // Column "detail_farm_seed_allocate"
        if ($this->DetailPages?->getItem("farm_seed_allocate")?->Visible && $Security->allowList(CurrentProjectID() . 'farm_seed_allocate')) {
            $link = "";
            $option = $this->ListOptions["detail_farm_seed_allocate"];
            $detailTbl = Container("farm_seed_allocate");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "FarmSeedAllocatePreview?t=farm&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"farm_seed_allocate\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'farm')) {
                $label = $Language->tablePhrase("farm_seed_allocate", "TblCaption");
                $detailTbl->Count = $detailTbl->loadRecordCount($detailFilter);
                $detailFilters[$detailTbl->TableVar] = $detailFilter;
                $label .= "&nbsp;" . JsEncode(str_replace(["%c", "%s"], [$detailTbl->Count, "blue"], $Language->phrase("DetailCount")));
                $url .= "&detailfilters=%f";
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"farm_seed_allocate\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("FarmSeedAllocateList?" . Config("TABLE_SHOW_MASTER") . "=farm");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("farm_seed_allocate", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("FarmSeedAllocateGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=farm_seed_allocate"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=farm_seed_allocate"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=farm_seed_allocate"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["ProvinceCode"] = strval($this->ProvinceCode->DbValue);
        $masterKeys["DistrictCode"] = strval($this->DistrictCode->DbValue);
        $masterKeys["CampCode"] = strval($this->CampCode->DbValue);
        $masterKeys["VillageCode"] = strval($this->VillageCode->DbValue);
        $masterKeys["NRC"] = strval($this->NRC->DbValue);
        $masterKeys["FarmNo"] = strval($this->FarmNo->DbValue);

        // Column "detail_farm_inspection"
        if ($this->DetailPages?->getItem("farm_inspection")?->Visible && $Security->allowList(CurrentProjectID() . 'farm_inspection')) {
            $link = "";
            $option = $this->ListOptions["detail_farm_inspection"];
            $detailTbl = Container("farm_inspection");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "FarmInspectionPreview?t=farm&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"farm_inspection\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'farm')) {
                $label = $Language->tablePhrase("farm_inspection", "TblCaption");
                $detailTbl->Count = $detailTbl->loadRecordCount($detailFilter);
                $detailFilters[$detailTbl->TableVar] = $detailFilter;
                $label .= "&nbsp;" . JsEncode(str_replace(["%c", "%s"], [$detailTbl->Count, "blue"], $Language->phrase("DetailCount")));
                $url .= "&detailfilters=%f";
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"farm_inspection\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("FarmInspectionList?" . Config("TABLE_SHOW_MASTER") . "=farm");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("farm_inspection", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("FarmInspectionGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=farm_inspection"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=farm_inspection"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=farm_inspection"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["FarmNo"] = strval($this->FarmNo->DbValue);
        $masterKeys["NRC"] = strval($this->NRC->DbValue);

        // Column "detail_production_sales"
        if ($this->DetailPages?->getItem("production_sales")?->Visible && $Security->allowList(CurrentProjectID() . 'production_sales')) {
            $link = "";
            $option = $this->ListOptions["detail_production_sales"];
            $detailTbl = Container("production_sales");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "ProductionSalesPreview?t=farm&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"production_sales\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'farm')) {
                $label = $Language->tablePhrase("production_sales", "TblCaption");
                $detailTbl->Count = $detailTbl->loadRecordCount($detailFilter);
                $detailFilters[$detailTbl->TableVar] = $detailFilter;
                $label .= "&nbsp;" . JsEncode(str_replace(["%c", "%s"], [$detailTbl->Count, "blue"], $Language->phrase("DetailCount")));
                $url .= "&detailfilters=%f";
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"production_sales\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("ProductionSalesList?" . Config("TABLE_SHOW_MASTER") . "=farm");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("production_sales", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ProductionSalesGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=production_sales"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=production_sales"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'farm')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=production_sales"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        foreach ($this->ListOptions as $option) {
            if (str_starts_with($option->Name, "detail_") && str_contains($option->Body, "&detailfilters=%f")) {
                if (count($detailFilters) > 0) {
                    $encryptedFilters = Encrypt(JsonEncode($detailFilters));
                    $option->Body = str_replace("&detailfilters=%f", "&detailfilters=" . $encryptedFilters, $option->Body);
                    $links = str_replace("&detailfilters=%f", "&detailfilters=" . $encryptedFilters, $links);
                } else {
                    $option->Body = str_replace("&detailfilters=%f", "", $option->Body);
                    $links = str_replace("&detailfilters=%f", "", $links);
                }
            }
        }

        // Add row attributes for expandable row
        if ($this->RowType == RowType::VIEW) {
            $this->RowAttrs["data-widget"] = "expandable-table";
            $this->RowAttrs["aria-expanded"] = "false";
        }

        // Column "preview"
        $option = $this->ListOptions["preview"];
        if (!$option) { // Add preview column
            $option = &$this->ListOptions->add("preview");
            $option->OnLeft = true;
            $checkboxPos = $this->ListOptions->itemPos("checkbox");
            $pos = $checkboxPos === false
                ? ($option->OnLeft ? 0 : -1)
                : ($option->OnLeft ? $checkboxPos + 1 : $checkboxPos);
            $option->moveTo($pos);
            $option->Visible = !($this->isExport() || $this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit());
            $option->ShowInDropDown = false;
            $option->ShowInButtonGroup = false;
        }
        if ($option) {
            $icon = "fa-solid fa-caret-right fa-fw"; // Right
            if (property_exists($this, "MultiColumnLayout") && $this->MultiColumnLayout == "table") {
                $option->CssStyle = "width: 1%;";
                if (!$option->OnLeft) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            if (IsRTL()) { // Reverse
                if (preg_match('/\\bleft\\b/', $icon)) {
                    $icon = preg_replace('/\\bleft\\b/', "right", $icon);
                } elseif (preg_match('/\\bright\\b/', $icon)) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            $option->Body = "<i role=\"button\" class=\"ew-preview-btn expandable-table-caret ew-icon " . $icon . "\"></i>" .
                "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }

        // Column "details" (Multiple details)
        $option = $this->ListOptions["details"];
        if ($option) {
            $option->Body .= "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $option = $this->OtherOptions["addedit"];
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Add
        if ($this->CurrentMode == "view") { // Check view mode
            $item = &$option->add("add");
            $addcaption = HtmlTitle($Language->phrase("AddLink"));
            $this->AddUrl = $this->getAddUrl();
            if ($this->ModalAdd && !IsMobile()) {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"farm\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
            } else {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
            }
            $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        }
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
            if (in_array($this->CurrentMode, ["add", "copy", "edit"]) && !$this->isConfirm()) { // Check add/copy/edit mode
                if ($this->AllowAddDeleteRow) {
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-ew-action=\"add-grid-row\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = $Security->canAdd();
                    $this->ShowOtherOptions = $item->Visible;
                }
            }
            if ($this->CurrentMode == "view") { // Check view mode
                $option = $options["addedit"];
                $item = $option["add"];
                $this->ShowOtherOptions = $item?->Visible ?? false;
            }
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        $this->StartRecord = 1;
        $this->StopRecord = $this->TotalRecords; // Show all records

        // Restore number of post back records
        if ($CurrentForm && ($this->isConfirm() || $this->EventCancelled)) {
            $CurrentForm->resetIndex();
            if ($CurrentForm->hasValue($this->FormKeyCountName) && ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm())) {
                $this->KeyCount = $CurrentForm->getValue($this->FormKeyCountName);
                $this->StopRecord = $this->StartRecord + $this->KeyCount - 1;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_farm", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }
        if ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm() || $this->isMultiEdit()) {
            $this->RowIndex++;
            $CurrentForm->Index = $this->RowIndex;
            if ($CurrentForm->hasValue($this->FormActionName) && ($this->isConfirm() || $this->EventCancelled)) {
                $this->RowAction = strval($CurrentForm->getValue($this->FormActionName));
            } elseif ($this->isGridAdd()) {
                $this->RowAction = "insert";
            } else {
                $this->RowAction = "";
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->loadRowValues($this->CurrentRow); // Load row values
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
            } else {
                $this->loadRowValues(); // Load default values
                $this->OldKey = "";
            }
        } else {
            $this->loadRowValues($this->CurrentRow); // Load row values
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
        }
        $this->setKey($this->OldKey);
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }
        if ($this->isGridAdd() && $this->EventCancelled && !$CurrentForm->hasValue($this->FormBlankRowName)) { // Insert failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isGridEdit()) { // Grid edit
            if ($this->EventCancelled) {
                $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
            }
            if ($this->RowAction == "insert") {
                $this->RowType = RowType::ADD; // Render add
            } else {
                $this->RowType = RowType::EDIT; // Render edit
            }
        }
        if ($this->isGridEdit() && ($this->RowType == RowType::EDIT || $this->RowType == RowType::ADD) && $this->EventCancelled) { // Update failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isConfirm()) { // Confirm row
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_farm",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->ProvinceCode->DefaultValue = $this->ProvinceCode->getDefault(); // PHP
        $this->ProvinceCode->OldValue = $this->ProvinceCode->DefaultValue;
        $this->DistrictCode->DefaultValue = $this->DistrictCode->getDefault(); // PHP
        $this->DistrictCode->OldValue = $this->DistrictCode->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $CurrentForm->FormName = $this->FormName;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'ProvinceCode' first before field var 'x_ProvinceCode'
        $val = $CurrentForm->hasValue("ProvinceCode") ? $CurrentForm->getValue("ProvinceCode") : $CurrentForm->getValue("x_ProvinceCode");
        if (!$this->ProvinceCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProvinceCode->Visible = false; // Disable update for API request
            } else {
                $this->ProvinceCode->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_ProvinceCode")) {
            $this->ProvinceCode->setOldValue($CurrentForm->getValue("o_ProvinceCode"));
        }

        // Check field name 'DistrictCode' first before field var 'x_DistrictCode'
        $val = $CurrentForm->hasValue("DistrictCode") ? $CurrentForm->getValue("DistrictCode") : $CurrentForm->getValue("x_DistrictCode");
        if (!$this->DistrictCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DistrictCode->Visible = false; // Disable update for API request
            } else {
                $this->DistrictCode->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_DistrictCode")) {
            $this->DistrictCode->setOldValue($CurrentForm->getValue("o_DistrictCode"));
        }

        // Check field name 'CampCode' first before field var 'x_CampCode'
        $val = $CurrentForm->hasValue("CampCode") ? $CurrentForm->getValue("CampCode") : $CurrentForm->getValue("x_CampCode");
        if (!$this->CampCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->CampCode->Visible = false; // Disable update for API request
            } else {
                $this->CampCode->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_CampCode")) {
            $this->CampCode->setOldValue($CurrentForm->getValue("o_CampCode"));
        }

        // Check field name 'VillageCode' first before field var 'x_VillageCode'
        $val = $CurrentForm->hasValue("VillageCode") ? $CurrentForm->getValue("VillageCode") : $CurrentForm->getValue("x_VillageCode");
        if (!$this->VillageCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->VillageCode->Visible = false; // Disable update for API request
            } else {
                $this->VillageCode->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_VillageCode")) {
            $this->VillageCode->setOldValue($CurrentForm->getValue("o_VillageCode"));
        }

        // Check field name 'NRC' first before field var 'x_NRC'
        $val = $CurrentForm->hasValue("NRC") ? $CurrentForm->getValue("NRC") : $CurrentForm->getValue("x_NRC");
        if (!$this->NRC->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NRC->Visible = false; // Disable update for API request
            } else {
                $this->NRC->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_NRC")) {
            $this->NRC->setOldValue($CurrentForm->getValue("o_NRC"));
        }

        // Check field name 'FieldType' first before field var 'x_FieldType'
        $val = $CurrentForm->hasValue("FieldType") ? $CurrentForm->getValue("FieldType") : $CurrentForm->getValue("x_FieldType");
        if (!$this->FieldType->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FieldType->Visible = false; // Disable update for API request
            } else {
                $this->FieldType->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_FieldType")) {
            $this->FieldType->setOldValue($CurrentForm->getValue("o_FieldType"));
        }

        // Check field name 'Ownership' first before field var 'x_Ownership'
        $val = $CurrentForm->hasValue("Ownership") ? $CurrentForm->getValue("Ownership") : $CurrentForm->getValue("x_Ownership");
        if (!$this->Ownership->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Ownership->Visible = false; // Disable update for API request
            } else {
                $this->Ownership->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_Ownership")) {
            $this->Ownership->setOldValue($CurrentForm->getValue("o_Ownership"));
        }

        // Check field name 'SeedlingsAllocated' first before field var 'x_SeedlingsAllocated'
        $val = $CurrentForm->hasValue("SeedlingsAllocated") ? $CurrentForm->getValue("SeedlingsAllocated") : $CurrentForm->getValue("x_SeedlingsAllocated");
        if (!$this->SeedlingsAllocated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SeedlingsAllocated->Visible = false; // Disable update for API request
            } else {
                $this->SeedlingsAllocated->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_SeedlingsAllocated")) {
            $this->SeedlingsAllocated->setOldValue($CurrentForm->getValue("o_SeedlingsAllocated"));
        }

        // Check field name 'TreesPlantedEstimated' first before field var 'x_TreesPlantedEstimated'
        $val = $CurrentForm->hasValue("TreesPlantedEstimated") ? $CurrentForm->getValue("TreesPlantedEstimated") : $CurrentForm->getValue("x_TreesPlantedEstimated");
        if (!$this->TreesPlantedEstimated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->TreesPlantedEstimated->Visible = false; // Disable update for API request
            } else {
                $this->TreesPlantedEstimated->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_TreesPlantedEstimated")) {
            $this->TreesPlantedEstimated->setOldValue($CurrentForm->getValue("o_TreesPlantedEstimated"));
        }

        // Check field name 'TreesPlantedVerified' first before field var 'x_TreesPlantedVerified'
        $val = $CurrentForm->hasValue("TreesPlantedVerified") ? $CurrentForm->getValue("TreesPlantedVerified") : $CurrentForm->getValue("x_TreesPlantedVerified");
        if (!$this->TreesPlantedVerified->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->TreesPlantedVerified->Visible = false; // Disable update for API request
            } else {
                $this->TreesPlantedVerified->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_TreesPlantedVerified")) {
            $this->TreesPlantedVerified->setOldValue($CurrentForm->getValue("o_TreesPlantedVerified"));
        }

        // Check field name 'FarmNo' first before field var 'x_FarmNo'
        $val = $CurrentForm->hasValue("FarmNo") ? $CurrentForm->getValue("FarmNo") : $CurrentForm->getValue("x_FarmNo");
        if (!$this->FarmNo->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->FarmNo->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->FarmNo->CurrentValue = $this->FarmNo->FormValue;
        }
        $this->ProvinceCode->CurrentValue = $this->ProvinceCode->FormValue;
        $this->DistrictCode->CurrentValue = $this->DistrictCode->FormValue;
        $this->CampCode->CurrentValue = $this->CampCode->FormValue;
        $this->VillageCode->CurrentValue = $this->VillageCode->FormValue;
        $this->NRC->CurrentValue = $this->NRC->FormValue;
        $this->FieldType->CurrentValue = $this->FieldType->FormValue;
        $this->Ownership->CurrentValue = $this->Ownership->FormValue;
        $this->SeedlingsAllocated->CurrentValue = $this->SeedlingsAllocated->FormValue;
        $this->TreesPlantedEstimated->CurrentValue = $this->TreesPlantedEstimated->FormValue;
        $this->TreesPlantedVerified->CurrentValue = $this->TreesPlantedVerified->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->FieldType->setDbValue($row['FieldType']);
        $this->Ownership->setDbValue($row['Ownership']);
        $this->SeedlingsAllocated->setDbValue($row['SeedlingsAllocated']);
        $this->TreesPlantedEstimated->setDbValue($row['TreesPlantedEstimated']);
        $this->FarmSizeEstimated->setDbValue($row['FarmSizeEstimated']);
        $this->FarmSizeVerified->setDbValue($row['FarmSizeVerified']);
        $this->TreesPlantedVerified->setDbValue($row['TreesPlantedVerified']);
        $this->SourcesOfSeedlings->setDbValue($row['SourcesOfSeedlings']);
        $this->InspecationReport->setDbValue($row['InspecationReport']);
        $this->ClearedLand->setDbValue($row['ClearedLand']);
        $this->OldTrees->setDbValue($row['OldTrees']);
        $this->FarmSize->setDbValue($row['FarmSize']);
        $this->Latitude->setDbValue($row['Latitude']);
        $this->Longitude->setDbValue($row['Longitude']);
        $this->Coordinates->setDbValue($row['Coordinates']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProvinceCode'] = $this->ProvinceCode->DefaultValue;
        $row['DistrictCode'] = $this->DistrictCode->DefaultValue;
        $row['CampCode'] = $this->CampCode->DefaultValue;
        $row['VillageCode'] = $this->VillageCode->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['FarmNo'] = $this->FarmNo->DefaultValue;
        $row['FarmerNo'] = $this->FarmerNo->DefaultValue;
        $row['FieldType'] = $this->FieldType->DefaultValue;
        $row['Ownership'] = $this->Ownership->DefaultValue;
        $row['SeedlingsAllocated'] = $this->SeedlingsAllocated->DefaultValue;
        $row['TreesPlantedEstimated'] = $this->TreesPlantedEstimated->DefaultValue;
        $row['FarmSizeEstimated'] = $this->FarmSizeEstimated->DefaultValue;
        $row['FarmSizeVerified'] = $this->FarmSizeVerified->DefaultValue;
        $row['TreesPlantedVerified'] = $this->TreesPlantedVerified->DefaultValue;
        $row['SourcesOfSeedlings'] = $this->SourcesOfSeedlings->DefaultValue;
        $row['InspecationReport'] = $this->InspecationReport->DefaultValue;
        $row['ClearedLand'] = $this->ClearedLand->DefaultValue;
        $row['OldTrees'] = $this->OldTrees->DefaultValue;
        $row['FarmSize'] = $this->FarmSize->DefaultValue;
        $row['Latitude'] = $this->Latitude->DefaultValue;
        $row['Longitude'] = $this->Longitude->DefaultValue;
        $row['Coordinates'] = $this->Coordinates->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProvinceCode

        // DistrictCode

        // CampCode

        // VillageCode

        // NRC

        // FarmNo

        // FarmerNo

        // FieldType

        // Ownership

        // SeedlingsAllocated

        // TreesPlantedEstimated

        // FarmSizeEstimated

        // FarmSizeVerified

        // TreesPlantedVerified

        // SourcesOfSeedlings

        // InspecationReport

        // ClearedLand

        // OldTrees

        // FarmSize

        // Latitude

        // Longitude

        // Coordinates

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProvinceCode
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }

            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // CampCode
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }

            // VillageCode
            $curVal = strval($this->VillageCode->CurrentValue);
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                if ($this->VillageCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                    }
                }
            } else {
                $this->VillageCode->ViewValue = null;
            }

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->ViewValue = $this->NRC->CurrentValue;
                    }
                }
            } else {
                $this->NRC->ViewValue = null;
            }

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

            // FieldType
            $curVal = strval($this->FieldType->CurrentValue);
            if ($curVal != "") {
                $this->FieldType->ViewValue = $this->FieldType->lookupCacheOption($curVal);
                if ($this->FieldType->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchExpression(), "=", $curVal, $this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchDataType(), "");
                    $sqlWrk = $this->FieldType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->FieldType->Lookup->renderViewRow($rswrk[0]);
                        $this->FieldType->ViewValue = $this->FieldType->displayValue($arwrk);
                    } else {
                        $this->FieldType->ViewValue = $this->FieldType->CurrentValue;
                    }
                }
            } else {
                $this->FieldType->ViewValue = null;
            }

            // Ownership
            $curVal = strval($this->Ownership->CurrentValue);
            if ($curVal != "") {
                $this->Ownership->ViewValue = $this->Ownership->lookupCacheOption($curVal);
                if ($this->Ownership->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchExpression(), "=", $curVal, $this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchDataType(), "");
                    $sqlWrk = $this->Ownership->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Ownership->Lookup->renderViewRow($rswrk[0]);
                        $this->Ownership->ViewValue = $this->Ownership->displayValue($arwrk);
                    } else {
                        $this->Ownership->ViewValue = $this->Ownership->CurrentValue;
                    }
                }
            } else {
                $this->Ownership->ViewValue = null;
            }

            // SeedlingsAllocated
            $this->SeedlingsAllocated->ViewValue = $this->SeedlingsAllocated->CurrentValue;
            $this->SeedlingsAllocated->ViewValue = FormatNumber($this->SeedlingsAllocated->ViewValue, $this->SeedlingsAllocated->formatPattern());

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->ViewValue = $this->TreesPlantedEstimated->CurrentValue;
            $this->TreesPlantedEstimated->ViewValue = FormatNumber($this->TreesPlantedEstimated->ViewValue, $this->TreesPlantedEstimated->formatPattern());

            // FarmSizeEstimated
            $this->FarmSizeEstimated->ViewValue = $this->FarmSizeEstimated->CurrentValue;
            $this->FarmSizeEstimated->ViewValue = FormatNumber($this->FarmSizeEstimated->ViewValue, $this->FarmSizeEstimated->formatPattern());

            // FarmSizeVerified
            $this->FarmSizeVerified->ViewValue = $this->FarmSizeVerified->CurrentValue;
            $this->FarmSizeVerified->ViewValue = FormatNumber($this->FarmSizeVerified->ViewValue, $this->FarmSizeVerified->formatPattern());

            // TreesPlantedVerified
            $this->TreesPlantedVerified->ViewValue = $this->TreesPlantedVerified->CurrentValue;
            $this->TreesPlantedVerified->ViewValue = FormatNumber($this->TreesPlantedVerified->ViewValue, $this->TreesPlantedVerified->formatPattern());

            // SourcesOfSeedlings
            $curVal = strval($this->SourcesOfSeedlings->CurrentValue);
            if ($curVal != "") {
                $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->lookupCacheOption($curVal);
                if ($this->SourcesOfSeedlings->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SourcesOfSeedlings->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SourcesOfSeedlings->Lookup->renderViewRow($rswrk[0]);
                        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->displayValue($arwrk);
                    } else {
                        $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;
                    }
                }
            } else {
                $this->SourcesOfSeedlings->ViewValue = null;
            }

            // ClearedLand
            $this->ClearedLand->ViewValue = $this->ClearedLand->CurrentValue;

            // OldTrees
            $this->OldTrees->ViewValue = $this->OldTrees->CurrentValue;

            // FarmSize
            $this->FarmSize->ViewValue = $this->FarmSize->CurrentValue;

            // Latitude
            $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
            $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

            // Longitude
            $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
            $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";
            $this->ProvinceCode->TooltipValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";
            $this->DistrictCode->TooltipValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";
            $this->CampCode->TooltipValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";
            $this->VillageCode->TooltipValue = "";

            // NRC
            $this->NRC->HrefValue = "";
            $this->NRC->TooltipValue = "";
            if (!$this->isExport()) {
                $this->NRC->ViewValue = $this->highlightValue($this->NRC);
            }

            // FieldType
            $this->FieldType->HrefValue = "";
            $this->FieldType->TooltipValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";
            $this->Ownership->TooltipValue = "";

            // SeedlingsAllocated
            $this->SeedlingsAllocated->HrefValue = "";
            $this->SeedlingsAllocated->TooltipValue = "";
            if (!$this->isExport()) {
                $this->SeedlingsAllocated->ViewValue = $this->highlightValue($this->SeedlingsAllocated);
            }

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->HrefValue = "";
            $this->TreesPlantedEstimated->TooltipValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";
            $this->TreesPlantedVerified->TooltipValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            if ($this->ProvinceCode->getSessionValue() != "") {
                $this->ProvinceCode->CurrentValue = GetForeignKeyValue($this->ProvinceCode->getSessionValue());
                $this->ProvinceCode->OldValue = $this->ProvinceCode->CurrentValue;
                $curVal = strval($this->ProvinceCode->CurrentValue);
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                    if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                        $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                        $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                        } else {
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                        }
                    }
                } else {
                    $this->ProvinceCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->ProvinceCode->CurrentValue));
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->ProvinceCode->ViewValue !== null) { // Load from cache
                    $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->CurrentValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->ProvinceCode->EditValue = $arwrk;
                }
                $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
            }

            // DistrictCode
            if ($this->DistrictCode->getSessionValue() != "") {
                $this->DistrictCode->CurrentValue = GetForeignKeyValue($this->DistrictCode->getSessionValue());
                $this->DistrictCode->OldValue = $this->DistrictCode->CurrentValue;
                $curVal = strval($this->DistrictCode->CurrentValue);
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                    if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                        $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                            $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                        } else {
                            $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                        }
                    }
                } else {
                    $this->DistrictCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->DistrictCode->CurrentValue));
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->DistrictCode->ViewValue !== null) { // Load from cache
                    $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
                    if ($this->DistrictCode->ViewValue == "") {
                        $this->DistrictCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->CurrentValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->DistrictCode->EditValue = $arwrk;
                }
                $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
            }

            // CampCode
            if ($this->CampCode->getSessionValue() != "") {
                $this->CampCode->CurrentValue = GetForeignKeyValue($this->CampCode->getSessionValue());
                $this->CampCode->OldValue = $this->CampCode->CurrentValue;
                $curVal = strval($this->CampCode->CurrentValue);
                if ($curVal != "") {
                    $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                    if ($this->CampCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                        $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                            $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                        } else {
                            $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                        }
                    }
                } else {
                    $this->CampCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->CampCode->CurrentValue));
                if ($curVal != "") {
                    $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                } else {
                    $this->CampCode->ViewValue = $this->CampCode->Lookup !== null && is_array($this->CampCode->lookupOptions()) && count($this->CampCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->CampCode->ViewValue !== null) { // Load from cache
                    $this->CampCode->EditValue = array_values($this->CampCode->lookupOptions());
                    if ($this->CampCode->ViewValue == "") {
                        $this->CampCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $this->CampCode->CurrentValue, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->CampCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->CampCode->EditValue = $arwrk;
                }
                $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());
            }

            // VillageCode
            if ($this->VillageCode->getSessionValue() != "") {
                $this->VillageCode->CurrentValue = GetForeignKeyValue($this->VillageCode->getSessionValue());
                $this->VillageCode->OldValue = $this->VillageCode->CurrentValue;
                $curVal = strval($this->VillageCode->CurrentValue);
                if ($curVal != "") {
                    $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                    if ($this->VillageCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                        $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                            $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                        } else {
                            $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                        }
                    }
                } else {
                    $this->VillageCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->VillageCode->CurrentValue));
                if ($curVal != "") {
                    $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                } else {
                    $this->VillageCode->ViewValue = $this->VillageCode->Lookup !== null && is_array($this->VillageCode->lookupOptions()) && count($this->VillageCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->VillageCode->ViewValue !== null) { // Load from cache
                    $this->VillageCode->EditValue = array_values($this->VillageCode->lookupOptions());
                    if ($this->VillageCode->ViewValue == "") {
                        $this->VillageCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $this->VillageCode->CurrentValue, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->VillageCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->VillageCode->EditValue = $arwrk;
                }
                $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
            }

            // NRC
            $this->NRC->setupEditAttributes();
            if ($this->NRC->getSessionValue() != "") {
                $this->NRC->CurrentValue = GetForeignKeyValue($this->NRC->getSessionValue());
                $this->NRC->OldValue = $this->NRC->CurrentValue;
                $this->NRC->ViewValue = $this->NRC->CurrentValue;
                $curVal = strval($this->NRC->CurrentValue);
                if ($curVal != "") {
                    $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                    if ($this->NRC->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                        $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                            $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                        } else {
                            $this->NRC->ViewValue = $this->NRC->CurrentValue;
                        }
                    }
                } else {
                    $this->NRC->ViewValue = null;
                }
            } else {
                if (!$this->NRC->Raw) {
                    $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
                }
                $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
                $curVal = strval($this->NRC->CurrentValue);
                if ($curVal != "") {
                    $this->NRC->EditValue = $this->NRC->lookupCacheOption($curVal);
                    if ($this->NRC->EditValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                        $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                            $this->NRC->EditValue = $this->NRC->displayValue($arwrk);
                        } else {
                            $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
                        }
                    }
                } else {
                    $this->NRC->EditValue = null;
                }
                $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());
            }

            // FieldType
            $this->FieldType->setupEditAttributes();
            $curVal = trim(strval($this->FieldType->CurrentValue));
            if ($curVal != "") {
                $this->FieldType->ViewValue = $this->FieldType->lookupCacheOption($curVal);
            } else {
                $this->FieldType->ViewValue = $this->FieldType->Lookup !== null && is_array($this->FieldType->lookupOptions()) && count($this->FieldType->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->FieldType->ViewValue !== null) { // Load from cache
                $this->FieldType->EditValue = array_values($this->FieldType->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchExpression(), "=", $this->FieldType->CurrentValue, $this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchDataType(), "");
                }
                $sqlWrk = $this->FieldType->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->FieldType->EditValue = $arwrk;
            }
            $this->FieldType->PlaceHolder = RemoveHtml($this->FieldType->caption());

            // Ownership
            $this->Ownership->setupEditAttributes();
            $curVal = trim(strval($this->Ownership->CurrentValue));
            if ($curVal != "") {
                $this->Ownership->ViewValue = $this->Ownership->lookupCacheOption($curVal);
            } else {
                $this->Ownership->ViewValue = $this->Ownership->Lookup !== null && is_array($this->Ownership->lookupOptions()) && count($this->Ownership->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Ownership->ViewValue !== null) { // Load from cache
                $this->Ownership->EditValue = array_values($this->Ownership->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchExpression(), "=", $this->Ownership->CurrentValue, $this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchDataType(), "");
                }
                $sqlWrk = $this->Ownership->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Ownership->EditValue = $arwrk;
            }
            $this->Ownership->PlaceHolder = RemoveHtml($this->Ownership->caption());

            // SeedlingsAllocated
            $this->SeedlingsAllocated->setupEditAttributes();
            $this->SeedlingsAllocated->EditValue = $this->SeedlingsAllocated->CurrentValue;
            $this->SeedlingsAllocated->PlaceHolder = RemoveHtml($this->SeedlingsAllocated->caption());
            if (strval($this->SeedlingsAllocated->EditValue) != "" && is_numeric($this->SeedlingsAllocated->EditValue)) {
                $this->SeedlingsAllocated->EditValue = FormatNumber($this->SeedlingsAllocated->EditValue, null);
            }

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->setupEditAttributes();
            $this->TreesPlantedEstimated->EditValue = $this->TreesPlantedEstimated->CurrentValue;
            $this->TreesPlantedEstimated->PlaceHolder = RemoveHtml($this->TreesPlantedEstimated->caption());
            if (strval($this->TreesPlantedEstimated->EditValue) != "" && is_numeric($this->TreesPlantedEstimated->EditValue)) {
                $this->TreesPlantedEstimated->EditValue = FormatNumber($this->TreesPlantedEstimated->EditValue, null);
            }

            // TreesPlantedVerified
            $this->TreesPlantedVerified->setupEditAttributes();
            $this->TreesPlantedVerified->EditValue = $this->TreesPlantedVerified->CurrentValue;
            $this->TreesPlantedVerified->PlaceHolder = RemoveHtml($this->TreesPlantedVerified->caption());
            if (strval($this->TreesPlantedVerified->EditValue) != "" && is_numeric($this->TreesPlantedVerified->EditValue)) {
                $this->TreesPlantedVerified->EditValue = FormatNumber($this->TreesPlantedVerified->EditValue, null);
            }

            // Add refer script

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FieldType
            $this->FieldType->HrefValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";

            // SeedlingsAllocated
            $this->SeedlingsAllocated->HrefValue = "";

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->HrefValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // ProvinceCode
            $this->ProvinceCode->setupEditAttributes();
            if ($this->ProvinceCode->getSessionValue() != "") {
                $this->ProvinceCode->CurrentValue = GetForeignKeyValue($this->ProvinceCode->getSessionValue());
                $this->ProvinceCode->OldValue = $this->ProvinceCode->CurrentValue;
                $curVal = strval($this->ProvinceCode->CurrentValue);
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                    if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                        $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                        $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                        } else {
                            $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                        }
                    }
                } else {
                    $this->ProvinceCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->ProvinceCode->CurrentValue));
                if ($curVal != "") {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->Lookup !== null && is_array($this->ProvinceCode->lookupOptions()) && count($this->ProvinceCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->ProvinceCode->ViewValue !== null) { // Load from cache
                    $this->ProvinceCode->EditValue = array_values($this->ProvinceCode->lookupOptions());
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $this->ProvinceCode->CurrentValue, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    }
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    $arwrk = $rswrk;
                    $this->ProvinceCode->EditValue = $arwrk;
                }
                $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
            }

            // DistrictCode
            if ($this->DistrictCode->getSessionValue() != "") {
                $this->DistrictCode->CurrentValue = GetForeignKeyValue($this->DistrictCode->getSessionValue());
                $this->DistrictCode->OldValue = $this->DistrictCode->CurrentValue;
                $curVal = strval($this->DistrictCode->CurrentValue);
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                    if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                        $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                            $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                        } else {
                            $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                        }
                    }
                } else {
                    $this->DistrictCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->DistrictCode->CurrentValue));
                if ($curVal != "") {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->DistrictCode->ViewValue !== null) { // Load from cache
                    $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
                    if ($this->DistrictCode->ViewValue == "") {
                        $this->DistrictCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->CurrentValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->DistrictCode->EditValue = $arwrk;
                }
                $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
            }

            // CampCode
            if ($this->CampCode->getSessionValue() != "") {
                $this->CampCode->CurrentValue = GetForeignKeyValue($this->CampCode->getSessionValue());
                $this->CampCode->OldValue = $this->CampCode->CurrentValue;
                $curVal = strval($this->CampCode->CurrentValue);
                if ($curVal != "") {
                    $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                    if ($this->CampCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                        $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                            $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                        } else {
                            $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                        }
                    }
                } else {
                    $this->CampCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->CampCode->CurrentValue));
                if ($curVal != "") {
                    $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                } else {
                    $this->CampCode->ViewValue = $this->CampCode->Lookup !== null && is_array($this->CampCode->lookupOptions()) && count($this->CampCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->CampCode->ViewValue !== null) { // Load from cache
                    $this->CampCode->EditValue = array_values($this->CampCode->lookupOptions());
                    if ($this->CampCode->ViewValue == "") {
                        $this->CampCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $this->CampCode->CurrentValue, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->CampCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->CampCode->EditValue = $arwrk;
                }
                $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());
            }

            // VillageCode
            if ($this->VillageCode->getSessionValue() != "") {
                $this->VillageCode->CurrentValue = GetForeignKeyValue($this->VillageCode->getSessionValue());
                $this->VillageCode->OldValue = $this->VillageCode->CurrentValue;
                $curVal = strval($this->VillageCode->CurrentValue);
                if ($curVal != "") {
                    $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                    if ($this->VillageCode->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                        $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                            $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                        } else {
                            $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                        }
                    }
                } else {
                    $this->VillageCode->ViewValue = null;
                }
            } else {
                $curVal = trim(strval($this->VillageCode->CurrentValue));
                if ($curVal != "") {
                    $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                } else {
                    $this->VillageCode->ViewValue = $this->VillageCode->Lookup !== null && is_array($this->VillageCode->lookupOptions()) && count($this->VillageCode->lookupOptions()) > 0 ? $curVal : null;
                }
                if ($this->VillageCode->ViewValue !== null) { // Load from cache
                    $this->VillageCode->EditValue = array_values($this->VillageCode->lookupOptions());
                    if ($this->VillageCode->ViewValue == "") {
                        $this->VillageCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                } else { // Lookup from database
                    if ($curVal == "") {
                        $filterWrk = "0=1";
                    } else {
                        $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $this->VillageCode->CurrentValue, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    }
                    $sqlWrk = $this->VillageCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $Language->phrase("PleaseSelect");
                    }
                    $arwrk = $rswrk;
                    $this->VillageCode->EditValue = $arwrk;
                }
                $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
            }

            // NRC
            $this->NRC->setupEditAttributes();
            if ($this->NRC->getSessionValue() != "") {
                $this->NRC->CurrentValue = GetForeignKeyValue($this->NRC->getSessionValue());
                $this->NRC->OldValue = $this->NRC->CurrentValue;
                $this->NRC->ViewValue = $this->NRC->CurrentValue;
                $curVal = strval($this->NRC->CurrentValue);
                if ($curVal != "") {
                    $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                    if ($this->NRC->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                        $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                            $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                        } else {
                            $this->NRC->ViewValue = $this->NRC->CurrentValue;
                        }
                    }
                } else {
                    $this->NRC->ViewValue = null;
                }
            } else {
                if (!$this->NRC->Raw) {
                    $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
                }
                $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
                $curVal = strval($this->NRC->CurrentValue);
                if ($curVal != "") {
                    $this->NRC->EditValue = $this->NRC->lookupCacheOption($curVal);
                    if ($this->NRC->EditValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                        $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                            $this->NRC->EditValue = $this->NRC->displayValue($arwrk);
                        } else {
                            $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
                        }
                    }
                } else {
                    $this->NRC->EditValue = null;
                }
                $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());
            }

            // FieldType
            $this->FieldType->setupEditAttributes();
            $curVal = trim(strval($this->FieldType->CurrentValue));
            if ($curVal != "") {
                $this->FieldType->ViewValue = $this->FieldType->lookupCacheOption($curVal);
            } else {
                $this->FieldType->ViewValue = $this->FieldType->Lookup !== null && is_array($this->FieldType->lookupOptions()) && count($this->FieldType->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->FieldType->ViewValue !== null) { // Load from cache
                $this->FieldType->EditValue = array_values($this->FieldType->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchExpression(), "=", $this->FieldType->CurrentValue, $this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchDataType(), "");
                }
                $sqlWrk = $this->FieldType->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->FieldType->EditValue = $arwrk;
            }
            $this->FieldType->PlaceHolder = RemoveHtml($this->FieldType->caption());

            // Ownership
            $this->Ownership->setupEditAttributes();
            $curVal = trim(strval($this->Ownership->CurrentValue));
            if ($curVal != "") {
                $this->Ownership->ViewValue = $this->Ownership->lookupCacheOption($curVal);
            } else {
                $this->Ownership->ViewValue = $this->Ownership->Lookup !== null && is_array($this->Ownership->lookupOptions()) && count($this->Ownership->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Ownership->ViewValue !== null) { // Load from cache
                $this->Ownership->EditValue = array_values($this->Ownership->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchExpression(), "=", $this->Ownership->CurrentValue, $this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchDataType(), "");
                }
                $sqlWrk = $this->Ownership->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Ownership->EditValue = $arwrk;
            }
            $this->Ownership->PlaceHolder = RemoveHtml($this->Ownership->caption());

            // SeedlingsAllocated
            $this->SeedlingsAllocated->setupEditAttributes();
            $this->SeedlingsAllocated->EditValue = $this->SeedlingsAllocated->CurrentValue;
            $this->SeedlingsAllocated->EditValue = FormatNumber($this->SeedlingsAllocated->EditValue, $this->SeedlingsAllocated->formatPattern());

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->setupEditAttributes();
            $this->TreesPlantedEstimated->EditValue = $this->TreesPlantedEstimated->CurrentValue;
            $this->TreesPlantedEstimated->PlaceHolder = RemoveHtml($this->TreesPlantedEstimated->caption());
            if (strval($this->TreesPlantedEstimated->EditValue) != "" && is_numeric($this->TreesPlantedEstimated->EditValue)) {
                $this->TreesPlantedEstimated->EditValue = FormatNumber($this->TreesPlantedEstimated->EditValue, null);
            }

            // TreesPlantedVerified
            $this->TreesPlantedVerified->setupEditAttributes();
            $this->TreesPlantedVerified->EditValue = $this->TreesPlantedVerified->CurrentValue;
            $this->TreesPlantedVerified->PlaceHolder = RemoveHtml($this->TreesPlantedVerified->caption());
            if (strval($this->TreesPlantedVerified->EditValue) != "" && is_numeric($this->TreesPlantedVerified->EditValue)) {
                $this->TreesPlantedVerified->EditValue = FormatNumber($this->TreesPlantedVerified->EditValue, null);
            }

            // Edit refer script

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FieldType
            $this->FieldType->HrefValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";

            // SeedlingsAllocated
            $this->SeedlingsAllocated->HrefValue = "";
            $this->SeedlingsAllocated->TooltipValue = "";

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->HrefValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->ProvinceCode->Visible && $this->ProvinceCode->Required) {
                if (!$this->ProvinceCode->IsDetailKey && EmptyValue($this->ProvinceCode->FormValue)) {
                    $this->ProvinceCode->addErrorMessage(str_replace("%s", $this->ProvinceCode->caption(), $this->ProvinceCode->RequiredErrorMessage));
                }
            }
            if ($this->DistrictCode->Visible && $this->DistrictCode->Required) {
                if (!$this->DistrictCode->IsDetailKey && EmptyValue($this->DistrictCode->FormValue)) {
                    $this->DistrictCode->addErrorMessage(str_replace("%s", $this->DistrictCode->caption(), $this->DistrictCode->RequiredErrorMessage));
                }
            }
            if ($this->CampCode->Visible && $this->CampCode->Required) {
                if (!$this->CampCode->IsDetailKey && EmptyValue($this->CampCode->FormValue)) {
                    $this->CampCode->addErrorMessage(str_replace("%s", $this->CampCode->caption(), $this->CampCode->RequiredErrorMessage));
                }
            }
            if ($this->VillageCode->Visible && $this->VillageCode->Required) {
                if (!$this->VillageCode->IsDetailKey && EmptyValue($this->VillageCode->FormValue)) {
                    $this->VillageCode->addErrorMessage(str_replace("%s", $this->VillageCode->caption(), $this->VillageCode->RequiredErrorMessage));
                }
            }
            if ($this->NRC->Visible && $this->NRC->Required) {
                if (!$this->NRC->IsDetailKey && EmptyValue($this->NRC->FormValue)) {
                    $this->NRC->addErrorMessage(str_replace("%s", $this->NRC->caption(), $this->NRC->RequiredErrorMessage));
                }
            }
            if ($this->FieldType->Visible && $this->FieldType->Required) {
                if (!$this->FieldType->IsDetailKey && EmptyValue($this->FieldType->FormValue)) {
                    $this->FieldType->addErrorMessage(str_replace("%s", $this->FieldType->caption(), $this->FieldType->RequiredErrorMessage));
                }
            }
            if ($this->Ownership->Visible && $this->Ownership->Required) {
                if (!$this->Ownership->IsDetailKey && EmptyValue($this->Ownership->FormValue)) {
                    $this->Ownership->addErrorMessage(str_replace("%s", $this->Ownership->caption(), $this->Ownership->RequiredErrorMessage));
                }
            }
            if ($this->SeedlingsAllocated->Visible && $this->SeedlingsAllocated->Required) {
                if (!$this->SeedlingsAllocated->IsDetailKey && EmptyValue($this->SeedlingsAllocated->FormValue)) {
                    $this->SeedlingsAllocated->addErrorMessage(str_replace("%s", $this->SeedlingsAllocated->caption(), $this->SeedlingsAllocated->RequiredErrorMessage));
                }
            }
            if ($this->TreesPlantedEstimated->Visible && $this->TreesPlantedEstimated->Required) {
                if (!$this->TreesPlantedEstimated->IsDetailKey && EmptyValue($this->TreesPlantedEstimated->FormValue)) {
                    $this->TreesPlantedEstimated->addErrorMessage(str_replace("%s", $this->TreesPlantedEstimated->caption(), $this->TreesPlantedEstimated->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->TreesPlantedEstimated->FormValue)) {
                $this->TreesPlantedEstimated->addErrorMessage($this->TreesPlantedEstimated->getErrorMessage(false));
            }
            if ($this->TreesPlantedVerified->Visible && $this->TreesPlantedVerified->Required) {
                if (!$this->TreesPlantedVerified->IsDetailKey && EmptyValue($this->TreesPlantedVerified->FormValue)) {
                    $this->TreesPlantedVerified->addErrorMessage(str_replace("%s", $this->TreesPlantedVerified->caption(), $this->TreesPlantedVerified->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->TreesPlantedVerified->FormValue)) {
                $this->TreesPlantedVerified->addErrorMessage($this->TreesPlantedVerified->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['FarmNo'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // ProvinceCode
        if ($this->ProvinceCode->getSessionValue() != "") {
            $this->ProvinceCode->ReadOnly = true;
        }
        $this->ProvinceCode->setDbValueDef($rsnew, $this->ProvinceCode->CurrentValue, $this->ProvinceCode->ReadOnly);

        // DistrictCode
        if ($this->DistrictCode->getSessionValue() != "") {
            $this->DistrictCode->ReadOnly = true;
        }
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, $this->DistrictCode->ReadOnly);

        // CampCode
        if ($this->CampCode->getSessionValue() != "") {
            $this->CampCode->ReadOnly = true;
        }
        $this->CampCode->setDbValueDef($rsnew, $this->CampCode->CurrentValue, $this->CampCode->ReadOnly);

        // VillageCode
        if ($this->VillageCode->getSessionValue() != "") {
            $this->VillageCode->ReadOnly = true;
        }
        $this->VillageCode->setDbValueDef($rsnew, $this->VillageCode->CurrentValue, $this->VillageCode->ReadOnly);

        // NRC
        if ($this->NRC->getSessionValue() != "") {
            $this->NRC->ReadOnly = true;
        }
        $this->NRC->setDbValueDef($rsnew, $this->NRC->CurrentValue, $this->NRC->ReadOnly);

        // FieldType
        $this->FieldType->setDbValueDef($rsnew, $this->FieldType->CurrentValue, $this->FieldType->ReadOnly);

        // Ownership
        $this->Ownership->setDbValueDef($rsnew, $this->Ownership->CurrentValue, $this->Ownership->ReadOnly);

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->setDbValueDef($rsnew, $this->TreesPlantedEstimated->CurrentValue, $this->TreesPlantedEstimated->ReadOnly);

        // TreesPlantedVerified
        $this->TreesPlantedVerified->setDbValueDef($rsnew, $this->TreesPlantedVerified->CurrentValue, $this->TreesPlantedVerified->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['ProvinceCode'])) { // ProvinceCode
            $this->ProvinceCode->CurrentValue = $row['ProvinceCode'];
        }
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->CurrentValue = $row['DistrictCode'];
        }
        if (isset($row['CampCode'])) { // CampCode
            $this->CampCode->CurrentValue = $row['CampCode'];
        }
        if (isset($row['VillageCode'])) { // VillageCode
            $this->VillageCode->CurrentValue = $row['VillageCode'];
        }
        if (isset($row['NRC'])) { // NRC
            $this->NRC->CurrentValue = $row['NRC'];
        }
        if (isset($row['FieldType'])) { // FieldType
            $this->FieldType->CurrentValue = $row['FieldType'];
        }
        if (isset($row['Ownership'])) { // Ownership
            $this->Ownership->CurrentValue = $row['Ownership'];
        }
        if (isset($row['TreesPlantedEstimated'])) { // TreesPlantedEstimated
            $this->TreesPlantedEstimated->CurrentValue = $row['TreesPlantedEstimated'];
        }
        if (isset($row['TreesPlantedVerified'])) { // TreesPlantedVerified
            $this->TreesPlantedVerified->CurrentValue = $row['TreesPlantedVerified'];
        }
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set up foreign key field value from Session
        if ($this->getCurrentMasterTable() == "farmer") {
            $this->NRC->Visible = true; // Need to insert foreign key
            $this->NRC->CurrentValue = $this->NRC->getSessionValue();
        }
        if ($this->getCurrentMasterTable() == "village") {
            $this->ProvinceCode->Visible = true; // Need to insert foreign key
            $this->ProvinceCode->CurrentValue = $this->ProvinceCode->getSessionValue();
            $this->DistrictCode->Visible = true; // Need to insert foreign key
            $this->DistrictCode->CurrentValue = $this->DistrictCode->getSessionValue();
            $this->CampCode->Visible = true; // Need to insert foreign key
            $this->CampCode->CurrentValue = $this->CampCode->getSessionValue();
            $this->VillageCode->Visible = true; // Need to insert foreign key
            $this->VillageCode->CurrentValue = $this->VillageCode->getSessionValue();
        }

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // ProvinceCode
        $this->ProvinceCode->setDbValueDef($rsnew, $this->ProvinceCode->CurrentValue, strval($this->ProvinceCode->CurrentValue) == "");

        // DistrictCode
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, strval($this->DistrictCode->CurrentValue) == "");

        // CampCode
        $this->CampCode->setDbValueDef($rsnew, $this->CampCode->CurrentValue, false);

        // VillageCode
        $this->VillageCode->setDbValueDef($rsnew, $this->VillageCode->CurrentValue, false);

        // NRC
        $this->NRC->setDbValueDef($rsnew, $this->NRC->CurrentValue, false);

        // FieldType
        $this->FieldType->setDbValueDef($rsnew, $this->FieldType->CurrentValue, false);

        // Ownership
        $this->Ownership->setDbValueDef($rsnew, $this->Ownership->CurrentValue, false);

        // SeedlingsAllocated
        $this->SeedlingsAllocated->setDbValueDef($rsnew, $this->SeedlingsAllocated->CurrentValue, false);

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->setDbValueDef($rsnew, $this->TreesPlantedEstimated->CurrentValue, false);

        // TreesPlantedVerified
        $this->TreesPlantedVerified->setDbValueDef($rsnew, $this->TreesPlantedVerified->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['ProvinceCode'])) { // ProvinceCode
            $this->ProvinceCode->setFormValue($row['ProvinceCode']);
        }
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->setFormValue($row['DistrictCode']);
        }
        if (isset($row['CampCode'])) { // CampCode
            $this->CampCode->setFormValue($row['CampCode']);
        }
        if (isset($row['VillageCode'])) { // VillageCode
            $this->VillageCode->setFormValue($row['VillageCode']);
        }
        if (isset($row['NRC'])) { // NRC
            $this->NRC->setFormValue($row['NRC']);
        }
        if (isset($row['FieldType'])) { // FieldType
            $this->FieldType->setFormValue($row['FieldType']);
        }
        if (isset($row['Ownership'])) { // Ownership
            $this->Ownership->setFormValue($row['Ownership']);
        }
        if (isset($row['SeedlingsAllocated'])) { // SeedlingsAllocated
            $this->SeedlingsAllocated->setFormValue($row['SeedlingsAllocated']);
        }
        if (isset($row['TreesPlantedEstimated'])) { // TreesPlantedEstimated
            $this->TreesPlantedEstimated->setFormValue($row['TreesPlantedEstimated']);
        }
        if (isset($row['TreesPlantedVerified'])) { // TreesPlantedVerified
            $this->TreesPlantedVerified->setFormValue($row['TreesPlantedVerified']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        // Hide foreign keys
        $masterTblVar = $this->getCurrentMasterTable();
        if ($masterTblVar == "farmer") {
            $masterTbl = Container("farmer");
            $this->NRC->Visible = false;
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
        }
        if ($masterTblVar == "village") {
            $masterTbl = Container("village");
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
            $this->VillageCode->Visible = false;
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_ProvinceCode":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_DistrictCode":
                    break;
                case "x_CampCode":
                    break;
                case "x_VillageCode":
                    break;
                case "x_NRC":
                    break;
                case "x_FieldType":
                    break;
                case "x_Ownership":
                    break;
                case "x_SourcesOfSeedlings":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }
}
