<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Table class for farm
 */
class Farm extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = true;
    public $ModalGridEdit = true;
    public $ModalMultiEdit = true;

    // Fields
    public $ProvinceCode;
    public $DistrictCode;
    public $CampCode;
    public $VillageCode;
    public $NRC;
    public $FarmNo;
    public $FarmerNo;
    public $FieldType;
    public $Ownership;
    public $SeedlingsAllocated;
    public $TreesPlantedEstimated;
    public $FarmSizeEstimated;
    public $FarmSizeVerified;
    public $TreesPlantedVerified;
    public $SourcesOfSeedlings;
    public $InspecationReport;
    public $ClearedLand;
    public $OldTrees;
    public $FarmSize;
    public $Latitude;
    public $Longitude;
    public $Coordinates;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "farm";
        $this->TableName = 'farm';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "farm";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = true; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);

        // ProvinceCode
        $this->ProvinceCode = new DbField(
            $this, // Table
            'x_ProvinceCode', // Variable name
            'ProvinceCode', // Name
            '`ProvinceCode`', // Expression
            '`ProvinceCode`', // Basic search expression
            3, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ProvinceCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ProvinceCode->addMethod("getSelectFilter", fn() => "`ProvinceCode` in (9)");
        $this->ProvinceCode->addMethod("getDefault", fn() => 0);
        $this->ProvinceCode->InputTextType = "text";
        $this->ProvinceCode->Raw = true;
        $this->ProvinceCode->IsForeignKey = true; // Foreign key field
        $this->ProvinceCode->Nullable = false; // NOT NULL field
        $this->ProvinceCode->Required = true; // Required field
        $this->ProvinceCode->setSelectMultiple(false); // Select one
        $this->ProvinceCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ProvinceCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ProvinceCode->UseFilter = true; // Table header filter
        $this->ProvinceCode->Lookup = new Lookup($this->ProvinceCode, 'province', true, 'ProvinceCode', ["ProvinceName","","",""], '', '', [], ["x_DistrictCode"], [], [], [], [], false, '', '', "`ProvinceName`");
        $this->ProvinceCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ProvinceCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ProvinceCode'] = &$this->ProvinceCode;

        // DistrictCode
        $this->DistrictCode = new DbField(
            $this, // Table
            'x_DistrictCode', // Variable name
            'DistrictCode', // Name
            '`DistrictCode`', // Expression
            '`DistrictCode`', // Basic search expression
            3, // Type
            2, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`DistrictCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->DistrictCode->addMethod("getDefault", fn() => 0);
        $this->DistrictCode->InputTextType = "text";
        $this->DistrictCode->Raw = true;
        $this->DistrictCode->IsForeignKey = true; // Foreign key field
        $this->DistrictCode->Nullable = false; // NOT NULL field
        $this->DistrictCode->Required = true; // Required field
        $this->DistrictCode->setSelectMultiple(false); // Select one
        $this->DistrictCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->DistrictCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->DistrictCode->UseFilter = true; // Table header filter
        $this->DistrictCode->Lookup = new Lookup($this->DistrictCode, 'district', true, 'DistrictCode', ["DistrictName","","",""], '', '', ["x_ProvinceCode"], ["x_CampCode"], ["ProvinceCode"], ["x_ProvinceCode"], [], [], false, '', '', "`DistrictName`");
        $this->DistrictCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->DistrictCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['DistrictCode'] = &$this->DistrictCode;

        // CampCode
        $this->CampCode = new DbField(
            $this, // Table
            'x_CampCode', // Variable name
            'CampCode', // Name
            '`CampCode`', // Expression
            '`CampCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`CampCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->CampCode->InputTextType = "text";
        $this->CampCode->Raw = true;
        $this->CampCode->IsForeignKey = true; // Foreign key field
        $this->CampCode->setSelectMultiple(false); // Select one
        $this->CampCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->CampCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->CampCode->UseFilter = true; // Table header filter
        $this->CampCode->Lookup = new Lookup($this->CampCode, 'camp', true, 'CampCode', ["CampName","","",""], '', '', ["x_DistrictCode"], ["x_VillageCode"], ["DistrictCode"], ["x_DistrictCode"], [], [], false, '', '', "`CampName`");
        $this->CampCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->CampCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['CampCode'] = &$this->CampCode;

        // VillageCode
        $this->VillageCode = new DbField(
            $this, // Table
            'x_VillageCode', // Variable name
            'VillageCode', // Name
            '`VillageCode`', // Expression
            '`VillageCode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`VillageCode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->VillageCode->InputTextType = "text";
        $this->VillageCode->Raw = true;
        $this->VillageCode->IsForeignKey = true; // Foreign key field
        $this->VillageCode->setSelectMultiple(false); // Select one
        $this->VillageCode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->VillageCode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->VillageCode->UseFilter = true; // Table header filter
        $this->VillageCode->Lookup = new Lookup($this->VillageCode, 'village', true, 'VillageCode', ["Village","","",""], '', '', ["x_CampCode"], [], ["CampCode"], ["x_CampCode"], [], [], false, '', '', "`Village`");
        $this->VillageCode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->VillageCode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['VillageCode'] = &$this->VillageCode;

        // NRC
        $this->NRC = new DbField(
            $this, // Table
            'x_NRC', // Variable name
            'NRC', // Name
            '`NRC`', // Expression
            '`NRC`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`NRC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->NRC->InputTextType = "text";
        $this->NRC->IsForeignKey = true; // Foreign key field
        $this->NRC->UseFilter = true; // Table header filter
        $this->NRC->Lookup = new Lookup($this->NRC, 'farmer', true, 'NRC', ["FarmerName","NRC","",""], '', '', [], [], [], [], [], [], false, '', '', "CONCAT(COALESCE(`FarmerName`, ''),'" . ValueSeparator(1, $this->NRC) . "',COALESCE(`NRC`,''))");
        $this->NRC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['NRC'] = &$this->NRC;

        // FarmNo
        $this->FarmNo = new DbField(
            $this, // Table
            'x_FarmNo', // Variable name
            'FarmNo', // Name
            '`FarmNo`', // Expression
            '`FarmNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->FarmNo->InputTextType = "text";
        $this->FarmNo->Raw = true;
        $this->FarmNo->IsAutoIncrement = true; // Autoincrement field
        $this->FarmNo->IsPrimaryKey = true; // Primary key field
        $this->FarmNo->IsForeignKey = true; // Foreign key field
        $this->FarmNo->Nullable = false; // NOT NULL field
        $this->FarmNo->UseFilter = true; // Table header filter
        $this->FarmNo->Lookup = new Lookup($this->FarmNo, 'farm', true, 'FarmNo', ["FarmNo","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->FarmNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['FarmNo'] = &$this->FarmNo;

        // FarmerNo
        $this->FarmerNo = new DbField(
            $this, // Table
            'x_FarmerNo', // Variable name
            'FarmerNo', // Name
            '`FarmerNo`', // Expression
            '`FarmerNo`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmerNo`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmerNo->InputTextType = "text";
        $this->FarmerNo->Raw = true;
        $this->FarmerNo->Nullable = false; // NOT NULL field
        $this->FarmerNo->Required = true; // Required field
        $this->FarmerNo->UseFilter = true; // Table header filter
        $this->FarmerNo->Lookup = new Lookup($this->FarmerNo, 'farm', true, 'FarmerNo', ["FarmerNo","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->FarmerNo->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FarmerNo->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['FarmerNo'] = &$this->FarmerNo;

        // FieldType
        $this->FieldType = new DbField(
            $this, // Table
            'x_FieldType', // Variable name
            'FieldType', // Name
            '`FieldType`', // Expression
            '`FieldType`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FieldType`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->FieldType->InputTextType = "text";
        $this->FieldType->Raw = true;
        $this->FieldType->setSelectMultiple(false); // Select one
        $this->FieldType->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->FieldType->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->FieldType->Lookup = new Lookup($this->FieldType, 'field_type', false, 'FieldType', ["FieldTypeName","","",""], '', '', [], [], [], [], [], [], false, '', '', "`FieldTypeName`");
        $this->FieldType->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->FieldType->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FieldType'] = &$this->FieldType;

        // Ownership
        $this->Ownership = new DbField(
            $this, // Table
            'x_Ownership', // Variable name
            'Ownership', // Name
            '`Ownership`', // Expression
            '`Ownership`', // Basic search expression
            16, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Ownership`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Ownership->InputTextType = "text";
        $this->Ownership->Raw = true;
        $this->Ownership->setSelectMultiple(false); // Select one
        $this->Ownership->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Ownership->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->Ownership->UseFilter = true; // Table header filter
        $this->Ownership->Lookup = new Lookup($this->Ownership, 'ownership', true, 'OwnershipType', ["Ownership","","",""], '', '', [], [], [], [], [], [], false, '', '', "`Ownership`");
        $this->Ownership->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Ownership->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Ownership'] = &$this->Ownership;

        // SeedlingsAllocated
        $this->SeedlingsAllocated = new DbField(
            $this, // Table
            'x_SeedlingsAllocated', // Variable name
            'SeedlingsAllocated', // Name
            '`SeedlingsAllocated`', // Expression
            '`SeedlingsAllocated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SeedlingsAllocated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->SeedlingsAllocated->InputTextType = "text";
        $this->SeedlingsAllocated->Raw = true;
        $this->SeedlingsAllocated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->SeedlingsAllocated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['SeedlingsAllocated'] = &$this->SeedlingsAllocated;

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated = new DbField(
            $this, // Table
            'x_TreesPlantedEstimated', // Variable name
            'TreesPlantedEstimated', // Name
            '`TreesPlantedEstimated`', // Expression
            '`TreesPlantedEstimated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesPlantedEstimated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesPlantedEstimated->InputTextType = "text";
        $this->TreesPlantedEstimated->Raw = true;
        $this->TreesPlantedEstimated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->TreesPlantedEstimated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['TreesPlantedEstimated'] = &$this->TreesPlantedEstimated;

        // FarmSizeEstimated
        $this->FarmSizeEstimated = new DbField(
            $this, // Table
            'x_FarmSizeEstimated', // Variable name
            'FarmSizeEstimated', // Name
            '`FarmSizeEstimated`', // Expression
            '`FarmSizeEstimated`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSizeEstimated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSizeEstimated->InputTextType = "text";
        $this->FarmSizeEstimated->Raw = true;
        $this->FarmSizeEstimated->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FarmSizeEstimated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmSizeEstimated'] = &$this->FarmSizeEstimated;

        // FarmSizeVerified
        $this->FarmSizeVerified = new DbField(
            $this, // Table
            'x_FarmSizeVerified', // Variable name
            'FarmSizeVerified', // Name
            '`FarmSizeVerified`', // Expression
            '`FarmSizeVerified`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSizeVerified`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSizeVerified->InputTextType = "text";
        $this->FarmSizeVerified->Raw = true;
        $this->FarmSizeVerified->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->FarmSizeVerified->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmSizeVerified'] = &$this->FarmSizeVerified;

        // TreesPlantedVerified
        $this->TreesPlantedVerified = new DbField(
            $this, // Table
            'x_TreesPlantedVerified', // Variable name
            'TreesPlantedVerified', // Name
            '`TreesPlantedVerified`', // Expression
            '`TreesPlantedVerified`', // Basic search expression
            5, // Type
            22, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`TreesPlantedVerified`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->TreesPlantedVerified->InputTextType = "text";
        $this->TreesPlantedVerified->Raw = true;
        $this->TreesPlantedVerified->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->TreesPlantedVerified->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['TreesPlantedVerified'] = &$this->TreesPlantedVerified;

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings = new DbField(
            $this, // Table
            'x_SourcesOfSeedlings', // Variable name
            'SourcesOfSeedlings', // Name
            '`SourcesOfSeedlings`', // Expression
            '`SourcesOfSeedlings`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`SourcesOfSeedlings`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->SourcesOfSeedlings->InputTextType = "text";
        $this->SourcesOfSeedlings->Raw = true;
        $this->SourcesOfSeedlings->setSelectMultiple(false); // Select one
        $this->SourcesOfSeedlings->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->SourcesOfSeedlings->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->SourcesOfSeedlings->Lookup = new Lookup($this->SourcesOfSeedlings, 'nursery', false, 'NurseryCode', ["NurseryName","","",""], '', '', [], [], [], [], [], [], false, '', '', "`NurseryName`");
        $this->SourcesOfSeedlings->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->SourcesOfSeedlings->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['SourcesOfSeedlings'] = &$this->SourcesOfSeedlings;

        // InspecationReport
        $this->InspecationReport = new DbField(
            $this, // Table
            'x_InspecationReport', // Variable name
            'InspecationReport', // Name
            '`InspecationReport`', // Expression
            '`InspecationReport`', // Basic search expression
            201, // Type
            2147483647, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`InspecationReport`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->InspecationReport->InputTextType = "text";
        $this->InspecationReport->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['InspecationReport'] = &$this->InspecationReport;

        // ClearedLand
        $this->ClearedLand = new DbField(
            $this, // Table
            'x_ClearedLand', // Variable name
            'ClearedLand', // Name
            '`ClearedLand`', // Expression
            '`ClearedLand`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ClearedLand`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ClearedLand->InputTextType = "text";
        $this->ClearedLand->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ClearedLand'] = &$this->ClearedLand;

        // OldTrees
        $this->OldTrees = new DbField(
            $this, // Table
            'x_OldTrees', // Variable name
            'OldTrees', // Name
            '`OldTrees`', // Expression
            '`OldTrees`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`OldTrees`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->OldTrees->InputTextType = "text";
        $this->OldTrees->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['OldTrees'] = &$this->OldTrees;

        // FarmSize
        $this->FarmSize = new DbField(
            $this, // Table
            'x_FarmSize', // Variable name
            'FarmSize', // Name
            '`FarmSize`', // Expression
            '`FarmSize`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`FarmSize`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->FarmSize->InputTextType = "text";
        $this->FarmSize->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['FarmSize'] = &$this->FarmSize;

        // Latitude
        $this->Latitude = new DbField(
            $this, // Table
            'x_Latitude', // Variable name
            'Latitude', // Name
            '`Latitude`', // Expression
            '`Latitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Latitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Latitude->InputTextType = "text";
        $this->Latitude->Raw = true;
        $this->Latitude->Nullable = false; // NOT NULL field
        $this->Latitude->Required = true; // Required field
        $this->Latitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Latitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Latitude'] = &$this->Latitude;

        // Longitude
        $this->Longitude = new DbField(
            $this, // Table
            'x_Longitude', // Variable name
            'Longitude', // Name
            '`Longitude`', // Expression
            '`Longitude`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Longitude`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Longitude->InputTextType = "text";
        $this->Longitude->Raw = true;
        $this->Longitude->Nullable = false; // NOT NULL field
        $this->Longitude->Required = true; // Required field
        $this->Longitude->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Longitude->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Longitude'] = &$this->Longitude;

        // Coordinates
        $this->Coordinates = new DbField(
            $this, // Table
            'x_Coordinates', // Variable name
            'Coordinates', // Name
            '`Coordinates`', // Expression
            '`Coordinates`', // Basic search expression
            200, // Type
            0, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Coordinates`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Coordinates->InputTextType = "text";
        $this->Coordinates->Raw = true;
        $this->Coordinates->CustomDataType = new GeometryType();
        $this->Coordinates->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Coordinates'] = &$this->Coordinates;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current master table name
    public function getCurrentMasterTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE"));
    }

    public function setCurrentMasterTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
    }

    // Get master WHERE clause from session values
    public function getMasterFilterFromSession()
    {
        // Master filter
        $masterFilter = "";
        if ($this->getCurrentMasterTable() == "farmer") {
            $masterTable = Container("farmer");
            if ($this->NRC->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->NRC, $this->NRC->getSessionValue(), $masterTable->NRC->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        if ($this->getCurrentMasterTable() == "village") {
            $masterTable = Container("village");
            if ($this->ProvinceCode->getSessionValue() != "") {
                $masterFilter .= "" . GetKeyFilter($masterTable->ProvinceCode, $this->ProvinceCode->getSessionValue(), $masterTable->ProvinceCode->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->DistrictCode->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->DistrictCode, $this->DistrictCode->getSessionValue(), $masterTable->DistrictCode->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->CampCode->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->CampCode, $this->CampCode->getSessionValue(), $masterTable->CampCode->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
            if ($this->VillageCode->getSessionValue() != "") {
                $masterFilter .= " AND " . GetKeyFilter($masterTable->VillageCode, $this->VillageCode->getSessionValue(), $masterTable->VillageCode->DataType, $masterTable->Dbid);
            } else {
                return "";
            }
        }
        return $masterFilter;
    }

    // Get detail WHERE clause from session values
    public function getDetailFilterFromSession()
    {
        // Detail filter
        $detailFilter = "";
        if ($this->getCurrentMasterTable() == "farmer") {
            $masterTable = Container("farmer");
            if ($this->NRC->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->NRC, $this->NRC->getSessionValue(), $masterTable->NRC->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        if ($this->getCurrentMasterTable() == "village") {
            $masterTable = Container("village");
            if ($this->ProvinceCode->getSessionValue() != "") {
                $detailFilter .= "" . GetKeyFilter($this->ProvinceCode, $this->ProvinceCode->getSessionValue(), $masterTable->ProvinceCode->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->DistrictCode->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->DistrictCode, $this->DistrictCode->getSessionValue(), $masterTable->DistrictCode->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->CampCode->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->CampCode, $this->CampCode->getSessionValue(), $masterTable->CampCode->DataType, $this->Dbid);
            } else {
                return "";
            }
            if ($this->VillageCode->getSessionValue() != "") {
                $detailFilter .= " AND " . GetKeyFilter($this->VillageCode, $this->VillageCode->getSessionValue(), $masterTable->VillageCode->DataType, $this->Dbid);
            } else {
                return "";
            }
        }
        return $detailFilter;
    }

    /**
     * Get master filter
     *
     * @param object $masterTable Master Table
     * @param array $keys Detail Keys
     * @return mixed NULL is returned if all keys are empty, Empty string is returned if some keys are empty and is required
     */
    public function getMasterFilter($masterTable, $keys)
    {
        $validKeys = true;
        switch ($masterTable->TableVar) {
            case "farmer":
                $key = $keys["NRC"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->NRC->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->NRC, $keys["NRC"], $this->NRC->DataType, $this->Dbid);
                }
                break;
            case "village":
                $key = $keys["ProvinceCode"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->ProvinceCode->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["DistrictCode"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->DistrictCode->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["CampCode"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->CampCode->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                $key = $keys["VillageCode"] ?? "";
                if (EmptyValue($key)) {
                    if ($masterTable->VillageCode->Required) { // Required field and empty value
                        return ""; // Return empty filter
                    }
                    $validKeys = false;
                } elseif (!$validKeys) { // Already has empty key
                    return ""; // Return empty filter
                }
                if ($validKeys) {
                    return GetKeyFilter($masterTable->ProvinceCode, $keys["ProvinceCode"], $this->ProvinceCode->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->DistrictCode, $keys["DistrictCode"], $this->DistrictCode->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->CampCode, $keys["CampCode"], $this->CampCode->DataType, $this->Dbid) . " AND " . GetKeyFilter($masterTable->VillageCode, $keys["VillageCode"], $this->VillageCode->DataType, $this->Dbid);
                }
                break;
        }
        return null; // All null values and no required fields
    }

    // Get detail filter
    public function getDetailFilter($masterTable)
    {
        switch ($masterTable->TableVar) {
            case "farmer":
                return GetKeyFilter($this->NRC, $masterTable->NRC->DbValue, $masterTable->NRC->DataType, $masterTable->Dbid);
            case "village":
                return GetKeyFilter($this->ProvinceCode, $masterTable->ProvinceCode->DbValue, $masterTable->ProvinceCode->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->DistrictCode, $masterTable->DistrictCode->DbValue, $masterTable->DistrictCode->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->CampCode, $masterTable->CampCode->DbValue, $masterTable->CampCode->DataType, $masterTable->Dbid) . " AND " . GetKeyFilter($this->VillageCode, $masterTable->VillageCode->DbValue, $masterTable->VillageCode->DataType, $masterTable->Dbid);
        }
        return "";
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")) ?? "";
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "farm_seed_allocate") {
            $detailUrl = Container("farm_seed_allocate")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_ProvinceCode", $this->ProvinceCode->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_DistrictCode", $this->DistrictCode->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_CampCode", $this->CampCode->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_VillageCode", $this->VillageCode->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_FarmNo", $this->FarmNo->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "farm_inspection") {
            $detailUrl = Container("farm_inspection")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_ProvinceCode", $this->ProvinceCode->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_DistrictCode", $this->DistrictCode->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_CampCode", $this->CampCode->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_VillageCode", $this->VillageCode->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_NRC", $this->NRC->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_FarmNo", $this->FarmNo->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "production_sales") {
            $detailUrl = Container("production_sales")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_FarmNo", $this->FarmNo->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_NRC", $this->NRC->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "FarmList";
        }
        return $detailUrl;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "farm";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "`ProvinceCode`= 9";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->FarmNo->setDbValue($conn->lastInsertId());
            $rs['FarmNo'] = $this->FarmNo->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['FarmNo']) && !EmptyValue($this->FarmNo->CurrentValue)) {
                $rs['FarmNo'] = $this->FarmNo->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'FarmNo';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('FarmNo', $rs)) {
                AddFilter($where, QuotedName('FarmNo', $this->Dbid) . '=' . QuotedValue($rs['FarmNo'], $this->FarmNo->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->ProvinceCode->DbValue = $row['ProvinceCode'];
        $this->DistrictCode->DbValue = $row['DistrictCode'];
        $this->CampCode->DbValue = $row['CampCode'];
        $this->VillageCode->DbValue = $row['VillageCode'];
        $this->NRC->DbValue = $row['NRC'];
        $this->FarmNo->DbValue = $row['FarmNo'];
        $this->FarmerNo->DbValue = $row['FarmerNo'];
        $this->FieldType->DbValue = $row['FieldType'];
        $this->Ownership->DbValue = $row['Ownership'];
        $this->SeedlingsAllocated->DbValue = $row['SeedlingsAllocated'];
        $this->TreesPlantedEstimated->DbValue = $row['TreesPlantedEstimated'];
        $this->FarmSizeEstimated->DbValue = $row['FarmSizeEstimated'];
        $this->FarmSizeVerified->DbValue = $row['FarmSizeVerified'];
        $this->TreesPlantedVerified->DbValue = $row['TreesPlantedVerified'];
        $this->SourcesOfSeedlings->DbValue = $row['SourcesOfSeedlings'];
        $this->InspecationReport->DbValue = $row['InspecationReport'];
        $this->ClearedLand->DbValue = $row['ClearedLand'];
        $this->OldTrees->DbValue = $row['OldTrees'];
        $this->FarmSize->DbValue = $row['FarmSize'];
        $this->Latitude->DbValue = $row['Latitude'];
        $this->Longitude->DbValue = $row['Longitude'];
        $this->Coordinates->DbValue = $row['Coordinates'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`FarmNo` = @FarmNo@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->FarmNo->CurrentValue : $this->FarmNo->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->FarmNo->CurrentValue = $keys[0];
            } else {
                $this->FarmNo->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('FarmNo', $row) ? $row['FarmNo'] : null;
        } else {
            $val = !EmptyValue($this->FarmNo->OldValue) && !$current ? $this->FarmNo->OldValue : $this->FarmNo->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@FarmNo@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("FarmList");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "FarmView" => $Language->phrase("View"),
            "FarmEdit" => $Language->phrase("Edit"),
            "FarmAdd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "FarmList";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "FarmView",
            Config("API_ADD_ACTION") => "FarmAdd",
            Config("API_EDIT_ACTION") => "FarmEdit",
            Config("API_DELETE_ACTION") => "FarmDelete",
            Config("API_LIST_ACTION") => "FarmList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "FarmList";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("FarmView", $parm);
        } else {
            $url = $this->keyUrl("FarmView", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "FarmAdd?" . $parm;
        } else {
            $url = "FarmAdd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("FarmEdit", $parm);
        } else {
            $url = $this->keyUrl("FarmEdit", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("FarmList", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("FarmAdd", $parm);
        } else {
            $url = $this->keyUrl("FarmAdd", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("FarmList", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("FarmDelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        if ($this->getCurrentMasterTable() == "farmer" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_NRC", $this->NRC->getSessionValue()); // Use Session Value
        }
        if ($this->getCurrentMasterTable() == "village" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
            $url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
            $url .= "&" . GetForeignKeyUrl("fk_ProvinceCode", $this->ProvinceCode->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_DistrictCode", $this->DistrictCode->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_CampCode", $this->CampCode->getSessionValue()); // Use Session Value
            $url .= "&" . GetForeignKeyUrl("fk_VillageCode", $this->VillageCode->getSessionValue()); // Use Session Value
        }
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"FarmNo\":" . VarToJson($this->FarmNo->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->FarmNo->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->FarmNo->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="1"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("FarmNo") ?? Route("FarmNo")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->FarmNo->CurrentValue = $key;
            } else {
                $this->FarmNo->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->ProvinceCode->setDbValue($row['ProvinceCode']);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmNo->setDbValue($row['FarmNo']);
        $this->FarmerNo->setDbValue($row['FarmerNo']);
        $this->FieldType->setDbValue($row['FieldType']);
        $this->Ownership->setDbValue($row['Ownership']);
        $this->SeedlingsAllocated->setDbValue($row['SeedlingsAllocated']);
        $this->TreesPlantedEstimated->setDbValue($row['TreesPlantedEstimated']);
        $this->FarmSizeEstimated->setDbValue($row['FarmSizeEstimated']);
        $this->FarmSizeVerified->setDbValue($row['FarmSizeVerified']);
        $this->TreesPlantedVerified->setDbValue($row['TreesPlantedVerified']);
        $this->SourcesOfSeedlings->setDbValue($row['SourcesOfSeedlings']);
        $this->InspecationReport->setDbValue($row['InspecationReport']);
        $this->ClearedLand->setDbValue($row['ClearedLand']);
        $this->OldTrees->setDbValue($row['OldTrees']);
        $this->FarmSize->setDbValue($row['FarmSize']);
        $this->Latitude->setDbValue($row['Latitude']);
        $this->Longitude->setDbValue($row['Longitude']);
        $this->Coordinates->setDbValue($row['Coordinates']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "FarmList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // ProvinceCode

        // DistrictCode

        // CampCode

        // VillageCode

        // NRC

        // FarmNo

        // FarmerNo

        // FieldType

        // Ownership

        // SeedlingsAllocated

        // TreesPlantedEstimated

        // FarmSizeEstimated

        // FarmSizeVerified

        // TreesPlantedVerified

        // SourcesOfSeedlings

        // InspecationReport

        // ClearedLand

        // OldTrees

        // FarmSize

        // Latitude

        // Longitude

        // Coordinates

        // ProvinceCode
        $curVal = strval($this->ProvinceCode->CurrentValue);
        if ($curVal != "") {
            $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
            if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                } else {
                    $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                }
            }
        } else {
            $this->ProvinceCode->ViewValue = null;
        }

        // DistrictCode
        $curVal = strval($this->DistrictCode->CurrentValue);
        if ($curVal != "") {
            $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
            if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                    $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                } else {
                    $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                }
            }
        } else {
            $this->DistrictCode->ViewValue = null;
        }

        // CampCode
        $curVal = strval($this->CampCode->CurrentValue);
        if ($curVal != "") {
            $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
            if ($this->CampCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                    $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                } else {
                    $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                }
            }
        } else {
            $this->CampCode->ViewValue = null;
        }

        // VillageCode
        $curVal = strval($this->VillageCode->CurrentValue);
        if ($curVal != "") {
            $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
            if ($this->VillageCode->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                    $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                } else {
                    $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                }
            }
        } else {
            $this->VillageCode->ViewValue = null;
        }

        // NRC
        $this->NRC->ViewValue = $this->NRC->CurrentValue;
        $curVal = strval($this->NRC->CurrentValue);
        if ($curVal != "") {
            $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
            if ($this->NRC->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                    $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                } else {
                    $this->NRC->ViewValue = $this->NRC->CurrentValue;
                }
            }
        } else {
            $this->NRC->ViewValue = null;
        }

        // FarmNo
        $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;

        // FarmerNo
        $this->FarmerNo->ViewValue = $this->FarmerNo->CurrentValue;

        // FieldType
        $curVal = strval($this->FieldType->CurrentValue);
        if ($curVal != "") {
            $this->FieldType->ViewValue = $this->FieldType->lookupCacheOption($curVal);
            if ($this->FieldType->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchExpression(), "=", $curVal, $this->FieldType->Lookup->getTable()->Fields["FieldType"]->searchDataType(), "");
                $sqlWrk = $this->FieldType->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->FieldType->Lookup->renderViewRow($rswrk[0]);
                    $this->FieldType->ViewValue = $this->FieldType->displayValue($arwrk);
                } else {
                    $this->FieldType->ViewValue = $this->FieldType->CurrentValue;
                }
            }
        } else {
            $this->FieldType->ViewValue = null;
        }

        // Ownership
        $curVal = strval($this->Ownership->CurrentValue);
        if ($curVal != "") {
            $this->Ownership->ViewValue = $this->Ownership->lookupCacheOption($curVal);
            if ($this->Ownership->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchExpression(), "=", $curVal, $this->Ownership->Lookup->getTable()->Fields["OwnershipType"]->searchDataType(), "");
                $sqlWrk = $this->Ownership->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->Ownership->Lookup->renderViewRow($rswrk[0]);
                    $this->Ownership->ViewValue = $this->Ownership->displayValue($arwrk);
                } else {
                    $this->Ownership->ViewValue = $this->Ownership->CurrentValue;
                }
            }
        } else {
            $this->Ownership->ViewValue = null;
        }

        // SeedlingsAllocated
        $this->SeedlingsAllocated->ViewValue = $this->SeedlingsAllocated->CurrentValue;
        $this->SeedlingsAllocated->ViewValue = FormatNumber($this->SeedlingsAllocated->ViewValue, $this->SeedlingsAllocated->formatPattern());

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->ViewValue = $this->TreesPlantedEstimated->CurrentValue;
        $this->TreesPlantedEstimated->ViewValue = FormatNumber($this->TreesPlantedEstimated->ViewValue, $this->TreesPlantedEstimated->formatPattern());

        // FarmSizeEstimated
        $this->FarmSizeEstimated->ViewValue = $this->FarmSizeEstimated->CurrentValue;
        $this->FarmSizeEstimated->ViewValue = FormatNumber($this->FarmSizeEstimated->ViewValue, $this->FarmSizeEstimated->formatPattern());

        // FarmSizeVerified
        $this->FarmSizeVerified->ViewValue = $this->FarmSizeVerified->CurrentValue;
        $this->FarmSizeVerified->ViewValue = FormatNumber($this->FarmSizeVerified->ViewValue, $this->FarmSizeVerified->formatPattern());

        // TreesPlantedVerified
        $this->TreesPlantedVerified->ViewValue = $this->TreesPlantedVerified->CurrentValue;
        $this->TreesPlantedVerified->ViewValue = FormatNumber($this->TreesPlantedVerified->ViewValue, $this->TreesPlantedVerified->formatPattern());

        // SourcesOfSeedlings
        $curVal = strval($this->SourcesOfSeedlings->CurrentValue);
        if ($curVal != "") {
            $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->lookupCacheOption($curVal);
            if ($this->SourcesOfSeedlings->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                $sqlWrk = $this->SourcesOfSeedlings->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->SourcesOfSeedlings->Lookup->renderViewRow($rswrk[0]);
                    $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->displayValue($arwrk);
                } else {
                    $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;
                }
            }
        } else {
            $this->SourcesOfSeedlings->ViewValue = null;
        }

        // InspecationReport
        $this->InspecationReport->ViewValue = $this->InspecationReport->CurrentValue;

        // ClearedLand
        $this->ClearedLand->ViewValue = $this->ClearedLand->CurrentValue;

        // OldTrees
        $this->OldTrees->ViewValue = $this->OldTrees->CurrentValue;

        // FarmSize
        $this->FarmSize->ViewValue = $this->FarmSize->CurrentValue;

        // Latitude
        $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
        $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());

        // Longitude
        $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
        $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());

        // Coordinates
        $this->Coordinates->ViewValue = $this->Coordinates->CurrentValue;

        // ProvinceCode
        $this->ProvinceCode->HrefValue = "";
        $this->ProvinceCode->TooltipValue = "";

        // DistrictCode
        $this->DistrictCode->HrefValue = "";
        $this->DistrictCode->TooltipValue = "";

        // CampCode
        $this->CampCode->HrefValue = "";
        $this->CampCode->TooltipValue = "";

        // VillageCode
        $this->VillageCode->HrefValue = "";
        $this->VillageCode->TooltipValue = "";

        // NRC
        $this->NRC->HrefValue = "";
        $this->NRC->TooltipValue = "";

        // FarmNo
        $this->FarmNo->HrefValue = "";
        $this->FarmNo->TooltipValue = "";

        // FarmerNo
        $this->FarmerNo->HrefValue = "";
        $this->FarmerNo->TooltipValue = "";

        // FieldType
        $this->FieldType->HrefValue = "";
        $this->FieldType->TooltipValue = "";

        // Ownership
        $this->Ownership->HrefValue = "";
        $this->Ownership->TooltipValue = "";

        // SeedlingsAllocated
        $this->SeedlingsAllocated->HrefValue = "";
        $this->SeedlingsAllocated->TooltipValue = "";

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->HrefValue = "";
        $this->TreesPlantedEstimated->TooltipValue = "";

        // FarmSizeEstimated
        $this->FarmSizeEstimated->HrefValue = "";
        $this->FarmSizeEstimated->TooltipValue = "";

        // FarmSizeVerified
        $this->FarmSizeVerified->HrefValue = "";
        $this->FarmSizeVerified->TooltipValue = "";

        // TreesPlantedVerified
        $this->TreesPlantedVerified->HrefValue = "";
        $this->TreesPlantedVerified->TooltipValue = "";

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->HrefValue = "";
        $this->SourcesOfSeedlings->TooltipValue = "";

        // InspecationReport
        $this->InspecationReport->HrefValue = "";
        $this->InspecationReport->TooltipValue = "";

        // ClearedLand
        $this->ClearedLand->HrefValue = "";
        $this->ClearedLand->TooltipValue = "";

        // OldTrees
        $this->OldTrees->HrefValue = "";
        $this->OldTrees->TooltipValue = "";

        // FarmSize
        $this->FarmSize->HrefValue = "";
        $this->FarmSize->TooltipValue = "";

        // Latitude
        $this->Latitude->HrefValue = "";
        $this->Latitude->TooltipValue = "";

        // Longitude
        $this->Longitude->HrefValue = "";
        $this->Longitude->TooltipValue = "";

        // Coordinates
        $this->Coordinates->HrefValue = "";
        $this->Coordinates->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // ProvinceCode
        $this->ProvinceCode->setupEditAttributes();
        if ($this->ProvinceCode->getSessionValue() != "") {
            $this->ProvinceCode->CurrentValue = GetForeignKeyValue($this->ProvinceCode->getSessionValue());
            $curVal = strval($this->ProvinceCode->CurrentValue);
            if ($curVal != "") {
                $this->ProvinceCode->ViewValue = $this->ProvinceCode->lookupCacheOption($curVal);
                if ($this->ProvinceCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchExpression(), "=", $curVal, $this->ProvinceCode->Lookup->getTable()->Fields["ProvinceCode"]->searchDataType(), "");
                    $lookupFilter = $this->ProvinceCode->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProvinceCode->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProvinceCode->Lookup->renderViewRow($rswrk[0]);
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->displayValue($arwrk);
                    } else {
                        $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
                    }
                }
            } else {
                $this->ProvinceCode->ViewValue = null;
            }
        } else {
            $this->ProvinceCode->PlaceHolder = RemoveHtml($this->ProvinceCode->caption());
        }

        // DistrictCode
        $this->DistrictCode->setupEditAttributes();
        if ($this->DistrictCode->getSessionValue() != "") {
            $this->DistrictCode->CurrentValue = GetForeignKeyValue($this->DistrictCode->getSessionValue());
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }
        } else {
            $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());
        }

        // CampCode
        $this->CampCode->setupEditAttributes();
        if ($this->CampCode->getSessionValue() != "") {
            $this->CampCode->CurrentValue = GetForeignKeyValue($this->CampCode->getSessionValue());
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }
        } else {
            $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());
        }

        // VillageCode
        $this->VillageCode->setupEditAttributes();
        if ($this->VillageCode->getSessionValue() != "") {
            $this->VillageCode->CurrentValue = GetForeignKeyValue($this->VillageCode->getSessionValue());
            $curVal = strval($this->VillageCode->CurrentValue);
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                if ($this->VillageCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                    }
                }
            } else {
                $this->VillageCode->ViewValue = null;
            }
        } else {
            $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());
        }

        // NRC
        $this->NRC->setupEditAttributes();
        if ($this->NRC->getSessionValue() != "") {
            $this->NRC->CurrentValue = GetForeignKeyValue($this->NRC->getSessionValue());
            $this->NRC->ViewValue = $this->NRC->CurrentValue;
            $curVal = strval($this->NRC->CurrentValue);
            if ($curVal != "") {
                $this->NRC->ViewValue = $this->NRC->lookupCacheOption($curVal);
                if ($this->NRC->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->NRC->Lookup->getTable()->Fields["NRC"]->searchExpression(), "=", $curVal, $this->NRC->Lookup->getTable()->Fields["NRC"]->searchDataType(), "");
                    $sqlWrk = $this->NRC->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->NRC->Lookup->renderViewRow($rswrk[0]);
                        $this->NRC->ViewValue = $this->NRC->displayValue($arwrk);
                    } else {
                        $this->NRC->ViewValue = $this->NRC->CurrentValue;
                    }
                }
            } else {
                $this->NRC->ViewValue = null;
            }
        } else {
            if (!$this->NRC->Raw) {
                $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
            }
            $this->NRC->EditValue = $this->NRC->CurrentValue;
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());
        }

        // FarmNo
        $this->FarmNo->setupEditAttributes();
        $this->FarmNo->EditValue = $this->FarmNo->CurrentValue;

        // FarmerNo
        $this->FarmerNo->setupEditAttributes();
        $this->FarmerNo->EditValue = $this->FarmerNo->CurrentValue;
        $this->FarmerNo->PlaceHolder = RemoveHtml($this->FarmerNo->caption());
        if (strval($this->FarmerNo->EditValue) != "" && is_numeric($this->FarmerNo->EditValue)) {
            $this->FarmerNo->EditValue = $this->FarmerNo->EditValue;
        }

        // FieldType
        $this->FieldType->setupEditAttributes();
        $this->FieldType->PlaceHolder = RemoveHtml($this->FieldType->caption());

        // Ownership
        $this->Ownership->setupEditAttributes();
        $this->Ownership->PlaceHolder = RemoveHtml($this->Ownership->caption());

        // SeedlingsAllocated
        $this->SeedlingsAllocated->setupEditAttributes();
        $this->SeedlingsAllocated->EditValue = $this->SeedlingsAllocated->CurrentValue;
        $this->SeedlingsAllocated->EditValue = FormatNumber($this->SeedlingsAllocated->EditValue, $this->SeedlingsAllocated->formatPattern());

        // TreesPlantedEstimated
        $this->TreesPlantedEstimated->setupEditAttributes();
        $this->TreesPlantedEstimated->EditValue = $this->TreesPlantedEstimated->CurrentValue;
        $this->TreesPlantedEstimated->PlaceHolder = RemoveHtml($this->TreesPlantedEstimated->caption());
        if (strval($this->TreesPlantedEstimated->EditValue) != "" && is_numeric($this->TreesPlantedEstimated->EditValue)) {
            $this->TreesPlantedEstimated->EditValue = FormatNumber($this->TreesPlantedEstimated->EditValue, null);
        }

        // FarmSizeEstimated
        $this->FarmSizeEstimated->setupEditAttributes();
        $this->FarmSizeEstimated->EditValue = $this->FarmSizeEstimated->CurrentValue;
        $this->FarmSizeEstimated->PlaceHolder = RemoveHtml($this->FarmSizeEstimated->caption());
        if (strval($this->FarmSizeEstimated->EditValue) != "" && is_numeric($this->FarmSizeEstimated->EditValue)) {
            $this->FarmSizeEstimated->EditValue = FormatNumber($this->FarmSizeEstimated->EditValue, null);
        }

        // FarmSizeVerified
        $this->FarmSizeVerified->setupEditAttributes();
        $this->FarmSizeVerified->EditValue = $this->FarmSizeVerified->CurrentValue;
        $this->FarmSizeVerified->PlaceHolder = RemoveHtml($this->FarmSizeVerified->caption());
        if (strval($this->FarmSizeVerified->EditValue) != "" && is_numeric($this->FarmSizeVerified->EditValue)) {
            $this->FarmSizeVerified->EditValue = FormatNumber($this->FarmSizeVerified->EditValue, null);
        }

        // TreesPlantedVerified
        $this->TreesPlantedVerified->setupEditAttributes();
        $this->TreesPlantedVerified->EditValue = $this->TreesPlantedVerified->CurrentValue;
        $this->TreesPlantedVerified->PlaceHolder = RemoveHtml($this->TreesPlantedVerified->caption());
        if (strval($this->TreesPlantedVerified->EditValue) != "" && is_numeric($this->TreesPlantedVerified->EditValue)) {
            $this->TreesPlantedVerified->EditValue = FormatNumber($this->TreesPlantedVerified->EditValue, null);
        }

        // SourcesOfSeedlings
        $this->SourcesOfSeedlings->setupEditAttributes();
        $curVal = strval($this->SourcesOfSeedlings->CurrentValue);
        if ($curVal != "") {
            $this->SourcesOfSeedlings->EditValue = $this->SourcesOfSeedlings->lookupCacheOption($curVal);
            if ($this->SourcesOfSeedlings->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SourcesOfSeedlings->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                $sqlWrk = $this->SourcesOfSeedlings->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->SourcesOfSeedlings->Lookup->renderViewRow($rswrk[0]);
                    $this->SourcesOfSeedlings->EditValue = $this->SourcesOfSeedlings->displayValue($arwrk);
                } else {
                    $this->SourcesOfSeedlings->EditValue = $this->SourcesOfSeedlings->CurrentValue;
                }
            }
        } else {
            $this->SourcesOfSeedlings->EditValue = null;
        }

        // InspecationReport
        $this->InspecationReport->setupEditAttributes();
        $this->InspecationReport->EditValue = $this->InspecationReport->CurrentValue;
        $this->InspecationReport->PlaceHolder = RemoveHtml($this->InspecationReport->caption());

        // ClearedLand
        $this->ClearedLand->setupEditAttributes();
        if (!$this->ClearedLand->Raw) {
            $this->ClearedLand->CurrentValue = HtmlDecode($this->ClearedLand->CurrentValue);
        }
        $this->ClearedLand->EditValue = $this->ClearedLand->CurrentValue;
        $this->ClearedLand->PlaceHolder = RemoveHtml($this->ClearedLand->caption());

        // OldTrees
        $this->OldTrees->setupEditAttributes();
        if (!$this->OldTrees->Raw) {
            $this->OldTrees->CurrentValue = HtmlDecode($this->OldTrees->CurrentValue);
        }
        $this->OldTrees->EditValue = $this->OldTrees->CurrentValue;
        $this->OldTrees->PlaceHolder = RemoveHtml($this->OldTrees->caption());

        // FarmSize
        $this->FarmSize->setupEditAttributes();
        if (!$this->FarmSize->Raw) {
            $this->FarmSize->CurrentValue = HtmlDecode($this->FarmSize->CurrentValue);
        }
        $this->FarmSize->EditValue = $this->FarmSize->CurrentValue;
        $this->FarmSize->PlaceHolder = RemoveHtml($this->FarmSize->caption());

        // Latitude
        $this->Latitude->setupEditAttributes();
        $this->Latitude->EditValue = $this->Latitude->CurrentValue;
        $this->Latitude->PlaceHolder = RemoveHtml($this->Latitude->caption());
        if (strval($this->Latitude->EditValue) != "" && is_numeric($this->Latitude->EditValue)) {
            $this->Latitude->EditValue = FormatNumber($this->Latitude->EditValue, null);
        }

        // Longitude
        $this->Longitude->setupEditAttributes();
        $this->Longitude->EditValue = $this->Longitude->CurrentValue;
        $this->Longitude->PlaceHolder = RemoveHtml($this->Longitude->caption());
        if (strval($this->Longitude->EditValue) != "" && is_numeric($this->Longitude->EditValue)) {
            $this->Longitude->EditValue = FormatNumber($this->Longitude->EditValue, null);
        }

        // Coordinates
        $this->Coordinates->setupEditAttributes();
        if (!$this->Coordinates->Raw) {
            $this->Coordinates->CurrentValue = HtmlDecode($this->Coordinates->CurrentValue);
        }
        $this->Coordinates->EditValue = $this->Coordinates->CurrentValue;
        $this->Coordinates->PlaceHolder = RemoveHtml($this->Coordinates->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmNo);
                    $doc->exportCaption($this->FieldType);
                    $doc->exportCaption($this->Ownership);
                    $doc->exportCaption($this->SeedlingsAllocated);
                    $doc->exportCaption($this->TreesPlantedEstimated);
                    $doc->exportCaption($this->FarmSizeEstimated);
                    $doc->exportCaption($this->FarmSizeVerified);
                    $doc->exportCaption($this->TreesPlantedVerified);
                    $doc->exportCaption($this->SourcesOfSeedlings);
                    $doc->exportCaption($this->InspecationReport);
                    $doc->exportCaption($this->ClearedLand);
                    $doc->exportCaption($this->OldTrees);
                    $doc->exportCaption($this->FarmSize);
                    $doc->exportCaption($this->Latitude);
                    $doc->exportCaption($this->Longitude);
                } else {
                    $doc->exportCaption($this->ProvinceCode);
                    $doc->exportCaption($this->DistrictCode);
                    $doc->exportCaption($this->CampCode);
                    $doc->exportCaption($this->VillageCode);
                    $doc->exportCaption($this->NRC);
                    $doc->exportCaption($this->FarmNo);
                    $doc->exportCaption($this->FieldType);
                    $doc->exportCaption($this->Ownership);
                    $doc->exportCaption($this->SeedlingsAllocated);
                    $doc->exportCaption($this->TreesPlantedEstimated);
                    $doc->exportCaption($this->FarmSizeEstimated);
                    $doc->exportCaption($this->FarmSizeVerified);
                    $doc->exportCaption($this->TreesPlantedVerified);
                    $doc->exportCaption($this->SourcesOfSeedlings);
                    $doc->exportCaption($this->ClearedLand);
                    $doc->exportCaption($this->OldTrees);
                    $doc->exportCaption($this->FarmSize);
                    $doc->exportCaption($this->Latitude);
                    $doc->exportCaption($this->Longitude);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmNo);
                        $doc->exportField($this->FieldType);
                        $doc->exportField($this->Ownership);
                        $doc->exportField($this->SeedlingsAllocated);
                        $doc->exportField($this->TreesPlantedEstimated);
                        $doc->exportField($this->FarmSizeEstimated);
                        $doc->exportField($this->FarmSizeVerified);
                        $doc->exportField($this->TreesPlantedVerified);
                        $doc->exportField($this->SourcesOfSeedlings);
                        $doc->exportField($this->InspecationReport);
                        $doc->exportField($this->ClearedLand);
                        $doc->exportField($this->OldTrees);
                        $doc->exportField($this->FarmSize);
                        $doc->exportField($this->Latitude);
                        $doc->exportField($this->Longitude);
                    } else {
                        $doc->exportField($this->ProvinceCode);
                        $doc->exportField($this->DistrictCode);
                        $doc->exportField($this->CampCode);
                        $doc->exportField($this->VillageCode);
                        $doc->exportField($this->NRC);
                        $doc->exportField($this->FarmNo);
                        $doc->exportField($this->FieldType);
                        $doc->exportField($this->Ownership);
                        $doc->exportField($this->SeedlingsAllocated);
                        $doc->exportField($this->TreesPlantedEstimated);
                        $doc->exportField($this->FarmSizeEstimated);
                        $doc->exportField($this->FarmSizeVerified);
                        $doc->exportField($this->TreesPlantedVerified);
                        $doc->exportField($this->SourcesOfSeedlings);
                        $doc->exportField($this->ClearedLand);
                        $doc->exportField($this->OldTrees);
                        $doc->exportField($this->FarmSize);
                        $doc->exportField($this->Latitude);
                        $doc->exportField($this->Longitude);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'farm');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['FarmNo'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'farm', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['FarmNo'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'farm', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['FarmNo'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'farm', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter) {
    	// Enter your code here
    	$username = CurrentUserName(); 
    	$levelid = CurrentUserLevel();
    	$row = executeRow("select role from musers where username = '" . $username . "'");

    	/*set filter for province
    	$prov = executeRow("select count(security_matrix.ProvinceCode)as kountprov 
    	from security_matrix, musers
    	where security_matrix.usercode = musers.usercode and security_matrix.ProvinceCode is not null  
    	and musers.username = '" . $username .     "'  ");
    	if(($levelid <> -1) && ($prov["kountprov"] > 0)) {				//levelid -1 is for admin
    	AddFilter($filter,"`ProvinceCode`  in   (select DISTINCT security_matrix.ProvinceCode
    	from security_matrix, musers                            
    	where security_matrix.usercode = musers.usercode 
    	and musers.username = '" . $username .  	"')  ");
    	} */

    	//set filter for district
    	$dis = executeRow("select count(security_matrix.DistrictCode)as kountdistrict 
    	from security_matrix, musers
    	where security_matrix.usercode = musers.usercode and security_matrix.DistrictCode is not null  
    	and musers.username = '" . $username .     "'  ");
    	if(($levelid <> -1) && ($dis["kountdistrict"] > 0)) {				//levelid -1 is for admin
    	AddFilter($filter,"`DistrictCode`  in   (select DISTINCT security_matrix.DistrictCode
    	from security_matrix, musers                            
    	where security_matrix.usercode = musers.usercode 
    	and musers.username = '" . $username .  	"')  ");
    	}
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
