<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class CidpDataAdd extends CidpData
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "CidpDataAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "CidpDataAdd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->DistrictCode->setVisibility();
        $this->DistrictName->setVisibility();
        $this->GRNCode->setVisibility();
        $this->GRN->setVisibility();
        $this->SupplierCode->setVisibility();
        $this->Supplier->setVisibility();
        $this->CampCode->setVisibility();
        $this->Camp->setVisibility();
        $this->VillageCode->setVisibility();
        $this->Village->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmerName->setVisibility();
        $this->DOB->setVisibility();
        $this->Age->setVisibility();
        $this->Group->setVisibility();
        $this->Gender->setVisibility();
        $this->Seedlings->setVisibility();
        $this->Seeds->setVisibility();
        $this->Type->setVisibility();
        $this->DateAllocated->setVisibility();
        $this->ID->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'cidp_data';
        $this->TableName = 'cidp_data';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (cidp_data)
        if (!isset($GLOBALS["cidp_data"]) || $GLOBALS["cidp_data"]::class == PROJECT_NAMESPACE . "cidp_data") {
            $GLOBALS["cidp_data"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'cidp_data');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "CidpDataView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['ID'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->ID->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->DistrictCode);
        $this->setupLookupOptions($this->GRNCode);
        $this->setupLookupOptions($this->SupplierCode);
        $this->setupLookupOptions($this->CampCode);
        $this->setupLookupOptions($this->VillageCode);
        $this->setupLookupOptions($this->Group);
        $this->setupLookupOptions($this->Gender);
        $this->setupLookupOptions($this->Type);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("ID") ?? Route("ID")) !== null) {
                $this->ID->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("CidpDataList"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "CidpDataList") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "CidpDataView") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "CidpDataList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "CidpDataList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'DistrictCode' first before field var 'x_DistrictCode'
        $val = $CurrentForm->hasValue("DistrictCode") ? $CurrentForm->getValue("DistrictCode") : $CurrentForm->getValue("x_DistrictCode");
        if (!$this->DistrictCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DistrictCode->Visible = false; // Disable update for API request
            } else {
                $this->DistrictCode->setFormValue($val);
            }
        }

        // Check field name 'DistrictName' first before field var 'x_DistrictName'
        $val = $CurrentForm->hasValue("DistrictName") ? $CurrentForm->getValue("DistrictName") : $CurrentForm->getValue("x_DistrictName");
        if (!$this->DistrictName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DistrictName->Visible = false; // Disable update for API request
            } else {
                $this->DistrictName->setFormValue($val);
            }
        }

        // Check field name 'GRNCode' first before field var 'x_GRNCode'
        $val = $CurrentForm->hasValue("GRNCode") ? $CurrentForm->getValue("GRNCode") : $CurrentForm->getValue("x_GRNCode");
        if (!$this->GRNCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GRNCode->Visible = false; // Disable update for API request
            } else {
                $this->GRNCode->setFormValue($val);
            }
        }

        // Check field name 'GRN' first before field var 'x_GRN'
        $val = $CurrentForm->hasValue("GRN") ? $CurrentForm->getValue("GRN") : $CurrentForm->getValue("x_GRN");
        if (!$this->GRN->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->GRN->Visible = false; // Disable update for API request
            } else {
                $this->GRN->setFormValue($val);
            }
        }

        // Check field name 'SupplierCode' first before field var 'x_SupplierCode'
        $val = $CurrentForm->hasValue("SupplierCode") ? $CurrentForm->getValue("SupplierCode") : $CurrentForm->getValue("x_SupplierCode");
        if (!$this->SupplierCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->SupplierCode->Visible = false; // Disable update for API request
            } else {
                $this->SupplierCode->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Supplier' first before field var 'x_Supplier'
        $val = $CurrentForm->hasValue("Supplier") ? $CurrentForm->getValue("Supplier") : $CurrentForm->getValue("x_Supplier");
        if (!$this->Supplier->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Supplier->Visible = false; // Disable update for API request
            } else {
                $this->Supplier->setFormValue($val);
            }
        }

        // Check field name 'CampCode' first before field var 'x_CampCode'
        $val = $CurrentForm->hasValue("CampCode") ? $CurrentForm->getValue("CampCode") : $CurrentForm->getValue("x_CampCode");
        if (!$this->CampCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->CampCode->Visible = false; // Disable update for API request
            } else {
                $this->CampCode->setFormValue($val);
            }
        }

        // Check field name 'Camp' first before field var 'x_Camp'
        $val = $CurrentForm->hasValue("Camp") ? $CurrentForm->getValue("Camp") : $CurrentForm->getValue("x_Camp");
        if (!$this->Camp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Camp->Visible = false; // Disable update for API request
            } else {
                $this->Camp->setFormValue($val);
            }
        }

        // Check field name 'VillageCode' first before field var 'x_VillageCode'
        $val = $CurrentForm->hasValue("VillageCode") ? $CurrentForm->getValue("VillageCode") : $CurrentForm->getValue("x_VillageCode");
        if (!$this->VillageCode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->VillageCode->Visible = false; // Disable update for API request
            } else {
                $this->VillageCode->setFormValue($val);
            }
        }

        // Check field name 'Village' first before field var 'x_Village'
        $val = $CurrentForm->hasValue("Village") ? $CurrentForm->getValue("Village") : $CurrentForm->getValue("x_Village");
        if (!$this->Village->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Village->Visible = false; // Disable update for API request
            } else {
                $this->Village->setFormValue($val);
            }
        }

        // Check field name 'NRC' first before field var 'x_NRC'
        $val = $CurrentForm->hasValue("NRC") ? $CurrentForm->getValue("NRC") : $CurrentForm->getValue("x_NRC");
        if (!$this->NRC->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->NRC->Visible = false; // Disable update for API request
            } else {
                $this->NRC->setFormValue($val);
            }
        }

        // Check field name 'FarmerName' first before field var 'x_FarmerName'
        $val = $CurrentForm->hasValue("FarmerName") ? $CurrentForm->getValue("FarmerName") : $CurrentForm->getValue("x_FarmerName");
        if (!$this->FarmerName->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->FarmerName->Visible = false; // Disable update for API request
            } else {
                $this->FarmerName->setFormValue($val);
            }
        }

        // Check field name 'DOB' first before field var 'x_DOB'
        $val = $CurrentForm->hasValue("DOB") ? $CurrentForm->getValue("DOB") : $CurrentForm->getValue("x_DOB");
        if (!$this->DOB->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DOB->Visible = false; // Disable update for API request
            } else {
                $this->DOB->setFormValue($val);
            }
        }

        // Check field name 'Age' first before field var 'x_Age'
        $val = $CurrentForm->hasValue("Age") ? $CurrentForm->getValue("Age") : $CurrentForm->getValue("x_Age");
        if (!$this->Age->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Age->Visible = false; // Disable update for API request
            } else {
                $this->Age->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Group' first before field var 'x_Group'
        $val = $CurrentForm->hasValue("Group") ? $CurrentForm->getValue("Group") : $CurrentForm->getValue("x_Group");
        if (!$this->Group->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Group->Visible = false; // Disable update for API request
            } else {
                $this->Group->setFormValue($val);
            }
        }

        // Check field name 'Gender' first before field var 'x_Gender'
        $val = $CurrentForm->hasValue("Gender") ? $CurrentForm->getValue("Gender") : $CurrentForm->getValue("x_Gender");
        if (!$this->Gender->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Gender->Visible = false; // Disable update for API request
            } else {
                $this->Gender->setFormValue($val);
            }
        }

        // Check field name 'Seedlings' first before field var 'x_Seedlings'
        $val = $CurrentForm->hasValue("Seedlings") ? $CurrentForm->getValue("Seedlings") : $CurrentForm->getValue("x_Seedlings");
        if (!$this->Seedlings->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Seedlings->Visible = false; // Disable update for API request
            } else {
                $this->Seedlings->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Seeds' first before field var 'x_Seeds'
        $val = $CurrentForm->hasValue("Seeds") ? $CurrentForm->getValue("Seeds") : $CurrentForm->getValue("x_Seeds");
        if (!$this->Seeds->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Seeds->Visible = false; // Disable update for API request
            } else {
                $this->Seeds->setFormValue($val);
            }
        }

        // Check field name 'Type' first before field var 'x_Type'
        $val = $CurrentForm->hasValue("Type") ? $CurrentForm->getValue("Type") : $CurrentForm->getValue("x_Type");
        if (!$this->Type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Type->Visible = false; // Disable update for API request
            } else {
                $this->Type->setFormValue($val);
            }
        }

        // Check field name 'DateAllocated' first before field var 'x_DateAllocated'
        $val = $CurrentForm->hasValue("DateAllocated") ? $CurrentForm->getValue("DateAllocated") : $CurrentForm->getValue("x_DateAllocated");
        if (!$this->DateAllocated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->DateAllocated->Visible = false; // Disable update for API request
            } else {
                $this->DateAllocated->setFormValue($val);
            }
        }

        // Check field name 'ID' first before field var 'x_ID'
        $val = $CurrentForm->hasValue("ID") ? $CurrentForm->getValue("ID") : $CurrentForm->getValue("x_ID");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->DistrictCode->CurrentValue = $this->DistrictCode->FormValue;
        $this->DistrictName->CurrentValue = $this->DistrictName->FormValue;
        $this->GRNCode->CurrentValue = $this->GRNCode->FormValue;
        $this->GRN->CurrentValue = $this->GRN->FormValue;
        $this->SupplierCode->CurrentValue = $this->SupplierCode->FormValue;
        $this->Supplier->CurrentValue = $this->Supplier->FormValue;
        $this->CampCode->CurrentValue = $this->CampCode->FormValue;
        $this->Camp->CurrentValue = $this->Camp->FormValue;
        $this->VillageCode->CurrentValue = $this->VillageCode->FormValue;
        $this->Village->CurrentValue = $this->Village->FormValue;
        $this->NRC->CurrentValue = $this->NRC->FormValue;
        $this->FarmerName->CurrentValue = $this->FarmerName->FormValue;
        $this->DOB->CurrentValue = $this->DOB->FormValue;
        $this->Age->CurrentValue = $this->Age->FormValue;
        $this->Group->CurrentValue = $this->Group->FormValue;
        $this->Gender->CurrentValue = $this->Gender->FormValue;
        $this->Seedlings->CurrentValue = $this->Seedlings->FormValue;
        $this->Seeds->CurrentValue = $this->Seeds->FormValue;
        $this->Type->CurrentValue = $this->Type->FormValue;
        $this->DateAllocated->CurrentValue = $this->DateAllocated->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->DistrictCode->setDbValue($row['DistrictCode']);
        $this->DistrictName->setDbValue($row['DistrictName']);
        $this->GRNCode->setDbValue($row['GRNCode']);
        $this->GRN->setDbValue($row['GRN']);
        $this->SupplierCode->setDbValue($row['SupplierCode']);
        $this->Supplier->setDbValue($row['Supplier']);
        $this->CampCode->setDbValue($row['CampCode']);
        $this->Camp->setDbValue($row['Camp']);
        $this->VillageCode->setDbValue($row['VillageCode']);
        $this->Village->setDbValue($row['Village']);
        $this->NRC->setDbValue($row['NRC']);
        $this->FarmerName->setDbValue($row['FarmerName']);
        $this->DOB->setDbValue($row['DOB']);
        $this->Age->setDbValue($row['Age']);
        $this->Group->setDbValue($row['Group']);
        $this->Gender->setDbValue($row['Gender']);
        $this->Seedlings->setDbValue($row['Seedlings']);
        $this->Seeds->setDbValue($row['Seeds']);
        $this->Type->setDbValue($row['Type']);
        $this->DateAllocated->setDbValue($row['DateAllocated']);
        $this->ID->setDbValue($row['ID']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['DistrictCode'] = $this->DistrictCode->DefaultValue;
        $row['DistrictName'] = $this->DistrictName->DefaultValue;
        $row['GRNCode'] = $this->GRNCode->DefaultValue;
        $row['GRN'] = $this->GRN->DefaultValue;
        $row['SupplierCode'] = $this->SupplierCode->DefaultValue;
        $row['Supplier'] = $this->Supplier->DefaultValue;
        $row['CampCode'] = $this->CampCode->DefaultValue;
        $row['Camp'] = $this->Camp->DefaultValue;
        $row['VillageCode'] = $this->VillageCode->DefaultValue;
        $row['Village'] = $this->Village->DefaultValue;
        $row['NRC'] = $this->NRC->DefaultValue;
        $row['FarmerName'] = $this->FarmerName->DefaultValue;
        $row['DOB'] = $this->DOB->DefaultValue;
        $row['Age'] = $this->Age->DefaultValue;
        $row['Group'] = $this->Group->DefaultValue;
        $row['Gender'] = $this->Gender->DefaultValue;
        $row['Seedlings'] = $this->Seedlings->DefaultValue;
        $row['Seeds'] = $this->Seeds->DefaultValue;
        $row['Type'] = $this->Type->DefaultValue;
        $row['DateAllocated'] = $this->DateAllocated->DefaultValue;
        $row['ID'] = $this->ID->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // DistrictCode
        $this->DistrictCode->RowCssClass = "row";

        // DistrictName
        $this->DistrictName->RowCssClass = "row";

        // GRNCode
        $this->GRNCode->RowCssClass = "row";

        // GRN
        $this->GRN->RowCssClass = "row";

        // SupplierCode
        $this->SupplierCode->RowCssClass = "row";

        // Supplier
        $this->Supplier->RowCssClass = "row";

        // CampCode
        $this->CampCode->RowCssClass = "row";

        // Camp
        $this->Camp->RowCssClass = "row";

        // VillageCode
        $this->VillageCode->RowCssClass = "row";

        // Village
        $this->Village->RowCssClass = "row";

        // NRC
        $this->NRC->RowCssClass = "row";

        // FarmerName
        $this->FarmerName->RowCssClass = "row";

        // DOB
        $this->DOB->RowCssClass = "row";

        // Age
        $this->Age->RowCssClass = "row";

        // Group
        $this->Group->RowCssClass = "row";

        // Gender
        $this->Gender->RowCssClass = "row";

        // Seedlings
        $this->Seedlings->RowCssClass = "row";

        // Seeds
        $this->Seeds->RowCssClass = "row";

        // Type
        $this->Type->RowCssClass = "row";

        // DateAllocated
        $this->DateAllocated->RowCssClass = "row";

        // ID
        $this->ID->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // DistrictCode
            $curVal = strval($this->DistrictCode->CurrentValue);
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
                if ($this->DistrictCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $curVal, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                    $sqlWrk = $this->DistrictCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                        $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                    } else {
                        $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
                    }
                }
            } else {
                $this->DistrictCode->ViewValue = null;
            }

            // DistrictName
            $this->DistrictName->ViewValue = $this->DistrictName->CurrentValue;

            // GRNCode
            $this->GRNCode->ViewValue = $this->GRNCode->CurrentValue;
            $curVal = strval($this->GRNCode->CurrentValue);
            if ($curVal != "") {
                $this->GRNCode->ViewValue = $this->GRNCode->lookupCacheOption($curVal);
                if ($this->GRNCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->GRNCode->Lookup->getTable()->Fields["GRN"]->searchExpression(), "=", $curVal, $this->GRNCode->Lookup->getTable()->Fields["GRN"]->searchDataType(), "");
                    $sqlWrk = $this->GRNCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->GRNCode->Lookup->renderViewRow($rswrk[0]);
                        $this->GRNCode->ViewValue = $this->GRNCode->displayValue($arwrk);
                    } else {
                        $this->GRNCode->ViewValue = $this->GRNCode->CurrentValue;
                    }
                }
            } else {
                $this->GRNCode->ViewValue = null;
            }

            // GRN
            $this->GRN->ViewValue = $this->GRN->CurrentValue;

            // SupplierCode
            $this->SupplierCode->ViewValue = $this->SupplierCode->CurrentValue;
            $curVal = strval($this->SupplierCode->CurrentValue);
            if ($curVal != "") {
                $this->SupplierCode->ViewValue = $this->SupplierCode->lookupCacheOption($curVal);
                if ($this->SupplierCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SupplierCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SupplierCode->Lookup->renderViewRow($rswrk[0]);
                        $this->SupplierCode->ViewValue = $this->SupplierCode->displayValue($arwrk);
                    } else {
                        $this->SupplierCode->ViewValue = $this->SupplierCode->CurrentValue;
                    }
                }
            } else {
                $this->SupplierCode->ViewValue = null;
            }

            // Supplier
            $this->Supplier->ViewValue = $this->Supplier->CurrentValue;

            // CampCode
            $curVal = strval($this->CampCode->CurrentValue);
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
                if ($this->CampCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $curVal, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                    $sqlWrk = $this->CampCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                        $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                    } else {
                        $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
                    }
                }
            } else {
                $this->CampCode->ViewValue = null;
            }

            // Camp
            $this->Camp->ViewValue = $this->Camp->CurrentValue;

            // VillageCode
            $curVal = strval($this->VillageCode->CurrentValue);
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
                if ($this->VillageCode->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $curVal, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                    $sqlWrk = $this->VillageCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                        $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                    } else {
                        $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
                    }
                }
            } else {
                $this->VillageCode->ViewValue = null;
            }

            // Village
            $this->Village->ViewValue = $this->Village->CurrentValue;

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;

            // FarmerName
            $this->FarmerName->ViewValue = $this->FarmerName->CurrentValue;

            // DOB
            $this->DOB->ViewValue = $this->DOB->CurrentValue;

            // Age
            $this->Age->ViewValue = $this->Age->CurrentValue;
            $this->Age->ViewValue = FormatNumber($this->Age->ViewValue, $this->Age->formatPattern());

            // Group
            if (strval($this->Group->CurrentValue) != "") {
                $this->Group->ViewValue = new OptionValues();
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), strval($this->Group->CurrentValue));
                $cnt = count($arwrk);
                for ($ari = 0; $ari < $cnt; $ari++)
                    $this->Group->ViewValue->add($this->Group->optionCaption(trim($arwrk[$ari])));
            } else {
                $this->Group->ViewValue = null;
            }

            // Gender
            $curVal = strval($this->Gender->CurrentValue);
            if ($curVal != "") {
                $this->Gender->ViewValue = $this->Gender->lookupCacheOption($curVal);
                if ($this->Gender->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Gender->Lookup->getTable()->Fields["Gender"]->searchExpression(), "=", $curVal, $this->Gender->Lookup->getTable()->Fields["Gender"]->searchDataType(), "");
                    $sqlWrk = $this->Gender->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Gender->Lookup->renderViewRow($rswrk[0]);
                        $this->Gender->ViewValue = $this->Gender->displayValue($arwrk);
                    } else {
                        $this->Gender->ViewValue = $this->Gender->CurrentValue;
                    }
                }
            } else {
                $this->Gender->ViewValue = null;
            }

            // Seedlings
            $this->Seedlings->ViewValue = $this->Seedlings->CurrentValue;
            $this->Seedlings->ViewValue = FormatNumber($this->Seedlings->ViewValue, $this->Seedlings->formatPattern());
            $this->Seedlings->CellCssStyle .= "text-align: right;";

            // Seeds
            $this->Seeds->ViewValue = $this->Seeds->CurrentValue;
            $this->Seeds->ViewValue = FormatNumber($this->Seeds->ViewValue, $this->Seeds->formatPattern());
            $this->Seeds->CellCssStyle .= "text-align: right;";

            // Type
            $curVal = strval($this->Type->CurrentValue);
            if ($curVal != "") {
                $this->Type->ViewValue = $this->Type->lookupCacheOption($curVal);
                if ($this->Type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Type->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $curVal, $this->Type->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                    $sqlWrk = $this->Type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Type->Lookup->renderViewRow($rswrk[0]);
                        $this->Type->ViewValue = $this->Type->displayValue($arwrk);
                    } else {
                        $this->Type->ViewValue = $this->Type->CurrentValue;
                    }
                }
            } else {
                $this->Type->ViewValue = null;
            }

            // DateAllocated
            $this->DateAllocated->ViewValue = $this->DateAllocated->CurrentValue;

            // ID
            $this->ID->ViewValue = $this->ID->CurrentValue;

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // DistrictName
            $this->DistrictName->HrefValue = "";

            // GRNCode
            $this->GRNCode->HrefValue = "";

            // GRN
            $this->GRN->HrefValue = "";

            // SupplierCode
            $this->SupplierCode->HrefValue = "";

            // Supplier
            $this->Supplier->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // Camp
            $this->Camp->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // Village
            $this->Village->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmerName
            $this->FarmerName->HrefValue = "";

            // DOB
            $this->DOB->HrefValue = "";

            // Age
            $this->Age->HrefValue = "";

            // Group
            $this->Group->HrefValue = "";

            // Gender
            $this->Gender->HrefValue = "";

            // Seedlings
            $this->Seedlings->HrefValue = "";

            // Seeds
            $this->Seeds->HrefValue = "";

            // Type
            $this->Type->HrefValue = "";

            // DateAllocated
            $this->DateAllocated->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // DistrictCode
            $curVal = trim(strval($this->DistrictCode->CurrentValue));
            if ($curVal != "") {
                $this->DistrictCode->ViewValue = $this->DistrictCode->lookupCacheOption($curVal);
            } else {
                $this->DistrictCode->ViewValue = $this->DistrictCode->Lookup !== null && is_array($this->DistrictCode->lookupOptions()) && count($this->DistrictCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->DistrictCode->ViewValue !== null) { // Load from cache
                $this->DistrictCode->EditValue = array_values($this->DistrictCode->lookupOptions());
                if ($this->DistrictCode->ViewValue == "") {
                    $this->DistrictCode->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchExpression(), "=", $this->DistrictCode->CurrentValue, $this->DistrictCode->Lookup->getTable()->Fields["DistrictCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->DistrictCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->DistrictCode->Lookup->renderViewRow($rswrk[0]);
                    $this->DistrictCode->ViewValue = $this->DistrictCode->displayValue($arwrk);
                } else {
                    $this->DistrictCode->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->DistrictCode->EditValue = $arwrk;
            }
            $this->DistrictCode->PlaceHolder = RemoveHtml($this->DistrictCode->caption());

            // DistrictName
            $this->DistrictName->setupEditAttributes();
            if (!$this->DistrictName->Raw) {
                $this->DistrictName->CurrentValue = HtmlDecode($this->DistrictName->CurrentValue);
            }
            $this->DistrictName->EditValue = HtmlEncode($this->DistrictName->CurrentValue);
            $this->DistrictName->PlaceHolder = RemoveHtml($this->DistrictName->caption());

            // GRNCode
            $this->GRNCode->setupEditAttributes();
            if (!$this->GRNCode->Raw) {
                $this->GRNCode->CurrentValue = HtmlDecode($this->GRNCode->CurrentValue);
            }
            $this->GRNCode->EditValue = HtmlEncode($this->GRNCode->CurrentValue);
            $curVal = strval($this->GRNCode->CurrentValue);
            if ($curVal != "") {
                $this->GRNCode->EditValue = $this->GRNCode->lookupCacheOption($curVal);
                if ($this->GRNCode->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->GRNCode->Lookup->getTable()->Fields["GRN"]->searchExpression(), "=", $curVal, $this->GRNCode->Lookup->getTable()->Fields["GRN"]->searchDataType(), "");
                    $sqlWrk = $this->GRNCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->GRNCode->Lookup->renderViewRow($rswrk[0]);
                        $this->GRNCode->EditValue = $this->GRNCode->displayValue($arwrk);
                    } else {
                        $this->GRNCode->EditValue = HtmlEncode($this->GRNCode->CurrentValue);
                    }
                }
            } else {
                $this->GRNCode->EditValue = null;
            }
            $this->GRNCode->PlaceHolder = RemoveHtml($this->GRNCode->caption());

            // GRN
            $this->GRN->setupEditAttributes();
            if (!$this->GRN->Raw) {
                $this->GRN->CurrentValue = HtmlDecode($this->GRN->CurrentValue);
            }
            $this->GRN->EditValue = HtmlEncode($this->GRN->CurrentValue);
            $this->GRN->PlaceHolder = RemoveHtml($this->GRN->caption());

            // SupplierCode
            $this->SupplierCode->setupEditAttributes();
            $this->SupplierCode->EditValue = $this->SupplierCode->CurrentValue;
            $curVal = strval($this->SupplierCode->CurrentValue);
            if ($curVal != "") {
                $this->SupplierCode->EditValue = $this->SupplierCode->lookupCacheOption($curVal);
                if ($this->SupplierCode->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchExpression(), "=", $curVal, $this->SupplierCode->Lookup->getTable()->Fields["NurseryCode"]->searchDataType(), "");
                    $sqlWrk = $this->SupplierCode->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->SupplierCode->Lookup->renderViewRow($rswrk[0]);
                        $this->SupplierCode->EditValue = $this->SupplierCode->displayValue($arwrk);
                    } else {
                        $this->SupplierCode->EditValue = HtmlEncode($this->SupplierCode->CurrentValue);
                    }
                }
            } else {
                $this->SupplierCode->EditValue = null;
            }
            $this->SupplierCode->PlaceHolder = RemoveHtml($this->SupplierCode->caption());

            // Supplier
            $this->Supplier->setupEditAttributes();
            if (!$this->Supplier->Raw) {
                $this->Supplier->CurrentValue = HtmlDecode($this->Supplier->CurrentValue);
            }
            $this->Supplier->EditValue = HtmlEncode($this->Supplier->CurrentValue);
            $this->Supplier->PlaceHolder = RemoveHtml($this->Supplier->caption());

            // CampCode
            $curVal = trim(strval($this->CampCode->CurrentValue));
            if ($curVal != "") {
                $this->CampCode->ViewValue = $this->CampCode->lookupCacheOption($curVal);
            } else {
                $this->CampCode->ViewValue = $this->CampCode->Lookup !== null && is_array($this->CampCode->lookupOptions()) && count($this->CampCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->CampCode->ViewValue !== null) { // Load from cache
                $this->CampCode->EditValue = array_values($this->CampCode->lookupOptions());
                if ($this->CampCode->ViewValue == "") {
                    $this->CampCode->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchExpression(), "=", $this->CampCode->CurrentValue, $this->CampCode->Lookup->getTable()->Fields["CampCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->CampCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->CampCode->Lookup->renderViewRow($rswrk[0]);
                    $this->CampCode->ViewValue = $this->CampCode->displayValue($arwrk);
                } else {
                    $this->CampCode->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->CampCode->EditValue = $arwrk;
            }
            $this->CampCode->PlaceHolder = RemoveHtml($this->CampCode->caption());

            // Camp
            $this->Camp->setupEditAttributes();
            if (!$this->Camp->Raw) {
                $this->Camp->CurrentValue = HtmlDecode($this->Camp->CurrentValue);
            }
            $this->Camp->EditValue = HtmlEncode($this->Camp->CurrentValue);
            $this->Camp->PlaceHolder = RemoveHtml($this->Camp->caption());

            // VillageCode
            $curVal = trim(strval($this->VillageCode->CurrentValue));
            if ($curVal != "") {
                $this->VillageCode->ViewValue = $this->VillageCode->lookupCacheOption($curVal);
            } else {
                $this->VillageCode->ViewValue = $this->VillageCode->Lookup !== null && is_array($this->VillageCode->lookupOptions()) && count($this->VillageCode->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->VillageCode->ViewValue !== null) { // Load from cache
                $this->VillageCode->EditValue = array_values($this->VillageCode->lookupOptions());
                if ($this->VillageCode->ViewValue == "") {
                    $this->VillageCode->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchExpression(), "=", $this->VillageCode->CurrentValue, $this->VillageCode->Lookup->getTable()->Fields["VillageCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->VillageCode->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->VillageCode->Lookup->renderViewRow($rswrk[0]);
                    $this->VillageCode->ViewValue = $this->VillageCode->displayValue($arwrk);
                } else {
                    $this->VillageCode->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->VillageCode->EditValue = $arwrk;
            }
            $this->VillageCode->PlaceHolder = RemoveHtml($this->VillageCode->caption());

            // Village
            $this->Village->setupEditAttributes();
            if (!$this->Village->Raw) {
                $this->Village->CurrentValue = HtmlDecode($this->Village->CurrentValue);
            }
            $this->Village->EditValue = HtmlEncode($this->Village->CurrentValue);
            $this->Village->PlaceHolder = RemoveHtml($this->Village->caption());

            // NRC
            $this->NRC->setupEditAttributes();
            if (!$this->NRC->Raw) {
                $this->NRC->CurrentValue = HtmlDecode($this->NRC->CurrentValue);
            }
            $this->NRC->EditValue = HtmlEncode($this->NRC->CurrentValue);
            $this->NRC->PlaceHolder = RemoveHtml($this->NRC->caption());

            // FarmerName
            $this->FarmerName->setupEditAttributes();
            if (!$this->FarmerName->Raw) {
                $this->FarmerName->CurrentValue = HtmlDecode($this->FarmerName->CurrentValue);
            }
            $this->FarmerName->EditValue = HtmlEncode($this->FarmerName->CurrentValue);
            $this->FarmerName->PlaceHolder = RemoveHtml($this->FarmerName->caption());

            // DOB
            $this->DOB->setupEditAttributes();
            if (!$this->DOB->Raw) {
                $this->DOB->CurrentValue = HtmlDecode($this->DOB->CurrentValue);
            }
            $this->DOB->EditValue = HtmlEncode($this->DOB->CurrentValue);
            $this->DOB->PlaceHolder = RemoveHtml($this->DOB->caption());

            // Age
            $this->Age->setupEditAttributes();
            $this->Age->EditValue = $this->Age->CurrentValue;
            $this->Age->PlaceHolder = RemoveHtml($this->Age->caption());
            if (strval($this->Age->EditValue) != "" && is_numeric($this->Age->EditValue)) {
                $this->Age->EditValue = FormatNumber($this->Age->EditValue, null);
            }

            // Group
            $this->Group->setupEditAttributes();
            $this->Group->EditValue = $this->Group->options(false);
            $this->Group->PlaceHolder = RemoveHtml($this->Group->caption());

            // Gender
            $this->Gender->setupEditAttributes();
            $curVal = trim(strval($this->Gender->CurrentValue));
            if ($curVal != "") {
                $this->Gender->ViewValue = $this->Gender->lookupCacheOption($curVal);
            } else {
                $this->Gender->ViewValue = $this->Gender->Lookup !== null && is_array($this->Gender->lookupOptions()) && count($this->Gender->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Gender->ViewValue !== null) { // Load from cache
                $this->Gender->EditValue = array_values($this->Gender->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Gender->Lookup->getTable()->Fields["Gender"]->searchExpression(), "=", $this->Gender->CurrentValue, $this->Gender->Lookup->getTable()->Fields["Gender"]->searchDataType(), "");
                }
                $sqlWrk = $this->Gender->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Gender->EditValue = $arwrk;
            }
            $this->Gender->PlaceHolder = RemoveHtml($this->Gender->caption());

            // Seedlings
            $this->Seedlings->setupEditAttributes();
            $this->Seedlings->EditValue = $this->Seedlings->CurrentValue;
            $this->Seedlings->PlaceHolder = RemoveHtml($this->Seedlings->caption());
            if (strval($this->Seedlings->EditValue) != "" && is_numeric($this->Seedlings->EditValue)) {
                $this->Seedlings->EditValue = FormatNumber($this->Seedlings->EditValue, null);
            }

            // Seeds
            $this->Seeds->setupEditAttributes();
            $this->Seeds->EditValue = $this->Seeds->CurrentValue;
            $this->Seeds->PlaceHolder = RemoveHtml($this->Seeds->caption());
            if (strval($this->Seeds->EditValue) != "" && is_numeric($this->Seeds->EditValue)) {
                $this->Seeds->EditValue = FormatNumber($this->Seeds->EditValue, null);
            }

            // Type
            $this->Type->setupEditAttributes();
            $curVal = trim(strval($this->Type->CurrentValue));
            if ($curVal != "") {
                $this->Type->ViewValue = $this->Type->lookupCacheOption($curVal);
            } else {
                $this->Type->ViewValue = $this->Type->Lookup !== null && is_array($this->Type->lookupOptions()) && count($this->Type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Type->ViewValue !== null) { // Load from cache
                $this->Type->EditValue = array_values($this->Type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Type->Lookup->getTable()->Fields["SeedVariety"]->searchExpression(), "=", $this->Type->CurrentValue, $this->Type->Lookup->getTable()->Fields["SeedVariety"]->searchDataType(), "");
                }
                $sqlWrk = $this->Type->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Type->EditValue = $arwrk;
            }
            $this->Type->PlaceHolder = RemoveHtml($this->Type->caption());

            // DateAllocated
            $this->DateAllocated->setupEditAttributes();
            if (!$this->DateAllocated->Raw) {
                $this->DateAllocated->CurrentValue = HtmlDecode($this->DateAllocated->CurrentValue);
            }
            $this->DateAllocated->EditValue = HtmlEncode($this->DateAllocated->CurrentValue);
            $this->DateAllocated->PlaceHolder = RemoveHtml($this->DateAllocated->caption());

            // Add refer script

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // DistrictName
            $this->DistrictName->HrefValue = "";

            // GRNCode
            $this->GRNCode->HrefValue = "";

            // GRN
            $this->GRN->HrefValue = "";

            // SupplierCode
            $this->SupplierCode->HrefValue = "";

            // Supplier
            $this->Supplier->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // Camp
            $this->Camp->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // Village
            $this->Village->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmerName
            $this->FarmerName->HrefValue = "";

            // DOB
            $this->DOB->HrefValue = "";

            // Age
            $this->Age->HrefValue = "";

            // Group
            $this->Group->HrefValue = "";

            // Gender
            $this->Gender->HrefValue = "";

            // Seedlings
            $this->Seedlings->HrefValue = "";

            // Seeds
            $this->Seeds->HrefValue = "";

            // Type
            $this->Type->HrefValue = "";

            // DateAllocated
            $this->DateAllocated->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->DistrictCode->Visible && $this->DistrictCode->Required) {
                if (!$this->DistrictCode->IsDetailKey && EmptyValue($this->DistrictCode->FormValue)) {
                    $this->DistrictCode->addErrorMessage(str_replace("%s", $this->DistrictCode->caption(), $this->DistrictCode->RequiredErrorMessage));
                }
            }
            if ($this->DistrictName->Visible && $this->DistrictName->Required) {
                if (!$this->DistrictName->IsDetailKey && EmptyValue($this->DistrictName->FormValue)) {
                    $this->DistrictName->addErrorMessage(str_replace("%s", $this->DistrictName->caption(), $this->DistrictName->RequiredErrorMessage));
                }
            }
            if ($this->GRNCode->Visible && $this->GRNCode->Required) {
                if (!$this->GRNCode->IsDetailKey && EmptyValue($this->GRNCode->FormValue)) {
                    $this->GRNCode->addErrorMessage(str_replace("%s", $this->GRNCode->caption(), $this->GRNCode->RequiredErrorMessage));
                }
            }
            if ($this->GRN->Visible && $this->GRN->Required) {
                if (!$this->GRN->IsDetailKey && EmptyValue($this->GRN->FormValue)) {
                    $this->GRN->addErrorMessage(str_replace("%s", $this->GRN->caption(), $this->GRN->RequiredErrorMessage));
                }
            }
            if ($this->SupplierCode->Visible && $this->SupplierCode->Required) {
                if (!$this->SupplierCode->IsDetailKey && EmptyValue($this->SupplierCode->FormValue)) {
                    $this->SupplierCode->addErrorMessage(str_replace("%s", $this->SupplierCode->caption(), $this->SupplierCode->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->SupplierCode->FormValue)) {
                $this->SupplierCode->addErrorMessage($this->SupplierCode->getErrorMessage(false));
            }
            if ($this->Supplier->Visible && $this->Supplier->Required) {
                if (!$this->Supplier->IsDetailKey && EmptyValue($this->Supplier->FormValue)) {
                    $this->Supplier->addErrorMessage(str_replace("%s", $this->Supplier->caption(), $this->Supplier->RequiredErrorMessage));
                }
            }
            if ($this->CampCode->Visible && $this->CampCode->Required) {
                if (!$this->CampCode->IsDetailKey && EmptyValue($this->CampCode->FormValue)) {
                    $this->CampCode->addErrorMessage(str_replace("%s", $this->CampCode->caption(), $this->CampCode->RequiredErrorMessage));
                }
            }
            if ($this->Camp->Visible && $this->Camp->Required) {
                if (!$this->Camp->IsDetailKey && EmptyValue($this->Camp->FormValue)) {
                    $this->Camp->addErrorMessage(str_replace("%s", $this->Camp->caption(), $this->Camp->RequiredErrorMessage));
                }
            }
            if ($this->VillageCode->Visible && $this->VillageCode->Required) {
                if (!$this->VillageCode->IsDetailKey && EmptyValue($this->VillageCode->FormValue)) {
                    $this->VillageCode->addErrorMessage(str_replace("%s", $this->VillageCode->caption(), $this->VillageCode->RequiredErrorMessage));
                }
            }
            if ($this->Village->Visible && $this->Village->Required) {
                if (!$this->Village->IsDetailKey && EmptyValue($this->Village->FormValue)) {
                    $this->Village->addErrorMessage(str_replace("%s", $this->Village->caption(), $this->Village->RequiredErrorMessage));
                }
            }
            if ($this->NRC->Visible && $this->NRC->Required) {
                if (!$this->NRC->IsDetailKey && EmptyValue($this->NRC->FormValue)) {
                    $this->NRC->addErrorMessage(str_replace("%s", $this->NRC->caption(), $this->NRC->RequiredErrorMessage));
                }
            }
            if ($this->FarmerName->Visible && $this->FarmerName->Required) {
                if (!$this->FarmerName->IsDetailKey && EmptyValue($this->FarmerName->FormValue)) {
                    $this->FarmerName->addErrorMessage(str_replace("%s", $this->FarmerName->caption(), $this->FarmerName->RequiredErrorMessage));
                }
            }
            if ($this->DOB->Visible && $this->DOB->Required) {
                if (!$this->DOB->IsDetailKey && EmptyValue($this->DOB->FormValue)) {
                    $this->DOB->addErrorMessage(str_replace("%s", $this->DOB->caption(), $this->DOB->RequiredErrorMessage));
                }
            }
            if ($this->Age->Visible && $this->Age->Required) {
                if (!$this->Age->IsDetailKey && EmptyValue($this->Age->FormValue)) {
                    $this->Age->addErrorMessage(str_replace("%s", $this->Age->caption(), $this->Age->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Age->FormValue)) {
                $this->Age->addErrorMessage($this->Age->getErrorMessage(false));
            }
            if ($this->Group->Visible && $this->Group->Required) {
                if ($this->Group->FormValue == "") {
                    $this->Group->addErrorMessage(str_replace("%s", $this->Group->caption(), $this->Group->RequiredErrorMessage));
                }
            }
            if ($this->Gender->Visible && $this->Gender->Required) {
                if (!$this->Gender->IsDetailKey && EmptyValue($this->Gender->FormValue)) {
                    $this->Gender->addErrorMessage(str_replace("%s", $this->Gender->caption(), $this->Gender->RequiredErrorMessage));
                }
            }
            if ($this->Seedlings->Visible && $this->Seedlings->Required) {
                if (!$this->Seedlings->IsDetailKey && EmptyValue($this->Seedlings->FormValue)) {
                    $this->Seedlings->addErrorMessage(str_replace("%s", $this->Seedlings->caption(), $this->Seedlings->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Seedlings->FormValue)) {
                $this->Seedlings->addErrorMessage($this->Seedlings->getErrorMessage(false));
            }
            if ($this->Seeds->Visible && $this->Seeds->Required) {
                if (!$this->Seeds->IsDetailKey && EmptyValue($this->Seeds->FormValue)) {
                    $this->Seeds->addErrorMessage(str_replace("%s", $this->Seeds->caption(), $this->Seeds->RequiredErrorMessage));
                }
            }
            if ($this->Type->Visible && $this->Type->Required) {
                if (!$this->Type->IsDetailKey && EmptyValue($this->Type->FormValue)) {
                    $this->Type->addErrorMessage(str_replace("%s", $this->Type->caption(), $this->Type->RequiredErrorMessage));
                }
            }
            if ($this->DateAllocated->Visible && $this->DateAllocated->Required) {
                if (!$this->DateAllocated->IsDetailKey && EmptyValue($this->DateAllocated->FormValue)) {
                    $this->DateAllocated->addErrorMessage(str_replace("%s", $this->DateAllocated->caption(), $this->DateAllocated->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // DistrictCode
        $this->DistrictCode->setDbValueDef($rsnew, $this->DistrictCode->CurrentValue, false);

        // DistrictName
        $this->DistrictName->setDbValueDef($rsnew, $this->DistrictName->CurrentValue, false);

        // GRNCode
        $this->GRNCode->setDbValueDef($rsnew, $this->GRNCode->CurrentValue, false);

        // GRN
        $this->GRN->setDbValueDef($rsnew, $this->GRN->CurrentValue, false);

        // SupplierCode
        $this->SupplierCode->setDbValueDef($rsnew, $this->SupplierCode->CurrentValue, false);

        // Supplier
        $this->Supplier->setDbValueDef($rsnew, $this->Supplier->CurrentValue, false);

        // CampCode
        $this->CampCode->setDbValueDef($rsnew, $this->CampCode->CurrentValue, false);

        // Camp
        $this->Camp->setDbValueDef($rsnew, $this->Camp->CurrentValue, false);

        // VillageCode
        $this->VillageCode->setDbValueDef($rsnew, $this->VillageCode->CurrentValue, false);

        // Village
        $this->Village->setDbValueDef($rsnew, $this->Village->CurrentValue, false);

        // NRC
        $this->NRC->setDbValueDef($rsnew, $this->NRC->CurrentValue, false);

        // FarmerName
        $this->FarmerName->setDbValueDef($rsnew, $this->FarmerName->CurrentValue, false);

        // DOB
        $this->DOB->setDbValueDef($rsnew, $this->DOB->CurrentValue, false);

        // Age
        $this->Age->setDbValueDef($rsnew, $this->Age->CurrentValue, false);

        // Group
        $this->Group->setDbValueDef($rsnew, $this->Group->CurrentValue, false);

        // Gender
        $this->Gender->setDbValueDef($rsnew, $this->Gender->CurrentValue, false);

        // Seedlings
        $this->Seedlings->setDbValueDef($rsnew, $this->Seedlings->CurrentValue, false);

        // Seeds
        $this->Seeds->setDbValueDef($rsnew, $this->Seeds->CurrentValue, false);

        // Type
        $this->Type->setDbValueDef($rsnew, $this->Type->CurrentValue, false);

        // DateAllocated
        $this->DateAllocated->setDbValueDef($rsnew, $this->DateAllocated->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['DistrictCode'])) { // DistrictCode
            $this->DistrictCode->setFormValue($row['DistrictCode']);
        }
        if (isset($row['DistrictName'])) { // DistrictName
            $this->DistrictName->setFormValue($row['DistrictName']);
        }
        if (isset($row['GRNCode'])) { // GRNCode
            $this->GRNCode->setFormValue($row['GRNCode']);
        }
        if (isset($row['GRN'])) { // GRN
            $this->GRN->setFormValue($row['GRN']);
        }
        if (isset($row['SupplierCode'])) { // SupplierCode
            $this->SupplierCode->setFormValue($row['SupplierCode']);
        }
        if (isset($row['Supplier'])) { // Supplier
            $this->Supplier->setFormValue($row['Supplier']);
        }
        if (isset($row['CampCode'])) { // CampCode
            $this->CampCode->setFormValue($row['CampCode']);
        }
        if (isset($row['Camp'])) { // Camp
            $this->Camp->setFormValue($row['Camp']);
        }
        if (isset($row['VillageCode'])) { // VillageCode
            $this->VillageCode->setFormValue($row['VillageCode']);
        }
        if (isset($row['Village'])) { // Village
            $this->Village->setFormValue($row['Village']);
        }
        if (isset($row['NRC'])) { // NRC
            $this->NRC->setFormValue($row['NRC']);
        }
        if (isset($row['FarmerName'])) { // FarmerName
            $this->FarmerName->setFormValue($row['FarmerName']);
        }
        if (isset($row['DOB'])) { // DOB
            $this->DOB->setFormValue($row['DOB']);
        }
        if (isset($row['Age'])) { // Age
            $this->Age->setFormValue($row['Age']);
        }
        if (isset($row['Group'])) { // Group
            $this->Group->setFormValue($row['Group']);
        }
        if (isset($row['Gender'])) { // Gender
            $this->Gender->setFormValue($row['Gender']);
        }
        if (isset($row['Seedlings'])) { // Seedlings
            $this->Seedlings->setFormValue($row['Seedlings']);
        }
        if (isset($row['Seeds'])) { // Seeds
            $this->Seeds->setFormValue($row['Seeds']);
        }
        if (isset($row['Type'])) { // Type
            $this->Type->setFormValue($row['Type']);
        }
        if (isset($row['DateAllocated'])) { // DateAllocated
            $this->DateAllocated->setFormValue($row['DateAllocated']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("CidpDataList"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_DistrictCode":
                    break;
                case "x_GRNCode":
                    break;
                case "x_SupplierCode":
                    break;
                case "x_CampCode":
                    break;
                case "x_VillageCode":
                    break;
                case "x_Group":
                    break;
                case "x_Gender":
                    break;
                case "x_Type":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
