<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class CampFarmActivitySummary extends CampFarmActivity
{
    use MessagesTrait;

    // Page ID
    public $PageID = "summary";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "CampFarmActivitySummary";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $ReportContainerClass = "ew-grid";
    public $CurrentPageName = "CampFarmActivity";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'CampFarmActivity';
        $this->TableName = 'CampFarmActivity';

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->ReportContainerClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (CampFarmActivity)
        if (!isset($GLOBALS["CampFarmActivity"]) || $GLOBALS["CampFarmActivity"]::class == PROJECT_NAMESPACE . "CampFarmActivity") {
            $GLOBALS["CampFarmActivity"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'CampFarmActivity');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection if not in dashboard
        if (!$DashboardReport) {
            CloseConnections();
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }
        if ($fld instanceof ReportField) {
            $lookup->RenderViewFunc = "renderLookup"; // Set up view renderer
        }
        $lookup->RenderEditFunc = ""; // Set up edit renderer

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Options
    public $HideOptions = false;
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $FilterOptions; // Filter options

    // Records
    public $GroupRecords = [];
    public $DetailRecords = [];
    public $DetailRecordCount = 0;

    // Paging variables
    public $RecordIndex = 0; // Record index
    public $RecordCount = 0; // Record count (start from 1 for each group)
    public $StartGroup = 0; // Start group
    public $StopGroup = 0; // Stop group
    public $TotalGroups = 0; // Total groups
    public $GroupCount = 0; // Group count
    public $GroupCounter = []; // Group counter
    public $DisplayGroups = 1; // Groups per page
    public $GroupRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $PageFirstGroupFilter = "";
    public $UserIDFilter = "";
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = "";
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $DrillDownList = "";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $SearchCommand = false;
    public $ShowHeader = true;
    public $GroupColumnCount = 0;
    public $SubGroupColumnCount = 0;
    public $DetailColumnCount = 0;
    public $TotalCount;
    public $PageTotalCount;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $DrillDownInPanel, $Breadcrumb, $DashboardReport;

        // Set up dashboard report
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));
        if ($DashboardReport) {
            $this->UseAjaxActions = true;
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar)); // Set up Dashboard Filter
        }

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Setup export options
        $this->setupExportOptions();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up table class
        if ($this->isExport("word") || $this->isExport("excel") || $this->isExport("pdf")) {
            $this->TableClass = "ew-table table-bordered table-sm";
        } else {
            PrependClass($this->TableClass, "table ew-table table-bordered table-sm");
        }

        // Set up report container class
        if (!$this->isExport("word") && !$this->isExport("excel")) {
            $this->ReportContainerClass .= " card ew-card";
        }

        // Set field visibility for detail fields
        $this->FarmerNo->setVisibility();
        $this->NRC->setVisibility();
        $this->FarmerName->setVisibility();
        $this->Age->setVisibility();
        $this->Gender->setVisibility();
        $this->MaritalStatus->setVisibility();
        $this->PhoneNo->setVisibility();
        $this->_Email->setVisibility();
        $this->Dependants->setVisibility();
        $this->MaleChildren->setVisibility();
        $this->FemaleChildren->setVisibility();
        $this->HouseholdHead->setVisibility();
        $this->FarmerOrg->setVisibility();
        $this->FarmerOrgPosition->setVisibility();
        $this->JoiningDate->setVisibility();
        $this->Comments->setVisibility();
        $this->ProvinceCode->setVisibility();
        $this->DistrictCode->setVisibility();
        $this->CampCode->setVisibility();
        $this->VillageCode->setVisibility();
        $this->FarmNo->setVisibility();
        $this->Latitude->setVisibility();
        $this->Longitude->setVisibility();
        $this->FieldType->setVisibility();
        $this->Ownership->setVisibility();
        $this->FarmSize->setVisibility();
        $this->TreesPlantedEstimated->setVisibility();
        $this->FarmSizeVerified->setVisibility();
        $this->TreesPlantedVerified->setVisibility();
        $this->SourcesOfSeedlings->setVisibility();
        $this->ClearedLand->setVisibility();
        $this->SeedlingsAllocated->setVisibility();
        $this->OldTrees->setVisibility();

        // Set up Breadcrumb
        if (!$this->isExport() && !$DashboardReport) {
            $this->setupBreadcrumb();
        }

        // Load custom filters
        $this->pageFilterLoad();

        // Extended filter
        $extendedFilter = "";

        // No filter
        $this->FilterOptions["savecurrentfilter"]->Visible = false;
        $this->FilterOptions["deletefilter"]->Visible = false;

        // Call Page Selecting event
        $this->pageSelecting($this->SearchWhere);

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Get sort
        $this->Sort = $this->getSort();

        // Search options
        $this->setupSearchOptions();

        // Update filter
        AddFilter($this->Filter, $this->SearchWhere);

        // Get total count
        $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
        $this->TotalGroups = $this->getRecordCount($sql);
        if ($this->DisplayGroups <= 0 || $this->DrillDown) { // Display all groups
            $this->DisplayGroups = $this->TotalGroups;
        }
        $this->StartGroup = 1;

        // Set up start position if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->DisplayGroups = $this->TotalGroups;
        } else {
            $this->setupStartGroup();
        }

        // Set no record found message
        if ($this->TotalGroups == 0) {
            $this->ShowHeader = false;
            if ($Security->canList()) {
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            } else {
                $this->setWarningMessage(DeniedMessage());
            }
        }

        // Hide export options if export/dashboard report/hide options
        if ($this->isExport() || $DashboardReport || $this->HideOptions) {
            $this->ExportOptions->hideAllOptions();
        }

        // Hide search/filter options if export/drilldown/dashboard report/hide options
        if ($this->isExport() || $this->DrillDown || $DashboardReport || $this->HideOptions) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }

        // Get current page records
        if ($this->TotalGroups > 0) {
            $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, $this->Sort);
            $rs = $sql->setFirstResult(max($this->StartGroup - 1, 0))->setMaxResults($this->DisplayGroups)->executeQuery();
            $this->DetailRecords = $rs->fetchAll(); // Get records
            $this->GroupCount = 1;
        }
        $this->setupFieldCount();

        // Set the last group to display if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->StopGroup = $this->TotalGroups;
        } else {
            $this->StopGroup = $this->StartGroup + $this->DisplayGroups - 1;
        }

        // Stop group <= total number of groups
        if (intval($this->StopGroup) > intval($this->TotalGroups)) {
            $this->StopGroup = $this->TotalGroups;
        }
        $this->RecordCount = 0;
        $this->RecordIndex = 0;
        $this->setGroupCount($this->StopGroup - $this->StartGroup + 1, 1);

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartGroup, $this->DisplayGroups, $this->TotalGroups, $this->PageSizes, $this->GroupRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Check if no records
        if ($this->TotalGroups == 0) {
            $this->ReportContainerClass .= " ew-no-record";
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load row values
    public function loadRowValues($record)
    {
        $data = [];
        $data["FarmerNo"] = $record['FarmerNo'];
        $data["NRC"] = $record['NRC'];
        $data["FarmerName"] = $record['FarmerName'];
        $data["Age"] = $record['Age'];
        $data["Gender"] = $record['Gender'];
        $data["MaritalStatus"] = $record['MaritalStatus'];
        $data["PhoneNo"] = $record['PhoneNo'];
        $data["_Email"] = $record['Email'];
        $data["Dependants"] = $record['Dependants'];
        $data["MaleChildren"] = $record['MaleChildren'];
        $data["FemaleChildren"] = $record['FemaleChildren'];
        $data["HouseholdHead"] = $record['HouseholdHead'];
        $data["FarmerOrg"] = $record['FarmerOrg'];
        $data["FarmerOrgPosition"] = $record['FarmerOrgPosition'];
        $data["JoiningDate"] = $record['JoiningDate'];
        $data["Comments"] = $record['Comments'];
        $data["ProvinceCode"] = $record['ProvinceCode'];
        $data["DistrictCode"] = $record['DistrictCode'];
        $data["CampCode"] = $record['CampCode'];
        $data["VillageCode"] = $record['VillageCode'];
        $data["FarmNo"] = $record['FarmNo'];
        $data["Coordinates"] = $record['Coordinates'];
        $data["Latitude"] = $record['Latitude'];
        $data["Longitude"] = $record['Longitude'];
        $data["FieldType"] = $record['FieldType'];
        $data["Ownership"] = $record['Ownership'];
        $data["FarmSize"] = $record['FarmSize'];
        $data["TreesPlantedEstimated"] = $record['TreesPlantedEstimated'];
        $data["FarmSizeVerified"] = $record['FarmSizeVerified'];
        $data["TreesPlantedVerified"] = $record['TreesPlantedVerified'];
        $data["SourcesOfSeedlings"] = $record['SourcesOfSeedlings'];
        $data["ClearedLand"] = $record['ClearedLand'];
        $data["SeedlingsAllocated"] = $record['SeedlingsAllocated'];
        $data["OldTrees"] = $record['OldTrees'];
        $this->Rows[] = $data;
        $this->FarmerNo->setDbValue($record['FarmerNo']);
        $this->NRC->setDbValue($record['NRC']);
        $this->FarmerName->setDbValue($record['FarmerName']);
        $this->Age->setDbValue($record['Age']);
        $this->Gender->setDbValue($record['Gender']);
        $this->MaritalStatus->setDbValue($record['MaritalStatus']);
        $this->PhoneNo->setDbValue($record['PhoneNo']);
        $this->_Email->setDbValue($record['Email']);
        $this->Dependants->setDbValue($record['Dependants']);
        $this->MaleChildren->setDbValue($record['MaleChildren']);
        $this->FemaleChildren->setDbValue($record['FemaleChildren']);
        $this->HouseholdHead->setDbValue($record['HouseholdHead']);
        $this->FarmerOrg->setDbValue($record['FarmerOrg']);
        $this->FarmerOrgPosition->setDbValue($record['FarmerOrgPosition']);
        $this->JoiningDate->setDbValue($record['JoiningDate']);
        $this->Comments->setDbValue($record['Comments']);
        $this->ProvinceCode->setDbValue($record['ProvinceCode']);
        $this->DistrictCode->setDbValue($record['DistrictCode']);
        $this->CampCode->setDbValue($record['CampCode']);
        $this->VillageCode->setDbValue($record['VillageCode']);
        $this->FarmNo->setDbValue($record['FarmNo']);
        $this->Coordinates->setDbValue($record['Coordinates']);
        $this->Latitude->setDbValue($record['Latitude']);
        $this->Longitude->setDbValue($record['Longitude']);
        $this->FieldType->setDbValue($record['FieldType']);
        $this->Ownership->setDbValue($record['Ownership']);
        $this->FarmSize->setDbValue($record['FarmSize']);
        $this->TreesPlantedEstimated->setDbValue($record['TreesPlantedEstimated']);
        $this->FarmSizeVerified->setDbValue($record['FarmSizeVerified']);
        $this->TreesPlantedVerified->setDbValue($record['TreesPlantedVerified']);
        $this->SourcesOfSeedlings->setDbValue($record['SourcesOfSeedlings']);
        $this->InspecationReport->setDbValue($record['InspecationReport']);
        $this->ClearedLand->setDbValue($record['ClearedLand']);
        $this->SeedlingsAllocated->setDbValue($record['SeedlingsAllocated']);
        $this->OldTrees->setDbValue($record['OldTrees']);
    }

    // Render row
    public function renderRow()
    {
        global $Security, $Language, $Language;
        $conn = $this->getConnection();
        if ($this->RowType == RowType::TOTAL && $this->RowTotalSubType == RowTotal::FOOTER && $this->RowTotalType == RowSummary::PAGE) { // Get Page total
            $records = &$this->DetailRecords;
            $this->PageTotalCount = count($records);
        } elseif ($this->RowType == RowType::TOTAL && $this->RowTotalSubType == RowTotal::FOOTER && $this->RowTotalType == RowSummary::GRAND) { // Get Grand total
            $hasCount = false;
            $hasSummary = false;

            // Get total count from SQL directly
            $sql = $this->buildReportSql($this->getSqlSelectCount(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
            $rstot = $conn->executeQuery($sql);
            if ($rstot && $cnt = $rstot->fetchOne()) {
                $hasCount = true;
            } else {
                $cnt = 0;
            }
            $this->TotalCount = $cnt;
            $hasSummary = true;

            // Accumulate grand summary from detail records
            if (!$hasCount || !$hasSummary) {
                $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
                $rs = $sql->executeQuery();
                $this->DetailRecords = $rs?->fetchAll() ?? [];
            }
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // FarmerNo

        // NRC

        // FarmerName

        // Age

        // Gender

        // MaritalStatus

        // PhoneNo

        // Email

        // Dependants

        // MaleChildren

        // FemaleChildren

        // HouseholdHead

        // FarmerOrg

        // FarmerOrgPosition

        // JoiningDate

        // Comments

        // ProvinceCode

        // DistrictCode

        // CampCode

        // VillageCode

        // FarmNo

        // Latitude

        // Longitude

        // FieldType

        // Ownership

        // FarmSize

        // TreesPlantedEstimated

        // FarmSizeVerified

        // TreesPlantedVerified

        // SourcesOfSeedlings

        // ClearedLand

        // SeedlingsAllocated

        // OldTrees
        if ($this->RowType == RowType::SEARCH) { // Search row
        } elseif ($this->RowType == RowType::TOTAL && !($this->RowTotalType == RowSummary::GROUP && $this->RowTotalSubType == RowTotal::HEADER)) { // Summary row
            $this->RowAttrs->prependClass(($this->RowTotalType == RowSummary::PAGE || $this->RowTotalType == RowSummary::GRAND) ? "ew-rpt-grp-aggregate" : ""); // Set up row class

            // FarmerNo
            $this->FarmerNo->HrefValue = "";

            // NRC
            $this->NRC->HrefValue = "";

            // FarmerName
            $this->FarmerName->HrefValue = "";

            // Age
            $this->Age->HrefValue = "";

            // Gender
            $this->Gender->HrefValue = "";

            // MaritalStatus
            $this->MaritalStatus->HrefValue = "";

            // PhoneNo
            $this->PhoneNo->HrefValue = "";

            // Email
            $this->_Email->HrefValue = "";

            // Dependants
            $this->Dependants->HrefValue = "";

            // MaleChildren
            $this->MaleChildren->HrefValue = "";

            // FemaleChildren
            $this->FemaleChildren->HrefValue = "";

            // HouseholdHead
            $this->HouseholdHead->HrefValue = "";

            // FarmerOrg
            $this->FarmerOrg->HrefValue = "";

            // FarmerOrgPosition
            $this->FarmerOrgPosition->HrefValue = "";

            // JoiningDate
            $this->JoiningDate->HrefValue = "";

            // Comments
            $this->Comments->HrefValue = "";

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";

            // FieldType
            $this->FieldType->HrefValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";

            // FarmSize
            $this->FarmSize->HrefValue = "";

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->HrefValue = "";

            // FarmSizeVerified
            $this->FarmSizeVerified->HrefValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->HrefValue = "";

            // ClearedLand
            $this->ClearedLand->HrefValue = "";

            // SeedlingsAllocated
            $this->SeedlingsAllocated->HrefValue = "";

            // OldTrees
            $this->OldTrees->HrefValue = "";
        } else {
            if ($this->RowTotalType == RowSummary::GROUP && $this->RowTotalSubType == RowTotal::HEADER) {
            } else {
            }

            // Increment RowCount
            if ($this->RowType == RowType::DETAIL) {
                $this->RowCount++;
            }

            // FarmerNo
            $this->FarmerNo->ViewValue = $this->FarmerNo->CurrentValue;
            $this->FarmerNo->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // NRC
            $this->NRC->ViewValue = $this->NRC->CurrentValue;
            $this->NRC->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FarmerName
            $this->FarmerName->ViewValue = $this->FarmerName->CurrentValue;
            $this->FarmerName->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Age
            $this->Age->ViewValue = $this->Age->CurrentValue;
            $this->Age->ViewValue = FormatNumber($this->Age->ViewValue, $this->Age->formatPattern());
            $this->Age->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Gender
            $this->Gender->ViewValue = $this->Gender->CurrentValue;
            $this->Gender->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // MaritalStatus
            $this->MaritalStatus->ViewValue = $this->MaritalStatus->CurrentValue;
            $this->MaritalStatus->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // PhoneNo
            $this->PhoneNo->ViewValue = $this->PhoneNo->CurrentValue;
            $this->PhoneNo->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Email
            $this->_Email->ViewValue = $this->_Email->CurrentValue;
            $this->_Email->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Dependants
            $this->Dependants->ViewValue = $this->Dependants->CurrentValue;
            $this->Dependants->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // MaleChildren
            $this->MaleChildren->ViewValue = $this->MaleChildren->CurrentValue;
            $this->MaleChildren->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FemaleChildren
            $this->FemaleChildren->ViewValue = $this->FemaleChildren->CurrentValue;
            $this->FemaleChildren->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // HouseholdHead
            $this->HouseholdHead->ViewValue = $this->HouseholdHead->CurrentValue;
            $this->HouseholdHead->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FarmerOrg
            $this->FarmerOrg->ViewValue = $this->FarmerOrg->CurrentValue;
            $this->FarmerOrg->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FarmerOrgPosition
            $this->FarmerOrgPosition->ViewValue = $this->FarmerOrgPosition->CurrentValue;
            $this->FarmerOrgPosition->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // JoiningDate
            $this->JoiningDate->ViewValue = $this->JoiningDate->CurrentValue;
            $this->JoiningDate->ViewValue = FormatDateTime($this->JoiningDate->ViewValue, $this->JoiningDate->formatPattern());
            $this->JoiningDate->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Comments
            $this->Comments->ViewValue = $this->Comments->CurrentValue;
            $this->Comments->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // ProvinceCode
            $this->ProvinceCode->ViewValue = $this->ProvinceCode->CurrentValue;
            $this->ProvinceCode->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // DistrictCode
            $this->DistrictCode->ViewValue = $this->DistrictCode->CurrentValue;
            $this->DistrictCode->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // CampCode
            $this->CampCode->ViewValue = $this->CampCode->CurrentValue;
            $this->CampCode->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // VillageCode
            $this->VillageCode->ViewValue = $this->VillageCode->CurrentValue;
            $this->VillageCode->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;
            $this->FarmNo->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Latitude
            $this->Latitude->ViewValue = $this->Latitude->CurrentValue;
            $this->Latitude->ViewValue = FormatNumber($this->Latitude->ViewValue, $this->Latitude->formatPattern());
            $this->Latitude->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Longitude
            $this->Longitude->ViewValue = $this->Longitude->CurrentValue;
            $this->Longitude->ViewValue = FormatNumber($this->Longitude->ViewValue, $this->Longitude->formatPattern());
            $this->Longitude->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FieldType
            $this->FieldType->ViewValue = $this->FieldType->CurrentValue;
            $this->FieldType->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Ownership
            $this->Ownership->ViewValue = $this->Ownership->CurrentValue;
            $this->Ownership->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FarmSize
            $this->FarmSize->ViewValue = $this->FarmSize->CurrentValue;
            $this->FarmSize->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->ViewValue = $this->TreesPlantedEstimated->CurrentValue;
            $this->TreesPlantedEstimated->ViewValue = FormatNumber($this->TreesPlantedEstimated->ViewValue, $this->TreesPlantedEstimated->formatPattern());
            $this->TreesPlantedEstimated->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FarmSizeVerified
            $this->FarmSizeVerified->ViewValue = $this->FarmSizeVerified->CurrentValue;
            $this->FarmSizeVerified->ViewValue = FormatNumber($this->FarmSizeVerified->ViewValue, $this->FarmSizeVerified->formatPattern());
            $this->FarmSizeVerified->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // TreesPlantedVerified
            $this->TreesPlantedVerified->ViewValue = $this->TreesPlantedVerified->CurrentValue;
            $this->TreesPlantedVerified->ViewValue = FormatNumber($this->TreesPlantedVerified->ViewValue, $this->TreesPlantedVerified->formatPattern());
            $this->TreesPlantedVerified->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->ViewValue = $this->SourcesOfSeedlings->CurrentValue;
            $this->SourcesOfSeedlings->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // ClearedLand
            $this->ClearedLand->ViewValue = $this->ClearedLand->CurrentValue;
            $this->ClearedLand->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // SeedlingsAllocated
            $this->SeedlingsAllocated->ViewValue = $this->SeedlingsAllocated->CurrentValue;
            $this->SeedlingsAllocated->ViewValue = FormatNumber($this->SeedlingsAllocated->ViewValue, $this->SeedlingsAllocated->formatPattern());
            $this->SeedlingsAllocated->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // OldTrees
            $this->OldTrees->ViewValue = $this->OldTrees->CurrentValue;
            $this->OldTrees->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FarmerNo
            $this->FarmerNo->HrefValue = "";
            $this->FarmerNo->TooltipValue = "";

            // NRC
            $this->NRC->HrefValue = "";
            $this->NRC->TooltipValue = "";

            // FarmerName
            $this->FarmerName->HrefValue = "";
            $this->FarmerName->TooltipValue = "";

            // Age
            $this->Age->HrefValue = "";
            $this->Age->TooltipValue = "";

            // Gender
            $this->Gender->HrefValue = "";
            $this->Gender->TooltipValue = "";

            // MaritalStatus
            $this->MaritalStatus->HrefValue = "";
            $this->MaritalStatus->TooltipValue = "";

            // PhoneNo
            $this->PhoneNo->HrefValue = "";
            $this->PhoneNo->TooltipValue = "";

            // Email
            $this->_Email->HrefValue = "";
            $this->_Email->TooltipValue = "";

            // Dependants
            $this->Dependants->HrefValue = "";
            $this->Dependants->TooltipValue = "";

            // MaleChildren
            $this->MaleChildren->HrefValue = "";
            $this->MaleChildren->TooltipValue = "";

            // FemaleChildren
            $this->FemaleChildren->HrefValue = "";
            $this->FemaleChildren->TooltipValue = "";

            // HouseholdHead
            $this->HouseholdHead->HrefValue = "";
            $this->HouseholdHead->TooltipValue = "";

            // FarmerOrg
            $this->FarmerOrg->HrefValue = "";
            $this->FarmerOrg->TooltipValue = "";

            // FarmerOrgPosition
            $this->FarmerOrgPosition->HrefValue = "";
            $this->FarmerOrgPosition->TooltipValue = "";

            // JoiningDate
            $this->JoiningDate->HrefValue = "";
            $this->JoiningDate->TooltipValue = "";

            // Comments
            $this->Comments->HrefValue = "";
            $this->Comments->TooltipValue = "";

            // ProvinceCode
            $this->ProvinceCode->HrefValue = "";
            $this->ProvinceCode->TooltipValue = "";

            // DistrictCode
            $this->DistrictCode->HrefValue = "";
            $this->DistrictCode->TooltipValue = "";

            // CampCode
            $this->CampCode->HrefValue = "";
            $this->CampCode->TooltipValue = "";

            // VillageCode
            $this->VillageCode->HrefValue = "";
            $this->VillageCode->TooltipValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";
            $this->FarmNo->TooltipValue = "";

            // Latitude
            $this->Latitude->HrefValue = "";
            $this->Latitude->TooltipValue = "";

            // Longitude
            $this->Longitude->HrefValue = "";
            $this->Longitude->TooltipValue = "";

            // FieldType
            $this->FieldType->HrefValue = "";
            $this->FieldType->TooltipValue = "";

            // Ownership
            $this->Ownership->HrefValue = "";
            $this->Ownership->TooltipValue = "";

            // FarmSize
            $this->FarmSize->HrefValue = "";
            $this->FarmSize->TooltipValue = "";

            // TreesPlantedEstimated
            $this->TreesPlantedEstimated->HrefValue = "";
            $this->TreesPlantedEstimated->TooltipValue = "";

            // FarmSizeVerified
            $this->FarmSizeVerified->HrefValue = "";
            $this->FarmSizeVerified->TooltipValue = "";

            // TreesPlantedVerified
            $this->TreesPlantedVerified->HrefValue = "";
            $this->TreesPlantedVerified->TooltipValue = "";

            // SourcesOfSeedlings
            $this->SourcesOfSeedlings->HrefValue = "";
            $this->SourcesOfSeedlings->TooltipValue = "";

            // ClearedLand
            $this->ClearedLand->HrefValue = "";
            $this->ClearedLand->TooltipValue = "";

            // SeedlingsAllocated
            $this->SeedlingsAllocated->HrefValue = "";
            $this->SeedlingsAllocated->TooltipValue = "";

            // OldTrees
            $this->OldTrees->HrefValue = "";
            $this->OldTrees->TooltipValue = "";
        }

        // Call Cell_Rendered event
        if ($this->RowType == RowType::TOTAL) { // Summary row
        } else {
            // FarmerNo
            $currentValue = $this->FarmerNo->CurrentValue;
            $viewValue = &$this->FarmerNo->ViewValue;
            $viewAttrs = &$this->FarmerNo->ViewAttrs;
            $cellAttrs = &$this->FarmerNo->CellAttrs;
            $hrefValue = &$this->FarmerNo->HrefValue;
            $linkAttrs = &$this->FarmerNo->LinkAttrs;
            $this->cellRendered($this->FarmerNo, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // NRC
            $currentValue = $this->NRC->CurrentValue;
            $viewValue = &$this->NRC->ViewValue;
            $viewAttrs = &$this->NRC->ViewAttrs;
            $cellAttrs = &$this->NRC->CellAttrs;
            $hrefValue = &$this->NRC->HrefValue;
            $linkAttrs = &$this->NRC->LinkAttrs;
            $this->cellRendered($this->NRC, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FarmerName
            $currentValue = $this->FarmerName->CurrentValue;
            $viewValue = &$this->FarmerName->ViewValue;
            $viewAttrs = &$this->FarmerName->ViewAttrs;
            $cellAttrs = &$this->FarmerName->CellAttrs;
            $hrefValue = &$this->FarmerName->HrefValue;
            $linkAttrs = &$this->FarmerName->LinkAttrs;
            $this->cellRendered($this->FarmerName, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Age
            $currentValue = $this->Age->CurrentValue;
            $viewValue = &$this->Age->ViewValue;
            $viewAttrs = &$this->Age->ViewAttrs;
            $cellAttrs = &$this->Age->CellAttrs;
            $hrefValue = &$this->Age->HrefValue;
            $linkAttrs = &$this->Age->LinkAttrs;
            $this->cellRendered($this->Age, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Gender
            $currentValue = $this->Gender->CurrentValue;
            $viewValue = &$this->Gender->ViewValue;
            $viewAttrs = &$this->Gender->ViewAttrs;
            $cellAttrs = &$this->Gender->CellAttrs;
            $hrefValue = &$this->Gender->HrefValue;
            $linkAttrs = &$this->Gender->LinkAttrs;
            $this->cellRendered($this->Gender, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // MaritalStatus
            $currentValue = $this->MaritalStatus->CurrentValue;
            $viewValue = &$this->MaritalStatus->ViewValue;
            $viewAttrs = &$this->MaritalStatus->ViewAttrs;
            $cellAttrs = &$this->MaritalStatus->CellAttrs;
            $hrefValue = &$this->MaritalStatus->HrefValue;
            $linkAttrs = &$this->MaritalStatus->LinkAttrs;
            $this->cellRendered($this->MaritalStatus, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // PhoneNo
            $currentValue = $this->PhoneNo->CurrentValue;
            $viewValue = &$this->PhoneNo->ViewValue;
            $viewAttrs = &$this->PhoneNo->ViewAttrs;
            $cellAttrs = &$this->PhoneNo->CellAttrs;
            $hrefValue = &$this->PhoneNo->HrefValue;
            $linkAttrs = &$this->PhoneNo->LinkAttrs;
            $this->cellRendered($this->PhoneNo, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Email
            $currentValue = $this->_Email->CurrentValue;
            $viewValue = &$this->_Email->ViewValue;
            $viewAttrs = &$this->_Email->ViewAttrs;
            $cellAttrs = &$this->_Email->CellAttrs;
            $hrefValue = &$this->_Email->HrefValue;
            $linkAttrs = &$this->_Email->LinkAttrs;
            $this->cellRendered($this->_Email, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Dependants
            $currentValue = $this->Dependants->CurrentValue;
            $viewValue = &$this->Dependants->ViewValue;
            $viewAttrs = &$this->Dependants->ViewAttrs;
            $cellAttrs = &$this->Dependants->CellAttrs;
            $hrefValue = &$this->Dependants->HrefValue;
            $linkAttrs = &$this->Dependants->LinkAttrs;
            $this->cellRendered($this->Dependants, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // MaleChildren
            $currentValue = $this->MaleChildren->CurrentValue;
            $viewValue = &$this->MaleChildren->ViewValue;
            $viewAttrs = &$this->MaleChildren->ViewAttrs;
            $cellAttrs = &$this->MaleChildren->CellAttrs;
            $hrefValue = &$this->MaleChildren->HrefValue;
            $linkAttrs = &$this->MaleChildren->LinkAttrs;
            $this->cellRendered($this->MaleChildren, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FemaleChildren
            $currentValue = $this->FemaleChildren->CurrentValue;
            $viewValue = &$this->FemaleChildren->ViewValue;
            $viewAttrs = &$this->FemaleChildren->ViewAttrs;
            $cellAttrs = &$this->FemaleChildren->CellAttrs;
            $hrefValue = &$this->FemaleChildren->HrefValue;
            $linkAttrs = &$this->FemaleChildren->LinkAttrs;
            $this->cellRendered($this->FemaleChildren, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // HouseholdHead
            $currentValue = $this->HouseholdHead->CurrentValue;
            $viewValue = &$this->HouseholdHead->ViewValue;
            $viewAttrs = &$this->HouseholdHead->ViewAttrs;
            $cellAttrs = &$this->HouseholdHead->CellAttrs;
            $hrefValue = &$this->HouseholdHead->HrefValue;
            $linkAttrs = &$this->HouseholdHead->LinkAttrs;
            $this->cellRendered($this->HouseholdHead, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FarmerOrg
            $currentValue = $this->FarmerOrg->CurrentValue;
            $viewValue = &$this->FarmerOrg->ViewValue;
            $viewAttrs = &$this->FarmerOrg->ViewAttrs;
            $cellAttrs = &$this->FarmerOrg->CellAttrs;
            $hrefValue = &$this->FarmerOrg->HrefValue;
            $linkAttrs = &$this->FarmerOrg->LinkAttrs;
            $this->cellRendered($this->FarmerOrg, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FarmerOrgPosition
            $currentValue = $this->FarmerOrgPosition->CurrentValue;
            $viewValue = &$this->FarmerOrgPosition->ViewValue;
            $viewAttrs = &$this->FarmerOrgPosition->ViewAttrs;
            $cellAttrs = &$this->FarmerOrgPosition->CellAttrs;
            $hrefValue = &$this->FarmerOrgPosition->HrefValue;
            $linkAttrs = &$this->FarmerOrgPosition->LinkAttrs;
            $this->cellRendered($this->FarmerOrgPosition, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // JoiningDate
            $currentValue = $this->JoiningDate->CurrentValue;
            $viewValue = &$this->JoiningDate->ViewValue;
            $viewAttrs = &$this->JoiningDate->ViewAttrs;
            $cellAttrs = &$this->JoiningDate->CellAttrs;
            $hrefValue = &$this->JoiningDate->HrefValue;
            $linkAttrs = &$this->JoiningDate->LinkAttrs;
            $this->cellRendered($this->JoiningDate, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Comments
            $currentValue = $this->Comments->CurrentValue;
            $viewValue = &$this->Comments->ViewValue;
            $viewAttrs = &$this->Comments->ViewAttrs;
            $cellAttrs = &$this->Comments->CellAttrs;
            $hrefValue = &$this->Comments->HrefValue;
            $linkAttrs = &$this->Comments->LinkAttrs;
            $this->cellRendered($this->Comments, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // ProvinceCode
            $currentValue = $this->ProvinceCode->CurrentValue;
            $viewValue = &$this->ProvinceCode->ViewValue;
            $viewAttrs = &$this->ProvinceCode->ViewAttrs;
            $cellAttrs = &$this->ProvinceCode->CellAttrs;
            $hrefValue = &$this->ProvinceCode->HrefValue;
            $linkAttrs = &$this->ProvinceCode->LinkAttrs;
            $this->cellRendered($this->ProvinceCode, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // DistrictCode
            $currentValue = $this->DistrictCode->CurrentValue;
            $viewValue = &$this->DistrictCode->ViewValue;
            $viewAttrs = &$this->DistrictCode->ViewAttrs;
            $cellAttrs = &$this->DistrictCode->CellAttrs;
            $hrefValue = &$this->DistrictCode->HrefValue;
            $linkAttrs = &$this->DistrictCode->LinkAttrs;
            $this->cellRendered($this->DistrictCode, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // CampCode
            $currentValue = $this->CampCode->CurrentValue;
            $viewValue = &$this->CampCode->ViewValue;
            $viewAttrs = &$this->CampCode->ViewAttrs;
            $cellAttrs = &$this->CampCode->CellAttrs;
            $hrefValue = &$this->CampCode->HrefValue;
            $linkAttrs = &$this->CampCode->LinkAttrs;
            $this->cellRendered($this->CampCode, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // VillageCode
            $currentValue = $this->VillageCode->CurrentValue;
            $viewValue = &$this->VillageCode->ViewValue;
            $viewAttrs = &$this->VillageCode->ViewAttrs;
            $cellAttrs = &$this->VillageCode->CellAttrs;
            $hrefValue = &$this->VillageCode->HrefValue;
            $linkAttrs = &$this->VillageCode->LinkAttrs;
            $this->cellRendered($this->VillageCode, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FarmNo
            $currentValue = $this->FarmNo->CurrentValue;
            $viewValue = &$this->FarmNo->ViewValue;
            $viewAttrs = &$this->FarmNo->ViewAttrs;
            $cellAttrs = &$this->FarmNo->CellAttrs;
            $hrefValue = &$this->FarmNo->HrefValue;
            $linkAttrs = &$this->FarmNo->LinkAttrs;
            $this->cellRendered($this->FarmNo, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Latitude
            $currentValue = $this->Latitude->CurrentValue;
            $viewValue = &$this->Latitude->ViewValue;
            $viewAttrs = &$this->Latitude->ViewAttrs;
            $cellAttrs = &$this->Latitude->CellAttrs;
            $hrefValue = &$this->Latitude->HrefValue;
            $linkAttrs = &$this->Latitude->LinkAttrs;
            $this->cellRendered($this->Latitude, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Longitude
            $currentValue = $this->Longitude->CurrentValue;
            $viewValue = &$this->Longitude->ViewValue;
            $viewAttrs = &$this->Longitude->ViewAttrs;
            $cellAttrs = &$this->Longitude->CellAttrs;
            $hrefValue = &$this->Longitude->HrefValue;
            $linkAttrs = &$this->Longitude->LinkAttrs;
            $this->cellRendered($this->Longitude, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FieldType
            $currentValue = $this->FieldType->CurrentValue;
            $viewValue = &$this->FieldType->ViewValue;
            $viewAttrs = &$this->FieldType->ViewAttrs;
            $cellAttrs = &$this->FieldType->CellAttrs;
            $hrefValue = &$this->FieldType->HrefValue;
            $linkAttrs = &$this->FieldType->LinkAttrs;
            $this->cellRendered($this->FieldType, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Ownership
            $currentValue = $this->Ownership->CurrentValue;
            $viewValue = &$this->Ownership->ViewValue;
            $viewAttrs = &$this->Ownership->ViewAttrs;
            $cellAttrs = &$this->Ownership->CellAttrs;
            $hrefValue = &$this->Ownership->HrefValue;
            $linkAttrs = &$this->Ownership->LinkAttrs;
            $this->cellRendered($this->Ownership, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FarmSize
            $currentValue = $this->FarmSize->CurrentValue;
            $viewValue = &$this->FarmSize->ViewValue;
            $viewAttrs = &$this->FarmSize->ViewAttrs;
            $cellAttrs = &$this->FarmSize->CellAttrs;
            $hrefValue = &$this->FarmSize->HrefValue;
            $linkAttrs = &$this->FarmSize->LinkAttrs;
            $this->cellRendered($this->FarmSize, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // TreesPlantedEstimated
            $currentValue = $this->TreesPlantedEstimated->CurrentValue;
            $viewValue = &$this->TreesPlantedEstimated->ViewValue;
            $viewAttrs = &$this->TreesPlantedEstimated->ViewAttrs;
            $cellAttrs = &$this->TreesPlantedEstimated->CellAttrs;
            $hrefValue = &$this->TreesPlantedEstimated->HrefValue;
            $linkAttrs = &$this->TreesPlantedEstimated->LinkAttrs;
            $this->cellRendered($this->TreesPlantedEstimated, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FarmSizeVerified
            $currentValue = $this->FarmSizeVerified->CurrentValue;
            $viewValue = &$this->FarmSizeVerified->ViewValue;
            $viewAttrs = &$this->FarmSizeVerified->ViewAttrs;
            $cellAttrs = &$this->FarmSizeVerified->CellAttrs;
            $hrefValue = &$this->FarmSizeVerified->HrefValue;
            $linkAttrs = &$this->FarmSizeVerified->LinkAttrs;
            $this->cellRendered($this->FarmSizeVerified, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // TreesPlantedVerified
            $currentValue = $this->TreesPlantedVerified->CurrentValue;
            $viewValue = &$this->TreesPlantedVerified->ViewValue;
            $viewAttrs = &$this->TreesPlantedVerified->ViewAttrs;
            $cellAttrs = &$this->TreesPlantedVerified->CellAttrs;
            $hrefValue = &$this->TreesPlantedVerified->HrefValue;
            $linkAttrs = &$this->TreesPlantedVerified->LinkAttrs;
            $this->cellRendered($this->TreesPlantedVerified, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // SourcesOfSeedlings
            $currentValue = $this->SourcesOfSeedlings->CurrentValue;
            $viewValue = &$this->SourcesOfSeedlings->ViewValue;
            $viewAttrs = &$this->SourcesOfSeedlings->ViewAttrs;
            $cellAttrs = &$this->SourcesOfSeedlings->CellAttrs;
            $hrefValue = &$this->SourcesOfSeedlings->HrefValue;
            $linkAttrs = &$this->SourcesOfSeedlings->LinkAttrs;
            $this->cellRendered($this->SourcesOfSeedlings, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // ClearedLand
            $currentValue = $this->ClearedLand->CurrentValue;
            $viewValue = &$this->ClearedLand->ViewValue;
            $viewAttrs = &$this->ClearedLand->ViewAttrs;
            $cellAttrs = &$this->ClearedLand->CellAttrs;
            $hrefValue = &$this->ClearedLand->HrefValue;
            $linkAttrs = &$this->ClearedLand->LinkAttrs;
            $this->cellRendered($this->ClearedLand, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // SeedlingsAllocated
            $currentValue = $this->SeedlingsAllocated->CurrentValue;
            $viewValue = &$this->SeedlingsAllocated->ViewValue;
            $viewAttrs = &$this->SeedlingsAllocated->ViewAttrs;
            $cellAttrs = &$this->SeedlingsAllocated->CellAttrs;
            $hrefValue = &$this->SeedlingsAllocated->HrefValue;
            $linkAttrs = &$this->SeedlingsAllocated->LinkAttrs;
            $this->cellRendered($this->SeedlingsAllocated, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // OldTrees
            $currentValue = $this->OldTrees->CurrentValue;
            $viewValue = &$this->OldTrees->ViewValue;
            $viewAttrs = &$this->OldTrees->ViewAttrs;
            $cellAttrs = &$this->OldTrees->CellAttrs;
            $hrefValue = &$this->OldTrees->HrefValue;
            $linkAttrs = &$this->OldTrees->LinkAttrs;
            $this->cellRendered($this->OldTrees, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        }

        // Call Row_Rendered event
        $this->rowRendered();
        $this->setupFieldCount();
    }
    private $groupCounts = [];

    // Get group count
    public function getGroupCount(...$args)
    {
        $key = implode("_", array_map(fn($arg) => strval($arg), $args));
        if ($key == "") {
            return -1;
        } elseif ($key == "0") { // Number of first level groups
            $i = 1;
            while (isset($this->groupCounts[strval($i)])) {
                $i++;
            }
            return $i - 1;
        }
        return isset($this->groupCounts[$key]) ? $this->groupCounts[$key] : -1;
    }

    // Set group count
    public function setGroupCount($value, ...$args)
    {
        $key = implode("_", array_map(fn($arg) => strval($arg), $args));
        if ($key == "") {
            return;
        }
        $this->groupCounts[$key] = $value;
    }

    // Setup field count
    protected function setupFieldCount()
    {
        $this->GroupColumnCount = 0;
        $this->SubGroupColumnCount = 0;
        $this->DetailColumnCount = 0;
        if ($this->FarmerNo->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->NRC->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FarmerName->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Age->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Gender->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->MaritalStatus->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->PhoneNo->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->_Email->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Dependants->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->MaleChildren->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FemaleChildren->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->HouseholdHead->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FarmerOrg->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FarmerOrgPosition->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->JoiningDate->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Comments->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->ProvinceCode->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->DistrictCode->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->CampCode->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->VillageCode->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FarmNo->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Latitude->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Longitude->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FieldType->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Ownership->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FarmSize->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->TreesPlantedEstimated->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FarmSizeVerified->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->TreesPlantedVerified->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->SourcesOfSeedlings->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->ClearedLand->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->SeedlingsAllocated->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->OldTrees->Visible) {
            $this->DetailColumnCount += 1;
        }
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-excel" title="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" data-ew-action="export" data-export="excel" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToExcel") . '</button>';
        } elseif (SameText($type, "word")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-word" title="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" data-ew-action="export" data-export="word" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToWord") . '</button>';
        } elseif (SameText($type, "pdf")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-pdf" title="' . HtmlEncode($Language->phrase("ExportToPdf", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToPdf", true)) . '" data-ew-action="export" data-export="pdf" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToPdf") . '</button>';
        } elseif (SameText($type, "html")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-html" title="' . HtmlEncode($Language->phrase("ExportToHtml", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToHtml", true)) . '" data-ew-action="export" data-export="html" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToHtml") . '</button>';
        } elseif (SameText($type, "email")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-ew-action="email" data-custom="false" data-export-selected="false" data-hdr="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = true;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide options for export
        if ($this->isExport()) {
            $this->ExportOptions->hideAllOptions();
        }
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return false;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("summary", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fCampFarmActivitysrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = false;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fCampFarmActivitysrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = false;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Set up starting group
    protected function setupStartGroup()
    {
        // Exit if no groups
        if ($this->DisplayGroups == 0) {
            return;
        }
        $startGrp = Param(Config("TABLE_START_GROUP"));
        $pageNo = Param(Config("TABLE_PAGE_NUMBER"));

        // Check for a 'start' parameter
        if ($startGrp !== null) {
            $this->StartGroup = $startGrp;
            $this->setStartGroup($this->StartGroup);
        } elseif ($pageNo !== null) {
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
                if ($this->StartGroup <= 0) {
                    $this->StartGroup = 1;
                } elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
                    $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
                }
                $this->setStartGroup($this->StartGroup);
            } else {
                $this->StartGroup = $this->getStartGroup();
            }
        } else {
            $this->StartGroup = $this->getStartGroup();
        }

        // Check if correct start group counter
        if (!is_numeric($this->StartGroup) || intval($this->StartGroup) <= 0) { // Avoid invalid start group counter
            $this->StartGroup = 1; // Reset start group counter
            $this->setStartGroup($this->StartGroup);
        } elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
            $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
            $this->setStartGroup($this->StartGroup);
        } elseif (($this->StartGroup - 1) % $this->DisplayGroups != 0) {
            $this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
            $this->setStartGroup($this->StartGroup);
        }
    }

    // Reset pager
    protected function resetPager()
    {
        // Reset start position (reset command)
        $this->StartGroup = 1;
        $this->setStartGroup($this->StartGroup);
    }

    // Get sort parameters based on sort links clicked
    protected function getSort()
    {
        if ($this->DrillDown) {
            return "";
        }
        $resetSort = Param("cmd") === "resetsort";
        $orderBy = Param("order", "");
        $orderType = Param("ordertype", "");

        // Check for a resetsort command
        if ($resetSort) {
            $this->setOrderBy("");
            $this->setStartGroup(1);
            $this->FarmerNo->setSort("");
            $this->NRC->setSort("");
            $this->FarmerName->setSort("");
            $this->Age->setSort("");
            $this->Gender->setSort("");
            $this->MaritalStatus->setSort("");
            $this->PhoneNo->setSort("");
            $this->_Email->setSort("");
            $this->Dependants->setSort("");
            $this->MaleChildren->setSort("");
            $this->FemaleChildren->setSort("");
            $this->HouseholdHead->setSort("");
            $this->FarmerOrg->setSort("");
            $this->FarmerOrgPosition->setSort("");
            $this->JoiningDate->setSort("");
            $this->Comments->setSort("");
            $this->ProvinceCode->setSort("");
            $this->DistrictCode->setSort("");
            $this->CampCode->setSort("");
            $this->VillageCode->setSort("");
            $this->FarmNo->setSort("");
            $this->Latitude->setSort("");
            $this->Longitude->setSort("");
            $this->FieldType->setSort("");
            $this->Ownership->setSort("");
            $this->FarmSize->setSort("");
            $this->TreesPlantedEstimated->setSort("");
            $this->FarmSizeVerified->setSort("");
            $this->TreesPlantedVerified->setSort("");
            $this->SourcesOfSeedlings->setSort("");
            $this->ClearedLand->setSort("");
            $this->SeedlingsAllocated->setSort("");
            $this->OldTrees->setSort("");

        // Check for an Order parameter
        } elseif ($orderBy != "") {
            $this->CurrentOrder = $orderBy;
            $this->CurrentOrderType = $orderType;
            $this->updateSort($this->FarmerNo); // FarmerNo
            $this->updateSort($this->NRC); // NRC
            $this->updateSort($this->FarmerName); // FarmerName
            $this->updateSort($this->Age); // Age
            $this->updateSort($this->Gender); // Gender
            $this->updateSort($this->MaritalStatus); // MaritalStatus
            $this->updateSort($this->PhoneNo); // PhoneNo
            $this->updateSort($this->_Email); // Email
            $this->updateSort($this->Dependants); // Dependants
            $this->updateSort($this->MaleChildren); // MaleChildren
            $this->updateSort($this->FemaleChildren); // FemaleChildren
            $this->updateSort($this->HouseholdHead); // HouseholdHead
            $this->updateSort($this->FarmerOrg); // FarmerOrg
            $this->updateSort($this->FarmerOrgPosition); // FarmerOrgPosition
            $this->updateSort($this->JoiningDate); // JoiningDate
            $this->updateSort($this->Comments); // Comments
            $this->updateSort($this->ProvinceCode); // ProvinceCode
            $this->updateSort($this->DistrictCode); // DistrictCode
            $this->updateSort($this->CampCode); // CampCode
            $this->updateSort($this->VillageCode); // VillageCode
            $this->updateSort($this->FarmNo); // FarmNo
            $this->updateSort($this->Latitude); // Latitude
            $this->updateSort($this->Longitude); // Longitude
            $this->updateSort($this->FieldType); // FieldType
            $this->updateSort($this->Ownership); // Ownership
            $this->updateSort($this->FarmSize); // FarmSize
            $this->updateSort($this->TreesPlantedEstimated); // TreesPlantedEstimated
            $this->updateSort($this->FarmSizeVerified); // FarmSizeVerified
            $this->updateSort($this->TreesPlantedVerified); // TreesPlantedVerified
            $this->updateSort($this->SourcesOfSeedlings); // SourcesOfSeedlings
            $this->updateSort($this->ClearedLand); // ClearedLand
            $this->updateSort($this->SeedlingsAllocated); // SeedlingsAllocated
            $this->updateSort($this->OldTrees); // OldTrees
            $sortSql = $this->sortSql();
            $this->setOrderBy($sortSql);
            $this->setStartGroup(1);
        }
        return $this->getOrderBy();
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Selecting event
    public function pageSelecting(&$filter)
    {
        // Enter your code here
    }

    // Load Filters event
    public function pageFilterLoad()
    {
        // Enter your code here
        // Example: Register/Unregister Custom Extended Filter
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A', 'GetStartsWithAFilter'); // With function, or
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A'); // No function, use Page_Filtering event
        //UnregisterFilter($this-><Field>, 'StartsWithA');
    }

    // Page Filter Validated event
    public function pageFilterValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Page Filtering event
    public function pageFiltering(&$fld, &$filter, $typ, $opr = "", $val = "", $cond = "", $opr2 = "", $val2 = "")
    {
        // Note: ALWAYS CHECK THE FILTER TYPE ($typ)! Example:
        //if ($typ == "dropdown" && $fld->Name == "MyField") // Dropdown filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "extended" && $fld->Name == "MyField") // Extended filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "custom" && $opr == "..." && $fld->Name == "MyField") // Custom filter, $opr is the custom filter ID
        //    $filter = "..."; // Modify the filter
    }

    // Cell Rendered event
    public function cellRendered(&$Field, $CurrentValue, &$ViewValue, &$ViewAttrs, &$CellAttrs, &$HrefValue, &$LinkAttrs)
    {
        //$ViewValue = "xxx";
        //$ViewAttrs["class"] = "xxx";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
