<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class BeneficiariesByGenderReportSummary extends BeneficiariesByGenderReport
{
    use MessagesTrait;

    // Page ID
    public $PageID = "summary";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "BeneficiariesByGenderReportSummary";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $ReportContainerClass = "ew-grid";
    public $CurrentPageName = "BeneficiariesByGenderReport";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'Beneficiaries_By_Gender_Report';
        $this->TableName = 'Beneficiaries By Gender Report';

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->ReportContainerClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (Beneficiaries_By_Gender_Report)
        if (!isset($GLOBALS["Beneficiaries_By_Gender_Report"]) || $GLOBALS["Beneficiaries_By_Gender_Report"]::class == PROJECT_NAMESPACE . "Beneficiaries_By_Gender_Report") {
            $GLOBALS["Beneficiaries_By_Gender_Report"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'Beneficiaries By Gender Report');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection if not in dashboard
        if (!$DashboardReport) {
            CloseConnections();
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }
        if ($fld instanceof ReportField) {
            $lookup->RenderViewFunc = "renderLookup"; // Set up view renderer
        }
        $lookup->RenderEditFunc = ""; // Set up edit renderer

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Options
    public $HideOptions = false;
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $FilterOptions; // Filter options

    // Records
    public $GroupRecords = [];
    public $DetailRecords = [];
    public $DetailRecordCount = 0;

    // Paging variables
    public $RecordIndex = 0; // Record index
    public $RecordCount = 0; // Record count (start from 1 for each group)
    public $StartGroup = 0; // Start group
    public $StopGroup = 0; // Stop group
    public $TotalGroups = 0; // Total groups
    public $GroupCount = 0; // Group count
    public $GroupCounter = []; // Group counter
    public $DisplayGroups = 1; // Groups per page
    public $GroupRange = 10;
    public $PageSizes = ""; // Page sizes (comma separated)
    public $PageFirstGroupFilter = "";
    public $UserIDFilter = "";
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = "";
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $DrillDownList = "";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $SearchCommand = false;
    public $ShowHeader = true;
    public $GroupColumnCount = 0;
    public $SubGroupColumnCount = 0;
    public $DetailColumnCount = 0;
    public $TotalCount;
    public $PageTotalCount;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $DrillDownInPanel, $Breadcrumb, $DashboardReport;

        // Set up dashboard report
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));
        if ($DashboardReport) {
            $this->UseAjaxActions = true;
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar)); // Set up Dashboard Filter
        }

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Setup export options
        $this->setupExportOptions();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up table class
        if ($this->isExport("word") || $this->isExport("excel") || $this->isExport("pdf")) {
            $this->TableClass = "ew-table table-bordered table-sm";
        } else {
            PrependClass($this->TableClass, "table ew-table table-bordered table-sm");
        }

        // Set up report container class
        if (!$this->isExport("word") && !$this->isExport("excel")) {
            $this->ReportContainerClass .= " card ew-card";
        }

        // Set field visibility for detail fields
        $this->FarmNo->setVisibility();
        $this->GRN->setVisibility();
        $this->TreesAllocated->setVisibility();
        $this->FarmingSeason->setVisibility();
        $this->SeedType->setVisibility();
        $this->DOB->setVisibility();
        $this->MaritalStatus->setVisibility();
        $this->FarmerOrganisation->setVisibility();
        $this->FarmerTypeName->setVisibility();

        // Set up Breadcrumb
        if (!$this->isExport() && !$DashboardReport) {
            $this->setupBreadcrumb();
        }

        // Check if search command
        $this->SearchCommand = (Get("cmd", "") == "search");

        // Load custom filters
        $this->pageFilterLoad();

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }

        // Extended filter
        $extendedFilter = "";

        // Restore filter list
        $this->restoreFilterList();

        // Build extended filter
        $extendedFilter = $this->getExtendedFilter();
        AddFilter($this->SearchWhere, $extendedFilter);

        // Call Page Selecting event
        $this->pageSelecting($this->SearchWhere);

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Get sort
        $this->Sort = $this->getSort();

        // Search options
        $this->setupSearchOptions();

        // Update filter
        AddFilter($this->Filter, $this->SearchWhere);

        // Get total group count
        $sql = $this->buildReportSql($this->getSqlSelectGroup(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
        $this->TotalGroups = $this->getRecordCount($sql);
        if ($this->DisplayGroups <= 0 || $this->DrillDown) { // Display all groups
            $this->DisplayGroups = $this->TotalGroups;
        }
        $this->StartGroup = 1;

        // Set up start position if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->DisplayGroups = $this->TotalGroups;
        } else {
            $this->setupStartGroup();
        }

        // Set no record found message
        if ($this->TotalGroups == 0) {
            $this->ShowHeader = false;
            if ($Security->canList()) {
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            } else {
                $this->setWarningMessage(DeniedMessage());
            }
        }

        // Hide export options if export/dashboard report/hide options
        if ($this->isExport() || $DashboardReport || $this->HideOptions) {
            $this->ExportOptions->hideAllOptions();
        }

        // Hide search/filter options if export/drilldown/dashboard report/hide options
        if ($this->isExport() || $this->DrillDown || $DashboardReport || $this->HideOptions) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }

        // Get group records
        if ($this->TotalGroups > 0) {
            $grpSort = UpdateSortFields($this->getSqlOrderByGroup(), $this->Sort, 2); // Get grouping field only
            $sql = $this->buildReportSql($this->getSqlSelectGroup(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderByGroup(), $this->Filter, $grpSort);
            $grpRs = $sql->setFirstResult(max($this->StartGroup - 1, 0))->setMaxResults($this->DisplayGroups)->executeQuery();
            $this->GroupRecords = $grpRs->fetchAll(); // Get records of first grouping field
            $this->loadGroupRowValues();
            $this->GroupCount = 1;
        }

        // Init detail records
        $this->DetailRecords = [];
        $this->setupFieldCount();

        // Set the last group to display if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->StopGroup = $this->TotalGroups;
        } else {
            $this->StopGroup = $this->StartGroup + $this->DisplayGroups - 1;
        }

        // Stop group <= total number of groups
        if (intval($this->StopGroup) > intval($this->TotalGroups)) {
            $this->StopGroup = $this->TotalGroups;
        }
        $this->RecordCount = 0;
        $this->RecordIndex = 0;

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartGroup, $this->DisplayGroups, $this->TotalGroups, $this->PageSizes, $this->GroupRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Check if no records
        if ($this->TotalGroups == 0) {
            $this->ReportContainerClass .= " ew-no-record";
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load group row values
    public function loadGroupRowValues()
    {
        $cnt = count($this->GroupRecords); // Get record count
        if ($this->GroupCount < $cnt) {
            $this->DistrictName->setGroupValue(reset($this->GroupRecords[$this->GroupCount]));
        } else {
            $this->DistrictName->setGroupValue("");
        }
    }

    // Load row values
    public function loadRowValues($record)
    {
        $data = [];
        $data["DistrictName"] = $record['DistrictName'];
        $data["FarmNo"] = $record['FarmNo'];
        $data["GRN"] = $record['GRN'];
        $data["TreesAllocated"] = $record['TreesAllocated'];
        $data["FarmingSeason"] = $record['FarmingSeason'];
        $data["SeedType"] = $record['SeedType'];
        $data["NurseryName"] = $record['NurseryName'];
        $data["DOB"] = $record['DOB'];
        $data["Age"] = $record['Age'];
        $data["Gender"] = $record['Gender'];
        $data["MaritalStatus"] = $record['MaritalStatus'];
        $data["FarmerOrganisation"] = $record['FarmerOrganisation'];
        $data["FarmerType"] = $record['FarmerType'];
        $data["FarmerTypeName"] = $record['FarmerTypeName'];
        $this->Rows[] = $data;
        $this->DistrictName->setDbValue(GroupValue($this->DistrictName, $record['DistrictName']));
        $this->FarmNo->setDbValue($record['FarmNo']);
        $this->GRN->setDbValue($record['GRN']);
        $this->TreesAllocated->setDbValue($record['TreesAllocated']);
        $this->FarmingSeason->setDbValue($record['FarmingSeason']);
        $this->SeedType->setDbValue($record['SeedType']);
        $this->NurseryName->setDbValue($record['NurseryName']);
        $this->DOB->setDbValue($record['DOB']);
        $this->Age->setDbValue($record['Age']);
        $this->Gender->setDbValue($record['Gender']);
        $this->MaritalStatus->setDbValue($record['MaritalStatus']);
        $this->FarmerOrganisation->setDbValue($record['FarmerOrganisation']);
        $this->FarmerType->setDbValue($record['FarmerType']);
        $this->FarmerTypeName->setDbValue($record['FarmerTypeName']);
    }

    // Render row
    public function renderRow()
    {
        global $Security, $Language, $Language;
        $conn = $this->getConnection();
        if ($this->RowType == RowType::TOTAL && $this->RowTotalSubType == RowTotal::FOOTER && $this->RowTotalType == RowSummary::PAGE) {
            // Build detail SQL
            $firstGrpFld = &$this->DistrictName;
            $firstGrpFld->getDistinctValues($this->GroupRecords);
            $where = DetailFilterSql($firstGrpFld, $this->getSqlFirstGroupField(), $firstGrpFld->DistinctValues, $this->Dbid);
            AddFilter($where, $this->Filter);
            $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $where, $this->Sort);
            $rs = $sql->executeQuery();
            $records = $rs?->fetchAll() ?? [];
            $this->PageTotalCount = count($records);
        } elseif ($this->RowType == RowType::TOTAL && $this->RowTotalSubType == RowTotal::FOOTER && $this->RowTotalType == RowSummary::GRAND) { // Get Grand total
            $hasCount = false;
            $hasSummary = false;

            // Get total count from SQL directly
            $sql = $this->buildReportSql($this->getSqlSelectCount(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
            $rstot = $conn->executeQuery($sql);
            if ($rstot && $cnt = $rstot->fetchOne()) {
                $hasCount = true;
            } else {
                $cnt = 0;
            }
            $this->TotalCount = $cnt;
            $hasSummary = true;

            // Accumulate grand summary from detail records
            if (!$hasCount || !$hasSummary) {
                $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
                $rs = $sql->executeQuery();
                $this->DetailRecords = $rs?->fetchAll() ?? [];
            }
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // DistrictName

        // NurseryName

        // Age

        // Gender

        // FarmNo

        // GRN

        // TreesAllocated

        // FarmingSeason

        // SeedType

        // DOB

        // MaritalStatus

        // FarmerOrganisation

        // FarmerTypeName
        if ($this->RowType == RowType::SEARCH) {
            // DistrictName
            if ($this->DistrictName->UseFilter && !EmptyValue($this->DistrictName->AdvancedSearch->SearchValue)) {
                if (is_array($this->DistrictName->AdvancedSearch->SearchValue)) {
                    $this->DistrictName->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->DistrictName->AdvancedSearch->SearchValue);
                }
                $this->DistrictName->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->DistrictName->AdvancedSearch->SearchValue);
            }

            // GRN
            if ($this->GRN->UseFilter && !EmptyValue($this->GRN->AdvancedSearch->SearchValue)) {
                if (is_array($this->GRN->AdvancedSearch->SearchValue)) {
                    $this->GRN->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->GRN->AdvancedSearch->SearchValue);
                }
                $this->GRN->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->GRN->AdvancedSearch->SearchValue);
            }

            // SeedType
            if ($this->SeedType->UseFilter && !EmptyValue($this->SeedType->AdvancedSearch->SearchValue)) {
                if (is_array($this->SeedType->AdvancedSearch->SearchValue)) {
                    $this->SeedType->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->SeedType->AdvancedSearch->SearchValue);
                }
                $this->SeedType->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->SeedType->AdvancedSearch->SearchValue);
            }

            // NurseryName
            if ($this->NurseryName->UseFilter && !EmptyValue($this->NurseryName->AdvancedSearch->SearchValue)) {
                if (is_array($this->NurseryName->AdvancedSearch->SearchValue)) {
                    $this->NurseryName->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->NurseryName->AdvancedSearch->SearchValue);
                }
                $this->NurseryName->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->NurseryName->AdvancedSearch->SearchValue);
            }

            // Age
            if ($this->Age->UseFilter && !EmptyValue($this->Age->AdvancedSearch->SearchValue)) {
                if (is_array($this->Age->AdvancedSearch->SearchValue)) {
                    $this->Age->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Age->AdvancedSearch->SearchValue);
                }
                $this->Age->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Age->AdvancedSearch->SearchValue);
            }

            // Gender
            if ($this->Gender->UseFilter && !EmptyValue($this->Gender->AdvancedSearch->SearchValue)) {
                if (is_array($this->Gender->AdvancedSearch->SearchValue)) {
                    $this->Gender->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Gender->AdvancedSearch->SearchValue);
                }
                $this->Gender->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Gender->AdvancedSearch->SearchValue);
            }

            // MaritalStatus
            if ($this->MaritalStatus->UseFilter && !EmptyValue($this->MaritalStatus->AdvancedSearch->SearchValue)) {
                if (is_array($this->MaritalStatus->AdvancedSearch->SearchValue)) {
                    $this->MaritalStatus->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->MaritalStatus->AdvancedSearch->SearchValue);
                }
                $this->MaritalStatus->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->MaritalStatus->AdvancedSearch->SearchValue);
            }

            // FarmerOrganisation
            if ($this->FarmerOrganisation->UseFilter && !EmptyValue($this->FarmerOrganisation->AdvancedSearch->SearchValue)) {
                if (is_array($this->FarmerOrganisation->AdvancedSearch->SearchValue)) {
                    $this->FarmerOrganisation->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->FarmerOrganisation->AdvancedSearch->SearchValue);
                }
                $this->FarmerOrganisation->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->FarmerOrganisation->AdvancedSearch->SearchValue);
            }
        } elseif ($this->RowType == RowType::TOTAL && !($this->RowTotalType == RowSummary::GROUP && $this->RowTotalSubType == RowTotal::HEADER)) { // Summary row
            $this->RowAttrs->prependClass(($this->RowTotalType == RowSummary::PAGE || $this->RowTotalType == RowSummary::GRAND) ? "ew-rpt-grp-aggregate" : ""); // Set up row class
            if ($this->RowTotalType == RowSummary::GROUP) {
                $this->RowAttrs["data-group"] = $this->DistrictName->groupValue(); // Set up group attribute
            }
            if ($this->RowTotalType == RowSummary::GROUP && $this->RowGroupLevel >= 2) {
                $this->RowAttrs["data-group-2"] = $this->NurseryName->groupValue(); // Set up group attribute 2
            }
            if ($this->RowTotalType == RowSummary::GROUP && $this->RowGroupLevel >= 3) {
                $this->RowAttrs["data-group-3"] = $this->Age->groupValue(); // Set up group attribute 3
            }
            if ($this->RowTotalType == RowSummary::GROUP && $this->RowGroupLevel >= 4) {
                $this->RowAttrs["data-group-4"] = $this->Gender->groupValue(); // Set up group attribute 4
            }

            // DistrictName
            $this->DistrictName->GroupViewValue = $this->DistrictName->groupValue();
            $this->DistrictName->CellCssClass = ($this->RowGroupLevel == 1 ? "ew-rpt-grp-summary-1" : "ew-rpt-grp-field-1");
            $this->DistrictName->GroupViewValue = DisplayGroupValue($this->DistrictName, $this->DistrictName->GroupViewValue);

            // NurseryName
            $this->NurseryName->GroupViewValue = $this->NurseryName->groupValue();
            $this->NurseryName->CellCssClass = ($this->RowGroupLevel == 2 ? "ew-rpt-grp-summary-2" : "ew-rpt-grp-field-2");
            $this->NurseryName->GroupViewValue = DisplayGroupValue($this->NurseryName, $this->NurseryName->GroupViewValue);

            // Age
            $this->Age->GroupViewValue = $this->Age->groupValue();
            $this->Age->CellCssClass = ($this->RowGroupLevel == 3 ? "ew-rpt-grp-summary-3" : "ew-rpt-grp-field-3");
            $this->Age->GroupViewValue = DisplayGroupValue($this->Age, $this->Age->GroupViewValue);

            // Gender
            $this->Gender->GroupViewValue = $this->Gender->groupValue();
            $this->Gender->CellCssClass = ($this->RowGroupLevel == 4 ? "ew-rpt-grp-summary-4" : "ew-rpt-grp-field-4");
            $this->Gender->GroupViewValue = DisplayGroupValue($this->Gender, $this->Gender->GroupViewValue);

            // DistrictName
            $this->DistrictName->HrefValue = "";

            // NurseryName
            $this->NurseryName->HrefValue = "";

            // Age
            $this->Age->HrefValue = "";

            // Gender
            $this->Gender->HrefValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";

            // GRN
            $this->GRN->HrefValue = "";

            // TreesAllocated
            $this->TreesAllocated->HrefValue = "";

            // FarmingSeason
            $this->FarmingSeason->HrefValue = "";

            // SeedType
            $this->SeedType->HrefValue = "";

            // DOB
            $this->DOB->HrefValue = "";

            // MaritalStatus
            $this->MaritalStatus->HrefValue = "";

            // FarmerOrganisation
            $this->FarmerOrganisation->HrefValue = "";

            // FarmerTypeName
            $this->FarmerTypeName->HrefValue = "";
        } else {
            if ($this->RowTotalType == RowSummary::GROUP && $this->RowTotalSubType == RowTotal::HEADER) {
                $this->RowAttrs["data-group"] = $this->DistrictName->groupValue(); // Set up group attribute
                if ($this->RowGroupLevel >= 2) {
                    $this->RowAttrs["data-group-2"] = $this->NurseryName->groupValue(); // Set up group attribute 2
                }
                if ($this->RowGroupLevel >= 3) {
                    $this->RowAttrs["data-group-3"] = $this->Age->groupValue(); // Set up group attribute 3
                }
                if ($this->RowGroupLevel >= 4) {
                    $this->RowAttrs["data-group-4"] = $this->Gender->groupValue(); // Set up group attribute 4
                }
            } else {
                $this->RowAttrs["data-group"] = $this->DistrictName->groupValue(); // Set up group attribute
                $this->RowAttrs["data-group-2"] = $this->NurseryName->groupValue(); // Set up group attribute 2
                $this->RowAttrs["data-group-3"] = $this->Age->groupValue(); // Set up group attribute 3
                $this->RowAttrs["data-group-4"] = $this->Gender->groupValue(); // Set up group attribute 4
            }

            // DistrictName
            $this->DistrictName->GroupViewValue = $this->DistrictName->groupValue();
            $this->DistrictName->CellCssClass = "ew-rpt-grp-field-1";
            $this->DistrictName->GroupViewValue = DisplayGroupValue($this->DistrictName, $this->DistrictName->GroupViewValue);
            if (!$this->DistrictName->LevelBreak) {
                $this->DistrictName->GroupViewValue = "";
            } else {
                $this->DistrictName->LevelBreak = false;
            }

            // NurseryName
            $this->NurseryName->GroupViewValue = $this->NurseryName->groupValue();
            $this->NurseryName->CellCssClass = "ew-rpt-grp-field-2";
            $this->NurseryName->GroupViewValue = DisplayGroupValue($this->NurseryName, $this->NurseryName->GroupViewValue);
            if (!$this->NurseryName->LevelBreak) {
                $this->NurseryName->GroupViewValue = "";
            } else {
                $this->NurseryName->LevelBreak = false;
            }

            // Age
            $this->Age->GroupViewValue = $this->Age->groupValue();
            $this->Age->CellCssClass = "ew-rpt-grp-field-3";
            $this->Age->GroupViewValue = DisplayGroupValue($this->Age, $this->Age->GroupViewValue);
            if (!$this->Age->LevelBreak) {
                $this->Age->GroupViewValue = "";
            } else {
                $this->Age->LevelBreak = false;
            }

            // Gender
            $this->Gender->GroupViewValue = $this->Gender->groupValue();
            $this->Gender->CellCssClass = "ew-rpt-grp-field-4";
            $this->Gender->GroupViewValue = DisplayGroupValue($this->Gender, $this->Gender->GroupViewValue);
            if (!$this->Gender->LevelBreak) {
                $this->Gender->GroupViewValue = "";
            } else {
                $this->Gender->LevelBreak = false;
            }

            // Increment RowCount
            if ($this->RowType == RowType::DETAIL) {
                $this->RowCount++;
            }

            // FarmNo
            $this->FarmNo->ViewValue = $this->FarmNo->CurrentValue;
            $this->FarmNo->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // GRN
            $this->GRN->ViewValue = $this->GRN->CurrentValue;
            $this->GRN->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // TreesAllocated
            $this->TreesAllocated->ViewValue = $this->TreesAllocated->CurrentValue;
            $this->TreesAllocated->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FarmingSeason
            $this->FarmingSeason->ViewValue = $this->FarmingSeason->CurrentValue;
            $this->FarmingSeason->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // SeedType
            $this->SeedType->ViewValue = $this->SeedType->CurrentValue;
            $this->SeedType->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // DOB
            $this->DOB->ViewValue = $this->DOB->CurrentValue;
            $this->DOB->ViewValue = FormatDateTime($this->DOB->ViewValue, $this->DOB->formatPattern());
            $this->DOB->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // MaritalStatus
            $this->MaritalStatus->ViewValue = $this->MaritalStatus->CurrentValue;
            $this->MaritalStatus->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FarmerOrganisation
            $this->FarmerOrganisation->ViewValue = $this->FarmerOrganisation->CurrentValue;
            $this->FarmerOrganisation->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // FarmerTypeName
            $this->FarmerTypeName->ViewValue = $this->FarmerTypeName->CurrentValue;
            $this->FarmerTypeName->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // DistrictName
            $this->DistrictName->HrefValue = "";
            $this->DistrictName->TooltipValue = "";

            // NurseryName
            $this->NurseryName->HrefValue = "";
            $this->NurseryName->TooltipValue = "";

            // Age
            $this->Age->HrefValue = "";
            $this->Age->TooltipValue = "";

            // Gender
            $this->Gender->HrefValue = "";
            $this->Gender->TooltipValue = "";

            // FarmNo
            $this->FarmNo->HrefValue = "";
            $this->FarmNo->TooltipValue = "";

            // GRN
            $this->GRN->HrefValue = "";
            $this->GRN->TooltipValue = "";

            // TreesAllocated
            $this->TreesAllocated->HrefValue = "";
            $this->TreesAllocated->TooltipValue = "";

            // FarmingSeason
            $this->FarmingSeason->HrefValue = "";
            $this->FarmingSeason->TooltipValue = "";

            // SeedType
            $this->SeedType->HrefValue = "";
            $this->SeedType->TooltipValue = "";

            // DOB
            $this->DOB->HrefValue = "";
            $this->DOB->TooltipValue = "";

            // MaritalStatus
            $this->MaritalStatus->HrefValue = "";
            $this->MaritalStatus->TooltipValue = "";

            // FarmerOrganisation
            $this->FarmerOrganisation->HrefValue = "";
            $this->FarmerOrganisation->TooltipValue = "";

            // FarmerTypeName
            $this->FarmerTypeName->HrefValue = "";
            $this->FarmerTypeName->TooltipValue = "";
        }

        // Call Cell_Rendered event
        if ($this->RowType == RowType::TOTAL) {
            // DistrictName
            $currentValue = $this->DistrictName->GroupViewValue;
            $viewValue = &$this->DistrictName->GroupViewValue;
            $viewAttrs = &$this->DistrictName->ViewAttrs;
            $cellAttrs = &$this->DistrictName->CellAttrs;
            $hrefValue = &$this->DistrictName->HrefValue;
            $linkAttrs = &$this->DistrictName->LinkAttrs;
            $this->cellRendered($this->DistrictName, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // NurseryName
            $currentValue = $this->NurseryName->GroupViewValue;
            $viewValue = &$this->NurseryName->GroupViewValue;
            $viewAttrs = &$this->NurseryName->ViewAttrs;
            $cellAttrs = &$this->NurseryName->CellAttrs;
            $hrefValue = &$this->NurseryName->HrefValue;
            $linkAttrs = &$this->NurseryName->LinkAttrs;
            $this->cellRendered($this->NurseryName, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Age
            $currentValue = $this->Age->GroupViewValue;
            $viewValue = &$this->Age->GroupViewValue;
            $viewAttrs = &$this->Age->ViewAttrs;
            $cellAttrs = &$this->Age->CellAttrs;
            $hrefValue = &$this->Age->HrefValue;
            $linkAttrs = &$this->Age->LinkAttrs;
            $this->cellRendered($this->Age, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Gender
            $currentValue = $this->Gender->GroupViewValue;
            $viewValue = &$this->Gender->GroupViewValue;
            $viewAttrs = &$this->Gender->ViewAttrs;
            $cellAttrs = &$this->Gender->CellAttrs;
            $hrefValue = &$this->Gender->HrefValue;
            $linkAttrs = &$this->Gender->LinkAttrs;
            $this->cellRendered($this->Gender, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        } else {
            // DistrictName
            $currentValue = $this->DistrictName->groupValue();
            $viewValue = &$this->DistrictName->GroupViewValue;
            $viewAttrs = &$this->DistrictName->ViewAttrs;
            $cellAttrs = &$this->DistrictName->CellAttrs;
            $hrefValue = &$this->DistrictName->HrefValue;
            $linkAttrs = &$this->DistrictName->LinkAttrs;
            $this->cellRendered($this->DistrictName, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // NurseryName
            $currentValue = $this->NurseryName->groupValue();
            $viewValue = &$this->NurseryName->GroupViewValue;
            $viewAttrs = &$this->NurseryName->ViewAttrs;
            $cellAttrs = &$this->NurseryName->CellAttrs;
            $hrefValue = &$this->NurseryName->HrefValue;
            $linkAttrs = &$this->NurseryName->LinkAttrs;
            $this->cellRendered($this->NurseryName, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Age
            $currentValue = $this->Age->groupValue();
            $viewValue = &$this->Age->GroupViewValue;
            $viewAttrs = &$this->Age->ViewAttrs;
            $cellAttrs = &$this->Age->CellAttrs;
            $hrefValue = &$this->Age->HrefValue;
            $linkAttrs = &$this->Age->LinkAttrs;
            $this->cellRendered($this->Age, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Gender
            $currentValue = $this->Gender->groupValue();
            $viewValue = &$this->Gender->GroupViewValue;
            $viewAttrs = &$this->Gender->ViewAttrs;
            $cellAttrs = &$this->Gender->CellAttrs;
            $hrefValue = &$this->Gender->HrefValue;
            $linkAttrs = &$this->Gender->LinkAttrs;
            $this->cellRendered($this->Gender, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FarmNo
            $currentValue = $this->FarmNo->CurrentValue;
            $viewValue = &$this->FarmNo->ViewValue;
            $viewAttrs = &$this->FarmNo->ViewAttrs;
            $cellAttrs = &$this->FarmNo->CellAttrs;
            $hrefValue = &$this->FarmNo->HrefValue;
            $linkAttrs = &$this->FarmNo->LinkAttrs;
            $this->cellRendered($this->FarmNo, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // GRN
            $currentValue = $this->GRN->CurrentValue;
            $viewValue = &$this->GRN->ViewValue;
            $viewAttrs = &$this->GRN->ViewAttrs;
            $cellAttrs = &$this->GRN->CellAttrs;
            $hrefValue = &$this->GRN->HrefValue;
            $linkAttrs = &$this->GRN->LinkAttrs;
            $this->cellRendered($this->GRN, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // TreesAllocated
            $currentValue = $this->TreesAllocated->CurrentValue;
            $viewValue = &$this->TreesAllocated->ViewValue;
            $viewAttrs = &$this->TreesAllocated->ViewAttrs;
            $cellAttrs = &$this->TreesAllocated->CellAttrs;
            $hrefValue = &$this->TreesAllocated->HrefValue;
            $linkAttrs = &$this->TreesAllocated->LinkAttrs;
            $this->cellRendered($this->TreesAllocated, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FarmingSeason
            $currentValue = $this->FarmingSeason->CurrentValue;
            $viewValue = &$this->FarmingSeason->ViewValue;
            $viewAttrs = &$this->FarmingSeason->ViewAttrs;
            $cellAttrs = &$this->FarmingSeason->CellAttrs;
            $hrefValue = &$this->FarmingSeason->HrefValue;
            $linkAttrs = &$this->FarmingSeason->LinkAttrs;
            $this->cellRendered($this->FarmingSeason, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // SeedType
            $currentValue = $this->SeedType->CurrentValue;
            $viewValue = &$this->SeedType->ViewValue;
            $viewAttrs = &$this->SeedType->ViewAttrs;
            $cellAttrs = &$this->SeedType->CellAttrs;
            $hrefValue = &$this->SeedType->HrefValue;
            $linkAttrs = &$this->SeedType->LinkAttrs;
            $this->cellRendered($this->SeedType, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // DOB
            $currentValue = $this->DOB->CurrentValue;
            $viewValue = &$this->DOB->ViewValue;
            $viewAttrs = &$this->DOB->ViewAttrs;
            $cellAttrs = &$this->DOB->CellAttrs;
            $hrefValue = &$this->DOB->HrefValue;
            $linkAttrs = &$this->DOB->LinkAttrs;
            $this->cellRendered($this->DOB, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // MaritalStatus
            $currentValue = $this->MaritalStatus->CurrentValue;
            $viewValue = &$this->MaritalStatus->ViewValue;
            $viewAttrs = &$this->MaritalStatus->ViewAttrs;
            $cellAttrs = &$this->MaritalStatus->CellAttrs;
            $hrefValue = &$this->MaritalStatus->HrefValue;
            $linkAttrs = &$this->MaritalStatus->LinkAttrs;
            $this->cellRendered($this->MaritalStatus, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FarmerOrganisation
            $currentValue = $this->FarmerOrganisation->CurrentValue;
            $viewValue = &$this->FarmerOrganisation->ViewValue;
            $viewAttrs = &$this->FarmerOrganisation->ViewAttrs;
            $cellAttrs = &$this->FarmerOrganisation->CellAttrs;
            $hrefValue = &$this->FarmerOrganisation->HrefValue;
            $linkAttrs = &$this->FarmerOrganisation->LinkAttrs;
            $this->cellRendered($this->FarmerOrganisation, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // FarmerTypeName
            $currentValue = $this->FarmerTypeName->CurrentValue;
            $viewValue = &$this->FarmerTypeName->ViewValue;
            $viewAttrs = &$this->FarmerTypeName->ViewAttrs;
            $cellAttrs = &$this->FarmerTypeName->CellAttrs;
            $hrefValue = &$this->FarmerTypeName->HrefValue;
            $linkAttrs = &$this->FarmerTypeName->LinkAttrs;
            $this->cellRendered($this->FarmerTypeName, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        }

        // Call Row_Rendered event
        $this->rowRendered();
        $this->setupFieldCount();
    }
    private $groupCounts = [];

    // Get group count
    public function getGroupCount(...$args)
    {
        $key = implode("_", array_map(fn($arg) => strval($arg), $args));
        if ($key == "") {
            return -1;
        } elseif ($key == "0") { // Number of first level groups
            $i = 1;
            while (isset($this->groupCounts[strval($i)])) {
                $i++;
            }
            return $i - 1;
        }
        return isset($this->groupCounts[$key]) ? $this->groupCounts[$key] : -1;
    }

    // Set group count
    public function setGroupCount($value, ...$args)
    {
        $key = implode("_", array_map(fn($arg) => strval($arg), $args));
        if ($key == "") {
            return;
        }
        $this->groupCounts[$key] = $value;
    }

    // Setup field count
    protected function setupFieldCount()
    {
        $this->GroupColumnCount = 0;
        $this->SubGroupColumnCount = 0;
        $this->DetailColumnCount = 0;
        if ($this->DistrictName->Visible) {
            $this->GroupColumnCount += 1;
        }
        if ($this->NurseryName->Visible) {
            $this->GroupColumnCount += 1;
            $this->SubGroupColumnCount += 1;
        }
        if ($this->Age->Visible) {
            $this->GroupColumnCount += 1;
            $this->SubGroupColumnCount += 1;
        }
        if ($this->Gender->Visible) {
            $this->GroupColumnCount += 1;
            $this->SubGroupColumnCount += 1;
        }
        if ($this->FarmNo->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->GRN->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->TreesAllocated->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FarmingSeason->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->SeedType->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->DOB->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->MaritalStatus->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FarmerOrganisation->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->FarmerTypeName->Visible) {
            $this->DetailColumnCount += 1;
        }
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-excel" title="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" data-ew-action="export" data-export="excel" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToExcel") . '</button>';
        } elseif (SameText($type, "word")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-word" title="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" data-ew-action="export" data-export="word" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToWord") . '</button>';
        } elseif (SameText($type, "pdf")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-pdf" title="' . HtmlEncode($Language->phrase("ExportToPdf", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToPdf", true)) . '" data-ew-action="export" data-export="pdf" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToPdf") . '</button>';
        } elseif (SameText($type, "html")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-html" title="' . HtmlEncode($Language->phrase("ExportToHtml", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToHtml", true)) . '" data-ew-action="export" data-export="html" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToHtml") . '</button>';
        } elseif (SameText($type, "email")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-ew-action="email" data-custom="false" data-export-selected="false" data-hdr="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = true;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = true;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = false;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide options for export
        if ($this->isExport()) {
            $this->ExportOptions->hideAllOptions();
        }
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return $this->DistrictName->Visible || $this->GRN->Visible || $this->SeedType->Visible || $this->NurseryName->Visible || $this->Age->Visible || $this->Gender->Visible || $this->MaritalStatus->Visible || $this->FarmerOrganisation->Visible;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("summary", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fBeneficiaries_By_Gender_Reportsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fBeneficiaries_By_Gender_Reportsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Set up starting group
    protected function setupStartGroup()
    {
        // Exit if no groups
        if ($this->DisplayGroups == 0) {
            return;
        }
        $startGrp = Param(Config("TABLE_START_GROUP"));
        $pageNo = Param(Config("TABLE_PAGE_NUMBER"));

        // Check for a 'start' parameter
        if ($startGrp !== null) {
            $this->StartGroup = $startGrp;
            $this->setStartGroup($this->StartGroup);
        } elseif ($pageNo !== null) {
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
                if ($this->StartGroup <= 0) {
                    $this->StartGroup = 1;
                } elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
                    $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
                }
                $this->setStartGroup($this->StartGroup);
            } else {
                $this->StartGroup = $this->getStartGroup();
            }
        } else {
            $this->StartGroup = $this->getStartGroup();
        }

        // Check if correct start group counter
        if (!is_numeric($this->StartGroup) || intval($this->StartGroup) <= 0) { // Avoid invalid start group counter
            $this->StartGroup = 1; // Reset start group counter
            $this->setStartGroup($this->StartGroup);
        } elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
            $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
            $this->setStartGroup($this->StartGroup);
        } elseif (($this->StartGroup - 1) % $this->DisplayGroups != 0) {
            $this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
            $this->setStartGroup($this->StartGroup);
        }
    }

    // Reset pager
    protected function resetPager()
    {
        // Reset start position (reset command)
        $this->StartGroup = 1;
        $this->setStartGroup($this->StartGroup);
    }

    // Get sort parameters based on sort links clicked
    protected function getSort()
    {
        if ($this->DrillDown) {
            return "";
        }
        $resetSort = Param("cmd") === "resetsort";
        $orderBy = Param("order", "");
        $orderType = Param("ordertype", "");

        // Check for a resetsort command
        if ($resetSort) {
            $this->setOrderBy("");
            $this->setStartGroup(1);
            $this->DistrictName->setSort("");
            $this->FarmNo->setSort("");
            $this->GRN->setSort("");
            $this->TreesAllocated->setSort("");
            $this->FarmingSeason->setSort("");
            $this->SeedType->setSort("");
            $this->NurseryName->setSort("");
            $this->DOB->setSort("");
            $this->Age->setSort("");
            $this->Gender->setSort("");
            $this->MaritalStatus->setSort("");
            $this->FarmerOrganisation->setSort("");
            $this->FarmerTypeName->setSort("");

        // Check for an Order parameter
        } elseif ($orderBy != "") {
            $this->CurrentOrder = $orderBy;
            $this->CurrentOrderType = $orderType;
            $this->updateSort($this->DistrictName); // DistrictName
            $this->updateSort($this->FarmNo); // FarmNo
            $this->updateSort($this->GRN); // GRN
            $this->updateSort($this->TreesAllocated); // TreesAllocated
            $this->updateSort($this->FarmingSeason); // FarmingSeason
            $this->updateSort($this->SeedType); // SeedType
            $this->updateSort($this->NurseryName); // NurseryName
            $this->updateSort($this->DOB); // DOB
            $this->updateSort($this->Age); // Age
            $this->updateSort($this->Gender); // Gender
            $this->updateSort($this->MaritalStatus); // MaritalStatus
            $this->updateSort($this->FarmerOrganisation); // FarmerOrganisation
            $this->updateSort($this->FarmerTypeName); // FarmerTypeName
            $sortSql = $this->sortSql();
            $this->setOrderBy($sortSql);
            $this->setStartGroup(1);
        }
        return $this->getOrderBy();
    }

    // Return extended filter
    protected function getExtendedFilter()
    {
        $filter = "";
        if ($this->DrillDown) {
            return "";
        }
        $restoreSession = false;
        $restoreDefault = false;
        // Reset search command
        if (Get("cmd") == "reset") {
            // Set default values
            $this->DistrictName->AdvancedSearch->unsetSession();
            $this->GRN->AdvancedSearch->unsetSession();
            $this->SeedType->AdvancedSearch->unsetSession();
            $this->NurseryName->AdvancedSearch->unsetSession();
            $this->Age->AdvancedSearch->unsetSession();
            $this->Gender->AdvancedSearch->unsetSession();
            $this->MaritalStatus->AdvancedSearch->unsetSession();
            $this->FarmerOrganisation->AdvancedSearch->unsetSession();
            $restoreDefault = true;
        } else {
            $restoreSession = !$this->SearchCommand;

            // Field DistrictName
            $this->getDropDownValue($this->DistrictName);

            // Field GRN
            $this->getDropDownValue($this->GRN);

            // Field SeedType
            $this->getDropDownValue($this->SeedType);

            // Field NurseryName
            $this->getDropDownValue($this->NurseryName);

            // Field Age
            $this->getDropDownValue($this->Age);

            // Field Gender
            $this->getDropDownValue($this->Gender);

            // Field MaritalStatus
            $this->getDropDownValue($this->MaritalStatus);

            // Field FarmerOrganisation
            $this->getDropDownValue($this->FarmerOrganisation);
            if (!$this->validateForm()) {
                return $filter;
            }
        }

        // Restore session
        if ($restoreSession) {
            $restoreDefault = true;
            if ($this->DistrictName->AdvancedSearch->issetSession()) { // Field DistrictName
                $this->DistrictName->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->GRN->AdvancedSearch->issetSession()) { // Field GRN
                $this->GRN->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->SeedType->AdvancedSearch->issetSession()) { // Field SeedType
                $this->SeedType->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->NurseryName->AdvancedSearch->issetSession()) { // Field NurseryName
                $this->NurseryName->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Age->AdvancedSearch->issetSession()) { // Field Age
                $this->Age->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Gender->AdvancedSearch->issetSession()) { // Field Gender
                $this->Gender->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->MaritalStatus->AdvancedSearch->issetSession()) { // Field MaritalStatus
                $this->MaritalStatus->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->FarmerOrganisation->AdvancedSearch->issetSession()) { // Field FarmerOrganisation
                $this->FarmerOrganisation->AdvancedSearch->load();
                $restoreDefault = false;
            }
        }

        // Restore default
        if ($restoreDefault) {
            $this->loadDefaultFilters();
        }

        // Call page filter validated event
        $this->pageFilterValidated();

        // Build SQL and save to session
        $this->buildDropDownFilter($this->DistrictName, $filter, false, true); // Field DistrictName
        $this->DistrictName->AdvancedSearch->save();
        $this->buildDropDownFilter($this->GRN, $filter, false, true); // Field GRN
        $this->GRN->AdvancedSearch->save();
        $this->buildDropDownFilter($this->SeedType, $filter, false, true); // Field SeedType
        $this->SeedType->AdvancedSearch->save();
        $this->buildDropDownFilter($this->NurseryName, $filter, false, true); // Field NurseryName
        $this->NurseryName->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Age, $filter, false, true); // Field Age
        $this->Age->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Gender, $filter, false, true); // Field Gender
        $this->Gender->AdvancedSearch->save();
        $this->buildDropDownFilter($this->MaritalStatus, $filter, false, true); // Field MaritalStatus
        $this->MaritalStatus->AdvancedSearch->save();
        $this->buildDropDownFilter($this->FarmerOrganisation, $filter, false, true); // Field FarmerOrganisation
        $this->FarmerOrganisation->AdvancedSearch->save();
        return $filter;
    }

    // Build dropdown filter
    protected function buildDropDownFilter(&$fld, &$filterClause, $default = false, $saveFilter = false)
    {
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        if (!EmptyValue($fld->DateFilter)) {
            $fldVal2 = "";
        } elseif ($fld->UseFilter) {
            $fldOpr = "";
            $fldVal2 = "";
        }
        $sql = "";
        if (is_array($fldVal)) {
            foreach ($fldVal as $val) {
                $wrk = DropDownFilter($fld, $val, $fldOpr, $this->Dbid);

                // Call Page Filtering event
                if (StartsString("@@", $val)) {
                    $this->pageFiltering($fld, $wrk, "custom", substr($val, 2));
                } else {
                    $this->pageFiltering($fld, $wrk, "dropdown", $fldOpr, $val);
                }
                AddFilter($sql, $wrk, "OR");
            }
        } else {
            $sql = DropDownFilter($fld, $fldVal, $fldOpr, $this->Dbid, $fldVal2);

            // Call Page Filtering event
            if (StartsString("@@", $fldVal)) {
                $this->pageFiltering($fld, $sql, "custom", substr($fldVal, 2));
            } else {
                $this->pageFiltering($fld, $sql, "dropdown", $fldOpr, $fldVal, "", "", $fldVal2);
            }
        }
        if ($sql != "") {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
            AddFilter($filterClause, $sql, $cond);
            if ($saveFilter) {
                $fld->CurrentFilter = $sql;
            }
        }
    }

    // Build extended filter
    protected function buildExtendedFilter(&$fld, &$filterClause, $default = false, $saveFilter = false)
    {
        $wrk = GetReportFilter($fld, $default, $this->Dbid);
        if (!$default) {
            $this->pageFiltering($fld, $wrk, "extended", $fld->AdvancedSearch->SearchOperator, $fld->AdvancedSearch->SearchValue, $fld->AdvancedSearch->SearchCondition, $fld->AdvancedSearch->SearchOperator2, $fld->AdvancedSearch->SearchValue2);
        }
        if ($wrk != "") {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
            AddFilter($filterClause, $wrk, $cond);
            if ($saveFilter) {
                $fld->CurrentFilter = $wrk;
            }
        }
    }

    // Get drop down value from querystring
    protected function getDropDownValue(&$fld)
    {
        if (IsPost()) {
            return false; // Skip post back
        }
        $res = false;
        $parm = $fld->Param;
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        $opr = Get("z_$parm");
        if ($opr !== null) {
            $fld->AdvancedSearch->SearchOperator = $opr;
        }
        $val = Get("x_$parm");
        if ($val !== null) {
            if (is_array($val)) {
                $val = implode($sep, $val);
            }
            $fld->AdvancedSearch->setSearchValue($val);
            $res = true;
        }
        $val2 = Get("y_$parm");
        if ($val2 !== null) {
            if (is_array($val2)) {
                $val2 = implode($sep, $val2);
            }
            $fld->AdvancedSearch->setSearchValue2($val2);
            $res = true;
        }
        return $res;
    }

    // Dropdown filter exist
    protected function dropDownFilterExist(&$fld)
    {
        $wrk = "";
        $this->buildDropDownFilter($fld, $wrk);
        return ($wrk != "");
    }

    // Extended filter exist
    protected function extendedFilterExist(&$fld)
    {
        $extWrk = "";
        $this->buildExtendedFilter($fld, $extWrk);
        return ($extWrk != "");
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Load default value for filters
    protected function loadDefaultFilters()
    {
        // Set up default values for extended filters
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fBeneficiaries_By_Gender_Reportsrch");
        }

        // Return filter list in json
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fBeneficiaries_By_Gender_Reportsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd", "") != "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter", ""), true);
        return $this->setupFilterList($filter);
    }

    // Setup list of filters
    protected function setupFilterList($filter)
    {
        if (!is_array($filter)) {
            return false;
        }
        return true;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Selecting event
    public function pageSelecting(&$filter)
    {
        // Enter your code here
    }

    // Load Filters event
    public function pageFilterLoad()
    {
        // Enter your code here
        // Example: Register/Unregister Custom Extended Filter
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A', 'GetStartsWithAFilter'); // With function, or
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A'); // No function, use Page_Filtering event
        //UnregisterFilter($this-><Field>, 'StartsWithA');
    }

    // Page Filter Validated event
    public function pageFilterValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Page Filtering event
    public function pageFiltering(&$fld, &$filter, $typ, $opr = "", $val = "", $cond = "", $opr2 = "", $val2 = "")
    {
        // Note: ALWAYS CHECK THE FILTER TYPE ($typ)! Example:
        //if ($typ == "dropdown" && $fld->Name == "MyField") // Dropdown filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "extended" && $fld->Name == "MyField") // Extended filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "custom" && $opr == "..." && $fld->Name == "MyField") // Custom filter, $opr is the custom filter ID
        //    $filter = "..."; // Modify the filter
    }

    // Cell Rendered event
    public function cellRendered(&$Field, $CurrentValue, &$ViewValue, &$ViewAttrs, &$CellAttrs, &$HrefValue, &$LinkAttrs)
    {
        //$ViewValue = "xxx";
        //$ViewAttrs["class"] = "xxx";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
