<?php

namespace PHPMaker2024\cidp24;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use Closure;

/**
 * Page class
 */
class AwpEdit extends Awp
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "AwpEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "AwpEdit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->Component->setVisibility();
        $this->Subcomponent->setVisibility();
        $this->InvestmentCost->setVisibility();
        $this->Type->setVisibility();
        $this->CategoryofExpenditure->setVisibility();
        $this->Activity->setVisibility();
        $this->Implementer->setVisibility();
        $this->Indicator->setVisibility();
        $this->ProjectTarget->setVisibility();
        $this->_2017Target->setVisibility();
        $this->ProjectBudget->setVisibility();
        $this->StartMonth->setVisibility();
        $this->EndMonth->setVisibility();
        $this->LineNo->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'awp';
        $this->TableName = 'awp';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (awp)
        if (!isset($GLOBALS["awp"]) || $GLOBALS["awp"]::class == PROJECT_NAMESPACE . "awp") {
            $GLOBALS["awp"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'awp');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "AwpView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['LineNo'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->LineNo->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->StartMonth);
        $this->setupLookupOptions($this->EndMonth);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Load record by position
        $loadByPosition = false;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("LineNo") ?? Key(0) ?? Route(2)) !== null) {
                $this->LineNo->setQueryStringValue($keyValue);
                $this->LineNo->setOldValue($this->LineNo->QueryStringValue);
            } elseif (Post("LineNo") !== null) {
                $this->LineNo->setFormValue(Post("LineNo"));
                $this->LineNo->setOldValue($this->LineNo->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("LineNo") ?? Route("LineNo")) !== null) {
                    $this->LineNo->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->LineNo->CurrentValue = null;
                }
                if (!$loadByQuery || Get(Config("TABLE_START_REC")) !== null || Get(Config("TABLE_PAGE_NUMBER")) !== null) {
                    $loadByPosition = true;
                }
            }

            // Load result set
            if ($this->isShow()) {
                if (!$this->IsModal) { // Normal edit page
                    $this->StartRecord = 1; // Initialize start position
                    $this->Recordset = $this->loadRecordset(); // Load records
                    if ($this->TotalRecords <= 0) { // No record found
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("AwpList"); // Return to list page
                        return;
                    } elseif ($loadByPosition) { // Load record by position
                        $this->setupStartRecord(); // Set up start record position
                        // Point to current record
                        if ($this->StartRecord <= $this->TotalRecords) {
                            $this->fetch($this->StartRecord);
                            // Redirect to correct record
                            $this->loadRowValues($this->CurrentRow);
                            $url = $this->getCurrentUrl();
                            $this->terminate($url);
                            return;
                        }
                    } else { // Match key values
                        if ($this->LineNo->CurrentValue != null) {
                            while ($this->fetch()) {
                                if (SameString($this->LineNo->CurrentValue, $this->CurrentRow['LineNo'])) {
                                    $this->setStartRecordNumber($this->StartRecord); // Save record position
                                    $loaded = true;
                                    break;
                                } else {
                                    $this->StartRecord++;
                                }
                            }
                        }
                    }

                    // Load current row values
                    if ($loaded) {
                        $this->loadRowValues($this->CurrentRow);
                    }
                } else {
                    // Load current record
                    $loaded = $this->loadRow();
                } // End modal checking
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$this->IsModal) { // Normal edit page
                    if (!$loaded) {
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("AwpList"); // Return to list page
                        return;
                    } else {
                    }
                } else { // Modal edit page
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("AwpList"); // No matching record, return to list
                        return;
                    }
                } // End modal checking
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "AwpList") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "AwpList") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "AwpList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();
        if (!$this->IsModal) { // Normal view page
            $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, "", $this->RecordRange, $this->AutoHidePager, false, false);
            $this->Pager->PageNumberName = Config("TABLE_PAGE_NUMBER");
            $this->Pager->PagePhraseId = "Record"; // Show as record
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'Component' first before field var 'x_Component'
        $val = $CurrentForm->hasValue("Component") ? $CurrentForm->getValue("Component") : $CurrentForm->getValue("x_Component");
        if (!$this->Component->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Component->Visible = false; // Disable update for API request
            } else {
                $this->Component->setFormValue($val);
            }
        }

        // Check field name 'Sub component' first before field var 'x_Subcomponent'
        $val = $CurrentForm->hasValue("Sub component") ? $CurrentForm->getValue("Sub component") : $CurrentForm->getValue("x_Subcomponent");
        if (!$this->Subcomponent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Subcomponent->Visible = false; // Disable update for API request
            } else {
                $this->Subcomponent->setFormValue($val);
            }
        }

        // Check field name 'Investment Cost' first before field var 'x_InvestmentCost'
        $val = $CurrentForm->hasValue("Investment Cost") ? $CurrentForm->getValue("Investment Cost") : $CurrentForm->getValue("x_InvestmentCost");
        if (!$this->InvestmentCost->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->InvestmentCost->Visible = false; // Disable update for API request
            } else {
                $this->InvestmentCost->setFormValue($val);
            }
        }

        // Check field name 'Type' first before field var 'x_Type'
        $val = $CurrentForm->hasValue("Type") ? $CurrentForm->getValue("Type") : $CurrentForm->getValue("x_Type");
        if (!$this->Type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Type->Visible = false; // Disable update for API request
            } else {
                $this->Type->setFormValue($val);
            }
        }

        // Check field name 'Category of Expenditure' first before field var 'x_CategoryofExpenditure'
        $val = $CurrentForm->hasValue("Category of Expenditure") ? $CurrentForm->getValue("Category of Expenditure") : $CurrentForm->getValue("x_CategoryofExpenditure");
        if (!$this->CategoryofExpenditure->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->CategoryofExpenditure->Visible = false; // Disable update for API request
            } else {
                $this->CategoryofExpenditure->setFormValue($val);
            }
        }

        // Check field name 'Activity' first before field var 'x_Activity'
        $val = $CurrentForm->hasValue("Activity") ? $CurrentForm->getValue("Activity") : $CurrentForm->getValue("x_Activity");
        if (!$this->Activity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Activity->Visible = false; // Disable update for API request
            } else {
                $this->Activity->setFormValue($val);
            }
        }

        // Check field name 'Implementer' first before field var 'x_Implementer'
        $val = $CurrentForm->hasValue("Implementer") ? $CurrentForm->getValue("Implementer") : $CurrentForm->getValue("x_Implementer");
        if (!$this->Implementer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Implementer->Visible = false; // Disable update for API request
            } else {
                $this->Implementer->setFormValue($val);
            }
        }

        // Check field name 'Indicator' first before field var 'x_Indicator'
        $val = $CurrentForm->hasValue("Indicator") ? $CurrentForm->getValue("Indicator") : $CurrentForm->getValue("x_Indicator");
        if (!$this->Indicator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->Indicator->Visible = false; // Disable update for API request
            } else {
                $this->Indicator->setFormValue($val);
            }
        }

        // Check field name 'Project Target' first before field var 'x_ProjectTarget'
        $val = $CurrentForm->hasValue("Project Target") ? $CurrentForm->getValue("Project Target") : $CurrentForm->getValue("x_ProjectTarget");
        if (!$this->ProjectTarget->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProjectTarget->Visible = false; // Disable update for API request
            } else {
                $this->ProjectTarget->setFormValue($val, true, $validate);
            }
        }

        // Check field name '2017 Target' first before field var 'x__2017Target'
        $val = $CurrentForm->hasValue("2017 Target") ? $CurrentForm->getValue("2017 Target") : $CurrentForm->getValue("x__2017Target");
        if (!$this->_2017Target->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_2017Target->Visible = false; // Disable update for API request
            } else {
                $this->_2017Target->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'Project Budget' first before field var 'x_ProjectBudget'
        $val = $CurrentForm->hasValue("Project Budget") ? $CurrentForm->getValue("Project Budget") : $CurrentForm->getValue("x_ProjectBudget");
        if (!$this->ProjectBudget->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ProjectBudget->Visible = false; // Disable update for API request
            } else {
                $this->ProjectBudget->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'StartMonth' first before field var 'x_StartMonth'
        $val = $CurrentForm->hasValue("StartMonth") ? $CurrentForm->getValue("StartMonth") : $CurrentForm->getValue("x_StartMonth");
        if (!$this->StartMonth->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->StartMonth->Visible = false; // Disable update for API request
            } else {
                $this->StartMonth->setFormValue($val);
            }
        }

        // Check field name 'EndMonth' first before field var 'x_EndMonth'
        $val = $CurrentForm->hasValue("EndMonth") ? $CurrentForm->getValue("EndMonth") : $CurrentForm->getValue("x_EndMonth");
        if (!$this->EndMonth->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->EndMonth->Visible = false; // Disable update for API request
            } else {
                $this->EndMonth->setFormValue($val);
            }
        }

        // Check field name 'LineNo' first before field var 'x_LineNo'
        $val = $CurrentForm->hasValue("LineNo") ? $CurrentForm->getValue("LineNo") : $CurrentForm->getValue("x_LineNo");
        if (!$this->LineNo->IsDetailKey) {
            $this->LineNo->setFormValue($val);
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->Component->CurrentValue = $this->Component->FormValue;
        $this->Subcomponent->CurrentValue = $this->Subcomponent->FormValue;
        $this->InvestmentCost->CurrentValue = $this->InvestmentCost->FormValue;
        $this->Type->CurrentValue = $this->Type->FormValue;
        $this->CategoryofExpenditure->CurrentValue = $this->CategoryofExpenditure->FormValue;
        $this->Activity->CurrentValue = $this->Activity->FormValue;
        $this->Implementer->CurrentValue = $this->Implementer->FormValue;
        $this->Indicator->CurrentValue = $this->Indicator->FormValue;
        $this->ProjectTarget->CurrentValue = $this->ProjectTarget->FormValue;
        $this->_2017Target->CurrentValue = $this->_2017Target->FormValue;
        $this->ProjectBudget->CurrentValue = $this->ProjectBudget->FormValue;
        $this->StartMonth->CurrentValue = $this->StartMonth->FormValue;
        $this->EndMonth->CurrentValue = $this->EndMonth->FormValue;
        $this->LineNo->CurrentValue = $this->LineNo->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->Component->setDbValue($row['Component']);
        $this->Subcomponent->setDbValue($row['Sub component']);
        $this->InvestmentCost->setDbValue($row['Investment Cost']);
        $this->Type->setDbValue($row['Type']);
        $this->CategoryofExpenditure->setDbValue($row['Category of Expenditure']);
        $this->Activity->setDbValue($row['Activity']);
        $this->Implementer->setDbValue($row['Implementer']);
        $this->Indicator->setDbValue($row['Indicator']);
        $this->ProjectTarget->setDbValue($row['Project Target']);
        $this->_2017Target->setDbValue($row['2017 Target']);
        $this->ProjectBudget->setDbValue($row['Project Budget']);
        $this->StartMonth->setDbValue($row['StartMonth']);
        $this->EndMonth->setDbValue($row['EndMonth']);
        $this->LineNo->setDbValue($row['LineNo']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['Component'] = $this->Component->DefaultValue;
        $row['Sub component'] = $this->Subcomponent->DefaultValue;
        $row['Investment Cost'] = $this->InvestmentCost->DefaultValue;
        $row['Type'] = $this->Type->DefaultValue;
        $row['Category of Expenditure'] = $this->CategoryofExpenditure->DefaultValue;
        $row['Activity'] = $this->Activity->DefaultValue;
        $row['Implementer'] = $this->Implementer->DefaultValue;
        $row['Indicator'] = $this->Indicator->DefaultValue;
        $row['Project Target'] = $this->ProjectTarget->DefaultValue;
        $row['2017 Target'] = $this->_2017Target->DefaultValue;
        $row['Project Budget'] = $this->ProjectBudget->DefaultValue;
        $row['StartMonth'] = $this->StartMonth->DefaultValue;
        $row['EndMonth'] = $this->EndMonth->DefaultValue;
        $row['LineNo'] = $this->LineNo->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // Component
        $this->Component->RowCssClass = "row";

        // Sub component
        $this->Subcomponent->RowCssClass = "row";

        // Investment Cost
        $this->InvestmentCost->RowCssClass = "row";

        // Type
        $this->Type->RowCssClass = "row";

        // Category of Expenditure
        $this->CategoryofExpenditure->RowCssClass = "row";

        // Activity
        $this->Activity->RowCssClass = "row";

        // Implementer
        $this->Implementer->RowCssClass = "row";

        // Indicator
        $this->Indicator->RowCssClass = "row";

        // Project Target
        $this->ProjectTarget->RowCssClass = "row";

        // 2017 Target
        $this->_2017Target->RowCssClass = "row";

        // Project Budget
        $this->ProjectBudget->RowCssClass = "row";

        // StartMonth
        $this->StartMonth->RowCssClass = "row";

        // EndMonth
        $this->EndMonth->RowCssClass = "row";

        // LineNo
        $this->LineNo->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // Component
            $this->Component->ViewValue = $this->Component->CurrentValue;

            // Sub component
            $this->Subcomponent->ViewValue = $this->Subcomponent->CurrentValue;

            // Investment Cost
            $this->InvestmentCost->ViewValue = $this->InvestmentCost->CurrentValue;

            // Type
            $this->Type->ViewValue = $this->Type->CurrentValue;

            // Category of Expenditure
            $this->CategoryofExpenditure->ViewValue = $this->CategoryofExpenditure->CurrentValue;

            // Activity
            $this->Activity->ViewValue = $this->Activity->CurrentValue;

            // Implementer
            $this->Implementer->ViewValue = $this->Implementer->CurrentValue;

            // Indicator
            $this->Indicator->ViewValue = $this->Indicator->CurrentValue;

            // Project Target
            $this->ProjectTarget->ViewValue = $this->ProjectTarget->CurrentValue;
            $this->ProjectTarget->ViewValue = FormatNumber($this->ProjectTarget->ViewValue, $this->ProjectTarget->formatPattern());
            $this->ProjectTarget->CellCssStyle .= "text-align: right;";

            // 2017 Target
            $this->_2017Target->ViewValue = $this->_2017Target->CurrentValue;
            $this->_2017Target->ViewValue = FormatNumber($this->_2017Target->ViewValue, $this->_2017Target->formatPattern());
            $this->_2017Target->CellCssStyle .= "text-align: right;";

            // Project Budget
            $this->ProjectBudget->ViewValue = $this->ProjectBudget->CurrentValue;
            $this->ProjectBudget->ViewValue = FormatNumber($this->ProjectBudget->ViewValue, $this->ProjectBudget->formatPattern());
            $this->ProjectBudget->CellCssStyle .= "text-align: right;";

            // StartMonth
            $curVal = strval($this->StartMonth->CurrentValue);
            if ($curVal != "") {
                $this->StartMonth->ViewValue = $this->StartMonth->lookupCacheOption($curVal);
                if ($this->StartMonth->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->StartMonth->Lookup->getTable()->Fields["MonthCode"]->searchExpression(), "=", $curVal, $this->StartMonth->Lookup->getTable()->Fields["MonthCode"]->searchDataType(), "");
                    $sqlWrk = $this->StartMonth->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->StartMonth->Lookup->renderViewRow($rswrk[0]);
                        $this->StartMonth->ViewValue = $this->StartMonth->displayValue($arwrk);
                    } else {
                        $this->StartMonth->ViewValue = $this->StartMonth->CurrentValue;
                    }
                }
            } else {
                $this->StartMonth->ViewValue = null;
            }

            // EndMonth
            $curVal = strval($this->EndMonth->CurrentValue);
            if ($curVal != "") {
                $this->EndMonth->ViewValue = $this->EndMonth->lookupCacheOption($curVal);
                if ($this->EndMonth->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->EndMonth->Lookup->getTable()->Fields["MonthCode"]->searchExpression(), "=", $curVal, $this->EndMonth->Lookup->getTable()->Fields["MonthCode"]->searchDataType(), "");
                    $sqlWrk = $this->EndMonth->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->EndMonth->Lookup->renderViewRow($rswrk[0]);
                        $this->EndMonth->ViewValue = $this->EndMonth->displayValue($arwrk);
                    } else {
                        $this->EndMonth->ViewValue = $this->EndMonth->CurrentValue;
                    }
                }
            } else {
                $this->EndMonth->ViewValue = null;
            }

            // LineNo
            $this->LineNo->ViewValue = $this->LineNo->CurrentValue;

            // Component
            $this->Component->HrefValue = "";

            // Sub component
            $this->Subcomponent->HrefValue = "";

            // Investment Cost
            $this->InvestmentCost->HrefValue = "";

            // Type
            $this->Type->HrefValue = "";

            // Category of Expenditure
            $this->CategoryofExpenditure->HrefValue = "";

            // Activity
            $this->Activity->HrefValue = "";

            // Implementer
            $this->Implementer->HrefValue = "";

            // Indicator
            $this->Indicator->HrefValue = "";

            // Project Target
            $this->ProjectTarget->HrefValue = "";

            // 2017 Target
            $this->_2017Target->HrefValue = "";

            // Project Budget
            $this->ProjectBudget->HrefValue = "";

            // StartMonth
            $this->StartMonth->HrefValue = "";

            // EndMonth
            $this->EndMonth->HrefValue = "";

            // LineNo
            $this->LineNo->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // Component
            $this->Component->setupEditAttributes();
            $this->Component->EditValue = HtmlEncode($this->Component->CurrentValue);
            $this->Component->PlaceHolder = RemoveHtml($this->Component->caption());

            // Sub component
            $this->Subcomponent->setupEditAttributes();
            $this->Subcomponent->EditValue = HtmlEncode($this->Subcomponent->CurrentValue);
            $this->Subcomponent->PlaceHolder = RemoveHtml($this->Subcomponent->caption());

            // Investment Cost
            $this->InvestmentCost->setupEditAttributes();
            if (!$this->InvestmentCost->Raw) {
                $this->InvestmentCost->CurrentValue = HtmlDecode($this->InvestmentCost->CurrentValue);
            }
            $this->InvestmentCost->EditValue = HtmlEncode($this->InvestmentCost->CurrentValue);
            $this->InvestmentCost->PlaceHolder = RemoveHtml($this->InvestmentCost->caption());

            // Type
            $this->Type->setupEditAttributes();
            if (!$this->Type->Raw) {
                $this->Type->CurrentValue = HtmlDecode($this->Type->CurrentValue);
            }
            $this->Type->EditValue = HtmlEncode($this->Type->CurrentValue);
            $this->Type->PlaceHolder = RemoveHtml($this->Type->caption());

            // Category of Expenditure
            $this->CategoryofExpenditure->setupEditAttributes();
            $this->CategoryofExpenditure->EditValue = HtmlEncode($this->CategoryofExpenditure->CurrentValue);
            $this->CategoryofExpenditure->PlaceHolder = RemoveHtml($this->CategoryofExpenditure->caption());

            // Activity
            $this->Activity->setupEditAttributes();
            $this->Activity->EditValue = HtmlEncode($this->Activity->CurrentValue);
            $this->Activity->PlaceHolder = RemoveHtml($this->Activity->caption());

            // Implementer
            $this->Implementer->setupEditAttributes();
            if (!$this->Implementer->Raw) {
                $this->Implementer->CurrentValue = HtmlDecode($this->Implementer->CurrentValue);
            }
            $this->Implementer->EditValue = HtmlEncode($this->Implementer->CurrentValue);
            $this->Implementer->PlaceHolder = RemoveHtml($this->Implementer->caption());

            // Indicator
            $this->Indicator->setupEditAttributes();
            if (!$this->Indicator->Raw) {
                $this->Indicator->CurrentValue = HtmlDecode($this->Indicator->CurrentValue);
            }
            $this->Indicator->EditValue = HtmlEncode($this->Indicator->CurrentValue);
            $this->Indicator->PlaceHolder = RemoveHtml($this->Indicator->caption());

            // Project Target
            $this->ProjectTarget->setupEditAttributes();
            $this->ProjectTarget->EditValue = $this->ProjectTarget->CurrentValue;
            $this->ProjectTarget->PlaceHolder = RemoveHtml($this->ProjectTarget->caption());
            if (strval($this->ProjectTarget->EditValue) != "" && is_numeric($this->ProjectTarget->EditValue)) {
                $this->ProjectTarget->EditValue = FormatNumber($this->ProjectTarget->EditValue, null);
            }

            // 2017 Target
            $this->_2017Target->setupEditAttributes();
            $this->_2017Target->EditValue = $this->_2017Target->CurrentValue;
            $this->_2017Target->PlaceHolder = RemoveHtml($this->_2017Target->caption());
            if (strval($this->_2017Target->EditValue) != "" && is_numeric($this->_2017Target->EditValue)) {
                $this->_2017Target->EditValue = FormatNumber($this->_2017Target->EditValue, null);
            }

            // Project Budget
            $this->ProjectBudget->setupEditAttributes();
            $this->ProjectBudget->EditValue = $this->ProjectBudget->CurrentValue;
            $this->ProjectBudget->PlaceHolder = RemoveHtml($this->ProjectBudget->caption());
            if (strval($this->ProjectBudget->EditValue) != "" && is_numeric($this->ProjectBudget->EditValue)) {
                $this->ProjectBudget->EditValue = FormatNumber($this->ProjectBudget->EditValue, null);
            }

            // StartMonth
            $this->StartMonth->setupEditAttributes();
            $curVal = trim(strval($this->StartMonth->CurrentValue));
            if ($curVal != "") {
                $this->StartMonth->ViewValue = $this->StartMonth->lookupCacheOption($curVal);
            } else {
                $this->StartMonth->ViewValue = $this->StartMonth->Lookup !== null && is_array($this->StartMonth->lookupOptions()) && count($this->StartMonth->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->StartMonth->ViewValue !== null) { // Load from cache
                $this->StartMonth->EditValue = array_values($this->StartMonth->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->StartMonth->Lookup->getTable()->Fields["MonthCode"]->searchExpression(), "=", $this->StartMonth->CurrentValue, $this->StartMonth->Lookup->getTable()->Fields["MonthCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->StartMonth->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->StartMonth->EditValue = $arwrk;
            }
            $this->StartMonth->PlaceHolder = RemoveHtml($this->StartMonth->caption());

            // EndMonth
            $this->EndMonth->setupEditAttributes();
            $curVal = trim(strval($this->EndMonth->CurrentValue));
            if ($curVal != "") {
                $this->EndMonth->ViewValue = $this->EndMonth->lookupCacheOption($curVal);
            } else {
                $this->EndMonth->ViewValue = $this->EndMonth->Lookup !== null && is_array($this->EndMonth->lookupOptions()) && count($this->EndMonth->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->EndMonth->ViewValue !== null) { // Load from cache
                $this->EndMonth->EditValue = array_values($this->EndMonth->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->EndMonth->Lookup->getTable()->Fields["MonthCode"]->searchExpression(), "=", $this->EndMonth->CurrentValue, $this->EndMonth->Lookup->getTable()->Fields["MonthCode"]->searchDataType(), "");
                }
                $sqlWrk = $this->EndMonth->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->EndMonth->EditValue = $arwrk;
            }
            $this->EndMonth->PlaceHolder = RemoveHtml($this->EndMonth->caption());

            // LineNo
            $this->LineNo->setupEditAttributes();
            $this->LineNo->EditValue = $this->LineNo->CurrentValue;

            // Edit refer script

            // Component
            $this->Component->HrefValue = "";

            // Sub component
            $this->Subcomponent->HrefValue = "";

            // Investment Cost
            $this->InvestmentCost->HrefValue = "";

            // Type
            $this->Type->HrefValue = "";

            // Category of Expenditure
            $this->CategoryofExpenditure->HrefValue = "";

            // Activity
            $this->Activity->HrefValue = "";

            // Implementer
            $this->Implementer->HrefValue = "";

            // Indicator
            $this->Indicator->HrefValue = "";

            // Project Target
            $this->ProjectTarget->HrefValue = "";

            // 2017 Target
            $this->_2017Target->HrefValue = "";

            // Project Budget
            $this->ProjectBudget->HrefValue = "";

            // StartMonth
            $this->StartMonth->HrefValue = "";

            // EndMonth
            $this->EndMonth->HrefValue = "";

            // LineNo
            $this->LineNo->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->Component->Visible && $this->Component->Required) {
                if (!$this->Component->IsDetailKey && EmptyValue($this->Component->FormValue)) {
                    $this->Component->addErrorMessage(str_replace("%s", $this->Component->caption(), $this->Component->RequiredErrorMessage));
                }
            }
            if ($this->Subcomponent->Visible && $this->Subcomponent->Required) {
                if (!$this->Subcomponent->IsDetailKey && EmptyValue($this->Subcomponent->FormValue)) {
                    $this->Subcomponent->addErrorMessage(str_replace("%s", $this->Subcomponent->caption(), $this->Subcomponent->RequiredErrorMessage));
                }
            }
            if ($this->InvestmentCost->Visible && $this->InvestmentCost->Required) {
                if (!$this->InvestmentCost->IsDetailKey && EmptyValue($this->InvestmentCost->FormValue)) {
                    $this->InvestmentCost->addErrorMessage(str_replace("%s", $this->InvestmentCost->caption(), $this->InvestmentCost->RequiredErrorMessage));
                }
            }
            if ($this->Type->Visible && $this->Type->Required) {
                if (!$this->Type->IsDetailKey && EmptyValue($this->Type->FormValue)) {
                    $this->Type->addErrorMessage(str_replace("%s", $this->Type->caption(), $this->Type->RequiredErrorMessage));
                }
            }
            if ($this->CategoryofExpenditure->Visible && $this->CategoryofExpenditure->Required) {
                if (!$this->CategoryofExpenditure->IsDetailKey && EmptyValue($this->CategoryofExpenditure->FormValue)) {
                    $this->CategoryofExpenditure->addErrorMessage(str_replace("%s", $this->CategoryofExpenditure->caption(), $this->CategoryofExpenditure->RequiredErrorMessage));
                }
            }
            if ($this->Activity->Visible && $this->Activity->Required) {
                if (!$this->Activity->IsDetailKey && EmptyValue($this->Activity->FormValue)) {
                    $this->Activity->addErrorMessage(str_replace("%s", $this->Activity->caption(), $this->Activity->RequiredErrorMessage));
                }
            }
            if ($this->Implementer->Visible && $this->Implementer->Required) {
                if (!$this->Implementer->IsDetailKey && EmptyValue($this->Implementer->FormValue)) {
                    $this->Implementer->addErrorMessage(str_replace("%s", $this->Implementer->caption(), $this->Implementer->RequiredErrorMessage));
                }
            }
            if ($this->Indicator->Visible && $this->Indicator->Required) {
                if (!$this->Indicator->IsDetailKey && EmptyValue($this->Indicator->FormValue)) {
                    $this->Indicator->addErrorMessage(str_replace("%s", $this->Indicator->caption(), $this->Indicator->RequiredErrorMessage));
                }
            }
            if ($this->ProjectTarget->Visible && $this->ProjectTarget->Required) {
                if (!$this->ProjectTarget->IsDetailKey && EmptyValue($this->ProjectTarget->FormValue)) {
                    $this->ProjectTarget->addErrorMessage(str_replace("%s", $this->ProjectTarget->caption(), $this->ProjectTarget->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->ProjectTarget->FormValue)) {
                $this->ProjectTarget->addErrorMessage($this->ProjectTarget->getErrorMessage(false));
            }
            if ($this->_2017Target->Visible && $this->_2017Target->Required) {
                if (!$this->_2017Target->IsDetailKey && EmptyValue($this->_2017Target->FormValue)) {
                    $this->_2017Target->addErrorMessage(str_replace("%s", $this->_2017Target->caption(), $this->_2017Target->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_2017Target->FormValue)) {
                $this->_2017Target->addErrorMessage($this->_2017Target->getErrorMessage(false));
            }
            if ($this->ProjectBudget->Visible && $this->ProjectBudget->Required) {
                if (!$this->ProjectBudget->IsDetailKey && EmptyValue($this->ProjectBudget->FormValue)) {
                    $this->ProjectBudget->addErrorMessage(str_replace("%s", $this->ProjectBudget->caption(), $this->ProjectBudget->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->ProjectBudget->FormValue)) {
                $this->ProjectBudget->addErrorMessage($this->ProjectBudget->getErrorMessage(false));
            }
            if ($this->StartMonth->Visible && $this->StartMonth->Required) {
                if (!$this->StartMonth->IsDetailKey && EmptyValue($this->StartMonth->FormValue)) {
                    $this->StartMonth->addErrorMessage(str_replace("%s", $this->StartMonth->caption(), $this->StartMonth->RequiredErrorMessage));
                }
            }
            if ($this->EndMonth->Visible && $this->EndMonth->Required) {
                if (!$this->EndMonth->IsDetailKey && EmptyValue($this->EndMonth->FormValue)) {
                    $this->EndMonth->addErrorMessage(str_replace("%s", $this->EndMonth->caption(), $this->EndMonth->RequiredErrorMessage));
                }
            }
            if ($this->LineNo->Visible && $this->LineNo->Required) {
                if (!$this->LineNo->IsDetailKey && EmptyValue($this->LineNo->FormValue)) {
                    $this->LineNo->addErrorMessage(str_replace("%s", $this->LineNo->caption(), $this->LineNo->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // Component
        $this->Component->setDbValueDef($rsnew, $this->Component->CurrentValue, $this->Component->ReadOnly);

        // Sub component
        $this->Subcomponent->setDbValueDef($rsnew, $this->Subcomponent->CurrentValue, $this->Subcomponent->ReadOnly);

        // Investment Cost
        $this->InvestmentCost->setDbValueDef($rsnew, $this->InvestmentCost->CurrentValue, $this->InvestmentCost->ReadOnly);

        // Type
        $this->Type->setDbValueDef($rsnew, $this->Type->CurrentValue, $this->Type->ReadOnly);

        // Category of Expenditure
        $this->CategoryofExpenditure->setDbValueDef($rsnew, $this->CategoryofExpenditure->CurrentValue, $this->CategoryofExpenditure->ReadOnly);

        // Activity
        $this->Activity->setDbValueDef($rsnew, $this->Activity->CurrentValue, $this->Activity->ReadOnly);

        // Implementer
        $this->Implementer->setDbValueDef($rsnew, $this->Implementer->CurrentValue, $this->Implementer->ReadOnly);

        // Indicator
        $this->Indicator->setDbValueDef($rsnew, $this->Indicator->CurrentValue, $this->Indicator->ReadOnly);

        // Project Target
        $this->ProjectTarget->setDbValueDef($rsnew, $this->ProjectTarget->CurrentValue, $this->ProjectTarget->ReadOnly);

        // 2017 Target
        $this->_2017Target->setDbValueDef($rsnew, $this->_2017Target->CurrentValue, $this->_2017Target->ReadOnly);

        // Project Budget
        $this->ProjectBudget->setDbValueDef($rsnew, $this->ProjectBudget->CurrentValue, $this->ProjectBudget->ReadOnly);

        // StartMonth
        $this->StartMonth->setDbValueDef($rsnew, $this->StartMonth->CurrentValue, $this->StartMonth->ReadOnly);

        // EndMonth
        $this->EndMonth->setDbValueDef($rsnew, $this->EndMonth->CurrentValue, $this->EndMonth->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['Component'])) { // Component
            $this->Component->CurrentValue = $row['Component'];
        }
        if (isset($row['Sub component'])) { // Sub component
            $this->Subcomponent->CurrentValue = $row['Sub component'];
        }
        if (isset($row['Investment Cost'])) { // Investment Cost
            $this->InvestmentCost->CurrentValue = $row['Investment Cost'];
        }
        if (isset($row['Type'])) { // Type
            $this->Type->CurrentValue = $row['Type'];
        }
        if (isset($row['Category of Expenditure'])) { // Category of Expenditure
            $this->CategoryofExpenditure->CurrentValue = $row['Category of Expenditure'];
        }
        if (isset($row['Activity'])) { // Activity
            $this->Activity->CurrentValue = $row['Activity'];
        }
        if (isset($row['Implementer'])) { // Implementer
            $this->Implementer->CurrentValue = $row['Implementer'];
        }
        if (isset($row['Indicator'])) { // Indicator
            $this->Indicator->CurrentValue = $row['Indicator'];
        }
        if (isset($row['Project Target'])) { // Project Target
            $this->ProjectTarget->CurrentValue = $row['Project Target'];
        }
        if (isset($row['2017 Target'])) { // 2017 Target
            $this->_2017Target->CurrentValue = $row['2017 Target'];
        }
        if (isset($row['Project Budget'])) { // Project Budget
            $this->ProjectBudget->CurrentValue = $row['Project Budget'];
        }
        if (isset($row['StartMonth'])) { // StartMonth
            $this->StartMonth->CurrentValue = $row['StartMonth'];
        }
        if (isset($row['EndMonth'])) { // EndMonth
            $this->EndMonth->CurrentValue = $row['EndMonth'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("index");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("AwpList"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_StartMonth":
                    break;
                case "x_EndMonth":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
