<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class YearsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/YearsList[/{year}]", [PermissionMiddleware::class], "list.years")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "YearsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/YearsAdd[/{year}]", [PermissionMiddleware::class], "add.years")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "YearsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/YearsView[/{year}]", [PermissionMiddleware::class], "view.years")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "YearsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/YearsEdit[/{year}]", [PermissionMiddleware::class], "edit.years")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "YearsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/YearsDelete[/{year}]", [PermissionMiddleware::class], "delete.years")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "YearsDelete");
    }
}
