<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class VillageController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/VillageList[/{VillageCode}]", [PermissionMiddleware::class], "list.village")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VillageList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/VillageAdd[/{VillageCode}]", [PermissionMiddleware::class], "add.village")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VillageAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/VillageView[/{VillageCode}]", [PermissionMiddleware::class], "view.village")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VillageView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/VillageEdit[/{VillageCode}]", [PermissionMiddleware::class], "edit.village")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VillageEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/VillageDelete[/{VillageCode}]", [PermissionMiddleware::class], "delete.village")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VillageDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/VillageSearch", [PermissionMiddleware::class], "search.village")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VillageSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/VillagePreview", [PermissionMiddleware::class], "preview.village")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VillagePreview", null, false);
    }
}
