<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class UserRoleController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/UserRoleList[/{Role:.*}]", [PermissionMiddleware::class], "list.user_role")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserRoleList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/UserRoleAdd[/{Role:.*}]", [PermissionMiddleware::class], "add.user_role")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserRoleAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/UserRoleView[/{Role:.*}]", [PermissionMiddleware::class], "view.user_role")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserRoleView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/UserRoleEdit[/{Role:.*}]", [PermissionMiddleware::class], "edit.user_role")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserRoleEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/UserRoleDelete[/{Role:.*}]", [PermissionMiddleware::class], "delete.user_role")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "UserRoleDelete");
    }
}
