<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class TrainingTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/TrainingTypeList[/{TrainingTypeCode}]", [PermissionMiddleware::class], "list.training_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TrainingTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/TrainingTypeAdd[/{TrainingTypeCode}]", [PermissionMiddleware::class], "add.training_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TrainingTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/TrainingTypeView[/{TrainingTypeCode}]", [PermissionMiddleware::class], "view.training_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TrainingTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/TrainingTypeEdit[/{TrainingTypeCode}]", [PermissionMiddleware::class], "edit.training_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TrainingTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/TrainingTypeDelete[/{TrainingTypeCode}]", [PermissionMiddleware::class], "delete.training_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "TrainingTypeDelete");
    }
}
