<?php

namespace PHPMaker2024\cidp24;

use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

/**
 * Seed_Allocation_Summary_Report controller
 */
class SeedAllocationSummaryReportController extends ControllerBase
{
    // summary
    #[Map(["GET", "POST", "OPTIONS"], "/SeedAllocationSummaryReport", [PermissionMiddleware::class], "summary.Seed_Allocation_Summary_Report")]
    public function summary(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "SeedAllocationSummaryReportSummary");
    }

    // SeedAllocationSummary (chart)
    #[Map(["GET", "POST", "OPTIONS"], "/SeedAllocationSummaryReport/SeedAllocationSummary", [PermissionMiddleware::class], "summary.Seed_Allocation_Summary_Report.SeedAllocationSummary")]
    public function SeedAllocationSummary(Request $request, Response $response, array $args): Response
    {
        return $this->runChart($request, $response, $args, "SeedAllocationSummaryReportSummary", "SeedAllocationSummary");
    }
}
