<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class ProvinceController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ProvinceList[/{ProvinceCode}]", [PermissionMiddleware::class], "list.province")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProvinceList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/ProvinceAdd[/{ProvinceCode}]", [PermissionMiddleware::class], "add.province")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProvinceAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ProvinceView[/{ProvinceCode}]", [PermissionMiddleware::class], "view.province")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProvinceView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ProvinceEdit[/{ProvinceCode}]", [PermissionMiddleware::class], "edit.province")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProvinceEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/ProvinceDelete[/{ProvinceCode}]", [PermissionMiddleware::class], "delete.province")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProvinceDelete");
    }
}
