<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class ProductionSalesController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/ProductionSalesList[/{keys:.*}]", [PermissionMiddleware::class], "list.production_sales")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "ProductionSalesList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/ProductionSalesAdd[/{keys:.*}]", [PermissionMiddleware::class], "add.production_sales")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "ProductionSalesAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/ProductionSalesView[/{keys:.*}]", [PermissionMiddleware::class], "view.production_sales")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "ProductionSalesView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/ProductionSalesEdit[/{keys:.*}]", [PermissionMiddleware::class], "edit.production_sales")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "ProductionSalesEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/ProductionSalesDelete[/{keys:.*}]", [PermissionMiddleware::class], "delete.production_sales")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "ProductionSalesDelete");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/ProductionSalesPreview", [PermissionMiddleware::class], "preview.production_sales")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "ProductionSalesPreview", null, false);
    }

    // Get keys as associative array
    protected function getKeyParams($args)
    {
        global $RouteValues;
        if (array_key_exists("keys", $args)) {
            $sep = Container("production_sales")->RouteCompositeKeySeparator;
            $keys = explode($sep, $args["keys"]);
            if (count($keys) == 3) {
                $keyArgs = array_combine(["FarmNo","NRC","SeasonYear"], $keys);
                $RouteValues = array_merge(Route(), $keyArgs);
                $args = array_merge($args, $keyArgs);
            }
        }
        return $args;
    }
}
