<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class PlantingMaterialsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/PlantingMaterialsList[/{MaterialCode}]", [PermissionMiddleware::class], "list.planting_materials")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PlantingMaterialsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/PlantingMaterialsAdd[/{MaterialCode}]", [PermissionMiddleware::class], "add.planting_materials")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PlantingMaterialsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/PlantingMaterialsView[/{MaterialCode}]", [PermissionMiddleware::class], "view.planting_materials")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PlantingMaterialsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/PlantingMaterialsEdit[/{MaterialCode}]", [PermissionMiddleware::class], "edit.planting_materials")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PlantingMaterialsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/PlantingMaterialsDelete[/{MaterialCode}]", [PermissionMiddleware::class], "delete.planting_materials")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PlantingMaterialsDelete");
    }
}
