<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class PeriodTypeController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/PeriodTypeList[/{Period_Type:.*}]", [PermissionMiddleware::class], "list.period_type")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PeriodTypeList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/PeriodTypeAdd[/{Period_Type:.*}]", [PermissionMiddleware::class], "add.period_type")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PeriodTypeAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/PeriodTypeView[/{Period_Type:.*}]", [PermissionMiddleware::class], "view.period_type")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PeriodTypeView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/PeriodTypeEdit[/{Period_Type:.*}]", [PermissionMiddleware::class], "edit.period_type")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PeriodTypeEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/PeriodTypeDelete[/{Period_Type:.*}]", [PermissionMiddleware::class], "delete.period_type")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "PeriodTypeDelete");
    }
}
