<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class OwnershipController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/OwnershipList[/{OwnershipType}]", [PermissionMiddleware::class], "list.ownership")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OwnershipList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/OwnershipAdd[/{OwnershipType}]", [PermissionMiddleware::class], "add.ownership")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OwnershipAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/OwnershipView[/{OwnershipType}]", [PermissionMiddleware::class], "view.ownership")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OwnershipView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/OwnershipEdit[/{OwnershipType}]", [PermissionMiddleware::class], "edit.ownership")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OwnershipEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/OwnershipDelete[/{OwnershipType}]", [PermissionMiddleware::class], "delete.ownership")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "OwnershipDelete");
    }
}
