<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class NurseryOwnershipController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/NurseryOwnershipList[/{NurseryOwnershipCode}]", [PermissionMiddleware::class], "list.nursery_ownership")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryOwnershipList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/NurseryOwnershipAdd[/{NurseryOwnershipCode}]", [PermissionMiddleware::class], "add.nursery_ownership")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryOwnershipAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/NurseryOwnershipView[/{NurseryOwnershipCode}]", [PermissionMiddleware::class], "view.nursery_ownership")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryOwnershipView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/NurseryOwnershipEdit[/{NurseryOwnershipCode}]", [PermissionMiddleware::class], "edit.nursery_ownership")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryOwnershipEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/NurseryOwnershipDelete[/{NurseryOwnershipCode}]", [PermissionMiddleware::class], "delete.nursery_ownership")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryOwnershipDelete");
    }
}
