<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class NurseryController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/NurseryList[/{NurseryCode}]", [PermissionMiddleware::class], "list.nursery")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/NurseryAdd[/{NurseryCode}]", [PermissionMiddleware::class], "add.nursery")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/NurseryView[/{NurseryCode}]", [PermissionMiddleware::class], "view.nursery")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/NurseryEdit[/{NurseryCode}]", [PermissionMiddleware::class], "edit.nursery")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/NurseryDelete[/{NurseryCode}]", [PermissionMiddleware::class], "delete.nursery")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryDelete");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/NurseryPreview", [PermissionMiddleware::class], "preview.nursery")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "NurseryPreview", null, false);
    }
}
