<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class MusersController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/MusersList[/{UserCode}]", [PermissionMiddleware::class], "list.musers")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MusersList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/MusersAdd[/{UserCode}]", [PermissionMiddleware::class], "add.musers")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MusersAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/MusersView[/{UserCode}]", [PermissionMiddleware::class], "view.musers")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MusersView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/MusersEdit[/{UserCode}]", [PermissionMiddleware::class], "edit.musers")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MusersEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/MusersDelete[/{UserCode}]", [PermissionMiddleware::class], "delete.musers")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MusersDelete");
    }
}
