<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class MaritalStatusController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/MaritalStatusList[/{MaritalStatusCode}]", [PermissionMiddleware::class], "list.marital_status")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaritalStatusList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/MaritalStatusAdd[/{MaritalStatusCode}]", [PermissionMiddleware::class], "add.marital_status")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaritalStatusAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/MaritalStatusView[/{MaritalStatusCode}]", [PermissionMiddleware::class], "view.marital_status")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaritalStatusView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/MaritalStatusEdit[/{MaritalStatusCode}]", [PermissionMiddleware::class], "edit.marital_status")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaritalStatusEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/MaritalStatusDelete[/{MaritalStatusCode}]", [PermissionMiddleware::class], "delete.marital_status")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MaritalStatusDelete");
    }
}
