<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class LockStatusController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/LockStatusList[/{LockStatus}]", [PermissionMiddleware::class], "list.lock_status")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LockStatusList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/LockStatusAdd[/{LockStatus}]", [PermissionMiddleware::class], "add.lock_status")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LockStatusAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/LockStatusView[/{LockStatus}]", [PermissionMiddleware::class], "view.lock_status")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LockStatusView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/LockStatusEdit[/{LockStatus}]", [PermissionMiddleware::class], "edit.lock_status")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LockStatusEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/LockStatusDelete[/{LockStatus}]", [PermissionMiddleware::class], "delete.lock_status")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "LockStatusDelete");
    }
}
