<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FopositionController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FopositionList[/{FOPosition:.*}]", [PermissionMiddleware::class], "list.foposition")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FopositionList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FopositionAdd[/{FOPosition:.*}]", [PermissionMiddleware::class], "add.foposition")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FopositionAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/FopositionView[/{FOPosition:.*}]", [PermissionMiddleware::class], "view.foposition")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FopositionView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/FopositionEdit[/{FOPosition:.*}]", [PermissionMiddleware::class], "edit.foposition")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FopositionEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/FopositionDelete[/{FOPosition:.*}]", [PermissionMiddleware::class], "delete.foposition")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FopositionDelete");
    }
}
