<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FarmerController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FarmerList[/{FarmerNo}]", [PermissionMiddleware::class], "list.farmer")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FarmerAdd[/{FarmerNo}]", [PermissionMiddleware::class], "add.farmer")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/FarmerView[/{FarmerNo}]", [PermissionMiddleware::class], "view.farmer")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/FarmerEdit[/{FarmerNo}]", [PermissionMiddleware::class], "edit.farmer")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/FarmerDelete[/{FarmerNo}]", [PermissionMiddleware::class], "delete.farmer")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/FarmerSearch", [PermissionMiddleware::class], "search.farmer")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/FarmerQuery", [PermissionMiddleware::class], "query.farmer")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerSearch", "FarmerQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/FarmerPreview", [PermissionMiddleware::class], "preview.farmer")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmerPreview", null, false);
    }
}
