<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FarmSeedAllocateController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedAllocateList[/{TransNo}]", [PermissionMiddleware::class], "list.farm_seed_allocate")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedAllocateList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedAllocateAdd[/{TransNo}]", [PermissionMiddleware::class], "add.farm_seed_allocate")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedAllocateAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedAllocateView[/{TransNo}]", [PermissionMiddleware::class], "view.farm_seed_allocate")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedAllocateView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedAllocateEdit[/{TransNo}]", [PermissionMiddleware::class], "edit.farm_seed_allocate")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedAllocateEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedAllocateDelete[/{TransNo}]", [PermissionMiddleware::class], "delete.farm_seed_allocate")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedAllocateDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedAllocateSearch", [PermissionMiddleware::class], "search.farm_seed_allocate")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedAllocateSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/FarmSeedAllocateQuery", [PermissionMiddleware::class], "query.farm_seed_allocate")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedAllocateSearch", "FarmSeedAllocateQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/FarmSeedAllocatePreview", [PermissionMiddleware::class], "preview.farm_seed_allocate")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmSeedAllocatePreview", null, false);
    }
}
