<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class FarmInspectionController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/FarmInspectionList[/{InspectionTransNo}]", [PermissionMiddleware::class], "list.farm_inspection")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmInspectionList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/FarmInspectionAdd[/{InspectionTransNo}]", [PermissionMiddleware::class], "add.farm_inspection")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmInspectionAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/FarmInspectionView[/{InspectionTransNo}]", [PermissionMiddleware::class], "view.farm_inspection")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmInspectionView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/FarmInspectionEdit[/{InspectionTransNo}]", [PermissionMiddleware::class], "edit.farm_inspection")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmInspectionEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/FarmInspectionDelete[/{InspectionTransNo}]", [PermissionMiddleware::class], "delete.farm_inspection")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmInspectionDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/FarmInspectionSearch", [PermissionMiddleware::class], "search.farm_inspection")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmInspectionSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/FarmInspectionPreview", [PermissionMiddleware::class], "preview.farm_inspection")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "FarmInspectionPreview", null, false);
    }
}
