<?php

namespace PHPMaker2024\cidp24;

use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

/**
 * District_Summary_Report controller
 */
class DistrictSummaryReportController extends ControllerBase
{
    // crosstab
    #[Map(["GET", "POST", "OPTIONS"], "/DistrictSummaryReport", [PermissionMiddleware::class], "crosstab.District_Summary_Report")]
    public function crosstab(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DistrictSummaryReportCrosstab");
    }

    // BeneficiariesByDistrict (chart)
    #[Map(["GET", "POST", "OPTIONS"], "/DistrictSummaryReport/BeneficiariesByDistrict", [PermissionMiddleware::class], "crosstab.District_Summary_Report.BeneficiariesByDistrict")]
    public function BeneficiariesByDistrict(Request $request, Response $response, array $args): Response
    {
        return $this->runChart($request, $response, $args, "DistrictSummaryReportCrosstab", "BeneficiariesByDistrict");
    }
}
