<?php

namespace PHPMaker2024\cidp24;

use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

/**
 * District_Summary2 controller
 */
class DistrictSummary2Controller extends ControllerBase
{
    // crosstab
    #[Map(["GET", "POST", "OPTIONS"], "/DistrictSummary2", [PermissionMiddleware::class], "crosstab.District_Summary2")]
    public function crosstab(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DistrictSummary2Crosstab");
    }

    // DistrictSummarybyAgeGroup (chart)
    #[Map(["GET", "POST", "OPTIONS"], "/DistrictSummary2/DistrictSummarybyAgeGroup", [PermissionMiddleware::class], "crosstab.District_Summary2.DistrictSummarybyAgeGroup")]
    public function DistrictSummarybyAgeGroup(Request $request, Response $response, array $args): Response
    {
        return $this->runChart($request, $response, $args, "DistrictSummary2Crosstab", "DistrictSummarybyAgeGroup");
    }

    // DistrictSummarybyGender (chart)
    #[Map(["GET", "POST", "OPTIONS"], "/DistrictSummary2/DistrictSummarybyGender", [PermissionMiddleware::class], "crosstab.District_Summary2.DistrictSummarybyGender")]
    public function DistrictSummarybyGender(Request $request, Response $response, array $args): Response
    {
        return $this->runChart($request, $response, $args, "DistrictSummary2Crosstab", "DistrictSummarybyGender");
    }
}
