<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class DistrictController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/DistrictList[/{DistrictCode}]", [PermissionMiddleware::class], "list.district")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DistrictList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/DistrictAdd[/{DistrictCode}]", [PermissionMiddleware::class], "add.district")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DistrictAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/DistrictView[/{DistrictCode}]", [PermissionMiddleware::class], "view.district")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DistrictView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/DistrictEdit[/{DistrictCode}]", [PermissionMiddleware::class], "edit.district")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DistrictEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/DistrictDelete[/{DistrictCode}]", [PermissionMiddleware::class], "delete.district")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DistrictDelete");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/DistrictPreview", [PermissionMiddleware::class], "preview.district")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "DistrictPreview", null, false);
    }
}
