<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class CidpDataController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/CidpDataList[/{ID}]", [PermissionMiddleware::class], "list.cidp_data")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CidpDataList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/CidpDataAdd[/{ID}]", [PermissionMiddleware::class], "add.cidp_data")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CidpDataAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/CidpDataView[/{ID}]", [PermissionMiddleware::class], "view.cidp_data")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CidpDataView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/CidpDataEdit[/{ID}]", [PermissionMiddleware::class], "edit.cidp_data")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CidpDataEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/CidpDataDelete[/{ID}]", [PermissionMiddleware::class], "delete.cidp_data")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CidpDataDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/CidpDataSearch", [PermissionMiddleware::class], "search.cidp_data")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CidpDataSearch");
    }
}
