<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class CampController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/CampList[/{CampCode}]", [PermissionMiddleware::class], "list.camp")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CampList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/CampAdd[/{CampCode}]", [PermissionMiddleware::class], "add.camp")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CampAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/CampView[/{CampCode}]", [PermissionMiddleware::class], "view.camp")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CampView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/CampEdit[/{CampCode}]", [PermissionMiddleware::class], "edit.camp")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CampEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/CampDelete[/{CampCode}]", [PermissionMiddleware::class], "delete.camp")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CampDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/CampSearch", [PermissionMiddleware::class], "search.camp")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CampSearch");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/CampPreview", [PermissionMiddleware::class], "preview.camp")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "CampPreview", null, false);
    }
}
