<?php

namespace PHPMaker2024\cidp24;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use PHPMaker2024\cidp24\Attributes\Delete;
use PHPMaker2024\cidp24\Attributes\Get;
use PHPMaker2024\cidp24\Attributes\Map;
use PHPMaker2024\cidp24\Attributes\Options;
use PHPMaker2024\cidp24\Attributes\Patch;
use PHPMaker2024\cidp24\Attributes\Post;
use PHPMaker2024\cidp24\Attributes\Put;

class BeneficiaryBySupplierController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/BeneficiaryBySupplierList", [PermissionMiddleware::class], "list.beneficiary_by_supplier")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BeneficiaryBySupplierList");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/BeneficiaryBySupplierSearch", [PermissionMiddleware::class], "search.beneficiary_by_supplier")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "BeneficiaryBySupplierSearch");
    }
}
